/*
 * Decompiled with CFR 0.152.
 */
package draw;

import basic.BasicCanvas;
import basic.Draw;
import basic.KSpriteX;
import basic.KUtils;
import basic.Resource;
import draw.GameMainDraw;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class DialogueDraw
extends Draw {
    public static KSpriteX spx;
    public static final byte WORDS_WIDTH;
    public static final byte EACHLINE_HEIGHT;
    private short leftTopX;
    private short leftTopY;
    private short width;
    private short height;
    private short moveWidth;
    private short moveHeight;
    private static byte lines;
    private static byte showLines;
    private static byte beginLine;
    private static byte[] showEachLineNum;
    private static char[] wordsArray;
    private static String sayName;
    private static byte eachLinesWordsNum;
    private static byte totalHeight;
    private byte skinW = (byte)4;
    public static byte waitCount;
    public static final int[] color;
    private byte[] KeywordColor;
    public static final byte STATE_DIALOGUE = 1;
    public static final byte STATE_SELECT = 2;
    public static final byte STATE_SELECTSAY = 3;
    public static final byte STATE_EXIT = 4;
    public static byte exitState;
    public static byte state;
    public static boolean isCanSelect;
    public static boolean isDialogue;
    static boolean end;
    public static final byte DOWN = 0;
    public static final byte MIDDLE = 1;
    public static final byte UP = 2;
    boolean begin;
    int tempColor;
    public static boolean isOver;
    private static Vector selectVector;
    private short selectX;
    private short selectY;
    private short selectWidth;
    private short selectHeight;
    private byte focusIndex;

    public void init(int s, String obj, int site) {
        this.setSkin();
        if (spx == null) {
            spx = Resource.getKSpriteX("/ui/next.sprite", "/ui/next.png");
        }
        int y = 0;
        switch (site) {
            case 0: {
                y = BasicCanvas.screenHeight - EACHLINE_HEIGHT * 2 - 12;
                break;
            }
            case 1: {
                y = BasicCanvas.screenHeight / 2 - 30;
                break;
            }
            case 2: {
                y = 5;
                break;
            }
        }
        this.setRect(0, y, BasicCanvas.screenWidth, EACHLINE_HEIGHT * 2 + 12, 2);
        this.setWords(obj);
        waitCount = (byte)8;
        state = (byte)s;
    }

    public void initSelect(String obj, int s) {
        isOver = false;
        isDialogue = true;
        this.focusIndex = 0;
        DialogueDraw.setSelectSkin();
        String[] sA = KUtils.splitString(obj, ',');
        this.selectWidth = (short)(KUtils.getMaxLength(sA) + 16);
        this.selectHeight = (short)Math.max(20, BasicCanvas.fontHeight + 2);
        this.selectX = (short)((BasicCanvas.screenWidth - this.selectWidth) / 2);
        this.selectY = (short)((BasicCanvas.screenHeight - this.selectHeight * sA.length - 26) / 2);
        this.addSelect(sA);
        waitCount = (byte)8;
        state = (byte)s;
    }

    public void setRect(int x, int y, int w, int h, int l) {
        this.leftTopX = (short)x;
        this.leftTopY = (short)y;
        this.width = (short)w;
        this.height = (short)h;
        lines = (byte)l;
        this.moveWidth = 0;
        this.moveHeight = 0;
    }

    public void setWords(String obj) {
        isOver = false;
        isDialogue = true;
        end = false;
        eachLinesWordsNum = (byte)((this.width - this.skinW * 2) / WORDS_WIDTH);
        Vector v = new Vector();
        StringBuffer sb = DialogueDraw.getColorVector(obj, v);
        this.KeywordColor = new byte[v.size()];
        int temp = -1;
        int i = 0;
        int j = this.KeywordColor.length - 1;
        while (i < this.KeywordColor.length) {
            this.KeywordColor[i] = ((Integer)v.elementAt(i)).byteValue();
            if (this.KeywordColor[i] != -1) {
                temp = this.KeywordColor[i];
            } else {
                this.KeywordColor[i] = temp;
            }
            ++i;
            --j;
        }
        wordsArray = sb.toString().toCharArray();
        totalHeight = (byte)(wordsArray.length / eachLinesWordsNum);
        if (wordsArray.length % eachLinesWordsNum != 0) {
            totalHeight = (byte)(totalHeight + 1);
        }
        this.begin = true;
        showLines = lines;
        beginLine = 0;
        showEachLineNum = new byte[totalHeight];
        for (int j2 = 0; j2 < totalHeight; ++j2) {
            DialogueDraw.showEachLineNum[j2] = eachLinesWordsNum;
        }
    }

    public static StringBuffer getColorVector(String obj, Vector v) {
        int i;
        StringBuffer sb = new StringBuffer(obj);
        int length = sb.length();
        int[] c = new int[length];
        for (i = length - 1; i >= 0; --i) {
            c[i] = -1;
            if (sb.charAt(i) == '\\') {
                sb.deleteCharAt(i);
                c[i] = -2;
                if (i + 2 >= length) continue;
                c[i + 1] = -2;
                c[i + 2] = sb.charAt(i) - 48;
                sb.deleteCharAt(i);
                continue;
            }
            if (sb.charAt(i) != '&') continue;
            sb.deleteCharAt(i);
            sb.insert(i, GameMainDraw.player.name);
        }
        v.removeAllElements();
        for (i = 0; i < length; ++i) {
            if (c[i] == -2) continue;
            v.addElement(new Integer(c[i]));
        }
        return sb;
    }

    public DialogueDraw(int sw, int sh) {
        super(sw, sh);
    }

    public void setSkin() {
    }

    public void drawWords(Graphics g) {
        if (this.begin) {
            this.begin = false;
            return;
        }
        g.setClip(0, 0, (int)BasicCanvas.screenWidth, (int)BasicCanvas.screenHeight);
        int showTempLength = Math.min(beginLine + showLines, totalHeight);
        if (beginLine >= showTempLength || wordsArray == null) {
            end = true;
            return;
        }
        int strColor = color[0];
        int i = beginLine;
        int k = 0;
        while (i < showTempLength) {
            for (int j = 0; j < showEachLineNum[i]; ++j) {
                int index = i * eachLinesWordsNum + j;
                if (index < this.KeywordColor.length && this.KeywordColor[index] != -1) {
                    strColor = color[this.KeywordColor[index]];
                }
                g.setColor(strColor);
                g.drawChar(wordsArray[index], this.leftTopX + this.skinW + j * WORDS_WIDTH, this.leftTopY + this.skinW + k * EACHLINE_HEIGHT, 20);
                if (index < wordsArray.length - 1) continue;
                end = true;
                return;
            }
            ++i;
            ++k;
        }
        if (!end) {
            int n = showTempLength - 1;
            showEachLineNum[n] = (byte)(showEachLineNum[n] + 1);
            if (showEachLineNum[showTempLength - 1] >= eachLinesWordsNum) {
                DialogueDraw.showEachLineNum[showTempLength - 1] = eachLinesWordsNum;
                showLines = (byte)Math.min(showLines + 1, lines);
            }
        }
    }

    public void key() {
        if (waitCount > 0 || isOver) {
            waitCount = (byte)(waitCount - 1);
            BasicCanvas.pressKeyInfo = 0;
            return;
        }
        switch (state) {
            case 1: {
                this.sayKey();
                break;
            }
            case 2: {
                this.selectKey();
                break;
            }
            case 3: {
                if (!end) {
                    this.sayKey();
                    break;
                }
                if (!isCanSelect) break;
                this.selectKey();
                break;
            }
        }
    }

    private void sayKey() {
        if (BasicCanvas.hitKey(131136) || BasicCanvas.hitKey(16896) || BasicCanvas.hitKey(8200) || BasicCanvas.hitKey(32800) || BasicCanvas.hitKey(65664)) {
            waitCount = (byte)2;
            if (end) {
                if (state == 3) {
                    waitCount = (byte)8;
                } else {
                    waitCount = (byte)8;
                    exitState = state;
                    state = (byte)4;
                }
            } else {
                try {
                    int temp = beginLine + showLines - 1;
                    if (temp >= 0 && temp < totalHeight) {
                        if (showLines == lines && showEachLineNum[temp] >= eachLinesWordsNum) {
                            if (beginLine < totalHeight - lines) {
                                beginLine = (byte)(beginLine + lines);
                                showLines = 1;
                            }
                        } else if (showLines != lines) {
                            showLines = lines;
                            int showTempLength = Math.min(beginLine + showLines, totalHeight);
                            for (int j = beginLine; j < showTempLength; ++j) {
                                DialogueDraw.showEachLineNum[j] = eachLinesWordsNum;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    BasicCanvas.Debug(ex.toString());
                }
            }
        }
    }

    private void selectKey() {
        if (BasicCanvas.hitKey(16896)) {
            this.focusIndex = (byte)(this.focusIndex + 1);
            if (this.focusIndex >= selectVector.size()) {
                this.focusIndex = 0;
            }
        } else if (BasicCanvas.hitKey(8200)) {
            this.focusIndex = (byte)(this.focusIndex - 1);
            if (this.focusIndex < 0) {
                this.focusIndex = (byte)(selectVector.size() - 1);
            }
        } else if (BasicCanvas.hitKey(131136)) {
            exitState = state;
            state = (byte)4;
        }
    }

    public static void clearMemory() {
        wordsArray = null;
        selectVector.removeAllElements();
        isDialogue = false;
        eachLinesWordsNum = 0;
        sayName = null;
        totalHeight = 0;
        showEachLineNum = new byte[0];
        showLines = 0;
        beginLine = 0;
        isCanSelect = false;
        state = 0;
    }

    public void logicMain() {
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                isOver = true;
                this.im.receiveMessage(this.ownId, exitState, this.focusIndex);
                DialogueDraw.clearMemory();
                break;
            }
        }
    }

    public void paintLoad(Graphics g) {
        this.drawStatus = 1;
    }

    public void paintMain(Graphics g) {
        if (isOver) {
            return;
        }
        switch (state) {
            case 1: {
                this.drawSay(g);
                break;
            }
            case 2: {
                this.drawSelect(g);
                break;
            }
            case 3: {
                this.drawSay(g);
                if (!end) break;
                if (!isCanSelect) {
                    waitCount = (byte)8;
                    isCanSelect = true;
                }
                this.drawSelect(g);
                break;
            }
        }
    }

    private void drawSelect(Graphics g) {
        int length = selectVector.size();
        int midx = this.selectX + this.selectWidth / 2;
        int selecth = length * this.selectHeight + 26;
        g.setColor(0xFFFFFF);
        g.drawRect((int)this.selectX, this.selectY + 1, this.selectWidth - 1, selecth - 3);
        g.drawRect(this.selectX + 1, (int)this.selectY, this.selectWidth - 3, selecth - 1);
        g.setColor(0);
        g.fillRect(this.selectX + 1, this.selectY + 1, this.selectWidth - 2, selecth - 2);
        for (int j = 0; j < length; ++j) {
            String frame = (String)selectVector.elementAt(j);
            int c = 10856358;
            if (this.focusIndex == j) {
                c = 16769043;
            }
            g.setColor(c);
            g.drawString(frame, midx, this.selectY + 13 + this.selectHeight * j, 17);
        }
    }

    private void drawSay(Graphics g) {
        g.setColor(0xFFFFFF);
        g.drawRect(this.leftTopX + (this.moveWidth >> 1), this.leftTopY + (this.moveHeight >> 1) + 1, this.width - this.moveWidth - 1, this.height - this.moveHeight - 3);
        g.drawRect(this.leftTopX + (this.moveWidth >> 1) + 1, this.leftTopY + (this.moveHeight >> 1), this.width - this.moveWidth - 3, this.height - this.moveHeight - 1);
        g.setColor(0);
        g.fillRect(this.leftTopX + (this.moveWidth >> 1) + 1, this.leftTopY + (this.moveHeight >> 1) + 1, this.width - this.moveWidth - 2, this.height - this.moveHeight - 2);
        this.moveHeight = (short)(this.moveHeight - Math.max(this.moveHeight / 2, 5));
        this.moveWidth = (short)(this.moveWidth - Math.max(this.moveWidth / 2, 8));
        if (this.moveHeight <= 0) {
            this.moveHeight = 0;
        }
        if (this.moveWidth > 0) {
            return;
        }
        this.moveWidth = 0;
        this.drawWords(g);
        if (spx != null) {
            spx.update();
            spx.paint(this.leftTopX + this.width - 10, this.leftTopY + this.height - 8, 2100);
        }
    }

    public void release() {
    }

    public static void setSelectSkin() {
    }

    public void addSelect(String[] obj) {
        if (obj == null) {
            BasicCanvas.Debug("addSelect wrong :null");
            return;
        }
        if (selectVector != null) {
            selectVector.removeAllElements();
        } else {
            selectVector = new Vector();
        }
        int length = obj.length;
        for (int i = 0; i < length; ++i) {
            selectVector.addElement(obj[i]);
        }
    }

    public int touchKey(int x, int y) {
        return -1;
    }

    static {
        WORDS_WIDTH = (byte)(BasicCanvas.fontWidth + 1);
        EACHLINE_HEIGHT = (byte)(BasicCanvas.fontHeight + 2);
        wordsArray = new char[0];
        eachLinesWordsNum = (byte)8;
        color = new int[]{0xFFFCCC, 0xFFFF00, 0xFF0000, 65280, 255, 65535, 0xFFFFFF, 9564205};
        selectVector = new Vector();
    }
}

