/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Font;

public final class TextUtil {
    private static final String UNRESERVED = "-_.!~*'()\"";

    public static String[] split(String value, char delimiter) {
        char[] valueChars = value.toCharArray();
        int lastIndex = 0;
        ArrayList strings = null;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            if (c != delimiter) continue;
            if (strings == null) {
                strings = new ArrayList();
            }
            strings.add(new String(valueChars, lastIndex, i - lastIndex));
            lastIndex = i + 1;
        }
        if (strings == null) {
            return new String[]{value};
        }
        strings.add(new String(valueChars, lastIndex, valueChars.length - lastIndex));
        return (String[])strings.toArray(new String[strings.size()]);
    }

    public static String[] splitAndTrim(String value, char delimiter) {
        String[] result = TextUtil.split(value, delimiter);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static String[] split(String value, char delimiter, int numberOfChunks) {
        char[] valueChars = value.toCharArray();
        int lastIndex = 0;
        String[] chunks = new String[numberOfChunks];
        int chunkIndex = 0;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            if (c != delimiter) continue;
            chunks[chunkIndex] = value.substring(lastIndex, i);
            lastIndex = i + 1;
            if (++chunkIndex == numberOfChunks) break;
        }
        if (chunkIndex < numberOfChunks) {
            chunks[chunkIndex] = value.substring(lastIndex, valueChars.length);
        }
        return chunks;
    }

    public static String[] split(String value, Font font, int firstLineWidth, int lineWidth) {
        return TextUtil.wrap(value, font, firstLineWidth, lineWidth);
    }

    public static String[] wrap(String value, Font font, int firstLineWidth, int lineWidth) {
        if (firstLineWidth <= 0 || lineWidth <= 0) {
            return new String[]{value};
        }
        boolean hasLineBreaks = value.indexOf(10) != -1;
        int completeWidth = font.stringWidth(value);
        if (completeWidth <= firstLineWidth && !hasLineBreaks) {
            return new String[]{value};
        }
        ArrayList lines = new ArrayList();
        if (!hasLineBreaks) {
            TextUtil.wrap(value, font, completeWidth, firstLineWidth, lineWidth, lines);
        } else {
            char[] valueChars = value.toCharArray();
            int lastIndex = 0;
            int c = 32;
            int lineBreakCount = 0;
            for (int i = 0; i < valueChars.length; ++i) {
                boolean isCRLF;
                c = valueChars[i];
                boolean bl = isCRLF = c == 13 && i < valueChars.length - 1 && valueChars[i + 1] == '\n';
                if (c != 10 && i != valueChars.length - 1 && !isCRLF) continue;
                ++lineBreakCount;
                String line = null;
                line = i == valueChars.length - 1 ? new String(valueChars, lastIndex, i + 1 - lastIndex) : new String(valueChars, lastIndex, i - lastIndex);
                completeWidth = font.stringWidth(line);
                if (completeWidth <= firstLineWidth) {
                    lines.add(line);
                } else {
                    TextUtil.wrap(line, font, completeWidth, firstLineWidth, lineWidth, lines);
                }
                if (isCRLF) {
                    ++i;
                }
                lastIndex = i + 1;
                firstLineWidth = lineWidth;
            }
            if (lineBreakCount > 1 && (c == 10 || c == 10)) {
                lines.add("");
            }
        }
        return (String[])lines.toArray(new String[lines.size()]);
    }

    public static void split(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, ArrayList list) {
        TextUtil.wrap(value, font, completeWidth, firstLineWidth, lineWidth, list);
    }

    public static void wrap(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, ArrayList list) {
        char[] valueChars = value.toCharArray();
        int startPos = 0;
        int lastSpacePos = -1;
        int lastSpacePosLength = 0;
        int currentLineWidth = 0;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            currentLineWidth += font.charWidth(c);
            if (c == '\n') {
                list.add(new String(valueChars, startPos, i - startPos));
                lastSpacePos = -1;
                startPos = i + 1;
                currentLineWidth = 0;
                firstLineWidth = lineWidth;
                i = startPos;
                continue;
            }
            if (currentLineWidth >= firstLineWidth && i > 0) {
                if (lastSpacePos == -1) {
                    list.add(new String(valueChars, startPos, --i - startPos));
                    startPos = i;
                    currentLineWidth = 0;
                } else {
                    currentLineWidth -= lastSpacePosLength;
                    list.add(new String(valueChars, startPos, lastSpacePos - startPos));
                    startPos = lastSpacePos + 1;
                    lastSpacePos = -1;
                }
                firstLineWidth = lineWidth;
                continue;
            }
            if (c != ' ' && c != '\t') continue;
            lastSpacePos = i;
            lastSpacePosLength = currentLineWidth;
        }
        list.add(new String(valueChars, startPos, valueChars.length - startPos));
    }

    private static char toHexChar(int digitValue) {
        if (digitValue < 10) {
            return (char)(48 + digitValue);
        }
        return (char)(65 + (digitValue - 10));
    }

    public static String encodeUrl(String url) {
        StringBuffer encodedUrl = new StringBuffer();
        int len = url.length();
        for (int i = 0; i < len; ++i) {
            char c = url.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                encodedUrl.append(c);
                continue;
            }
            int imark = UNRESERVED.indexOf(c);
            if (imark >= 0) {
                encodedUrl.append(c);
                continue;
            }
            encodedUrl.append('%');
            encodedUrl.append(TextUtil.toHexChar((c & 0xF0) >> 4));
            encodedUrl.append(TextUtil.toHexChar(c & 0xF));
        }
        return encodedUrl.toString();
    }

    public static String replace(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            StringBuffer buffer = new StringBuffer();
            int lastPos = 0;
            do {
                buffer.append(input.substring(lastPos, pos)).append(replacement);
            } while ((pos = input.indexOf(search, lastPos = pos + search.length())) != -1);
            buffer.append(input.substring(lastPos));
            input = buffer.toString();
        }
        return input;
    }

    public static String replaceFirst(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            input = input.substring(0, pos) + replacement + input.substring(pos + search.length());
        }
        return input;
    }

    public static String replaceLast(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            int lastPos = pos;
            while ((pos = input.indexOf(search, lastPos + 1)) != -1) {
                lastPos = pos;
            }
            input = input.substring(0, lastPos) + replacement + input.substring(lastPos + search.length());
        }
        return input;
    }

    public static int lastIndexOf(String text, String match) {
        int lastIndex = -1;
        int index = text.indexOf(match);
        while (index != -1) {
            lastIndex = index;
            index = text.indexOf(match, lastIndex + 1);
        }
        return lastIndex;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1.equalsIgnoreCase(str2);
    }
}

