/*
 * Decompiled with CFR 0.152.
 */
package basic;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class KFile {
    public static final short BUFFER_SIZE = 1024;
    public static final byte MODE_READ = 1;
    public static final byte MODE_WRITE = 2;
    public static final byte MODE_CREATE = 4;
    protected String name;
    protected RecordStore rms;
    protected int mode;
    protected byte[] buf;
    protected int pos;
    protected int size;
    protected boolean isLoacl;
    protected static int saveIndex;

    public KFile() {
    }

    public void setSaveIndex(int index) {
        saveIndex = index;
    }

    public int getSaveIndex() {
        return saveIndex;
    }

    public KFile(String name, int mode) {
        this.open(name, mode);
    }

    public boolean open(String name, int mode) {
        this.close();
        this.name = name = name + saveIndex;
        this.mode = mode;
        try {
            if ((mode & 4) != 0) {
                this.rms = RecordStore.openRecordStore((String)name, (boolean)true);
                if (this.rms.getNumRecords() > 0) {
                    this.buf = this.rms.getRecord(1);
                    this.size = this.buf.length;
                } else {
                    this.buf = new byte[1024];
                    this.rms.addRecord(this.buf, 0, 1);
                }
            } else {
                this.rms = RecordStore.openRecordStore((String)name, (boolean)false);
                this.buf = this.rms.getRecord(1);
                this.size = this.buf.length;
            }
        }
        catch (RecordStoreException ex) {
            return false;
        }
        return true;
    }

    public void close() {
        if (this.rms != null) {
            this.flush();
            try {
                this.rms.closeRecordStore();
                this.rms = null;
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        this.name = null;
        this.mode = 0;
        this.buf = null;
        this.pos = 0;
        this.size = 0;
    }

    public void flush() {
        if (this.rms != null) {
            try {
                this.rms.setRecord(1, this.buf, 0, this.size);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void clear() {
        this.pos = 0;
        this.size = 0;
    }

    public static boolean delete(String name) {
        try {
            RecordStore.deleteRecordStore((String)(name + saveIndex));
        }
        catch (RecordStoreException ex) {
            return false;
        }
        return true;
    }

    public static boolean isExist(String name) {
        try {
            RecordStore rms = RecordStore.openRecordStore((String)(name + saveIndex), (boolean)false);
            rms.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            return false;
        }
        return true;
    }

    public int getSize() {
        return this.size;
    }

    public int getPosition() {
        return this.pos;
    }

    public int read() throws IOException {
        if (!(this.rms != null && (this.mode & 1) != 0 || this.isLoacl)) {
            throw new IOException();
        }
        if (this.pos >= this.size) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!(this.rms != null && (this.mode & 1) != 0 || this.isLoacl)) {
            throw new IOException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.pos >= this.size) {
            return -1;
        }
        int available = this.size - this.pos;
        if (len > available) {
            len = available;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (!(this.rms != null && (this.mode & 1) != 0 || this.isLoacl)) {
            throw new IOException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int available = this.size - this.pos;
        if (available < len) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        char[] str = new char[utflen];
        byte[] bytearr = new byte[utflen];
        int count = 0;
        int strlen = 0;
        this.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str, 0, strlen);
    }

    public void write(int b) throws IOException {
        if (!(this.rms != null && (this.mode & 2) != 0 || this.isLoacl)) {
            throw new IOException();
        }
        if (this.pos >= this.buf.length) {
            byte[] dat = new byte[this.pos + 1024];
            System.arraycopy(this.buf, 0, dat, 0, this.size);
            this.buf = dat;
        }
        this.buf[this.pos++] = (byte)b;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!(this.rms != null && (this.mode & 2) != 0 || this.isLoacl)) {
            throw new IOException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.pos + len >= this.buf.length) {
            byte[] dat = new byte[this.pos + (1024 > len ? 1024 : len)];
            System.arraycopy(this.buf, 0, dat, 0, this.size);
            this.buf = dat;
        }
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.write(bytearr);
    }
}

