/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.m3g.Transform;

final class cMath {
    public static Transform s_identityTrans = new Transform();
    public static Transform s_tempTrans = new Transform();
    public static short[] cosTable;
    public static byte[] atanTable;
    static Random randGen;
    public static int ATAN_SIZE;
    static long rndx;
    static long rndy;
    static long rndz;
    static long rndw;
    public static int s_viewportX;
    public static int s_viewportY;
    public static int s_3DPosX;
    public static int s_3DPosY;
    public static int s_3DPosZ;

    public static void initMath() {
        cGame.Lib_Open("/math", true);
        byte[] data = null;
        data = cGame.Lib_GetData(0, false);
        cGame.Lib_BindData(data);
        cosTable = cGame.Lib_ReadShortArray();
        cGame.Lib_UnBindData();
        data = cGame.Lib_GetData(1, false);
        cGame.Lib_BindData(data);
        atanTable = cGame.Lib_ReadByteArray();
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
    }

    public static int sin(int angle) {
        angle -= 1024;
        if ((angle &= 0xFFF) < 0) {
            angle += 4096;
        }
        if (angle <= 1024) {
            return cosTable[angle];
        }
        if (angle <= 2048) {
            return -cosTable[2048 - angle];
        }
        if (angle <= 3072) {
            return -cosTable[angle - 2048];
        }
        if (angle <= 4096) {
            return cosTable[4096 - angle];
        }
        return 0;
    }

    public static int cos(int angle) {
        if ((angle &= 0xFFF) < 0) {
            angle += 4096;
        }
        if (angle <= 1024) {
            return cosTable[angle];
        }
        if (angle <= 2048) {
            return -cosTable[2048 - angle];
        }
        if (angle <= 3072) {
            return -cosTable[angle - 2048];
        }
        if (angle <= 4096) {
            return cosTable[4096 - angle];
        }
        return 0;
    }

    public static int atan2(int x, int y) {
        if (x == 0) {
            if (y >= 0) {
                return 1024;
            }
            return 3072;
        }
        if (x > 0) {
            if (y >= 0) {
                if (x >= y) {
                    int Index = y * ATAN_SIZE / x;
                    return (atanTable[Index] & 0xFF) << 1;
                }
                int Index = x * ATAN_SIZE / y;
                return 1024 - ((atanTable[Index] & 0xFF) << 1);
            }
            if (x >= (y = -y)) {
                int Index = y * ATAN_SIZE / x;
                return 4096 - ((atanTable[Index] & 0xFF) << 1);
            }
            int Index = x * ATAN_SIZE / y;
            return 3072 + ((atanTable[Index] & 0xFF) << 1);
        }
        x = -x;
        if (y >= 0) {
            if (x >= y) {
                int Index = y * ATAN_SIZE / x;
                return 2048 - ((atanTable[Index] & 0xFF) << 1);
            }
            int Index = x * ATAN_SIZE / y;
            return 1024 + ((atanTable[Index] & 0xFF) << 1);
        }
        if (x >= (y = -y)) {
            int Index = y * ATAN_SIZE / x;
            return 2048 + ((atanTable[Index] & 0xFF) << 1);
        }
        int Index = x * ATAN_SIZE / y;
        return 3072 - ((atanTable[Index] & 0xFF) << 1);
    }

    static int normAngle(int angle) {
        while ((angle < 0 ? -angle : angle) > 2048) {
            angle += -1 * (angle < 0 ? -1 : 1) * 4096;
        }
        return angle;
    }

    static int interpolateAngle(int a1, int a2, int percent) {
        int min = a1 < a2 ? a1 : a2;
        int max = a1 > a2 ? a1 : a2;
        int cw = 1;
        int d = max - min;
        if (d > 2048) {
            d = 4096 - d;
            cw = -1;
        }
        int pmin = percent * 10;
        if (a1 == max) {
            pmin = 1024 - pmin;
        }
        return cMath.normAngle(min + (cw * (d * pmin) >> 10));
    }

    static int interpolateInt(int a1, int a2, int factor) {
        return a1 + ((a2 - a1) * (factor * 10) >> 10);
    }

    static int addAngle(int a1, int a2) {
        return cMath.normAngle(a1 + a2);
    }

    static int subAngle(int a1, int a2) {
        return cMath.normAngle(a1 - a2);
    }

    static int subAngleDistance(int a1, int a2) {
        int dif = cMath.normAngle(a1 - a2);
        if (dif > 2048) {
            dif = 4096 - dif;
        }
        return dif;
    }

    static int angleZeroTo2PI(int a) {
        while (a < 0) {
            a += 4096;
        }
        return a & 0xFFF;
    }

    public static int sqrt(int x) {
        int r = 0;
        for (x = x + 1 >> 1; x > r; x -= r++) {
        }
        return r;
    }

    public static void skewZonXY(int amount, int rx, int ry, float[] m) {
        m[0] = 1.0f;
        m[1] = 0.0f;
        m[2] = (float)(amount * rx) / 4096.0f;
        m[3] = 0.0f;
        m[4] = 0.0f;
        m[5] = 1.0f;
        m[6] = (float)(amount * ry) / 4096.0f;
        m[7] = 0.0f;
        m[8] = 0.0f;
        m[9] = 0.0f;
        m[10] = (float)amount / 4096.0f;
        m[11] = 0.0f;
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    static void srand(int seed) {
        rndx = seed;
        rndy = 842502087L;
        rndz = 3579807591L;
        rndw = 273326509L;
    }

    private static int rand() {
        long t = rndx ^ rndx << 11;
        rndx = rndy;
        rndy = rndz;
        rndz = rndw;
        long rtn = (rndw = rndw ^ rndw >> 19 ^ (t ^ t >> 8)) & Integer.MAX_VALUE;
        if (rtn == Integer.MAX_VALUE) {
            return cMath.rand();
        }
        return (int)rtn;
    }

    static int rand(int lowerBound, int upperBound) {
        if (lowerBound > upperBound) {
            int t = lowerBound;
            lowerBound = upperBound;
            upperBound = t;
        }
        long rnd = cMath.rand();
        int range = upperBound - lowerBound;
        return (int)((long)lowerBound + (rnd * (long)range >> 31));
    }

    private static boolean pointInTriangle(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3) {
        long fAB = (y - y1) * (x2 - x1) - (x - x1) * (y2 - y1);
        long fBC = (y - y2) * (x3 - x2) - (x - x2) * (y3 - y2);
        long fCA = (y - y3) * (x1 - x3) - (x - x3) * (y1 - y3);
        if (fBC < 5000L && fBC > -5000L || fAB < 5000L && fAB > -5000L || fCA < 5000L && fCA > -5000L) {
            boolean c = false;
            if ((y1 <= y && y < y3 || y3 <= y && y < y1) && x < (x3 - x1) * (y - y1) / (y3 - y1) + x1) {
                c = true;
            }
            if ((y2 <= y && y < y1 || y1 <= y && y < y2) && x < (x1 - x2) * (y - y2) / (y1 - y2) + x2) {
                boolean bl = c = !c;
            }
            if ((y3 <= y && y < y2 || y2 <= y && y < y3) && x < (x2 - x3) * (y - y3) / (y2 - y3) + x3) {
                c = !c;
            }
            return c;
        }
        if (fAB * fBC <= 0L) {
            return false;
        }
        return fBC * fCA > 0L;
    }

    static boolean pointInRectangle(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        boolean in = cMath.pointInTriangle(x, y, x1, y1, x2, y2, x3, y3);
        if (!in) {
            in = cMath.pointInTriangle(x, y, x2, y2, x4, y4, x3, y3);
        }
        return in;
    }

    public static void getScrCoorFrom3D(int nearView, int width, int height, int viewportW, int viewportH, int viewX, int viewY, int viewZ, int upX, int upY, int upZ, int rightX, int rightY, int rightZ, int eyeX, int eyeY, int eyeZ, int pX, int pY, int pZ) {
        int projView = 0;
        int projViewX = 0;
        int projViewY = 0;
        int projViewZ = 0;
        int projRight = 0;
        int projRightX = 0;
        int projRightY = 0;
        int projRightZ = 0;
        int projUp = 0;
        int projUpSgn = 0;
        int dir1X = 0;
        int dir1Y = 0;
        int dir1Z = 0;
        int dir2X = 0;
        int dir2Y = 0;
        int dir2Z = 0;
        int dir3X = 0;
        int dir3Y = 0;
        int dir3Z = 0;
        dir1X = pX - eyeX;
        dir1Y = pY - eyeY;
        dir1Z = pZ - eyeZ;
        projView = (dir1X * viewX >> 12) + (dir1Y * viewY >> 12) + (dir1Z * viewZ >> 12);
        if (projView <= nearView) {
            s_viewportX = -(viewportW << 1);
            s_viewportY = -(viewportH << 1);
            return;
        }
        projViewX = viewX * projView >> 12;
        projViewY = viewY * projView >> 12;
        projViewZ = viewZ * projView >> 12;
        dir2X = dir1X - projViewX;
        dir2Y = dir1Y - projViewY;
        dir2Z = dir1Z - projViewZ;
        projRight = (dir2X * rightX >> 12) + (dir2Y * rightY >> 12) + (dir2Z * rightZ >> 12);
        projRightX = rightX * projRight >> 12;
        projRightY = rightY * projRight >> 12;
        projRightZ = rightZ * projRight >> 12;
        dir3X = dir1X - (projViewX + projRightX);
        dir3Y = dir1Y - (projViewY + projRightY);
        dir3Z = dir1Z - (projViewZ + projRightZ);
        projUp = projUpSgn = (dir3X * upX >> 12) + (dir3Y * upY >> 12) + (dir3Z * upZ >> 12);
        s_viewportX = (viewportW * projRight * nearView << 7) / (width * projView);
        s_viewportY = (viewportH * projUp * nearView << 7) / (height * projView);
    }

    public static void get3DFromScrCoor(int nearView, int width, int height, int viewportW, int viewportH, int viewX, int viewY, int viewZ, int upX, int upY, int upZ, int rightX, int rightY, int rightZ, int eyeX, int eyeY, int eyeZ, int scrX, int scrY) {
        int projView = 100 * nearView;
        int projViewX = projView * viewX >> 12;
        int projViewY = projView * viewY >> 12;
        int projViewZ = projView * viewZ >> 12;
        int projRight = 100 * scrX * width / viewportW >> 7;
        int projRightX = projRight * rightX >> 12;
        int projRightY = projRight * rightY >> 12;
        int projRightZ = projRight * rightZ >> 12;
        int projUp = 100 * scrY * height / viewportH >> 7;
        int projUpX = projUp * upX >> 12;
        int projUpY = projUp * upY >> 12;
        int projUpZ = projUp * upZ >> 12;
        s_3DPosX = eyeX + projViewX + (projRightX + projUpX);
        s_3DPosY = eyeY + projViewY + (projRightY + projUpY);
        s_3DPosZ = eyeZ + projViewZ + (projRightZ + projUpZ);
    }

    public static boolean IntersectionOfTwoLines(int aX, int aY, int bX, int bY, int cX, int cY, int dX, int dY) {
        int denominator = (bX - aX) * (dY - cY) - (bY - aY) * (dX - cX);
        if (denominator == 0) {
            return false;
        }
        int numeratorR = (aY - cY) * (dX - cX) - (aX - cX) * (dY - cY);
        int numeratorS = (aY - cY) * (bX - aX) - (aX - cX) * (bY - aY);
        return !(denominator > 0 ? 0 > numeratorR || numeratorR > denominator || 0 > numeratorS || numeratorS > denominator : denominator > numeratorR || numeratorR > 0 || denominator > numeratorS || numeratorS > 0);
    }

    static {
        new cMatrix();
        cosTable = null;
        atanTable = null;
        randGen = new Random();
        ATAN_SIZE = 512;
        s_viewportX = 0;
        s_viewportY = 0;
        s_3DPosX = 0;
        s_3DPosY = 0;
        s_3DPosZ = 0;
    }
}

