/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class LogoScreen {
    private GameCanvas mainCanvas;
    private Player player = null;
    private int soundTigerLogo = 0;
    private int iNum = 0;
    private int LCD_WIDTH = 240;
    private int LCD_HEIGHT = 320;
    private int LCD_CENTERX = this.LCD_WIDTH >> 1;
    private int LCD_CENTERY = this.LCD_HEIGHT >> 1;
    private int KEY_SOFT1 = -6;
    private int KEY_SOFT2 = -7;
    public final int[] TouchLR = new int[]{0, this.LCD_HEIGHT - 20, 30, this.LCD_HEIGHT, this.LCD_WIDTH - 30, this.LCD_HEIGHT - 20, this.LCD_WIDTH, this.LCD_HEIGHT};
    private Image[] img = null;
    private int state = 0;
    private int moveState = 0;
    private int x = 0;
    private int y = 0;
    private int clip_W = 150;
    private int clip_H = 74;
    private int clip_X = 11;
    private int clip_Y = 70;
    private int[][] pos = new int[][]{{11, 78}, {64, 86}, {114, 86}};
    private int[] pos2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 18};
    private byte[][] posMove = new byte[][]{{0, 0, 5}, {64, 75, 5}, {0, 0, 5}, {0, 0, 5}, {62, 72, 7}, {0, 0, 5}, {0, 0, 5}, {62, 72, 8}, {118, 74, 5}, {10, 72, 8}, {64, 75, 5}, {114, 72, 7}, {10, 72, 7}, {0, 0, 5}, {114, 72, 8}, {10, 72, 8}, {64, 75, 5}, {114, 72, 7}, {10, 72, 7}, {0, 0, 5}, {114, 72, 8}, {10, 72, 8}, {64, 75, 5}, {114, 72, 7}, {10, 72, 7}, {0, 0, 5}, {114, 72, 8}, {10, 72, 8}, {64, 75, 5}, {114, 72, 7}, {10, 72, 7}, {0, 0, 5}, {114, 72, 8}, {13, 95, 3}, {64, 75, 5}, {114, 72, 7}, {13, 71, 3}, {0, 0, 5}, {114, 72, 8}, {13, 90, 3}, {64, 75, 5}, {114, 72, 7}, {13, 76, 3}, {0, 0, 5}, {114, 72, 8}, {13, 82, 3}, {64, 75, 5}, {114, 72, 7}, {13, 84, 3}, {0, 0, 5}, {114, 72, 8}, {13, 82, 3}, {64, 75, 5}, {114, 72, 7}, {13, 82, 3}, {0, 0, 5}, {114, 72, 8}, {13, 82, 3}, {64, 95, 2}, {114, 72, 7}, {13, 82, 3}, {64, 71, 2}, {114, 72, 8}, {13, 82, 3}, {64, 90, 2}, {118, 74, 5}, {13, 82, 3}, {64, 76, 2}, {114, 72, 7}, {13, 82, 3}, {64, 82, 2}, {114, 72, 8}, {13, 82, 3}, {64, 84, 2}, {118, 74, 5}, {13, 82, 3}, {64, 82, 2}, {123, 95, 4}, {13, 82, 3}, {64, 82, 2}, {123, 71, 4}, {13, 82, 3}, {64, 82, 2}, {123, 90, 4}, {13, 82, 3}, {64, 82, 2}, {123, 76, 4}, {13, 82, 3}, {64, 82, 2}, {123, 88, 4}, {13, 82, 3}, {64, 82, 2}, {123, 82, 4}, {13, 82, 3}, {64, 82, 2}, {123, 88, 4}};

    public LogoScreen(GameCanvas mainCanvas, int soft1, int soft2, int w, int h, int soundTigerLogo) {
        this.mainCanvas = mainCanvas;
        this.soundTigerLogo = soundTigerLogo;
        this.KEY_SOFT1 = soft1;
        this.KEY_SOFT2 = soft2;
        this.LCD_WIDTH = w;
        this.LCD_HEIGHT = h;
        this.LCD_CENTERX = this.LCD_WIDTH >> 1;
        this.LCD_CENTERY = this.LCD_HEIGHT >> 1;
        this.soundTigerLogoState();
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.LCD_WIDTH, this.LCD_HEIGHT);
        switch (this.state) {
            case 0: {
                if (this.soundTigerLogo == 0) {
                    ++this.iNum;
                    if (this.iNum > 10) {
                        this.iNum = 0;
                        this.state = 1;
                    }
                    g.drawImage(this.img[9], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    break;
                }
                if (this.soundTigerLogo == 1) {
                    ++this.iNum;
                    if (this.iNum > 10) {
                        this.iNum = 0;
                        this.state = 2;
                    }
                    g.drawImage(this.img[9], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    break;
                }
                if (this.soundTigerLogo == 2) {
                    ++this.iNum;
                    if (this.iNum > 10) {
                        this.iNum = 0;
                        this.state = 10;
                    }
                    g.drawImage(this.img[5], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    break;
                }
                if (this.soundTigerLogo != 3) break;
                ++this.iNum;
                if (this.iNum > 10) {
                    this.iNum = 0;
                    this.state = 10;
                }
                g.drawImage(this.img[5], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                break;
            }
            case 1: 
            case 15: {
                g.drawImage(this.img[9], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                g.setColor(-1);
                g.drawString("\u662f\u5426\u5f00\u542f\u58f0\u97f3", this.LCD_CENTERX, this.LCD_HEIGHT - 20, 33);
                g.drawString("\u662f", 0, this.LCD_HEIGHT, 36);
                g.drawString("\u5426", this.LCD_WIDTH, this.LCD_HEIGHT, 40);
                break;
            }
            case 2: {
                this.renderTigerLogo(g);
                break;
            }
            case 10: {
                ++this.iNum;
                if (this.iNum < 30) {
                    g.drawImage(this.img[2], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    g.setColor(-1);
                    g.drawString("\u624b\u673a\u6e38\u620f", this.LCD_CENTERX, this.LCD_CENTERY + (this.img[2].getHeight() >> 1) + 4, 17);
                    break;
                }
                if (this.iNum >= 30 && this.iNum < 60) {
                    g.drawImage(this.img[3], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    break;
                }
                if (this.iNum >= 60 && this.iNum < 90) {
                    g.drawImage(this.img[4], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    break;
                }
                this.iNum = 0;
                this.destroy();
                this.mainCanvas.loadIndex = 0;
                this.mainCanvas.getClass();
                this.mainCanvas.gameState = 104;
                this.mainCanvas.getClass();
                this.mainCanvas.gameLoadState = 101;
                this.mainCanvas.musicIndex = 1;
                return;
            }
            case 20: {
                ++this.iNum;
                if (this.iNum < 30) {
                    g.drawImage(this.img[0], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    break;
                }
                if (this.iNum >= 30 && this.iNum < 60) {
                    g.drawImage(this.img[1], this.LCD_CENTERX, this.LCD_CENTERY, 3);
                    break;
                }
                this.iNum = 0;
                this.destroy();
                this.mainCanvas.loadIndex = 0;
                this.mainCanvas.getClass();
                this.mainCanvas.gameState = 104;
                this.mainCanvas.getClass();
                this.mainCanvas.gameLoadState = 101;
                this.mainCanvas.musicIndex = 1;
                return;
            }
        }
    }

    public void keyPressedEvent(int keyCode) {
        if (this.state == 1 || this.state == 15) {
            this.mainCanvas.isMusic = false;
            this.iNum = 0;
            if (keyCode == this.KEY_SOFT1) {
                this.key(true);
                this.soundStart();
            } else if (keyCode == this.KEY_SOFT2) {
                this.key(false);
            }
        }
    }

    public void keyReleasedEvent(int keyCode) {
    }

    public void pointerKeyPressed(int x, int y) {
        if (this.state == 1) {
            if (this.touch(x, y, this.TouchLR[0], this.TouchLR[1], this.TouchLR[2], this.TouchLR[3])) {
                this.keyPressedEvent(this.KEY_SOFT1);
            } else if (this.touch(x, y, this.TouchLR[4], this.TouchLR[5], this.TouchLR[6], this.TouchLR[7])) {
                this.keyPressedEvent(this.KEY_SOFT2);
            }
        }
    }

    public void destroy() {
        if (this.img != null) {
            for (int i = 0; i < this.img.length; ++i) {
                this.img[i] = null;
            }
            this.img = null;
        }
        try {
            if (this.player != null) {
                this.player.stop();
                this.player.close();
            }
            this.player = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("\u91ca\u653elogo\u56fe\u7247\u548c\u58f0\u97f3");
    }

    public void initSound() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/logo/logo.mid");
            this.player = Manager.createPlayer((InputStream)in, (String)"audio/midi");
            this.player.realize();
            this.player.prefetch();
            this.player.setLoopCount(1);
        }
        catch (IOException ex) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private final void renderTigerLogo(Graphics g) {
        g.drawImage(this.img[6], this.x, this.y, 0);
        g.setClip(this.clip_X + this.x, this.clip_Y + this.y, this.clip_W, this.clip_H);
        switch (this.moveState) {
            case 0: {
                ++this.iNum;
                if (this.iNum == this.pos2.length - 1) {
                    this.moveState = 1;
                    this.iNum = 0;
                    return;
                }
                g.drawImage(this.img[2], this.pos[0][0] + this.x, this.pos[0][1] + this.y + this.pos2[this.iNum], 0);
                g.drawImage(this.img[0], this.pos[1][0] + this.x, this.pos[1][1] + this.y + this.pos2[this.iNum], 0);
                g.drawImage(this.img[1], this.pos[2][0] + this.x, this.pos[2][1] + this.y + this.pos2[this.iNum], 0);
                break;
            }
            case 1: {
                g.drawImage(this.img[this.posMove[0 + this.iNum][2]], this.posMove[0 + this.iNum][0] + this.x, this.posMove[0 + this.iNum][1] + this.y, 0);
                g.drawImage(this.img[this.posMove[1 + this.iNum][2]], this.posMove[1 + this.iNum][0] + this.x, this.posMove[1 + this.iNum][1] + this.y, 0);
                g.drawImage(this.img[this.posMove[2 + this.iNum][2]], this.posMove[2 + this.iNum][0] + this.x, this.posMove[2 + this.iNum][1] + this.y, 0);
                this.iNum += 3;
                if (this.iNum <= this.posMove.length - 3) break;
                this.iNum = 0;
                this.moveState = 2;
                break;
            }
            case 2: {
                if (++this.iNum > 25) {
                    this.iNum = 0;
                    this.destroy();
                    this.mainCanvas.loadIndex = 0;
                    this.mainCanvas.getClass();
                    this.mainCanvas.gameState = 104;
                    this.mainCanvas.getClass();
                    this.mainCanvas.gameLoadState = 101;
                    this.mainCanvas.musicIndex = 1;
                    return;
                }
                g.drawImage(this.img[this.posMove[this.posMove.length - 3][2]], this.posMove[this.posMove.length - 3][0] + this.x, this.posMove[this.posMove.length - 3][1] + this.y, 0);
                g.drawImage(this.img[this.posMove[this.posMove.length - 2][2]], this.posMove[this.posMove.length - 2][0] + this.x, this.posMove[this.posMove.length - 2][1] + this.y, 0);
                g.drawImage(this.img[this.posMove[this.posMove.length - 1][2]], this.posMove[this.posMove.length - 1][0] + this.x, this.posMove[this.posMove.length - 1][1] + this.y, 0);
            }
        }
        g.setClip(0, 0, this.LCD_WIDTH, this.LCD_HEIGHT);
    }

    private final void soundStart() {
        if (this.player != null) {
            try {
                this.player.start();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public void drawFrameX(Graphics g, Image img, int current, int w, int h, int x, int y) {
        g.setClip(x, y, w, h);
        g.drawImage(img, x - current * w, y, 0);
        g.setClip(0, 0, this.LCD_WIDTH, this.LCD_HEIGHT);
    }

    public boolean touch(int x, int y, int x1, int y1, int x2, int y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    private final void key(boolean isSound) {
        this.mainCanvas.isMusic = isSound;
        this.iNum = 0;
        switch (this.soundTigerLogo) {
            case 0: {
                this.moveState = 0;
                this.state = 2;
                break;
            }
            case 2: {
                this.state = 10;
                break;
            }
            case 5: {
                this.state = 20;
            }
        }
    }

    private final void soundTigerLogoState() {
        switch (this.soundTigerLogo) {
            case 0: {
                this.initImage();
                this.initGame();
                this.initSound();
                break;
            }
            case 1: {
                this.initImage();
                this.initGame();
                this.state = 0;
                break;
            }
            case 2: {
                this.init();
                this.initSound();
                this.state = 0;
                break;
            }
            case 3: {
                this.init();
                this.state = 0;
                break;
            }
            case 4: {
                this.init2();
                this.state = 20;
                break;
            }
            case 5: {
                this.init2();
                this.state = 15;
            }
        }
    }

    private final void init() {
        this.img = new Image[6];
        this.img[2] = this.createImage("/logo/logo2.png");
        this.img[3] = this.createImage("/logo/logo3.png");
        this.img[4] = this.createImage("/logo/logo4.png");
        this.img[5] = this.createImage("/logo/gameback.png");
    }

    private final void init2() {
        this.img = new Image[2];
        this.img[0] = this.createImage("/logo/QQlogo.png");
        this.img[1] = this.createImage("/logo/sky.png");
    }

    private void initGame() {
        this.x = this.LCD_WIDTH - 176 >> 1;
        this.y = this.LCD_HEIGHT > 208 ? this.LCD_HEIGHT - 208 >> 1 : 0;
    }

    public void initImage() {
        this.img = new Image[10];
        for (int i = 0; i < 6; ++i) {
            this.img[i] = this.createImage("/logo/logo" + i + ".png");
        }
        this.img[6] = this.createImage("/logo/bg.png");
        this.img[7] = this.createImage("/logo/logo51.png");
        this.img[8] = this.createImage("/logo/logo52.png");
        this.img[9] = this.createImage("/logo/gameback.png");
    }

    public final Image createImage(String path) {
        Image tempImg = null;
        try {
            tempImg = Image.createImage((String)path);
        }
        catch (Exception e) {
            System.out.println("create image erro: path " + path);
        }
        return tempImg;
    }
}

