/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.math;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.math.Interpolator;

public class InterpolatorLinear
extends Interpolator {
    private static final int DEFAULT_INTERPOLATION_TIME = 500;
    private int mInterpTargetTime = 500;
    private int mInterpTime = 0;
    private int mStartX = 0;
    private int mStartY = 0;
    private int mOffsetX = 0;
    private int mOffsetY = 0;
    private int mDeltaX = 0;
    private int mDeltaY = 0;

    public void update(int n) {
        if (this.mInterpTime < this.mInterpTargetTime) {
            this.mInterpTime += n;
            if (this.mInterpTime >= this.mInterpTargetTime) {
                this.mInterpTime = this.mInterpTargetTime;
                this.mOffsetX = this.mDeltaX;
                this.mOffsetY = this.mDeltaY;
            } else {
                int n2 = PMMath.DIV(this.mInterpTime << 16, this.mInterpTargetTime << 16);
                this.mOffsetX = PMMath.MUL(n2, this.mDeltaX);
                this.mOffsetY = PMMath.MUL(n2, this.mDeltaY);
            }
        }
    }

    public boolean isDone() {
        return this.mInterpTime >= this.mInterpTargetTime;
    }

    public void set(int n, int n2, int n3, int n4) {
        this.mStartX = n;
        this.mStartY = n2;
        this.mDeltaX = n3 - n;
        this.mDeltaY = n4 - n2;
        this.mOffsetX = 0;
        this.mOffsetY = 0;
        this.mInterpTargetTime = 500;
        this.mInterpTime = 0;
    }

    public int getX() {
        return this.mStartX + this.mOffsetX;
    }

    public int getY() {
        return this.mStartY + this.mOffsetY;
    }
}

