/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.items;

import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.VisualEffect;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Health {
    private static final int HALF_WIDTH = 8;
    private static final int HALF_WIDTH_FP = 524288;
    private static final int STATE_HEALTH_IDLE = 0;
    private static final int STATE_HEALTH_GONE = 1;
    private static final int FULL_HEALTH_ALPHA = 0x500000;
    private static final int NORMAL_HEALTH_ALPHA = 0xFF0000;
    private World mWorldRef;
    private Vector2[] mPositions;
    private int[] mStates;
    private Movie mAnimIdle;
    private boolean mFullHealth;
    private int mCurrentAlpha;

    public Health(Vector2[] vector2Array, World world) {
        this.mPositions = vector2Array;
        this.mWorldRef = world;
        this.mStates = new int[vector2Array.length];
        this.mFullHealth = true;
        this.mCurrentAlpha = 0x500000;
        this.mAnimIdle = Movie.load((short)16246);
        this.mAnimIdle.loadGfx();
        this.mAnimIdle.gotoTick(0);
    }

    public void update(boolean bl) {
        this.mAnimIdle.update(Timer.mDt);
        this.mFullHealth = bl;
        if (this.mFullHealth) {
            if (this.mCurrentAlpha > 0x500000) {
                this.mCurrentAlpha -= 4092 * Timer.mDt;
                if (this.mCurrentAlpha < 0x500000) {
                    this.mCurrentAlpha = 0x500000;
                }
            }
        } else if (this.mCurrentAlpha < 0xFF0000) {
            this.mCurrentAlpha += 4092 * Timer.mDt;
            if (this.mCurrentAlpha > 0xFF0000) {
                this.mCurrentAlpha = 0xFF0000;
            }
        }
    }

    public void draw(Vector2 vector2) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mStates[i] == 1) continue;
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 1;
            long l2 = (long)vector2.mX * 5L >> 1;
            int n = (int)((l >> 16) - (l2 >> 16));
            int n2 = 40;
            long l3 = (long)vector22.mY * 5L >> 1;
            long l4 = (long)vector2.mY * 5L >> 1;
            int n3 = (int)((l3 >> 16) - (l4 >> 16));
            int n4 = 40;
            if (!Camera.isInside(n - (n2 >> 1), n3 - (n4 >> 1), n2, n4)) continue;
            this.mAnimIdle.drawAlpha(n, n3, this.mCurrentAlpha >> 16);
        }
    }

    public int collision(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mStates[i] != 0) continue;
            Vector2 vector2 = this.mPositions[i];
            int n5 = vector2.mX - 524288;
            int n6 = vector2.mX + 524288;
            int n7 = vector2.mY - 524288;
            int n8 = vector2.mY + 524288;
            if (n3 < n5 || n > n6 || n4 < n7 || n2 > n8) continue;
            return i;
        }
        return -1;
    }

    public void take(int n) {
        Vector2 vector2 = this.mPositions[n];
        this.mStates[n] = 1;
        VisualEffect.spawn(0, vector2);
    }
}

