/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.enemies.Enemy3Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy3State;
import dk.progressivemedia.skeleton.game.enemies.Enemy3StateDieing;
import dk.progressivemedia.skeleton.game.enemies.Enemy3StateFalling;
import dk.progressivemedia.skeleton.game.enemies.Enemy3StateWalking;
import dk.progressivemedia.skeleton.game.enemies.Enemy3View;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy3StateController {
    private Enemy3Data mData;
    private Enemy3View mView;
    public static final int STATE_FALLING = 0;
    public static final int STATE_WALKING = 1;
    public static final int STATE_DIEING = 2;
    private int mActiveStateID;
    private Enemy3State mActiveState;
    private Enemy3StateFalling mStateFalling;
    private Enemy3StateWalking mStateWalking;
    private Enemy3StateDieing mStateDieing;

    public Enemy3StateController(Enemy3Data enemy3Data, Enemy3View enemy3View) {
        this.mData = enemy3Data;
        this.mView = enemy3View;
        this.mStateFalling = new Enemy3StateFalling(enemy3Data, enemy3View, this);
        this.mStateWalking = new Enemy3StateWalking(enemy3Data, enemy3View, this);
        this.mStateDieing = new Enemy3StateDieing(enemy3Data, enemy3View, this);
        this.setInitialState();
    }

    public void update() {
        Vector2 vector2 = this.mData.getPositionRef();
        this.mData.setPositionPrev(vector2);
        this.mActiveState.update();
    }

    public void requestStateChange(int n) {
        this.mActiveState.exit();
        this.mActiveStateID = n;
        switch (n) {
            case 0: {
                this.mActiveState = this.mStateFalling;
                break;
            }
            case 1: {
                this.mActiveState = this.mStateWalking;
                break;
            }
            case 2: {
                this.mActiveState = this.mStateDieing;
            }
        }
        this.mActiveState.enter();
    }

    private void setInitialState() {
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getDimensionRef();
        SurfaceIntersectionResult surfaceIntersectionResult = new SurfaceIntersectionResult();
        World world = this.mData.getWorldRef();
        world.intersectionTest(vector2.mX, vector2.mY - 65536, 0, 0x100000, vector22.mX >> 1, surfaceIntersectionResult);
        if (surfaceIntersectionResult.mSurface != null) {
            this.mData.setSurface(surfaceIntersectionResult.mSurface, surfaceIntersectionResult.mSegmentIndex, surfaceIntersectionResult.mLengthOffset);
            Surface surface = surfaceIntersectionResult.mSurface;
            surface.getSurfacePosition(surfaceIntersectionResult.mSegmentIndex, surfaceIntersectionResult.mLengthOffset, vector22.mX >> 1, vector2);
            this.mActiveStateID = 1;
            this.mActiveState = this.mStateWalking;
            this.mActiveState.enter();
        } else {
            this.mActiveStateID = 0;
            this.mActiveState = this.mStateFalling;
            this.mActiveState.enter();
        }
    }
}

