/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.dangers;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.SoundBufferPositional;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Danger2s {
    private static final int HALF_WIDTH = 8;
    private static final int HALF_WIDTH_FP = 524288;
    private Vector2[] mPositions;
    private int[] mFireDelays;
    private int[] mJumpForces;
    private int[] mFireTimers;
    private int[] mJumpVelocities;
    private int[] mJumpOffsets;
    private boolean mRotate;
    private int mAngle;
    private int mDrawAngle;
    private Movie mAnimJumper;

    public Danger2s(Vector2[] vector2Array, int[] nArray, int[] nArray2, int[] nArray3) {
        this.mPositions = vector2Array;
        this.mFireDelays = nArray2;
        this.mJumpForces = nArray3;
        this.mFireTimers = new int[this.mPositions.length];
        this.mJumpVelocities = new int[this.mPositions.length];
        this.mJumpOffsets = new int[this.mPositions.length];
        for (int i = 0; i < this.mPositions.length; ++i) {
            this.mFireTimers[i] = nArray[i];
            this.mJumpVelocities[i] = 0;
            this.mJumpOffsets[i] = 0;
        }
        this.mAngle = 0;
        this.mDrawAngle = 0;
        switch (Defines.mWorldLookup[GameState.mLevel]) {
            case 0: {
                this.mAnimJumper = Movie.load((short)27060);
                this.mAnimJumper.loadGfx();
                this.mAnimJumper.gotoTick(0);
                this.mRotate = false;
                break;
            }
            case 1: {
                this.mAnimJumper = Movie.load((short)22999);
                this.mAnimJumper.loadGfx();
                this.mAnimJumper.gotoTick(0);
                this.mRotate = true;
                break;
            }
            case 2: 
            case 3: {
                this.mRotate = true;
                break;
            }
            case 4: {
                this.mAnimJumper = Movie.load((short)27060);
                this.mAnimJumper.loadGfx();
                this.mAnimJumper.gotoTick(0);
                this.mRotate = false;
            }
        }
    }

    public void update(AABB aABB) {
        if (this.mAnimJumper != null) {
            this.mAnimJumper.update(Timer.mDt);
        }
        if (this.mRotate) {
            this.mAngle += 3971 * Timer.mDt >> 6;
            while (this.mAngle > 65536) {
                this.mAngle -= 65536;
            }
            this.mDrawAngle = 359 * this.mAngle >> 16;
        }
        for (int i = 0; i < this.mPositions.length; ++i) {
            Vector2 vector2 = this.mPositions[i];
            if (this.mFireTimers[i] > 0) {
                if (vector2.mX < aABB.mMinX || vector2.mX > aABB.mMaxX || vector2.mY < aABB.mMinY || vector2.mY > aABB.mMaxY) continue;
                int n = i;
                this.mFireTimers[n] = this.mFireTimers[n] - Timer.mDt;
                if (this.mFireTimers[i] > 0) continue;
                this.mFireTimers[i] = 0;
                this.mJumpVelocities[i] = this.mJumpForces[i];
                SoundBufferPositional.play(37, 200, vector2.mX, vector2.mY + this.mJumpOffsets[i]);
                continue;
            }
            int n = i;
            this.mJumpVelocities[n] = this.mJumpVelocities[n] + Timer.mFeatureWorldGravity;
            if (this.mJumpVelocities[i] > Timer.mFeatureWorldGravityMax) {
                this.mJumpVelocities[i] = Timer.mFeatureWorldGravityMax;
            }
            int n2 = i;
            this.mJumpOffsets[n2] = this.mJumpOffsets[n2] + this.mJumpVelocities[i];
            if (this.mJumpOffsets[i] <= 0) continue;
            this.mFireTimers[i] = this.mFireDelays[i];
            this.mJumpVelocities[i] = 0;
            this.mJumpOffsets[i] = 0;
        }
    }

    public void draw(Vector2 vector2) {
        block7: for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mFireTimers[i] != 0) continue;
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 1;
            long l2 = (long)vector2.mX * 5L >> 1;
            int n = (int)((l >> 16) - (l2 >> 16));
            int n2 = 40;
            long l3 = (long)(vector22.mY + this.mJumpOffsets[i]) * 5L >> 1;
            long l4 = (long)vector2.mY * 5L >> 1;
            int n3 = (int)((l3 >> 16) - (l4 >> 16));
            int n4 = 40;
            if (!Camera.isInside(n - (n2 >> 1), n3 - (n4 >> 1), n2, n4)) continue;
            switch (Defines.mWorldLookup[GameState.mLevel]) {
                case 0: {
                    this.mAnimJumper.draw(n, n3);
                    continue block7;
                }
                case 1: {
                    this.mAnimJumper.draw(n, n3, this.mDrawAngle);
                    continue block7;
                }
                case 2: {
                    PMImageManager.draw(745, n, n3, false, this.mDrawAngle);
                    continue block7;
                }
                case 3: {
                    PMImageManager.draw(743, n, n3, false, this.mDrawAngle);
                    continue block7;
                }
                case 4: {
                    this.mAnimJumper.draw(n, n3);
                }
            }
        }
    }

    public boolean collision(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mPositions.length; ++i) {
            if (this.mFireTimers[i] != 0) continue;
            Vector2 vector2 = this.mPositions[i];
            int n5 = vector2.mX - 524288;
            int n6 = vector2.mX + 524288;
            int n7 = vector2.mY + this.mJumpOffsets[i] - 524288;
            int n8 = vector2.mY + this.mJumpOffsets[i] + 524288;
            if (n3 < n5 || n > n6 || n4 < n7 || n2 > n8) continue;
            return true;
        }
        return false;
    }
}

