/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.math.AABB;

public class SoundBufferPositional {
    private static final int NUM_BUFFERED = 50;
    private static int[] mFree = new int[50];
    private static int mCurFreeSlot = 0;
    private static boolean[] mActive = new boolean[50];
    private static int[] mEffects = new int[50];
    private static int[] mTimeouts = new int[50];
    private static int[] mVolumen = new int[50];
    private static int mNumBuffered;
    private static AABB mCameraAABB;

    public static void init() {
        for (int i = 0; i < 50; ++i) {
            SoundBufferPositional.mFree[i] = i == 49 ? -1 : i + 1;
            SoundBufferPositional.mActive[i] = false;
        }
        mCurFreeSlot = 0;
    }

    public static void update(int n, int n2) {
        SoundBufferPositional.mCameraAABB.mMinX = n;
        SoundBufferPositional.mCameraAABB.mMinY = n2;
        SoundBufferPositional.mCameraAABB.mMaxX = n + 0x2800000;
        SoundBufferPositional.mCameraAABB.mMaxY = n2 + 23592960;
        for (int i = 0; i < 50; ++i) {
            if (!mActive[i]) continue;
            int n3 = mVolumen[i] * 10 / 255;
            if (n3 > 0) {
                PMAudio.play(mEffects[i], 1);
            }
            PMAudio.setVolume(mEffects[i], mVolumen[i] * 10 / 255);
            PMAudio.update();
            if (mTimeouts[i] > 0) {
                int n4 = i;
                mTimeouts[n4] = mTimeouts[n4] - Timer.mDt;
            }
            if (!PMAudio.isPlaying(mEffects[i], -1) && mTimeouts[i] >= 0) continue;
            SoundBufferPositional.mFree[i] = mCurFreeSlot;
            mCurFreeSlot = i;
            SoundBufferPositional.mActive[i] = false;
        }
    }

    public static void play(int n, int n2, int n3, int n4) {
        int n5 = mCurFreeSlot;
        if (n5 >= 0) {
            mCurFreeSlot = mFree[n5];
            SoundBufferPositional.mActive[n5] = true;
            SoundBufferPositional.mEffects[n5] = n;
            SoundBufferPositional.mTimeouts[n5] = n2;
            int n6 = 0;
            int n7 = 0;
            if (n3 < SoundBufferPositional.mCameraAABB.mMinX) {
                n6 = SoundBufferPositional.mCameraAABB.mMinX - n3;
            } else if (n3 > SoundBufferPositional.mCameraAABB.mMaxX) {
                n6 = n3 - SoundBufferPositional.mCameraAABB.mMaxX;
            }
            if (n4 < SoundBufferPositional.mCameraAABB.mMinY) {
                n7 = SoundBufferPositional.mCameraAABB.mMinY - n4;
            } else if (n4 > SoundBufferPositional.mCameraAABB.mMaxY) {
                n7 = n4 - SoundBufferPositional.mCameraAABB.mMaxY;
            }
            if (n6 == 0 && n7 == 0) {
                SoundBufferPositional.mVolumen[n5] = 255;
            } else {
                int n8 = n6 > n7 ? n6 : n7;
                SoundBufferPositional.mVolumen[n5] = n8 > 0x190000 ? 0 : 255 * (65536 - PMMath.DIV(n8, 0x190000)) >> 16;
            }
        }
    }

    static {
        mCameraAABB = new AABB();
    }
}

