/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.system;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMTimer;
import dk.progressivemedia.rflib.util.PMLoading;
import dk.progressivemedia.skeleton.Main;

public class PMSystem {
    public static boolean externalPause;
    public static boolean internalLoop;
    public static long time1;
    public static long time2;
    public static int frameCapDuration;
    public static final int FRAME_CAPDURATION = 32;

    public static void nextFrame() {
        if (internalLoop) {
            PMDebug.println("Warning: internal loop detected!");
        }
        internalLoop = true;
        PMLoading.stop();
        PMAudio.update();
        PMCanvas.PMInput_readKeys();
        Main.preFlush();
        PMCanvas.PMGraphics_flush();
        PMSystem.frameCap();
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void gc() {
        System.gc();
    }

    public static void forceGC() {
        long l = Runtime.getRuntime().freeMemory();
        System.gc();
        for (int i = 0; i < 10; ++i) {
            Thread.yield();
            if (Runtime.getRuntime().freeMemory() >= l) continue;
            return;
        }
    }

    public static void beginFrameCap() {
        PMSystem.beginFrameCap(32);
    }

    public static void beginFrameCap(int n) {
        frameCapDuration = n;
        time1 = PMTimer.tick();
    }

    public static void endFrameCap() {
        time2 = PMTimer.tick();
        if (time2 - time1 < (long)frameCapDuration) {
            PMSystem.sleep((long)frameCapDuration - (time2 - time1));
        }
    }

    public static void frameCap() {
        time2 = PMTimer.tick();
        if (time2 - time1 < 32L) {
            PMSystem.sleep(32L - (time2 - time1));
        }
        time1 = PMTimer.tick();
    }

    static {
        internalLoop = false;
    }
}

