/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.VarProxy;
import dk.progressivemedia.skeleton.math.InterpolatorSpring;
import dk.progressivemedia.skeleton.menu.StateLevelSelection;

public class LevelSelectionHUD {
    private static final int STATE_ENTERING = 0;
    private static final int STATE_IDLE = 1;
    private int mState = 0;
    private InterpolatorSpring mSpringLifeBox;
    private InterpolatorSpring mSpringGoldcoin;
    private InterpolatorSpring mSpringChest;
    private static final int BUTTON_ID_ACCEPT = 0;
    private static final int BUTTON_ID_BACK = 1;
    private static final int BUTTON_COUNT = 2;
    private int[] mButtonCoords = new int[8];
    private int[] mButtonID = new int[2];
    private boolean[] mButtonPressed = new boolean[2];
    private static final int PRESSED_OFFSET = 2;

    public LevelSelectionHUD() {
        int n;
        for (n = 0; n < 2; ++n) {
            this.mButtonPressed[n] = false;
        }
        this.mButtonID[0] = 0;
        this.mButtonCoords[0] = 553;
        this.mButtonCoords[1] = 285;
        this.mButtonCoords[2] = 623;
        this.mButtonCoords[3] = 355;
        this.mButtonID[1] = 1;
        this.mButtonCoords[4] = 559;
        this.mButtonCoords[5] = 7;
        this.mButtonCoords[6] = 617;
        this.mButtonCoords[7] = 65;
        Touch.init(2, this.mButtonCoords, this.mButtonID, true);
        this.mSpringLifeBox = new InterpolatorSpring();
        this.mSpringGoldcoin = new InterpolatorSpring();
        this.mSpringChest = new InterpolatorSpring();
        n = -12320768;
        int n2 = 0;
        int n3 = -(VarProxy.HUD_goldcoinY + 80 << 16);
        int n4 = VarProxy.HUD_goldcoinY << 16;
        int n5 = -(VarProxy.HUD_chestY + 34 << 16);
        int n6 = VarProxy.HUD_chestY << 16;
        this.mSpringLifeBox.set(n, 0, n2, 0);
        this.mSpringGoldcoin.set(VarProxy.HUD_goldcoinX << 16, n3, VarProxy.HUD_goldcoinX << 16, n4);
        this.mSpringChest.set(VarProxy.HUD_chestX << 16, n5, VarProxy.HUD_chestX << 16, n6);
    }

    public void update() {
        if (this.mState == 1) {
            if (!Dialog.isActive()) {
                for (int i = 0; i < 2; ++i) {
                    this.mButtonPressed[i] = Touch.isDown(this.mButtonID[i]) || Touch.isPressed(this.mButtonID[i]);
                }
                if (Touch.wasReleased(0) || Touch.isPressed(0)) {
                    StateLevelSelection.transitionToGame();
                } else if (Touch.wasReleased(1) || Touch.isPressed(1)) {
                    StateLevelSelection.transitionToSaveMenu();
                }
            }
        } else {
            this.mSpringLifeBox.update(Timer.mDt);
            this.mSpringChest.update(Timer.mDt);
            this.mSpringGoldcoin.update(Timer.mDt);
            if (this.mSpringLifeBox.isDone() && this.mSpringChest.isDone() && this.mSpringGoldcoin.isDone()) {
                this.mState = 1;
            }
        }
    }

    public void draw(int n) {
        int n2 = 255 * n >> 16;
        int n3 = this.mSpringLifeBox.getX() >> 16;
        int n4 = this.mSpringLifeBox.getY() >> 16;
        PMImageManager.draw(485, n3, n4);
        int n5 = VarProxy.HUD_livesX + n3;
        int n6 = VarProxy.HUD_livesY;
        PMImageManager.draw(479, n5, n6);
        PMImageManager.draw(484, n5 += 18, n6);
        PMCanvas.PMGraphics_drawString(n5 += 26, n6 - 33, "" + GameState.mLives, 0);
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    n5 = VarProxy.HUD_health1X + n3;
                    n6 = VarProxy.HUD_health1Y;
                    break;
                }
                case 1: {
                    n5 = VarProxy.HUD_health2X + n3;
                    n6 = VarProxy.HUD_health2Y;
                    break;
                }
                case 2: {
                    n5 = VarProxy.HUD_health3X + n3;
                    n6 = VarProxy.HUD_health3Y;
                }
            }
            PMImageManager.draw(480, n5, n6);
        }
        n5 = 588 + (this.mButtonPressed[1] ? 2 : 0);
        n6 = 36 + (this.mButtonPressed[1] ? 2 : 0);
        PMImageManager.draw(501, n5, n6, false, 0, n2);
        n5 = 588 + (this.mButtonPressed[0] ? 2 : 0);
        n6 = 320 + (this.mButtonPressed[0] ? 2 : 0);
        PMImageManager.draw(500, n5, n6, false, 0, n2);
        if (Defines.mNumChests[GameState.mLevel] > 0) {
            n5 = this.mSpringChest.getX() >> 16;
            n6 = this.mSpringChest.getY() >> 16;
            PMImageManager.draw(978, n5, n6);
            PMCanvas.PMGraphics_drawString(n5 += 40, n6 - 33, "" + GameState.mNumChestsOpened[GameState.mLevel] + "+" + Defines.mNumChests[GameState.mLevel], 0);
        }
        if (Defines.mNumGoldCoins[GameState.mLevel] > 0) {
            n5 = this.mSpringGoldcoin.getX() >> 16;
            n6 = this.mSpringGoldcoin.getY() >> 16;
            PMImageManager.draw(979, n5, n6);
            PMCanvas.PMGraphics_drawString(n5 += 40, n6 - 33, "" + GameState.mNumGoldCoins[GameState.mLevel] + "+" + Defines.mNumGoldCoins[GameState.mLevel], 0);
        }
        InputProxy.setMasterAlpha(n2);
        InputProxy.drawTouchInput(false);
    }

    public boolean isHUDReady() {
        return this.mState == 1;
    }
}

