/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class LevelSelectionCamera {
    private Vector2 mTranslationFP;
    private Vector2 mTarget;
    private int mMenuHeight;
    private int mMenuWidth;

    public LevelSelectionCamera(int n, int n2, int n3, int n4) {
        this.mMenuWidth = n - 0x1000000;
        this.mMenuHeight = n2 - 0x900000;
        this.mTarget = new Vector2();
        this.setTarget(n3, n4);
        this.mTranslationFP = new Vector2();
        this.mTranslationFP.set(this.mTarget);
    }

    public void update() {
        int n = 19393 * Timer.mDt >> 6;
        int n2 = PMMath.MUL(this.mTarget.mX - this.mTranslationFP.mX, n);
        int n3 = PMMath.MUL(this.mTarget.mY - this.mTranslationFP.mY, n);
        n2 = MathUtil.clamp(n2, -700000, 700000);
        n3 = MathUtil.clamp(n3, -700000, 700000);
        this.mTranslationFP.mX += n2;
        this.mTranslationFP.mY += n3;
        this.mTranslationFP.mX = MathUtil.clamp(this.mTranslationFP.mX, 0, this.mMenuWidth);
        this.mTranslationFP.mY = MathUtil.clamp(this.mTranslationFP.mY, 0, this.mMenuHeight);
    }

    public void setTarget(int n, int n2) {
        this.mTarget.mX = MathUtil.clamp(n - 0x800000, 0, this.mMenuWidth);
        this.mTarget.mY = MathUtil.clamp(n2 - 0x480000, 0, this.mMenuHeight);
    }

    public boolean isTargetReached() {
        return MathUtil.abs(this.mTarget.mX - this.mTranslationFP.mX) < 2048 && MathUtil.abs(this.mTarget.mY - this.mTranslationFP.mY) < 2048;
    }

    public Vector2 getTranslationFP() {
        return this.mTranslationFP;
    }

    public static boolean isInside(int n, int n2, int n3, int n4) {
        return n + n3 >= 0 && 640 > n && n2 + n4 >= 0 && 360 > n2;
    }
}

