/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineState;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateController;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineStateJumping
extends PixelineState {
    private static final int STATE_JUMPING = 0;
    private static final int STATE_FALLING = 1;
    private int mState;
    private boolean mJumpBoostAllowed;
    private Vector2 mNextPos;
    private SurfaceIntersectionResult mIntersectionRes;
    private AABB mTileAABB;

    public PixelineStateJumping(PixelineData pixelineData, PixelineViewController pixelineViewController, PixelineStateController pixelineStateController) {
        this.mData = pixelineData;
        this.mView = pixelineViewController;
        this.mController = pixelineStateController;
        this.mNextPos = new Vector2();
        this.mIntersectionRes = new SurfaceIntersectionResult();
        this.mTileAABB = new AABB();
    }

    public void enter() {
        Vector2 vector2 = this.mData.getVelocityRef();
        Surface surface = this.mData.getSurfaceRef();
        if (vector2.mY >= 0) {
            this.mView.setAnimState(4, false);
            this.mState = 1;
            this.mJumpBoostAllowed = false;
        } else {
            int n = 0;
            int n2 = 0;
            if (surface != null) {
                Vector2 vector22 = surface.getVelocity();
                n = vector22.mX >> 1;
                if (vector22.mY < 0) {
                    n2 = vector22.mY >> 1;
                }
            }
            vector2.mX += n;
            vector2.mY += n2;
            this.mView.setAnimState(3, false);
            this.mState = 0;
            this.mJumpBoostAllowed = true;
        }
        if (surface != null) {
            surface.setPlayerTouching(false);
        }
    }

    public void exit() {
        this.mData.resetJumpEnergy();
        this.mView.setAnimState(5, false);
    }

    public void update() {
        int n;
        int n2;
        int n3;
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getPositionPrevRef();
        Vector2 vector23 = this.mData.getVelocityRef();
        Vector2 vector24 = this.mData.getDimensionRef();
        int n4 = this.mData.getRunSpeedMax();
        if (GameState.mAnalogTouch == 1) {
            n3 = InputProxy.getAnalogX();
            if (n3 == 0) {
                if (vector23.mX > 0) {
                    vector23.mX -= this.mData.getRunSpeedAcceleration();
                    if (vector23.mX <= 0) {
                        vector23.mX = 0;
                    }
                } else {
                    vector23.mX += this.mData.getRunSpeedAcceleration();
                    if (vector23.mX >= 0) {
                        vector23.mX = 0;
                    }
                }
            } else if (this.mData.getDirection() == 0) {
                if (n3 < 0) {
                    vector23.mX = PMMath.MUL(this.mData.getRunSpeedMax(), n3);
                } else {
                    this.mData.setDirection(1);
                    vector23.mX = PMMath.MUL(this.mData.getRunSpeedMax(), n3);
                }
            } else if (n3 > 0) {
                vector23.mX = PMMath.MUL(this.mData.getRunSpeedMax(), n3);
            } else {
                this.mData.setDirection(0);
                vector23.mX = PMMath.MUL(this.mData.getRunSpeedMax(), n3);
            }
        } else {
            n3 = InputProxy.isHeldLeft() ? 1 : 0;
            n2 = InputProxy.isHeldRight();
            if (n3 != 0) {
                if (vector23.mX > -n4) {
                    vector23.mX -= this.mData.getRunSpeedAcceleration();
                }
                this.mData.setDirection(0);
            } else if (n2 != 0) {
                if (vector23.mX < n4) {
                    vector23.mX += this.mData.getRunSpeedAcceleration();
                }
                this.mData.setDirection(1);
            } else if (vector23.mX > 0) {
                vector23.mX -= this.mData.getRunSpeedAcceleration();
            } else if (vector23.mX < 0) {
                vector23.mX += this.mData.getRunSpeedAcceleration();
            }
        }
        vector23.mX = MathUtil.clamp(vector23.mX, -n4, n4);
        n3 = 1;
        if (this.mState == 0) {
            if ((PMCanvas.PMInput_isPressed(1) || PMCanvas.PMInput_isHeld(1) || PMCanvas.PMInput_isHeld(128) || PMCanvas.PMInput_isHeld(256) || this.mData.getJumpButtonPressed() || this.mData.getJumpButtonDown()) && this.mData.getJumpEnergy() > 0 && this.mJumpBoostAllowed) {
                this.mData.setJumpEnergy(this.mData.getJumpEnergy() - Timer.mDt);
                n3 = 0;
            } else {
                this.mJumpBoostAllowed = false;
            }
            if (vector23.mY >= 0) {
                this.mState = 1;
                this.mView.setAnimState(4, false);
            }
        }
        if (n3 != 0) {
            n2 = 0;
            n2 = 67878 * Timer.mDt >> 6;
            vector23.mY += n2;
            n = PMMath.MUL(424288, this.mData.getGravityModifier());
            if (vector23.mY > 424288) {
                vector23.mY = 424288;
            }
        }
        this.mNextPos.set(vector2);
        this.mNextPos.add(vector23);
        this.mIntersectionRes.clear();
        World world = this.mData.getWorldRef();
        world.intersectionTest(vector2.mX, vector2.mY, vector23.mX, vector23.mY, vector24.mX >> 1, this.mIntersectionRes);
        if (this.mIntersectionRes.mSurface != null) {
            this.mData.setSurface(this.mIntersectionRes.mSurface, this.mIntersectionRes.mSegmentIndex, this.mIntersectionRes.mLengthOffset);
            Surface surface = this.mIntersectionRes.mSurface;
            surface.getSurfacePosition(this.mIntersectionRes.mSegmentIndex, this.mIntersectionRes.mLengthOffset, vector24.mX >> 1, vector2);
            int n5 = this.mData.getTotemState();
            if (n5 == 3) {
                world.spawnParticle(1, vector2.mX - 131072, vector2.mY, -262144, -327680);
                world.spawnParticle(1, vector2.mX - 65536, vector2.mY, -131072, -262144);
                world.spawnParticle(1, vector2.mX, vector2.mY, 0, -327680);
                world.spawnParticle(1, vector2.mX + 65536, vector2.mY, 131072, -262144);
            }
            if (vector23.mX == 0) {
                this.mController.requestStateChange(0);
            } else {
                this.mController.requestStateChange(1);
            }
        } else {
            n = 0;
            boolean bl = false;
            int n6 = this.mNextPos.mX - (vector24.mX >> 1);
            int n7 = this.mNextPos.mY;
            if (world.collisionTest(n6, n7, this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMaxX + (vector24.mX >> 1) + 1;
                vector23.mX = 0;
                n = 1;
            }
            if (n == 0 && world.collisionTest(n6 = this.mNextPos.mX - (vector24.mX >> 1), n7 = this.mNextPos.mY - (vector24.mY >> 1), this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMaxX + (vector24.mX >> 1) + 1;
                vector23.mX = 0;
                n = 1;
            }
            if (world.collisionTest(n6 = this.mNextPos.mX + (vector24.mX >> 1), n7 = this.mNextPos.mY, this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMinX - (vector24.mX >> 1) - 1;
                vector23.mX = 0;
                bl = true;
            }
            if (!bl && world.collisionTest(n6 = this.mNextPos.mX + (vector24.mX >> 1), n7 = this.mNextPos.mY - (vector24.mY >> 1), this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMinX - (vector24.mX >> 1) - 1;
                vector23.mX = 0;
                bl = true;
            }
            if (this.mState == 0) {
                n6 = this.mNextPos.mX + (vector24.mX >> 1);
                n7 = this.mNextPos.mY - vector24.mY;
                if (world.collisionTest(n6, n7, this.mTileAABB)) {
                    this.mNextPos.mY = this.mTileAABB.mMaxY + vector24.mY + 1;
                    vector23.mY = 0;
                }
                if (world.collisionTest(n6 = this.mNextPos.mX - (vector24.mX >> 1), n7 = this.mNextPos.mY - vector24.mY, this.mTileAABB)) {
                    this.mNextPos.mY = this.mTileAABB.mMaxY + vector24.mY + 1;
                    vector23.mY = 0;
                }
            }
            int n8 = world.getWorldMinX();
            int n9 = world.getWorldMaxX();
            n6 = this.mNextPos.mX - (vector24.mX >> 1);
            if (n6 < n8) {
                this.mNextPos.mX = n8 + (vector24.mX >> 1);
                vector23.mX = 0;
            }
            if ((n6 = this.mNextPos.mX + (vector24.mX >> 1)) > n9) {
                this.mNextPos.mX = n9 - (vector24.mX >> 1);
                vector23.mX = 0;
            }
            vector2.set(this.mNextPos);
        }
    }
}

