/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy5Data {
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_RIGHT = 1;
    private int mDirection = 1;
    private World mWorld;
    private Vector2 mPosition;
    private Vector2 mPositionPrev;
    private Vector2 mDimension;
    private Vector2 mVelocity;
    private Vector2 mMovementDirection;
    private int mMovementLength;
    private int mMovementSpeed;
    public static final int ENEMY_STATE_ALIVE = 0;
    public static final int ENEMY_STATE_DEAD = 1;
    public static final int ENEMY_STATE_DISABLED = 2;
    private int mState;

    public Enemy5Data(World world) {
        this.mWorld = world;
        this.mPosition = new Vector2();
        this.mPositionPrev = new Vector2();
        this.mDimension = new Vector2(PMMath.FP(15), PMMath.FP(10));
        this.mVelocity = new Vector2();
        this.mState = 0;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int n) {
        this.mDirection = n;
    }

    public World getWorldRef() {
        return this.mWorld;
    }

    public Vector2 getPositionRef() {
        return this.mPosition;
    }

    public Vector2 getPositionPrevRef() {
        return this.mPositionPrev;
    }

    public void setPosition(Vector2 vector2) {
        this.mPosition.set(vector2);
    }

    public void setPosition(int n, int n2) {
        this.mPosition.set(n, n2);
    }

    public void setPositionPrev(Vector2 vector2) {
        this.mPositionPrev.set(vector2);
    }

    public void setPositionPrev(int n, int n2) {
        this.mPositionPrev.set(n, n2);
    }

    public Vector2 getDimensionRef() {
        return this.mDimension;
    }

    public void setDimension(Vector2 vector2) {
        this.mDimension.set(vector2);
    }

    public Vector2 getVelocityRef() {
        return this.mVelocity;
    }

    public void setVelocity(Vector2 vector2) {
        this.mVelocity.set(vector2);
    }

    public void setMovementDirection(Vector2 vector2) {
        this.mMovementDirection = vector2;
    }

    public Vector2 getMovementDirection() {
        return this.mMovementDirection;
    }

    public void setMovementLength(int n) {
        this.mMovementLength = n;
    }

    public int getMovementLength() {
        return this.mMovementLength;
    }

    public void setMovementSpeed(int n) {
        this.mMovementSpeed = (n << 6) / 33;
    }

    public int getMovementSpeed() {
        return this.mMovementSpeed;
    }

    public void setState(int n) {
        this.mState = n;
    }

    public boolean isAlive() {
        return this.mState == 0;
    }

    public boolean isEnabled() {
        return this.mState != 2;
    }
}

