/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.enemies.Enemy2Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy2State;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateAnticipating;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateDieing;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateFalling;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateJumping;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateLanding;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateWalking;
import dk.progressivemedia.skeleton.game.enemies.Enemy2View;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy2StateController {
    private Enemy2Data mData;
    private Enemy2View mView;
    public static final int STATE_FALLING = 0;
    public static final int STATE_WALKING = 1;
    public static final int STATE_ANTICIPATION = 2;
    public static final int STATE_JUMPING = 3;
    public static final int STATE_LANDED = 4;
    public static final int STATE_DIEING = 5;
    private int mActiveStateID;
    private Enemy2State mActiveState;
    private Enemy2StateWalking mStateWalking;
    private Enemy2StateAnticipating mStateAnticipating;
    private Enemy2StateJumping mStateJumping;
    private Enemy2StateFalling mStateFalling;
    private Enemy2StateLanding mStateLanding;
    private Enemy2StateDieing mStateDieing;
    private AABB mTileAABB;

    public Enemy2StateController(Enemy2Data enemy2Data, Enemy2View enemy2View) {
        this.mData = enemy2Data;
        this.mView = enemy2View;
        this.mStateWalking = new Enemy2StateWalking(enemy2Data, enemy2View, this);
        this.mStateAnticipating = new Enemy2StateAnticipating(enemy2Data, enemy2View, this);
        this.mStateJumping = new Enemy2StateJumping(enemy2Data, enemy2View, this);
        this.mStateFalling = new Enemy2StateFalling(enemy2Data, enemy2View, this);
        this.mStateLanding = new Enemy2StateLanding(enemy2Data, enemy2View, this);
        this.mStateDieing = new Enemy2StateDieing(enemy2Data, enemy2View, this);
        this.mTileAABB = new AABB();
        this.setInitialState();
    }

    public void update() {
        Vector2 vector2 = this.mData.getVelocityRef();
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        this.mData.setPositionPrev(vector22);
        this.mActiveState.update();
        if (this.mActiveStateID == 1 || this.mActiveStateID == 2 || this.mActiveStateID == 4) {
            Surface surface = this.mData.getSurfaceRef();
            if (!surface.getSolidity()) {
                this.requestStateChange(0);
            } else {
                int n = this.mData.getSurfaceIndex();
                int n2 = this.mData.getSurfaceOffset();
                int n3 = vector23.mX >> 1;
                n2 += vector2.mX;
                if (n == 0) {
                    if (n2 < 0) {
                        this.requestStateChange(0);
                    } else if (n2 > n3) {
                        this.mData.setSurfacePosition(++n, n2 -= n3);
                    } else {
                        this.mData.setSurfacePosition(n, n2);
                    }
                } else if (n == surface.getNumSegments() - 1) {
                    if (n2 < 0) {
                        this.mData.setSurfacePosition(n, n2 += surface.getSegmentLength(--n));
                    } else if (n2 > n3) {
                        this.requestStateChange(0);
                    } else {
                        this.mData.setSurfacePosition(n, n2);
                    }
                } else if (n2 < 0) {
                    if (--n == 0) {
                        if (this.mData.getTurnAtEdge()) {
                            ++n;
                            vector2.mX = -vector2.mX;
                            this.mData.setDirection(1);
                        } else {
                            n2 += n3;
                        }
                    } else {
                        n2 += surface.getSegmentLength(n);
                    }
                    this.mData.setSurfacePosition(n, n2);
                } else if (n2 > surface.getSegmentLength(n)) {
                    if (++n == surface.getNumSegments() - 1 && this.mData.getTurnAtEdge()) {
                        --n;
                        vector2.mX = -vector2.mX;
                        this.mData.setDirection(0);
                    } else {
                        n2 -= surface.getSegmentLength(n - 1);
                    }
                    this.mData.setSurfacePosition(n, n2);
                } else {
                    this.mData.setSurfacePosition(n, n2);
                }
                surface.getSurfacePosition(n, n2, vector23.mX >> 1, vector22);
                World world = this.mData.getWorldRef();
                int n4 = 10;
                int n5 = vector22.mX - (vector23.mX >> 1);
                int n6 = vector22.mY - vector23.mY + n4;
                if (world.collisionTest(n5, n6, this.mTileAABB)) {
                    this.mData.setSurfacePosition(n, n2 += this.mTileAABB.mMaxX - n5);
                    surface.getSurfacePosition(n, n2, vector23.mX >> 1, vector22);
                    vector2.mX = -vector2.mX;
                    this.mData.setDirection(1);
                }
                if (world.collisionTest(n5 = vector22.mX + (vector23.mX >> 1), n6 = vector22.mY - vector23.mY + n4, this.mTileAABB)) {
                    this.mData.setSurfacePosition(n, n2 -= n5 - this.mTileAABB.mMinX);
                    surface.getSurfacePosition(n, n2, vector23.mX >> 1, vector22);
                    vector2.mX = -vector2.mX;
                    this.mData.setDirection(0);
                }
            }
        }
    }

    public void requestStateChange(int n) {
        this.mActiveState.exit();
        this.mActiveStateID = n;
        switch (n) {
            case 1: {
                this.mActiveState = this.mStateWalking;
                break;
            }
            case 2: {
                this.mActiveState = this.mStateAnticipating;
                break;
            }
            case 3: {
                this.mActiveState = this.mStateJumping;
                break;
            }
            case 0: {
                this.mActiveState = this.mStateFalling;
                break;
            }
            case 4: {
                this.mActiveState = this.mStateLanding;
                break;
            }
            case 5: {
                this.mActiveState = this.mStateDieing;
            }
        }
        this.mActiveState.enter();
    }

    private void setInitialState() {
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getDimensionRef();
        SurfaceIntersectionResult surfaceIntersectionResult = new SurfaceIntersectionResult();
        World world = this.mData.getWorldRef();
        world.intersectionTest(vector2.mX, vector2.mY - 65536, 0, 0x100000, vector22.mX >> 1, surfaceIntersectionResult);
        if (surfaceIntersectionResult.mSurface != null) {
            this.mData.setSurface(surfaceIntersectionResult.mSurface, surfaceIntersectionResult.mSegmentIndex, surfaceIntersectionResult.mLengthOffset);
            Surface surface = surfaceIntersectionResult.mSurface;
            surface.getSurfacePosition(surfaceIntersectionResult.mSegmentIndex, surfaceIntersectionResult.mLengthOffset, vector22.mX >> 1, vector2);
            this.mActiveStateID = 1;
            this.mActiveState = this.mStateWalking;
            this.mActiveState.enter();
        } else {
            this.mActiveStateID = 0;
            this.mActiveState = this.mStateFalling;
            this.mActiveState.enter();
        }
    }
}

