/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class VisualEffect {
    private static final int FULL_ROTATION = 23527424;
    public static final int EFFECTID_HEALTH = 0;
    public static final int EFFECTID_GOLDCOIN = 1;
    private static final int EFFECT_COUNT = 5;
    private static final int PARTICLES_PER_EFFECT = 3;
    private static final int PARTICLE_COUNT = 15;
    private static final int ITEM_START_ALPHA = 33423360;
    private static int[] mPosX;
    private static int[] mPosY;
    private static int[] mLife;
    private static int[] mItemAlpha;
    private static int[] mItemAlphaVel;
    private static int[] mEffectTypes;
    private static int[] mRot;
    private static int[] mRotVel;
    private static int[] mScale;
    private static int[] mScaleVel;
    private static int[] mAlpha;
    private static int[] mAlphaVel;

    public static void init() {
        int n;
        mPosX = new int[5];
        mPosY = new int[5];
        mLife = new int[5];
        mItemAlpha = new int[5];
        mItemAlphaVel = new int[5];
        mEffectTypes = new int[5];
        mRot = new int[15];
        mRotVel = new int[15];
        mScale = new int[15];
        mScaleVel = new int[15];
        mAlpha = new int[15];
        mAlphaVel = new int[15];
        for (n = 0; n < 5; ++n) {
            VisualEffect.mPosX[n] = 0;
            VisualEffect.mPosY[n] = 0;
            VisualEffect.mLife[n] = 0;
            VisualEffect.mItemAlpha[n] = 33423360;
            VisualEffect.mItemAlphaVel[n] = 0;
            VisualEffect.mEffectTypes[n] = 0;
        }
        for (n = 0; n < 15; ++n) {
            VisualEffect.mRot[n] = 0;
            VisualEffect.mRotVel[n] = 0;
            VisualEffect.mScale[n] = 196608;
            VisualEffect.mScaleVel[n] = 0;
            VisualEffect.mAlpha[n] = 0xFF0000;
            VisualEffect.mAlphaVel[n] = 0;
        }
    }

    public static void update() {
        for (int i = 0; i < 5; ++i) {
            if (mLife[i] <= 0) continue;
            int n = PMMath.DIV(Timer.mDt << 16, 65536000);
            for (int j = 0; j < 3; ++j) {
                int n2;
                int n3 = n2 = i * 3 + j;
                mRot[n3] = mRot[n3] + mRotVel[n2];
                while (mRot[n2] > 23527424) {
                    int n4 = n2;
                    mRot[n4] = mRot[n4] - 23527424;
                }
                while (mRot[n2] < 0) {
                    int n5 = n2;
                    mRot[n5] = mRot[n5] + 23527424;
                }
                if (mScale[n2] > 0) {
                    int n6 = n2;
                    mScale[n6] = mScale[n6] + mScaleVel[n2];
                    if (mScale[n2] < 0) {
                        VisualEffect.mScale[n2] = 0;
                    }
                }
                int n7 = n2;
                mAlpha[n7] = mAlpha[n7] - PMMath.MUL(mAlphaVel[n2], n);
                if (mAlpha[n2] >= 0) continue;
                VisualEffect.mAlpha[n2] = 0;
            }
            int n8 = i;
            mItemAlpha[n8] = mItemAlpha[n8] - PMMath.MUL(mItemAlphaVel[i], n);
            if (mItemAlpha[i] < 0) {
                VisualEffect.mItemAlpha[i] = 0;
            }
            int n9 = i;
            mLife[n9] = mLife[n9] - Timer.mDt;
        }
    }

    public static void draw(Vector2 vector2) {
        block4: for (int i = 0; i < 5; ++i) {
            int n;
            if (mLife[i] <= 0) continue;
            long l = (long)mPosX[i] * 5L >> 1;
            long l2 = (long)mPosY[i] * 5L >> 1;
            long l3 = (long)vector2.mX * 5L >> 1;
            long l4 = (long)vector2.mY * 5L >> 1;
            int n2 = (int)((l >> 16) - (l3 >> 16));
            int n3 = (int)((l2 >> 16) - (l4 >> 16));
            for (n = 0; n < 3; ++n) {
                int n4 = i * 3 + n;
                int n5 = mRot[n4] >> 16;
                int n6 = mScale[n4];
                int n7 = mAlpha[n4] >> 16;
                PMImageManager.draw(987, n2, n3, false, n5, n7, n6);
                PMDebug.println("rot: " + n5);
                PMDebug.println("scale: " + n6);
            }
            n = mItemAlpha[i] >> 16;
            if (n > 255) {
                n = 255;
            }
            switch (mEffectTypes[i]) {
                case 0: {
                    PMImageManager.draw(57, n2, n3, false, 0, n);
                    continue block4;
                }
                case 1: {
                    PMImageManager.draw(880, n2, n3, false, 0, n);
                }
            }
        }
    }

    public static void spawn(int n, Vector2 vector2) {
        for (int i = 0; i < 5; ++i) {
            if (mLife[i] > 0) continue;
            VisualEffect.mEffectTypes[i] = n;
            VisualEffect.mPosX[i] = vector2.mX;
            VisualEffect.mPosY[i] = vector2.mY;
            VisualEffect.mLife[i] = 600;
            for (int j = 0; j < 3; ++j) {
                int n2 = i * 3 + j;
                VisualEffect.mRot[n2] = MathUtil.randomBounded(23527424);
                VisualEffect.mRotVel[n2] = j % 2 == 0 ? -120000 : 120000;
                VisualEffect.mScale[n2] = MathUtil.randomBounded(90000, 120000);
                VisualEffect.mScaleVel[n2] = MathUtil.randomBounded(-150, -50);
                VisualEffect.mAlpha[n2] = MathUtil.randomBounded(0x780000, 0xC80000);
                VisualEffect.mAlphaVel[n2] = PMMath.MUL(mAlpha[n2], PMMath.DIV(65536000, 0x1900000));
            }
            VisualEffect.mItemAlpha[i] = 33423360;
            VisualEffect.mItemAlphaVel[i] = PMMath.MUL(mItemAlpha[i], PMMath.DIV(65536000, mLife[i] << 16));
            break;
        }
    }
}

