/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.game.StateGame;
import dk.progressivemedia.skeleton.math.Interpolator;
import dk.progressivemedia.skeleton.math.InterpolatorLinear;
import dk.progressivemedia.skeleton.math.InterpolatorSpring;
import dk.progressivemedia.skeleton.math.TouchInertia;

public class PauseMenu {
    private static final int BOX_SIZE_X = 0x10A0000;
    private static final int BOX_SIZE_Y = 0x1310000;
    private static final int BOX_SIZE_HELP_X = 24510464;
    private static final int BOX_SIZE_HELP_Y = 20054016;
    private static final int NUM_BUTTONS = 5;
    private static final int NUM_BUTTONS_HELP = 1;
    private static final int PRESSED_OFFSET = 2;
    private static final int STATE_ENTERING = 0;
    private static final int STATE_OPEN = 1;
    private static final int STATE_ENTERING_HELP = 2;
    private static final int STATE_HELP = 3;
    private static final int STATE_EXITING_HELP = 4;
    private static final int STATE_EXITING = 5;
    private static int mState;
    private static final int CLOSE_ACTION_RESUME = 0;
    private static final int CLOSE_ACTION_RESET = 1;
    private static final int CLOSE_ACTION_EXIT = 2;
    private static int mCloseAction;
    private static String[] mText;
    private static String mTextMusicOn;
    private static String mTextMusicOff;
    private static int[] mPositionX;
    private static int[] mPositionY;
    private static int[] mTextWidths;
    private static int[] mButtonWidths;
    private static int mBoxExitTarget;
    private static int mBoxEnterTarget;
    private static int[] mButtonExitTarget;
    private static int[] mButtonEnterTarget;
    private static InterpolatorLinear mBoxLinear;
    private static InterpolatorSpring mBoxSpring;
    private static Interpolator mBoxInterp;
    private static InterpolatorLinear[] mButtonLinear;
    private static InterpolatorSpring[] mButtonSprings;
    private static int[] mEnterTimer;
    private static int mButtonSpacing;
    private static InterpolatorSpring mBoxSizeSpring;
    private static String mHelpText;
    private static int mHelpTextHeight;
    private static TouchInertia mTextScroller;
    private static final int BUTTON_RESUME = 0;
    private static final int BUTTON_RESTART = 1;
    private static final int BUTTON_MUSIC_TOGGLE = 2;
    private static final int BUTTON_HELP = 3;
    private static final int BUTTON_EXIT = 4;
    private static final int BUTTON_BACK = 0;
    private static boolean[] mButtonDown;
    private static boolean[] mButtonDownHelp;
    private static int[] mButtonCoords;
    private static int[] mButtonIDs;
    private static int[] mButtonCoordsHelp;
    private static int[] mButtonIDsHelp;

    public static void init() {
        mTextMusicOff = PMText.getText(131074);
        mTextMusicOn = PMText.getText(131073);
        PauseMenu.mText[0] = PMText.getText(131072);
        PauseMenu.mText[1] = PMText.getText(131076);
        PauseMenu.mText[2] = MusicBuffer.isMuted() ? mTextMusicOn : mTextMusicOff;
        PauseMenu.mText[3] = PMText.getText(131075);
        PauseMenu.mText[4] = PMText.getText(131077);
        mHelpText = PMText.getText(131078);
        mButtonSpacing = 50;
        PauseMenu.setupButtons();
        mBoxEnterTarget = 0x1400000;
        mBoxExitTarget = -17432576;
        for (int i = 0; i < 5; ++i) {
            PauseMenu.mButtonDown[i] = false;
            PauseMenu.mButtonLinear[i] = new InterpolatorLinear();
            PauseMenu.mButtonSprings[i] = new InterpolatorSpring();
            PauseMenu.mButtonEnterTarget[i] = mPositionX[i] << 16;
            PauseMenu.mButtonExitTarget[i] = -(mButtonWidths[i] << 16);
        }
        mBoxSizeSpring.set(0x10A0000, 0x1310000, 0x10A0000, 0x1310000);
        int[] nArray = PMFont.stringBoxLines(374, mHelpText, 1);
        mHelpTextHeight = nArray.length * 19;
        mTextScroller = new TouchInertia(mHelpTextHeight + 38 - 306 << 16);
        PauseMenu.calculateOverlay();
    }

    public static void openMenu() {
        mState = 0;
        mBoxInterp = mBoxSpring;
        mBoxInterp.set(mBoxExitTarget, 0xB40000, mBoxEnterTarget, 0xB40000);
        for (int i = 0; i < 5; ++i) {
            mButtonSprings[i].set(mButtonExitTarget[i], mPositionY[i] << 16, mButtonEnterTarget[i], mPositionY[i] << 16);
            PauseMenu.mEnterTimer[i] = (i + 1) * 100;
        }
        SoundBuffer.play(41, 200);
        Touch.init(5, mButtonCoords, mButtonIDs, false);
        MusicBuffer.setVolume(0);
    }

    public static void closeMenu() {
        if (mState == 1) {
            mState = 5;
            mBoxInterp = mBoxLinear;
            mBoxInterp.set(mBoxEnterTarget, 0xB40000, mBoxExitTarget, 0xB40000);
            for (int i = 0; i < 5; ++i) {
                mButtonLinear[i].set(mButtonEnterTarget[i], mPositionY[i] << 16, mButtonExitTarget[i], mPositionY[i] << 16);
                PauseMenu.mEnterTimer[i] = 0;
            }
            SoundBuffer.play(41, 200);
        }
    }

    public static boolean update() {
        block0 : switch (mState) {
            case 0: {
                mBoxInterp.update(Timer.mDt);
                boolean bl = true;
                for (int i = 0; i < 5; ++i) {
                    if (mEnterTimer[i] <= 0) {
                        mButtonSprings[i].update(Timer.mDt);
                        if (mButtonSprings[i].isDone()) continue;
                        bl = false;
                        continue;
                    }
                    int n = i;
                    mEnterTimer[n] = mEnterTimer[n] - Timer.mDt;
                    bl = false;
                }
                if (!mBoxInterp.isDone() || !bl) break;
                mState = 1;
                break;
            }
            case 1: {
                int n;
                if (Dialog.isActive()) break;
                for (n = 0; n < 5; ++n) {
                    PauseMenu.mButtonDown[n] = Touch.isDown(n) || Touch.isPressed(n);
                }
                n = 0;
                boolean bl = false;
                boolean bl2 = false;
                if (Touch.wasReleased(0) || Touch.isDown(0) || Touch.isPressed(0)) {
                    SoundBuffer.play(33, 500);
                    mCloseAction = 0;
                    n = 1;
                } else if (Touch.wasReleased(1) || Touch.isDown(1) || Touch.isPressed(1)) {
                    SoundBuffer.play(33, 500);
                    mCloseAction = 1;
                    n = 1;
                } else if (Touch.wasReleased(2) || Touch.isPressed(2)) {
                    SoundBuffer.play(33, 500);
                    bl = true;
                } else if (Touch.wasReleased(3) || Touch.isDown(3) || Touch.isPressed(3)) {
                    SoundBuffer.play(33, 500);
                    bl2 = true;
                } else if (Touch.wasReleased(4) || Touch.isDown(4) || Touch.isPressed(4)) {
                    SoundBuffer.play(33, 500);
                    mCloseAction = 2;
                    n = 1;
                }
                if (n != 0) {
                    PauseMenu.closeMenu();
                    break;
                }
                if (bl) {
                    if (MusicBuffer.isMuted()) {
                        PauseMenu.mText[2] = mTextMusicOff;
                        MusicBuffer.setMuted(false);
                    } else {
                        PauseMenu.mText[2] = mTextMusicOn;
                        MusicBuffer.setMuted(true);
                    }
                    PauseMenu.setupButtons();
                    PauseMenu.calculateOverlay();
                    break;
                }
                if (!bl2) break;
                mState = 2;
                mBoxSizeSpring.set(0x10A0000, 0x1310000, 24510464, 20054016);
                break;
            }
            case 2: {
                mBoxSizeSpring.update(Timer.mDt);
                if (!mBoxSizeSpring.isDone()) break;
                mState = 3;
                Touch.init(1, mButtonCoordsHelp, mButtonIDsHelp, false);
                mTextScroller.reset();
                break;
            }
            case 3: {
                int n;
                mTextScroller.update(Timer.mDt);
                for (n = 0; n < 1; ++n) {
                    PauseMenu.mButtonDownHelp[n] = Touch.isDown(n);
                }
                n = 0;
                if (Touch.wasReleased(0) || Touch.isDown(0) || Touch.isPressed(0)) {
                    SoundBuffer.play(33, 500);
                    n = 1;
                }
                if (n == 0) break;
                mState = 4;
                mBoxSizeSpring.set(24510464, 20054016, 0x10A0000, 0x1310000);
                break;
            }
            case 4: {
                mBoxSizeSpring.update(Timer.mDt);
                if (!mBoxSizeSpring.isDone()) break;
                mState = 1;
                Touch.init(5, mButtonCoords, mButtonIDs, false);
                break;
            }
            case 5: {
                mBoxInterp.update(Timer.mDt);
                boolean bl = true;
                for (int i = 0; i < 5; ++i) {
                    if (mEnterTimer[i] <= 0) {
                        mButtonLinear[i].update(Timer.mDt);
                        if (mButtonLinear[i].isDone()) continue;
                        bl = false;
                        continue;
                    }
                    int n = i;
                    mEnterTimer[n] = mEnterTimer[n] - Timer.mDt;
                    bl = false;
                }
                if (!mBoxInterp.isDone() || !bl) break;
                if (mCloseAction == 0) {
                    MusicBuffer.setVolume(MusicBuffer.DEFAULT_MUSIC_VOLUMEN);
                }
                switch (mCloseAction) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        StateGame.restartLevel();
                        break block0;
                    }
                    case 2: {
                        StateGame.transitionToMenuPauseMenu();
                    }
                }
            }
        }
        return false;
    }

    public static void draw() {
        int n;
        int n2;
        int n3 = mBoxInterp.getX() >> 16;
        int n4 = mBoxInterp.getY() >> 16;
        int n5 = mBoxSizeSpring.getX();
        int n6 = mBoxSizeSpring.getY();
        int n7 = n5 + 0x1C0000;
        int n8 = n6 + 0x1D0000;
        int n9 = PMMath.DIV(n7, 0x280000);
        int n10 = PMMath.DIV(n8, 0x280000);
        int n11 = PMMath.DIV(n5, 0x220000);
        int n12 = PMMath.DIV(n6, 0x1D0000);
        n11 = (n11 >> 16) + 1;
        n12 = (n12 >> 16) + 1;
        int n13 = n3 - ((n5 >>= 16) >> 1);
        int n14 = n4 - ((n6 >>= 16) >> 1);
        PMCanvas.PMGraphics_setColor(208, 139, 25);
        PMCanvas.PMGraphics_fillRect(n13, n14, n5, n6);
        PMImageManager.draw(506, n13, n14);
        PMCanvas.PMGraphics_setClip(n13, 0, n5, 360);
        for (n2 = 0; n2 < n11; ++n2) {
            n = n13 + n2 * 34;
            PMImageManager.draw(507, n, n4 - (n6 >> 1));
            PMImageManager.draw(511, n, n4 + (n6 >> 1));
        }
        PMCanvas.PMGraphics_setClip(0, n14, 640, n6);
        for (n2 = 0; n2 < n12; ++n2) {
            n = n14 + n2 * 34;
            PMImageManager.draw(512, n3 - (n5 >> 1), n);
            PMImageManager.draw(509, n3 + (n5 >> 1), n);
        }
        PMCanvas.PMGraphics_setClip(0, 0, 640, 360);
        n13 = n3 + (n5 >> 1);
        n14 = n4 - (n6 >> 1);
        PMImageManager.draw(508, n13, n14);
        n13 = n3 + (n5 >> 1);
        n14 = n4 + (n6 >> 1);
        PMImageManager.draw(510, n13, n14);
        n13 = n3 - (n5 >> 1);
        n14 = n4 + (n6 >> 1);
        PMImageManager.draw(513, n13, n14);
        switch (mState) {
            case 0: 
            case 1: 
            case 5: {
                for (n2 = 0; n2 < 5; ++n2) {
                    n = mButtonWidths[n2];
                    int n15 = 35;
                    int n16 = 65536;
                    n = PMMath.MUL(n16, n << 16) >> 16;
                    n15 = PMMath.MUL(n16, n15 << 16) >> 16;
                    if (mState == 5) {
                        n3 = (mButtonLinear[n2].getX() >> 16) - (n >> 1);
                        n4 = (mButtonLinear[n2].getY() >> 16) - (n15 >> 1);
                    } else {
                        n3 = (mButtonSprings[n2].getX() >> 16) - (n >> 1);
                        n4 = (mButtonSprings[n2].getY() >> 16) - (n15 >> 1);
                    }
                    n3 += mButtonDown[n2] ? 2 : 0;
                    n4 += mButtonDown[n2] ? 2 : 0;
                    int n17 = n - 16 << 16;
                    int n18 = n15 - 16 << 16;
                    n17 = PMMath.DIV(n17, 524288);
                    n18 = PMMath.DIV(n18, 524288);
                    n = mTextWidths[n2] >> 1;
                    n15 = 33;
                    if (mState == 5) {
                        n3 = (mButtonLinear[n2].getX() >> 16) - n;
                        n4 = (mButtonLinear[n2].getY() >> 16) - n15;
                    } else {
                        n3 = (mButtonSprings[n2].getX() >> 16) - n;
                        n4 = (mButtonSprings[n2].getY() >> 16) - n15;
                    }
                    PMCanvas.PMGraphics_drawString(n3 += mButtonDown[n2] ? 2 : 0, n4 += mButtonDown[n2] ? 2 : 0, mText[n2], 0);
                }
                break;
            }
            case 3: {
                n2 = n3 - 187 + 20;
                n = n4 - 153 + 20;
                int n19 = 334;
                int n20 = 266;
                PMCanvas.PMGraphics_setClip(n2, n, n19, n20);
                PMCanvas.PMGraphics_drawStringBox(n2, n - mTextScroller.getOffset(), n19, mHelpTextHeight, mHelpText, 2, 0, mHelpText.length(), false);
                int n21 = 65536;
                n3 = 600 + (mButtonDownHelp[0] ? 2 : 0);
                n4 = 320 + (mButtonDownHelp[0] ? 2 : 0);
                PMCanvas.PMGraphics_setClip(n3 - 35, n4 - 35, 71, 71);
                PMImageManager.draw(501, n3, n4, n21);
                PMCanvas.PMGraphics_setClip(n2, n, n19, n20);
            }
        }
        Dialog.draw();
    }

    private static void setupButtons() {
        for (int i = 0; i < 5; ++i) {
            PauseMenu.mTextWidths[i] = PMFont.stringWidth(mText[i], 0);
            PauseMenu.mButtonWidths[i] = mTextWidths[i] + 10;
            PauseMenu.mPositionX[i] = 320;
            PauseMenu.mPositionY[i] = 28 + (i + 1) * mButtonSpacing;
        }
    }

    private static void calculateOverlay() {
        for (int i = 0; i < 5; ++i) {
            int n = i * 4;
            PauseMenu.mButtonCoords[n + 0] = mPositionX[i] - (mButtonWidths[i] >> 1);
            PauseMenu.mButtonCoords[n + 1] = mPositionY[i] - 17;
            PauseMenu.mButtonCoords[n + 2] = mPositionX[i] + (mButtonWidths[i] >> 1);
            PauseMenu.mButtonCoords[n + 3] = mPositionY[i] + 17;
        }
        PauseMenu.mButtonCoordsHelp[0] = 565;
        PauseMenu.mButtonCoordsHelp[1] = 285;
        PauseMenu.mButtonCoordsHelp[2] = 635;
        PauseMenu.mButtonCoordsHelp[3] = 355;
    }

    public static void touchDown(int n, int n2) {
        if (mState == 3) {
            mTextScroller.touchDown(n, n2);
        }
    }

    public static void touchMove(int n, int n2) {
        if (mState == 3) {
            mTextScroller.touchMove(n, n2);
        }
    }

    public static void touchUp(int n, int n2) {
        if (mState == 3) {
            mTextScroller.touchUp(n, n2);
        }
    }

    static {
        mText = new String[5];
        mPositionX = new int[5];
        mPositionY = new int[5];
        mTextWidths = new int[5];
        mButtonWidths = new int[5];
        mButtonExitTarget = new int[5];
        mButtonEnterTarget = new int[5];
        mBoxLinear = new InterpolatorLinear();
        mBoxSpring = new InterpolatorSpring();
        mBoxInterp = null;
        mButtonLinear = new InterpolatorLinear[5];
        mButtonSprings = new InterpolatorSpring[5];
        mEnterTimer = new int[5];
        mButtonSpacing = 0;
        mBoxSizeSpring = new InterpolatorSpring();
        mButtonDown = new boolean[5];
        mButtonDownHelp = new boolean[1];
        mButtonCoords = new int[20];
        mButtonIDs = new int[]{0, 1, 2, 3, 4};
        mButtonCoordsHelp = new int[4];
        mButtonIDsHelp = new int[]{0};
    }
}

