/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.graphics;

import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.graphics.PMImage;
import dk.progressivemedia.rflib.graphics.PMVector;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMSystem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PMImageManager {
    private static int itemCount;
    public static short[] index;
    public static short[] width;
    public static short[] height;
    public static short[] flag;
    public static short[] offsetX;
    public static short[] offsetY;
    public static short[] anchorX;
    public static short[] anchorY;
    private static int collectionCount;
    public static Object[] collection;
    public static byte[] collectionFlag;
    public static short[] collectionDataA;
    public static short[] collectionDataB;
    public static final int COLLECTION_TYPE_MASK = 7;
    public static final int COLLECTION_FLAG_MASK = 248;
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_RGBA = 1;
    public static final int TYPE_VECTOR = 2;
    public static final int TYPE_MUTABLE = 3;
    public static final int TYPE_UNUSED1 = 4;
    public static final int TYPE_UNUSED2 = 5;
    public static final int TYPE_UNUSED3 = 6;
    public static final int TYPE_UNUSED4 = 7;
    private static final int FLAG_MIRROR_MASK = 1;
    private static final int FLAG_ROT_MASK = 6;

    public static void init() {
        int n;
        PMFile.openFile((short)4278);
        itemCount = PMFile.readShort();
        collectionCount = PMFile.readShort();
        index = new short[itemCount];
        width = new short[itemCount];
        height = new short[itemCount];
        flag = new short[itemCount];
        offsetX = new short[itemCount];
        offsetY = new short[itemCount];
        anchorX = new short[itemCount];
        anchorY = new short[itemCount];
        collection = new Object[collectionCount];
        collectionFlag = new byte[collectionCount];
        collectionDataA = new short[collectionCount];
        collectionDataB = new short[collectionCount];
        for (n = 0; n < itemCount; ++n) {
            PMImageManager.index[n] = PMFile.readShort();
            PMImageManager.width[n] = PMFile.readShort();
            PMImageManager.height[n] = PMFile.readShort();
            PMImageManager.flag[n] = PMFile.readShort();
            PMImageManager.offsetX[n] = PMFile.readShort();
            PMImageManager.offsetY[n] = PMFile.readShort();
            PMImageManager.anchorX[n] = PMFile.readShort();
            PMImageManager.anchorY[n] = PMFile.readShort();
        }
        for (n = 0; n < collectionCount; ++n) {
            PMImageManager.collectionFlag[n] = PMFile.readByte();
            PMImageManager.collectionDataA[n] = PMFile.readShort();
            PMImageManager.collectionDataB[n] = PMFile.readShort();
        }
        PMFile.closeFile();
    }

    public static void draw(int n, int n2, int n3) {
        PMImageManager.draw(n, n2, n3, false, 0, 255, 65536, 65536);
    }

    public static void draw(int n, int n2, int n3, int n4) {
        PMImageManager.draw(n, n2, n3, false, 0, 255, n4, n4);
    }

    public static void draw(int n, int n2, int n3, int n4, int n5) {
        PMImageManager.draw(n, n2, n3, false, 0, 255, n4, n5);
    }

    public static void draw(int n, int n2, int n3, boolean bl, int n4) {
        PMImageManager.draw(n, n2, n3, bl, n4, 255, 65536, 65536);
    }

    public static void draw(int n, int n2, int n3, boolean bl, int n4, int n5) {
        PMImageManager.draw(n, n2, n3, bl, n4, n5, 65536, 65536);
    }

    public static void draw(int n, int n2, int n3, boolean bl, int n4, int n5, int n6) {
        PMImageManager.draw(n, n2, n3, bl, n4, n5, n6, n6);
    }

    public static void draw(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7) {
        int n8;
        if (n < 0) {
            return;
        }
        short s = index[n];
        if (collection[s] == null) {
            PMImageManager.load(n);
        }
        if (flag[n] != 0) {
            bl |= (flag[n] & 1) > 0;
            n4 += (flag[n] & 6) * 45;
        }
        if ((n8 = collectionFlag[s] & 7) == 0 || n8 == 3) {
            if (!bl && n4 == 0) {
                PMCanvas.PMGraphics_drawImage((Image)collection[s], n2 - anchorX[n], n3 - anchorY[n]);
            } else {
                PMCanvas.PMGraphics_drawImageTransform((Image)collection[s], n2, n3, width[n], height[n], offsetX[n], offsetY[n], anchorX[n], anchorY[n], bl, n4);
            }
        } else if (n8 == 1) {
            PMCanvas.PMGraphics_drawRGBA((int[])collection[s], n2 - anchorX[n], n3 - anchorY[n]);
        } else if (n8 == 2) {
            PMVector.draw((byte[])collection[s], n2, n3, bl, n4, n6, n7);
        }
    }

    public static Graphics getGraphics(int n) {
        short s = index[n];
        return ((Image)collection[s]).getGraphics();
    }

    public static int getWidth(int n) {
        return width[n];
    }

    public static int getHeight(int n) {
        return height[n];
    }

    public static int getAnchorX(int n) {
        if (n >= 0) {
            return anchorX[n];
        }
        return 0;
    }

    public static int getAnchorY(int n) {
        if (n >= 0) {
            return anchorY[n];
        }
        return 0;
    }

    public static void load(int n) {
        if (n < 0) {
            return;
        }
        short s = index[n];
        if (collection[s] == null) {
            PMDebug.println(5, "PMImageManager.load( id:{0} ) loading collection:{1}", n, (int)s);
            int n2 = collectionFlag[s] & 7;
            if (n2 == 0) {
                PMImageManager.collection[s] = PMImage.loadImage(collectionDataA[s], collectionDataB[s]);
            } else if (n2 == 1) {
                PMImageManager.collection[s] = PMImage.loadRGBA(collectionDataA[s], collectionDataB[s], collectionFlag[s] & 0xF8);
            } else if (n2 == 2) {
                PMImageManager.collection[s] = PMFile.fileToConstByteArray(collectionDataA[s]);
            } else if (n2 == 3) {
                PMImageManager.collection[s] = Image.createImage((int)width[n], (int)height[n]);
            }
        }
    }

    public static void unload(int n) {
        PMImageManager.collection[PMImageManager.index[n]] = null;
    }

    public static void unloadAll() {
        for (int i = 0; i < collection.length; ++i) {
            PMImageManager.collection[i] = null;
        }
        PMSystem.forceGC();
    }

    public static void load(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            PMImageManager.load(nArray[i]);
        }
    }

    public static void load(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                PMImageManager.load(nArray[i][j]);
            }
        }
    }

    public static void load(int n, int n2) {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            PMImageManager.load(i);
        }
    }

    public static void unload(int n, int n2) {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            PMImageManager.unload(i);
        }
    }

    public static void unload(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            PMImageManager.unload(nArray[i]);
        }
    }

    public static void unload(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                PMImageManager.unload(nArray[i][j]);
            }
        }
    }
}

