/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ZorroFightEngine {
    static byte bTypeLoaded = (byte)4;
    int[] TAN = new int[]{6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 15, 15, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 28, 29, 31, 33, 36};
    static final byte DEF_ROOF_Y = 112;
    static final int DEF_BACKWALL_Y = 144;
    static final int DEF_FLOOR_Y = 176;
    static final byte DEF_HEALTH_METER_X = 3;
    static final byte DEF_HEALTH_METER_Y = 3;
    static final byte DEF_STAMINA_METER_X = 121;
    static final byte DEF_STAMINA_METER_Y = 3;
    static final byte DEF_BACKWALL_SIZE = 32;
    private int m_iScreenWidth;
    private int m_iScreenHeight;
    private int m_iComboY = 0;
    private int m_iDrawTiles = 0;
    static int m_iSceneHeight = 100;
    static final int DEF_PUSH_VALUE = 4;
    static final byte DEF_ACTION_NONE = -1;
    static final byte DEF_ACTION_EN_GUARDE = 0;
    static final byte DEF_ACTION_SWORD_DRAW = 1;
    static final byte DEF_ACTION_RUN = 2;
    static final byte DEF_ACTION_HI_ATTACK = 3;
    static final byte DEF_ACTION_LOW_ATTACK = 4;
    static final byte DEF_ACTION_HI_BLOCK = 5;
    static final byte DEF_ACTION_LOW_BLOCK = 6;
    static final byte DEF_ACTION_CROUCH = 7;
    static final byte DEF_ACTION_JUMP = 9;
    static final byte DEF_ACTION_WALK = 10;
    static final byte DEF_ACTION_WALK_BACK = 11;
    static final byte DEF_ACTION_ENTER_WALK = 12;
    static final byte DEF_ACTION_TURN = 13;
    static final byte DEF_ACTION_FAST_TURN = 14;
    static final byte DEF_ACTION_DIE = 15;
    static final byte DEF_ACTION_LOW_ATTACK_BLOCKED = 23;
    static final byte DEF_ACTION_HI_ATTACK_BLOCKED = 24;
    static final byte DEF_ACTION_LOW_BLOCK_HOLD = 25;
    static final byte DEF_ACTION_HI_BLOCK_HOLD = 26;
    static final byte DEF_ACTION_HI_ATTACK_HOLD = 31;
    static final byte DEF_ACTION_LOW_ATTACK_HOLD = 32;
    static final byte DEF_ACTION_HI_ATTACK_RELEASE = 33;
    static final byte DEF_ACTION_LOW_ATTACK_RELEASE = 34;
    static final byte DEF_ACTION_ROLL_HOLD = 41;
    static final byte DEF_ACTION_ROLL_RELEASE = 42;
    static final byte DEF_ACTION_WALK_UP = 45;
    static final byte DEF_ACTION_WALK_DOWN = 46;
    static final byte DEF_ACTION_HALT = 47;
    static final byte DEF_ACTION_COMBO = 51;
    static final byte DEF_ACTION_COMBO_NORMAL = 51;
    static final byte DEF_ACTION_COMBO_DUAL = 52;
    static byte DEF_FRAMENODE_ACTION = 0;
    static byte DEF_FRAMENODE_XOFFSET1 = 1;
    static byte DEF_FRAMENODE_YOFFSET1 = (byte)2;
    static byte DEF_FRAMENODE_XOFFSET2 = (byte)3;
    static byte DEF_FRAMENODE_YOFFSET2 = (byte)4;
    static byte DEF_FRAMENODE_WIDTH1 = (byte)5;
    static byte DEF_FRAMENODE_HEIGHT1 = (byte)6;
    static byte DEF_FRAMENODE_WIDTH2 = (byte)7;
    static byte DEF_FRAMENODE_HEIGHT2 = (byte)8;
    static byte DEF_FRAMENODE_HSHIFT = (byte)9;
    static byte DEF_FRAMENODE_QSHIFT = (byte)10;
    static byte DEF_FRAMENODE_CENTERX = (byte)11;
    static byte DEF_FRAMENODE_XMOVE = (byte)12;
    static byte DEF_FRAMENODE_YMOVE = (byte)13;
    static byte DEF_FRAMENODE_REPEAT = (byte)14;
    static byte DEF_FRAMENODE_SPECIAL = (byte)15;
    static final int DEF_AI_DUMMY = -1;
    static final int DEF_AI_PASSIVE = 0;
    static final int DEF_AI_ACTIVE = 1;
    static final int DEF_AI_VIEW_DISTANCE = 96;
    static final int DEF_AI_IDLE_MAX_WALK = 100;
    static final int DEF_AI_IDLE_MAX_STAND = 80;
    Image m_imgZorroFrames = null;
    Image m_imgEnemyFrames = null;
    Image m_imgGUI = null;
    Image m_imgTiles = null;
    private Image[] m_imgTexture = new Image[5];
    private Image[] m_imgfloor = new Image[5];
    static int m_iZorroImageWidth = 114;
    static int[] m_iImageWidthEnemy = new int[]{125, 103};
    static int m_iZorroImageHeight = 138;
    static int[] m_iEnemyImageHeight = new int[]{82, 73};
    static Random m_cRandom = new Random(System.currentTimeMillis());
    static long m_pressTime = 0L;
    static long m_pressTime2 = 0L;
    boolean m_bFightActive = false;
    byte[] m_byRoomArray = null;
    int m_iRoomWidth = 0;
    int m_iRoomTileWidth = 0;
    byte m_byEnemyType = 0;
    int[] iFloorLevel = new int[]{76, 84, 92, 140};
    int m_iZorroAction = -1;
    int m_iZorroX = 0;
    int m_iZorroY = 0;
    int m_iSwordPower = 25;
    int m_iZorroDX = 0;
    int m_iZorroLevel = 0;
    int m_iZorroSpecial = 0;
    int m_iZorroSpecialBlock = 0;
    boolean m_bIsZorroFacingRight = true;
    int m_iZorroNextAction = -1;
    CFrameQueue m_cZorroFrameQueue = new CFrameQueue();
    CFrameNode m_cZorroDefaultFrame = null;
    CFrameQueue[] m_cEnemyFrameQueue = null;
    CFrameNode[] m_cEnemyDefaultFrame = null;
    private int[][] m_iDamageXPoint = new int[][]{{31, 31}, {20, 20}};
    private int[][] m_iEnemyDamageXPoint = new int[][]{{31, 31}, {20, 20}};
    int[] DIST = null;
    int[] SCALE = null;
    int[] INVSCALE = null;
    int[] WIDTH = null;
    int[][][] m_shTextureBuffer = null;
    boolean bReDivideAttackers = false;
    private int m_iScroller = 0;
    private int DEF_SCROLLER_DISTANCE = 0;
    static int DEF_SCROLLER_SPEED = 12;
    int m_iComboInProgress = 0;
    boolean[] m_bCombo = new boolean[]{false, false};
    private boolean[] m_bInCombo = null;
    private boolean[] m_bComboEnemy = new boolean[]{false, false};
    private int DEF_MAX_ENEMIES = 8;
    private int m_iAmountOfEnemies = 0;
    public int[] m_iEnemy = null;
    public int[] m_iAttacker = new int[6];
    public boolean m_bZorroSeen = false;
    int m_iRandom = 0;
    public boolean bReCheckAttackers = true;
    boolean m_bRedo = false;
    static byte[][][] m_iActionArray = null;
    private static byte[] m_iActionSize = null;
    private static byte m_iZorroHitWidth = (byte)20;
    private static byte m_iEnemyHitWidth = (byte)20;

    public void ZorroFightEngine() {
    }

    public void setupFight(int n, boolean bl, byte by) {
        this.m_iComboInProgress = 0;
        this.m_bCombo[1] = false;
        this.m_bCombo[0] = false;
        this.m_bComboEnemy[1] = false;
        this.m_bComboEnemy[0] = false;
        this.m_iAmountOfEnemies = 0;
        this.iFloorLevel[0] = 76;
        this.iFloorLevel[1] = 84;
        this.iFloorLevel[2] = 92;
        this.iFloorLevel[3] = 140;
        this.m_iScreenWidth = ZorroCanvas.siWidth;
        this.m_iScreenHeight = ZorroCanvas.siHeight;
        this.m_iComboY = this.m_iScreenHeight - this.m_iScreenHeight / 10 - 10;
        this.m_iDrawTiles = this.m_iScreenWidth / 32 + 1 + (this.m_iScreenWidth % 32 > 0 ? 1 : 0);
        this.DEF_SCROLLER_DISTANCE = this.m_iScreenWidth >> 1;
        if (bTypeLoaded != by) {
            this.loadFrames("zf", by == 0 ? "sf" : "if");
        }
        int n2 = this.m_iScreenHeight - m_iSceneHeight >> 1;
        int n3 = 0;
        if (n2 < 0) {
            n3 = m_iSceneHeight - this.m_iScreenHeight;
            n2 = 0;
        }
        int n4 = 0;
        while (n4 < 4) {
            this.iFloorLevel[n4] = this.iFloorLevel[n4] + n2 - n3;
            ++n4;
        }
        this.m_bFightActive = true;
        this.m_byEnemyType = by;
        this.m_iEnemy = new int[this.DEF_MAX_ENEMIES];
        this.m_bInCombo = new boolean[this.DEF_MAX_ENEMIES];
        this.ZORRO_load();
        n4 = 0;
        while (n4 < this.DEF_MAX_ENEMIES) {
            this.m_iEnemy[n4] = -1;
            this.m_bInCombo[n4] = false;
            ++n4;
        }
        this.m_cEnemyDefaultFrame = new CFrameNode[this.DEF_MAX_ENEMIES];
        this.m_cEnemyFrameQueue = new CFrameQueue[this.DEF_MAX_ENEMIES];
        this.m_iZorroX = this.m_iZorroDX = n;
        if (ZorroCanvas.bCurrentMap == 2) {
            this.m_iZorroSpecial = 200;
        }
        this.m_iZorroAction = 0;
        this.m_bIsZorroFacingRight = bl;
        this.m_iZorroLevel = 1;
        this.m_iZorroY = this.iFloorLevel[this.m_iZorroLevel];
        this.centerScreen();
        this.bReCheckAttackers = true;
    }

    public void setupRoom(byte[] byArray) {
        this.m_byRoomArray = byArray;
        this.m_iRoomTileWidth = byArray.length;
        this.m_iRoomWidth = this.m_iRoomTileWidth << 5;
    }

    public void load(byte by) {
        try {
            if (bTypeLoaded == 4) {
                this.m_imgZorroFrames = Image.createImage((String)"/FE_z.png");
                bTypeLoaded = (byte)3;
            }
            if (by == 0) {
                if (bTypeLoaded != 0) {
                    this.m_imgEnemyFrames = Image.createImage((String)"/FE_s.png");
                }
                bTypeLoaded = 0;
            } else {
                if (bTypeLoaded != 1) {
                    this.m_imgEnemyFrames = Image.createImage((String)"/FE_i.png");
                }
                bTypeLoaded = 1;
            }
            this.m_imgTiles = ZorroCanvas.imgTiles;
            this.m_imgGUI = ZorroCanvas.imgGUI;
            this.m_imgTexture[0] = Image.createImage((String)"/sky.png");
            this.m_imgTexture[1] = Image.createImage((String)"/sky2.png");
            this.m_imgTexture[2] = Image.createImage((String)"/roomsky3.png");
            this.m_imgfloor[0] = Image.createImage((String)"/floor.png");
            this.m_imgfloor[1] = Image.createImage((String)"/grass.png");
            this.m_imgfloor[2] = Image.createImage((String)"/roomfloor.png");
        }
        catch (IOException iOException) {}
    }

    public void centerScreen() {
        this.m_iScroller = this.m_bIsZorroFacingRight ? this.m_iZorroX - this.DEF_SCROLLER_DISTANCE : this.m_iZorroX - (this.m_iScreenWidth - this.DEF_SCROLLER_DISTANCE);
    }

    public void unload() {
        this.m_cZorroFrameQueue = new CFrameQueue();
        this.m_imgGUI = null;
        this.m_cZorroDefaultFrame = null;
        int n = 0;
        while (n < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n] >= 0) {
                this.ENEMY_unload(ZorroCanvas.enemies[this.m_iEnemy[n]]);
                this.m_iEnemy[n] = -1;
            }
            ++n;
        }
        this.m_cEnemyDefaultFrame = null;
        this.m_cEnemyFrameQueue = null;
        this.m_iZorroDX = this.m_iZorroX - this.m_iZorroDX;
        System.gc();
    }

    public void update() {
        int n;
        int n2 = 0;
        boolean bl = false;
        byte by = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = false;
        this.collision();
        boolean bl5 = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n6] >= 0) {
                ++n5;
                if (ZorroCanvas.enemies[this.m_iEnemy[n6]].m_bAIWait) {
                    bl5 = true;
                }
            }
            ++n6;
        }
        if (n5 == 1 && !bl5) {
            n = 0;
            while (n < this.DEF_MAX_ENEMIES) {
                if (this.m_iEnemy[n] >= 0) {
                    if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX <= this.m_iZorroX) {
                        if (!ZorroCanvas.enemies[this.m_iEnemy[n]].m_bLeftGroup) {
                            bl5 = true;
                        }
                    } else if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_bLeftGroup) {
                        bl5 = true;
                    }
                }
                ++n;
            }
        }
        if (this.bReDivideAttackers || n5 == 1 && bl5) {
            this.bReDivideAttackers = false;
            this.divideAttackers();
            this.bReCheckAttackers = true;
        }
        if (this.bReCheckAttackers) {
            this.checkAttackers();
            this.bReCheckAttackers = false;
        }
        this.ZORRO_update();
        if (this.m_bIsZorroFacingRight) {
            if (this.m_iScroller < this.m_iZorroX - this.DEF_SCROLLER_DISTANCE) {
                this.m_iScroller += DEF_SCROLLER_SPEED;
            }
            if (this.m_iScroller > this.m_iZorroX - this.DEF_SCROLLER_DISTANCE) {
                this.m_iScroller = this.m_iZorroX - this.DEF_SCROLLER_DISTANCE;
            }
        } else {
            if (this.m_iScroller > this.m_iZorroX - (this.m_iScreenWidth - this.DEF_SCROLLER_DISTANCE)) {
                this.m_iScroller -= DEF_SCROLLER_SPEED;
            }
            if (this.m_iScroller < this.m_iZorroX - (this.m_iScreenWidth - this.DEF_SCROLLER_DISTANCE)) {
                this.m_iScroller = this.m_iZorroX - (this.m_iScreenWidth - this.DEF_SCROLLER_DISTANCE);
            }
        }
        if (!this.m_cZorroFrameQueue.isEmpty() && this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] == 1) {
            n4 = 0;
            while (n4 < this.DEF_MAX_ENEMIES) {
                if (this.m_iEnemy[n4] >= 0 && ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iLevel == this.m_iZorroLevel && ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iHP > 0) {
                    n3 = 0;
                    n = 0;
                    while (n < 2) {
                        if (n3 == 0) {
                            if (this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 3) {
                                n2 = this.m_iDamageXPoint[n][0];
                                by = 1;
                            } else if (this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 4) {
                                n2 = this.m_iDamageXPoint[n][1];
                                by = 0;
                            } else {
                                n2 = this.m_iDamageXPoint[n][1];
                                by = 3;
                            }
                            n2 = this.m_bIsZorroFacingRight ? this.m_iZorroX + n2 : this.m_iZorroX - n2;
                            n3 = this.ENEMY_isHit(ZorroCanvas.enemies[this.m_iEnemy[n4]], n2, by);
                        }
                        ++n;
                    }
                }
                ++n4;
            }
        }
        if (this.m_bFightActive && this.m_iComboInProgress <= 0) {
            n4 = 0;
            while (n4 < this.DEF_MAX_ENEMIES) {
                if (this.m_iEnemy[n4] >= 0) {
                    if (ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iHP <= 0) {
                        if (!this.m_cEnemyFrameQueue[ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iFEId].isEmpty() && this.m_cEnemyFrameQueue[ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iFEId].m_cTopNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] == 52) {
                            this.ENEMY_unload(ZorroCanvas.enemies[this.m_iEnemy[n4]]);
                            ZorroCanvas.enemies[this.m_iEnemy[n4]] = null;
                            --this.m_iAmountOfEnemies;
                            this.m_iEnemy[n4] = -1;
                            this.divideAttackers();
                            this.bReCheckAttackers = true;
                            this.bReCheckAttackers = true;
                        } else {
                            this.ENEMY_update(ZorroCanvas.enemies[this.m_iEnemy[n4]]);
                        }
                    } else {
                        this.ENEMY_update(ZorroCanvas.enemies[this.m_iEnemy[n4]]);
                        this.ENEMY_doAI(ZorroCanvas.enemies[this.m_iEnemy[n4]]);
                        if (ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iLevel == this.m_iZorroLevel && !this.m_cEnemyFrameQueue[ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iFEId].isEmpty() && this.m_cEnemyFrameQueue[ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iFEId].m_cTopNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] == 1) {
                            n3 = 0;
                            n = 0;
                            while (n < 2) {
                                if (n3 == 0) {
                                    if (this.m_cEnemyFrameQueue[ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iFEId].m_cTopNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 3) {
                                        n2 = this.m_iEnemyDamageXPoint[n][0];
                                        bl = true;
                                    } else {
                                        n2 = this.m_iEnemyDamageXPoint[n][1];
                                        bl = false;
                                    }
                                    n2 = ZorroCanvas.enemies[this.m_iEnemy[n4]].m_bIsFacingRight ? ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iX + n2 : ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iX - n2;
                                    n3 = this.ZORRO_isHit(ZorroCanvas.enemies[this.m_iEnemy[n4]].m_bIsFacingRight, n2, bl);
                                    if (n3 == 2) {
                                        if (bl) {
                                            this.ENEMY_setAction(ZorroCanvas.enemies[this.m_iEnemy[n4]], 24);
                                        } else {
                                            this.ENEMY_setAction(ZorroCanvas.enemies[this.m_iEnemy[n4]], 23);
                                        }
                                    }
                                }
                                ++n;
                            }
                        }
                    }
                }
                ++n4;
            }
        }
        if (this.m_iZorroSpecialBlock > 0) {
            this.m_iZorroSpecial += 5;
            this.m_iZorroSpecialBlock -= 5;
            if (this.m_iZorroSpecial > 200) {
                this.m_iZorroSpecial = 200;
            }
        }
    }

    public void draw(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 32;
        byte by = 0;
        int n6 = 0;
        int n7 = this.m_iDrawTiles;
        int n8 = 0;
        n = this.m_iScroller;
        if (n < 0) {
            n = 0;
        }
        if (n + this.m_iScreenWidth >= this.m_iRoomWidth) {
            n = this.m_iRoomWidth - (this.m_iScreenWidth + 1);
        }
        n4 = -(n % 32);
        graphics.setClip(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
        graphics.clipRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
        graphics.setColor(0x2C2C2C);
        graphics.fillRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
        n6 = n;
        if (this.m_iScreenHeight < m_iSceneHeight) {
            m_iSceneHeight = this.m_iScreenHeight;
        }
        n8 = this.m_iScreenHeight - m_iSceneHeight >> 1;
        if (n7 > this.m_iRoomTileWidth) {
            n4 = this.m_iScreenWidth - this.m_iRoomWidth >> 1;
            n6 = -n4;
            n = 0;
            n7 = this.m_iRoomTileWidth;
        }
        if (this.m_iComboInProgress < 2 || this.m_iComboInProgress > 6) {
            n2 = 0;
            while (n2 < n7) {
                if (n4 + 32 > this.m_iScreenWidth) {
                    n5 -= n4 + n5 - this.m_iScreenWidth;
                }
                graphics.setClip(n4, 144, n5, 32);
                if (n / 32 + n2 == this.m_iRoomTileWidth) break;
                by = this.m_byRoomArray[n / 32 + n2];
                graphics.drawImage(this.m_imgTiles, n4 - by * 32, 144, 0);
                n4 += 32;
                ++n2;
            }
            this.draw3d(graphics, n);
        } else {
            if (this.m_iComboInProgress == 6 || this.m_iComboInProgress == 4) {
                graphics.setColor(0xFFFFFF);
            } else if (this.m_iComboInProgress == 5 || this.m_iComboInProgress == 3) {
                graphics.setColor(0);
            } else {
                graphics.setColor(0xDD0000);
            }
            if (this.m_iComboInProgress > 2) {
                --this.m_iComboInProgress;
            }
            graphics.setClip(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            graphics.fillRect(0, 112, this.m_iScreenWidth, 96);
        }
        n = n6;
        n3 = 0;
        while (n3 < 4) {
            n2 = 0;
            while (n2 < this.DEF_MAX_ENEMIES) {
                if (this.m_iEnemy[n2] >= 0 && (this.m_iComboInProgress <= 0 || this.m_bInCombo[n2] || this.m_iComboInProgress > 6) && !ZorroCanvas.enemies[this.m_iEnemy[n2]].m_bDrawInFront && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iLevel == n3) {
                    this.ENEMY_draw(ZorroCanvas.enemies[this.m_iEnemy[n2]], graphics, n);
                }
                ++n2;
            }
            if (this.m_iZorroLevel == n3) {
                this.ZORRO_draw(graphics, n);
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n2] > 0 && (this.m_iComboInProgress <= 0 || this.m_bInCombo[n2] || this.m_iComboInProgress > 6) && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_bDrawInFront) {
                this.ENEMY_draw(ZorroCanvas.enemies[this.m_iEnemy[n2]], graphics, n);
            }
            ++n2;
        }
        graphics.setClip(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
        graphics.clipRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
        graphics.setColor(0x2C2C2C);
        graphics.fillRect(0, 208, this.m_iScreenWidth, this.m_iScreenHeight - 208);
        if (n < 0) {
            graphics.fillRect(0, 0, -n, this.m_iScreenHeight);
            graphics.fillRect(this.m_iScreenWidth + n, 0, -n, this.m_iScreenHeight);
            graphics.setColor(0);
            graphics.drawLine(-n, 111, this.m_iScreenWidth + n, 111);
            graphics.drawLine(-n, 208, this.m_iScreenWidth + n, 208);
            graphics.drawLine(-n, 111, -n, 208);
            graphics.drawLine(this.m_iScreenWidth + n, 111, this.m_iScreenWidth + n, 208);
        } else {
            graphics.setColor(0);
            graphics.drawLine(0, 111, this.m_iScreenWidth, 111);
            graphics.drawLine(0, 208, this.m_iScreenWidth, 208);
        }
        graphics.setClip(ZorroCanvas.healthX, ZorroCanvas.healthY, ZorroCanvas.healthWidth, ZorroCanvas.healthHeight);
        graphics.drawImage(this.m_imgGUI, ZorroCanvas.healthX, ZorroCanvas.healthY, 0);
        if (ZorroCanvas.zorroIsHit) {
            switch (ZorroCanvas.zorroFlash++) {
                case 0: 
                case 2: {
                    graphics.setColor(-1);
                    graphics.drawLine(ZorroCanvas.healthX + 1, ZorroCanvas.healthY + 1, Zorro.iHP / 4 + 1, ZorroCanvas.healthY + 1);
                    graphics.drawLine(ZorroCanvas.healthX + 1, ZorroCanvas.healthY + 2, Zorro.iHP / 4 + 1, ZorroCanvas.healthY + 2);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
        graphics.setColor(0);
        graphics.drawLine(ZorroCanvas.healthXEnd, ZorroCanvas.healthY + 1, ZorroCanvas.healthXEnd - (200 - Zorro.iHP) / 4, ZorroCanvas.healthY + 1);
        graphics.drawLine(ZorroCanvas.healthXEnd, ZorroCanvas.healthY + 2, ZorroCanvas.healthXEnd - (200 - Zorro.iHP) / 4, ZorroCanvas.healthY + 2);
        graphics.setClip(this.m_iScreenWidth - ZorroCanvas.healthWidth - 3, ZorroCanvas.healthY, ZorroCanvas.healthWidth, ZorroCanvas.healthHeight);
        graphics.drawImage(this.m_imgGUI, this.m_iScreenWidth - ZorroCanvas.healthWidth - 3, ZorroCanvas.healthY - 23, 0);
        if (ZorroCanvas.zorroIsHit && ZorroCanvas.zorroFlash == 4) {
            ZorroCanvas.zorroIsHit = false;
            ZorroCanvas.zorroFlash = 0;
        }
        if (ZorroCanvas.zorroIsHit && (ZorroCanvas.zorroFlash == 1 || ZorroCanvas.zorroFlash == 3)) {
            graphics.setColor(-1);
            graphics.fillRect(this.m_iScreenWidth - ZorroCanvas.healthWidth - 3 + (200 - this.m_iZorroSpecial >> 2), ZorroCanvas.healthY + 1, (this.m_iZorroSpecial >> 2) + 1, 2);
        }
        graphics.setColor(0);
        graphics.fillRect(this.m_iScreenWidth - ZorroCanvas.healthWidth - 3 + 1, ZorroCanvas.healthY + 1, 200 - this.m_iZorroSpecial >> 2, 2);
        if (ZorroCanvas.bCurrentMap == 2) {
            graphics.setClip(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            graphics.setFont(ZorroCanvas.f);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(ZorroCanvas.sGameStrings[29], 1, this.m_iScreenHeight - 1, 36);
            graphics.drawString(ZorroCanvas.menuStrings[4], this.m_iScreenWidth - 1, this.m_iScreenHeight - 1, 40);
        }
    }

    private int iEnemyAttacking() {
        int n = 0;
        while (n < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n] >= 0 && (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX > this.m_iZorroX && this.m_bIsZorroFacingRight || ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX < this.m_iZorroX && !this.m_bIsZorroFacingRight)) {
                if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iAction == 4) {
                    return 2;
                }
                if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iAction == 3) {
                    return 1;
                }
            }
            ++n;
        }
        return 0;
    }

    public void keyPressed(int n) {
        switch (n) {
            case -4: 
            case 54: {
                if (this.m_iComboInProgress > 0) {
                    this.m_bCombo[1] = true;
                    if (this.m_bCombo[0]) break;
                    this.m_bIsZorroFacingRight = true;
                    break;
                }
                if (this.m_bIsZorroFacingRight) {
                    this.ZORRO_doAction(10);
                    break;
                }
                this.ZORRO_doAction(13);
                break;
            }
            case -3: 
            case 52: {
                if (this.m_iComboInProgress > 0) {
                    this.m_bCombo[0] = true;
                    if (this.m_bCombo[1]) break;
                    this.m_bIsZorroFacingRight = false;
                    break;
                }
                if (!this.m_bIsZorroFacingRight) {
                    this.ZORRO_doAction(10);
                    break;
                }
                this.ZORRO_doAction(13);
                break;
            }
            case -1: 
            case 50: {
                this.ZORRO_doAction(45);
                break;
            }
            case -2: 
            case 56: {
                this.ZORRO_doAction(46);
                break;
            }
            case 53: {
                if (System.currentTimeMillis() - m_pressTime < 300L && this.m_iZorroSpecial > 199) {
                    if (this.m_iComboInProgress <= 0) {
                        this.m_iComboInProgress = 15;
                    }
                } else {
                    this.ZORRO_doAction(m_cRandom.nextInt() > 0 ? 31 : 32);
                }
                m_pressTime = System.currentTimeMillis();
                break;
            }
            case 55: {
                if (System.currentTimeMillis() - m_pressTime2 < 300L) {
                    this.ZORRO_doAction(41);
                    MultiPlayer.playSound(6);
                    break;
                }
                this.block();
                m_pressTime2 = System.currentTimeMillis();
            }
        }
    }

    public void block() {
        if (this.iEnemyAttacking() == 2) {
            this.ZORRO_doAction(6);
        } else if (this.iEnemyAttacking() == 1) {
            this.ZORRO_doAction(5);
        } else {
            this.ZORRO_doAction(m_cRandom.nextInt() > 0 ? 5 : 6);
        }
    }

    public void keyReleased(int n) {
        if (this.ZORRO_isNextActionLooping()) {
            this.m_iZorroNextAction = -1;
        }
    }

    public boolean addEnemy(int n, boolean bl) {
        int n2 = 0;
        boolean bl2 = false;
        n2 = 0;
        while (n2 < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n2] == -1) {
                this.m_iEnemy[n2] = n;
                ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iFEId = n2;
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (!bl2) {
            return false;
        }
        ++this.m_iAmountOfEnemies;
        ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iAIState = 0;
        ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iAction = -1;
        ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iNextAction = -1;
        ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iZorroDistance = Integer.MAX_VALUE;
        if (ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX < 0) {
            ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX = 0;
        }
        if (ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX > this.m_iRoomWidth) {
            ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX = this.m_iRoomWidth;
        }
        if (!bl) {
            ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iLevel = 3;
        }
        this.ENEMY_load(ZorroCanvas.enemies[this.m_iEnemy[n2]]);
        ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iY = this.iFloorLevel[ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iLevel];
        this.m_bInCombo[n2] = false;
        this.divideAttackers();
        this.bReCheckAttackers = true;
        return true;
    }

    private void collision() {
        int n;
        boolean bl = false;
        if (this.m_iZorroAction != 41) {
            n = 0;
            while (n < this.DEF_MAX_ENEMIES) {
                if (this.m_iEnemy[n] >= 0 && ZorroCanvas.enemies[this.m_iEnemy[n]].m_iLevel == this.m_iZorroLevel && (this.m_iZorroX + (m_iZorroHitWidth >> 1) - 2 >= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX - (m_iEnemyHitWidth >> 1) && this.m_iZorroX + (m_iZorroHitWidth >> 1) - 2 <= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX + (m_iEnemyHitWidth >> 1) || this.m_iZorroX - ((m_iZorroHitWidth >> 1) - 2) >= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX - (m_iEnemyHitWidth >> 1) && this.m_iZorroX - ((m_iZorroHitWidth >> 1) - 2) <= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX + (m_iEnemyHitWidth >> 1))) {
                    if (this.m_iZorroX <= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX && this.m_bIsZorroFacingRight && !ZorroCanvas.enemies[this.m_iEnemy[n]].m_bIsFacingRight) {
                        this.ZORRO_move(-4, 0);
                        this.ENEMY_move(ZorroCanvas.enemies[this.m_iEnemy[n]], -4, 0);
                    }
                    if (this.m_iZorroX >= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX && this.m_bIsZorroFacingRight && !ZorroCanvas.enemies[this.m_iEnemy[n]].m_bIsFacingRight) {
                        this.ZORRO_move(4, 0);
                        this.ENEMY_move(ZorroCanvas.enemies[this.m_iEnemy[n]], 4, 0);
                    } else if (this.m_iZorroX >= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX && !this.m_bIsZorroFacingRight && ZorroCanvas.enemies[this.m_iEnemy[n]].m_bIsFacingRight) {
                        this.ZORRO_move(-4, 0);
                        this.ENEMY_move(ZorroCanvas.enemies[this.m_iEnemy[n]], -4, 0);
                    } else if (this.m_iZorroX <= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX && !this.m_bIsZorroFacingRight && !ZorroCanvas.enemies[this.m_iEnemy[n]].m_bIsFacingRight) {
                        this.ENEMY_move(ZorroCanvas.enemies[this.m_iEnemy[n]], -4, 0);
                    } else if (this.m_iZorroX >= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX && !this.m_bIsZorroFacingRight && !ZorroCanvas.enemies[this.m_iEnemy[n]].m_bIsFacingRight) {
                        this.ZORRO_move(-4, 0);
                    } else if (this.m_iZorroX >= ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX && this.m_bIsZorroFacingRight && ZorroCanvas.enemies[this.m_iEnemy[n]].m_bIsFacingRight) {
                        this.ENEMY_move(ZorroCanvas.enemies[this.m_iEnemy[n]], -4, 0);
                    } else {
                        this.ZORRO_move(-4, 0);
                    }
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n] >= 0) {
                if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_bIsFacingRight) {
                    if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX + 24 > this.m_iRoomWidth) {
                        ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX -= 4;
                    }
                    if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX - 6 < 0) {
                        ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX += 4;
                    }
                } else {
                    if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX + 6 > this.m_iRoomWidth) {
                        ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX -= 4;
                    }
                    if (ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX - 24 < 0) {
                        ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX += 4;
                    }
                }
            }
            ++n;
        }
        if (this.m_bIsZorroFacingRight) {
            if (this.m_iZorroX + 24 > this.m_iRoomWidth) {
                this.m_iZorroX -= 4;
            }
            if (this.m_iZorroX - 6 < 0) {
                this.m_iZorroX += 4;
            }
        } else {
            if (this.m_iZorroX + 6 > this.m_iRoomWidth) {
                this.m_iZorroX -= 4;
            }
            if (this.m_iZorroX - 24 < 0) {
                this.m_iZorroX += 4;
            }
        }
    }

    public void draw3d(Graphics graphics, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        graphics.setClip(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
        graphics.clipRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
        n5 = n + (this.m_iScreenWidth >> 1);
        n4 = 0;
        while (n4 < 32) {
            n2 = (-(this.m_iScreenWidth >> 1) - n5) * this.INVSCALE[n4];
            n3 = Math.abs((this.m_iScreenWidth >> 1) + (n2 >> 11)) % this.WIDTH[n4];
            graphics.drawRGB(this.m_shTextureBuffer[0][n4], n3, 416 - n3, 0, 112 + (31 - n4), this.m_iScreenWidth + this.WIDTH[n4], 1, false);
            graphics.drawRGB(this.m_shTextureBuffer[1][n4], n3, 416 - n3, 0, 176 + n4, this.m_iScreenWidth + this.WIDTH[n4], 1, false);
            ++n4;
        }
    }

    public boolean load3DStuff() {
        Graphics graphics = null;
        Image image = null;
        this.DIST = new int[35];
        this.SCALE = new int[35];
        this.INVSCALE = new int[35];
        this.WIDTH = new int[35];
        int[] nArray = new int[1024];
        int[] nArray2 = new int[1024];
        int n = 1;
        while (n < 33) {
            this.WIDTH[n - 1] = 32 + (n - 1);
            this.SCALE[n - 1] = 16384 / this.WIDTH[n - 1];
            this.INVSCALE[n - 1] = 2048 * this.WIDTH[n - 1] / 32;
            this.DIST[n - 1] = Math.abs(37 - this.TAN[31 - (n - 1)]);
            ++n;
        }
        this.m_shTextureBuffer = new int[2][32][416];
        image = Image.createImage((int)32, (int)32);
        graphics = image.getGraphics();
        graphics.drawImage(this.m_imgTiles, -32, 0, 0);
        image.getRGB(nArray, 0, 32, 0, 0, 32, 32);
        graphics.drawImage(this.m_imgTiles, 0, 0, 0);
        image.getRGB(nArray2, 0, 32, 0, 0, 32, 32);
        int n2 = 0;
        while (n2 < 32) {
            int n3 = 0;
            while (n3 < 416) {
                int n4 = this.DIST[n2] % 32;
                int n5 = (n3 * this.SCALE[n2] >> 9) % 32;
                this.m_shTextureBuffer[0][n2][n3] = nArray[n4 * 32 + n5];
                this.m_shTextureBuffer[1][n2][n3] = nArray2[n4 * 32 + n5];
                ++n3;
            }
            ++n2;
        }
        nArray = null;
        nArray2 = null;
        image = null;
        System.gc();
        System.gc();
        return true;
    }

    private void ZORRO_performCombo(boolean bl) {
        int n = 0;
        while (n < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n] >= 0 && ZorroCanvas.enemies[this.m_iEnemy[n]].m_iLevel == this.m_iZorroLevel) {
                int n2 = this.m_iZorroX - ZorroCanvas.enemies[this.m_iEnemy[n]].m_iX;
                if (bl) {
                    boolean bl2 = this.m_bInCombo[n] = Math.abs(n2) - (m_iEnemyHitWidth >> 1) - 4 < this.m_iDamageXPoint[0][0];
                    if (this.m_bInCombo[n]) {
                        this.m_bComboEnemy[n2 > 0 ? 0 : 1] = true;
                    }
                } else if (this.m_bIsZorroFacingRight && n2 < 0 && Math.abs(n2) - (m_iEnemyHitWidth >> 1) - 4 < this.m_iDamageXPoint[0][0]) {
                    this.m_bInCombo[n] = true;
                    this.m_bComboEnemy[1] = true;
                } else if (!this.m_bIsZorroFacingRight && n2 > 0 && n2 - (m_iEnemyHitWidth >> 1) - 4 < this.m_iDamageXPoint[0][0]) {
                    this.m_bInCombo[n] = true;
                    this.m_bComboEnemy[0] = true;
                }
            }
            ++n;
        }
        this.ZORRO_doAction(bl ? 52 : 51);
        this.m_iComboInProgress = 6;
        MultiPlayer.playSound(6);
    }

    private void ZORRO_endCombo() {
        this.m_iComboInProgress = 0;
        this.m_bCombo[1] = false;
        this.m_bCombo[0] = false;
        this.m_bComboEnemy[1] = false;
        this.m_bComboEnemy[0] = false;
        int n = 0;
        while (n < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n] >= 0 && this.m_bInCombo[n]) {
                MultiPlayer.playSound(5);
                this.ENEMY_setAction(ZorroCanvas.enemies[this.m_iEnemy[n]], 15);
                ZorroCanvas.enemies[this.m_iEnemy[n]].m_iAIState = -1;
                ZorroCanvas.enemies[this.m_iEnemy[n]].m_iHP = 0;
                if (ZorroCanvas.bArcadeMode) {
                    ZorroCanvas.iArcadeScore += 10;
                }
            }
            ++n;
        }
    }

    private void ZORRO_update() {
        boolean bl = true;
        byte by = 0;
        if (this.m_cZorroFrameQueue.isEmpty()) {
            this.m_iZorroAction = 0;
        } else {
            switch (this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_SPECIAL]) {
                case 5: {
                    this.m_bIsZorroFacingRight = !this.m_bIsZorroFacingRight;
                    break;
                }
                case 65: {
                    if ((!this.m_bIsZorroFacingRight || !this.m_bComboEnemy[1]) && (this.m_bIsZorroFacingRight || !this.m_bComboEnemy[0])) break;
                    MultiPlayer.playSound(8);
                    break;
                }
                case 66: {
                    this.ZORRO_endCombo();
                }
            }
            this.m_iZorroAction = this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_ACTION];
            this.m_cZorroFrameQueue.pumpQueue();
            if (this.m_cZorroFrameQueue.isEmpty() && this.m_iZorroNextAction != -1) {
                int n = this.m_iZorroNextAction;
                this.m_iZorroNextAction = -1;
                this.ZORRO_doAction(n);
            }
            if (!this.m_cZorroFrameQueue.isEmpty()) {
                bl = this.ZORRO_move(this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_XMOVE], this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_YMOVE]);
                if (this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 41 && !bl) {
                    this.m_iZorroNextAction = -1;
                }
                by = this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_ACTION];
            }
        }
        if (this.m_iComboInProgress > 6) {
            --this.m_iComboInProgress;
            if (this.m_iComboInProgress == 6) {
                if (!this.m_cZorroFrameQueue.isEmpty() || !this.m_bCombo[0] && !this.m_bCombo[1]) {
                    this.ZORRO_endCombo();
                } else {
                    if (ZorroCanvas.bCurrentMap != 2) {
                        this.m_iZorroSpecial -= this.m_bCombo[1] && this.m_bCombo[0] ? 200 : 100;
                    }
                    this.ZORRO_performCombo(this.m_bCombo[0] && this.m_bCombo[1]);
                }
            }
        }
    }

    private void ZORRO_draw(Graphics graphics, int n) {
        int n2 = 0;
        int n3 = 0;
        CFrameNode cFrameNode = null;
        cFrameNode = this.m_cZorroFrameQueue.isEmpty() ? this.m_cZorroDefaultFrame : this.m_cZorroFrameQueue.m_cTopNode;
        n2 = this.m_iZorroX - n;
        n3 = this.m_iZorroY - cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2];
        if (this.m_bIsZorroFacingRight) {
            graphics.setClip(n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX], n3, (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2], (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2]);
            graphics.drawImage(this.m_imgZorroFrames, n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX] - cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET2], n3 - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET2], 20);
        } else {
            graphics.setClip(n2 - (cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2] - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX]), n3, (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2], (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2]);
            graphics.drawImage(this.m_imgZorroFrames, n2 - (cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2] - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX]) + cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET2] - (m_iZorroImageWidth - cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2]), n3 - m_iZorroImageHeight - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET2], 20);
        }
        n2 = this.m_iZorroX - n;
        n3 = this.m_iZorroY + cFrameNode.m_iFrameData[DEF_FRAMENODE_QSHIFT] - cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT1] - cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2];
        if (this.m_bIsZorroFacingRight) {
            graphics.setClip(n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX] + cFrameNode.m_iFrameData[DEF_FRAMENODE_HSHIFT], n3, (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1], (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT1]);
            graphics.drawImage(this.m_imgZorroFrames, n2 + cFrameNode.m_iFrameData[DEF_FRAMENODE_HSHIFT] - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX] - cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET1], n3 - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET1], 20);
        } else {
            graphics.setClip(n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_HSHIFT] - (cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1] - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX]), n3, (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1], (int)cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT1]);
            graphics.drawImage(this.m_imgZorroFrames, n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_HSHIFT] - (cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1] - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX]) + cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET1] - (m_iZorroImageWidth - cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1]), n3 - m_iZorroImageHeight - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET1], 20);
        }
    }

    private boolean ZORRO_move(int n, int n2) {
        this.m_iZorroY += n2;
        if (!this.m_bIsZorroFacingRight) {
            n = -n;
        }
        if (this.m_iZorroX + n > 5 && this.m_iZorroX + n < this.m_iRoomWidth - 5) {
            this.m_iZorroX += n;
            if (n < 0) {
                Zorro.moveZorro((byte)6, true, -n);
            } else {
                Zorro.moveZorro((byte)2, true, n);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean ZORRO_isNextActionLooping() {
        if (this.m_iZorroNextAction == 10) {
            return true;
        }
        if (this.m_iZorroNextAction == 11) {
            return true;
        }
        if (this.m_iZorroNextAction == 45) {
            return true;
        }
        if (this.m_iZorroNextAction == 46) {
            return true;
        }
        if (this.m_iZorroNextAction == 26) {
            return true;
        }
        if (this.m_iZorroNextAction == 25) {
            return true;
        }
        if (this.m_iZorroNextAction == 31) {
            this.m_iZorroNextAction = 33;
            return false;
        }
        if (this.m_iZorroNextAction == 32) {
            this.m_iZorroNextAction = 34;
            return false;
        }
        return false;
    }

    private void ZORRO_load() {
        this.m_cZorroDefaultFrame = new CFrameNode(m_iActionArray[0][0]);
    }

    private int ZORRO_isHit(boolean bl, int n, boolean bl2) {
        CFrameNode cFrameNode = null;
        cFrameNode = this.m_cZorroFrameQueue.isEmpty() ? this.m_cZorroDefaultFrame : this.m_cZorroFrameQueue.m_cTopNode;
        if (n > this.m_iZorroX - (m_iZorroHitWidth >> 1) && n < this.m_iZorroX + (m_iZorroHitWidth >> 1)) {
            if (bl != this.m_bIsZorroFacingRight && cFrameNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] == -1) {
                if (cFrameNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 5 && bl2) {
                    MultiPlayer.playSound(3);
                    if (ZorroCanvas.bArcadeMode && ZorroCanvas.iArcadeBlocksInWave > 0) {
                        ZorroCanvas.iArcadeScore += 10;
                        --ZorroCanvas.iArcadeBlocksInWave;
                    }
                    return 2;
                }
                if (cFrameNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 6 && !bl2) {
                    MultiPlayer.playSound(3);
                    if (ZorroCanvas.bArcadeMode && ZorroCanvas.iArcadeBlocksInWave > 0) {
                        ZorroCanvas.iArcadeScore += 10;
                        --ZorroCanvas.iArcadeBlocksInWave;
                    }
                    return 2;
                }
            }
            if ((Zorro.iHP -= this.m_byEnemyType == 0 ? 24 : 17) > 0) {
                ZorroCanvas.zorroIsHit = true;
                MultiPlayer.playSound(7);
            }
            return 1;
        }
        return 0;
    }

    private void ZORRO_doAction(int n) {
        int n2;
        byte[][] byArray = null;
        this.m_iZorroAction = n;
        switch (this.m_iZorroAction) {
            case 10: {
                byArray = m_iActionArray[11];
                this.m_iZorroNextAction = 10;
                this.m_iZorroY = this.iFloorLevel[this.m_iZorroLevel];
                break;
            }
            case 45: {
                if (this.m_iZorroLevel > 0) {
                    byArray = m_iActionArray[12];
                    this.m_iZorroNextAction = 45;
                    n2 = 0;
                    while (n2 < 5) {
                        Zorro.moveZorro((byte)0, true, 4);
                        ++n2;
                    }
                    --this.m_iZorroLevel;
                    if (this.m_iZorroX > 64 && this.m_iZorroX < this.m_iRoomWidth - 64) {
                        this.divideAttackers();
                    }
                    this.bReCheckAttackers = true;
                    break;
                }
                byArray = m_iActionArray[0];
                break;
            }
            case 46: {
                if (this.m_iZorroLevel < 2) {
                    byArray = m_iActionArray[13];
                    this.m_iZorroNextAction = 46;
                    n2 = 0;
                    while (n2 < 5) {
                        Zorro.moveZorro((byte)4, true, 4);
                        ++n2;
                    }
                    ++this.m_iZorroLevel;
                    if (this.m_iZorroX > 64 && this.m_iZorroX < this.m_iRoomWidth - 64) {
                        this.divideAttackers();
                    }
                    this.bReCheckAttackers = true;
                    break;
                }
                byArray = m_iActionArray[0];
                break;
            }
            case 31: {
                byArray = m_iActionArray[3];
                this.m_iZorroNextAction = 31;
                break;
            }
            case 32: {
                byArray = m_iActionArray[1];
                this.m_iZorroNextAction = 32;
                break;
            }
            case 33: {
                byArray = m_iActionArray[4];
                break;
            }
            case 34: {
                byArray = m_iActionArray[2];
                break;
            }
            case 24: {
                byArray = m_iActionArray[6];
                break;
            }
            case 23: {
                byArray = m_iActionArray[5];
                break;
            }
            case 51: {
                byArray = m_iActionArray[14];
                break;
            }
            case 52: {
                byArray = m_iActionArray[15];
                break;
            }
            case 5: {
                byArray = m_iActionArray[7];
                this.m_iZorroNextAction = 26;
                break;
            }
            case 6: {
                byArray = m_iActionArray[8];
                this.m_iZorroNextAction = 25;
                break;
            }
            case 26: {
                byArray = m_iActionArray[9];
                this.m_iZorroNextAction = 26;
                break;
            }
            case 25: {
                byArray = m_iActionArray[10];
                this.m_iZorroNextAction = 25;
                break;
            }
            case 41: {
                byArray = m_iActionArray[16];
                this.m_iZorroNextAction = 42;
                break;
            }
            case 42: {
                byArray = m_iActionArray[17];
                this.bReDivideAttackers = true;
                break;
            }
            case 13: {
                byArray = m_iActionArray[0];
                this.m_bIsZorroFacingRight = !this.m_bIsZorroFacingRight;
                this.m_iZorroNextAction = 10;
            }
        }
        if (this.m_iZorroLevel > 2) {
            this.m_iZorroLevel = 2;
        }
        if (this.m_iZorroLevel < 0) {
            this.m_iZorroLevel = 0;
        }
        n2 = 0;
        while (n2 < byArray.length) {
            this.m_cZorroFrameQueue.addFrame(byArray[n2]);
            ++n2;
        }
    }

    private void ZORRO_setAction(int n) {
        this.m_cZorroFrameQueue.flushQueue();
        this.ZORRO_doAction(n);
    }

    private void divideAttackers() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        n2 = 0;
        while (n2 < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n2] >= 0) {
                n3 = Math.abs(ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX - (this.m_iZorroX - 40));
                n4 = Math.abs(ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX - (this.m_iZorroX + 40));
                if (n3 < n6) {
                    n6 = n3;
                }
                if (n4 < n5) {
                    n5 = n4;
                }
            }
            ++n2;
        }
        bl = n6 < n5;
        n = this.m_iAmountOfEnemies >> 1;
        n2 = 0;
        while (n2 < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n2] >= 0) {
                ZorroCanvas.enemies[this.m_iEnemy[n2]].m_bLeftGroup = bl;
            }
            ++n2;
        }
        int n7 = bl ? 0 : Integer.MAX_VALUE;
        boolean bl2 = false;
        int n8 = 0;
        n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < this.DEF_MAX_ENEMIES) {
                if (this.m_iEnemy[n2] >= 0 && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_bLeftGroup == bl && (bl && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX > n7 && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX >= this.m_iZorroX || !bl && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX < n7 && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX <= this.m_iZorroX)) {
                    bl2 = true;
                    n7 = ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX;
                    n4 = n2;
                }
                ++n2;
            }
            if (bl2) {
                bl2 = false;
                ZorroCanvas.enemies[this.m_iEnemy[n4]].m_bLeftGroup = !bl;
                ++n8;
            }
            n7 = bl ? 0 : Integer.MAX_VALUE;
            ++n3;
        }
        if (n8 < n) {
            n7 = bl ? Integer.MAX_VALUE : 0;
            n3 = 0;
            while (n3 < n - n8) {
                n2 = 0;
                while (n2 < this.DEF_MAX_ENEMIES) {
                    if (this.m_iEnemy[n2] >= 0 && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_bLeftGroup == bl && (bl && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX < n7 || !bl && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX > n7)) {
                        bl2 = true;
                        n7 = ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX;
                        n4 = n2;
                    }
                    ++n2;
                }
                if (bl2) {
                    bl2 = false;
                    ZorroCanvas.enemies[this.m_iEnemy[n4]].m_bLeftGroup = !bl;
                }
                n7 = bl ? Integer.MAX_VALUE : 0;
                ++n3;
            }
        }
    }

    private void checkAttackers() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n2] >= 0) {
                ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iAIPassiveState = 0;
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < 9) {
            int n4 = -1;
            switch (n3) {
                case 1: {
                    n = this.m_iZorroX - 40;
                    break;
                }
                case 2: {
                    n = this.m_iZorroX - 56;
                    break;
                }
                case 3: {
                    n = this.m_iZorroX - 56;
                    break;
                }
                case 4: {
                    n = this.m_iZorroX - 72;
                    break;
                }
                case 5: {
                    n = this.m_iZorroX + 40;
                    break;
                }
                case 6: {
                    n = this.m_iZorroX + 56;
                    break;
                }
                case 7: {
                    n = this.m_iZorroX + 56;
                    break;
                }
                case 8: {
                    n = this.m_iZorroX + 72;
                }
            }
            int n5 = Integer.MAX_VALUE;
            n2 = 0;
            while (n2 < this.DEF_MAX_ENEMIES) {
                if (this.m_iEnemy[n2] >= 0 && ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iAIPassiveState == 0 && (ZorroCanvas.enemies[this.m_iEnemy[n2]].m_bLeftGroup && n3 < 5 || !ZorroCanvas.enemies[this.m_iEnemy[n2]].m_bLeftGroup && n3 > 4) && Math.abs(ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX - n) < n5) {
                    n5 = Math.abs(ZorroCanvas.enemies[this.m_iEnemy[n2]].m_iX - n);
                    n4 = n2;
                }
                ++n2;
            }
            if (n4 != -1) {
                ZorroCanvas.enemies[this.m_iEnemy[n4]].m_iAIPassiveState = n3;
            }
            ++n3;
        }
        this.ENEMY_resetAI();
    }

    private boolean ENEMY_walkAI(Enemy enemy, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = true;
        enemy.m_bAIWait = false;
        if (n2 < 25) {
            if (n2 > 15) {
                n2 = 28;
            } else if (this.m_iRoomWidth > 170) {
                n2 = 140;
                enemy.m_bAIWait = true;
            } else if (enemy.m_iLevel == n) {
                return true;
            }
        }
        if (n2 + 25 > this.m_iRoomWidth) {
            if (n2 < this.m_iRoomWidth - 15) {
                n2 = this.m_iRoomWidth - 28;
            } else if (this.m_iRoomWidth > 170) {
                n2 = this.m_iRoomWidth - 140;
                enemy.m_bAIWait = true;
            } else if (enemy.m_iLevel == n) {
                return true;
            }
        }
        if (enemy.m_iLevel == this.m_iZorroLevel && (n2 < enemy.m_iX && n2 < this.m_iZorroX - 20 && enemy.m_iX > this.m_iZorroX + 20 || n2 > enemy.m_iX && n2 > this.m_iZorroX - 20 && enemy.m_iX < this.m_iZorroX - 20)) {
            if (enemy.m_iLevel != 0) {
                this.ENEMY_doAction(enemy, 45);
            } else {
                this.ENEMY_doAction(enemy, 46);
            }
        }
        n3 = Math.abs(n2 - enemy.m_iX);
        if (enemy.m_iAIState != 1 && n3 > 4) {
            if (enemy.m_iX < this.m_iZorroX && !enemy.m_bIsFacingRight || enemy.m_iX > this.m_iZorroX && enemy.m_bIsFacingRight) {
                this.ENEMY_doAction(enemy, 13);
            } else if (enemy.m_iX < n2 && enemy.m_bIsFacingRight || enemy.m_iX > n2 && !enemy.m_bIsFacingRight) {
                this.ENEMY_doAction(enemy, 10);
            } else {
                this.ENEMY_doAction(enemy, 11);
            }
            return false;
        }
        if (enemy.m_iAIState == 1 && n3 > 24) {
            enemy.m_iAIState = 0;
            return false;
        }
        if (enemy.m_iLevel != n) {
            if (enemy.m_iLevel < n) {
                this.ENEMY_doAction(enemy, 46);
            } else {
                this.ENEMY_doAction(enemy, 45);
            }
        }
        return true;
    }

    private void ENEMY_resetAI() {
        int n = 0;
        while (n < this.DEF_MAX_ENEMIES) {
            if (this.m_iEnemy[n] >= 0) {
                ZorroCanvas.enemies[this.m_iEnemy[n]].m_iAIState = 0;
            }
            ++n;
        }
    }

    private void ENEMY_doAI(Enemy enemy) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        if (enemy.m_iLevel == 3) {
            this.ENEMY_doAction(enemy, 12);
            enemy.m_iY -= 2;
            if (enemy.m_iY <= this.iFloorLevel[2]) {
                enemy.m_iY = this.iFloorLevel[2];
                enemy.m_iLevel = 2;
            }
        } else if (!this.m_bZorroSeen) {
            if (enemy.m_iAIRepeatIdleAction == 0) {
                this.m_iRandom = Math.abs(m_cRandom.nextInt()) % 100;
                if (this.m_iRandom < enemy.m_iAIIdleActionOdds[0]) {
                    enemy.m_iAICurrentIdleAction = 1;
                    enemy.m_iAIRepeatIdleAction = Math.abs(m_cRandom.nextInt()) % 100;
                } else if (this.m_iRandom < enemy.m_iAIIdleActionOdds[1]) {
                    enemy.m_iAICurrentIdleAction = 2;
                    enemy.m_iAIRepeatIdleAction = 0;
                    enemy.m_bIsFacingRight = !enemy.m_bIsFacingRight;
                    enemy.m_iNextAction = -1;
                } else if (this.m_iRandom < enemy.m_iAIIdleActionOdds[2]) {
                    enemy.m_iAIRepeatIdleAction = 1;
                    enemy.m_iAICurrentIdleAction = m_cRandom.nextInt() < 0 ? 3 : 4;
                } else {
                    enemy.m_iAICurrentIdleAction = 0;
                    enemy.m_iAIRepeatIdleAction = Math.abs(m_cRandom.nextInt()) % 80;
                }
            } else {
                switch (enemy.m_iAICurrentIdleAction) {
                    case 0: {
                        enemy.m_iNextAction = -1;
                        break;
                    }
                    case 1: {
                        this.ENEMY_doAction(enemy, 10);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.ENEMY_doAction(enemy, 45);
                        break;
                    }
                    case 4: {
                        this.ENEMY_doAction(enemy, 46);
                    }
                }
                --enemy.m_iAIRepeatIdleAction;
            }
            if (enemy.m_bIsFacingRight) {
                if (this.m_iZorroX > enemy.m_iX && this.m_iZorroX < enemy.m_iX + 96) {
                    this.m_bZorroSeen = true;
                } else if (enemy.m_iX > this.m_iRoomWidth - 48) {
                    enemy.m_bIsFacingRight = false;
                }
            } else if (this.m_iZorroX < enemy.m_iX && this.m_iZorroX > enemy.m_iX - 96) {
                this.m_bZorroSeen = true;
            } else if (enemy.m_iX < 48) {
                enemy.m_bIsFacingRight = true;
            }
        } else {
            enemy.m_iZorroDistance = this.m_iZorroX - enemy.m_iX;
            if (enemy.m_iAIPassiveState > 0) {
                switch (enemy.m_iAIPassiveState) {
                    case 1: {
                        n = this.m_iZorroX - 40;
                        n2 = this.m_iZorroLevel;
                        break;
                    }
                    case 2: {
                        n = this.m_iZorroX - 56;
                        if (this.m_iZorroLevel == 1) {
                            n2 = 2;
                            break;
                        }
                        n2 = 1;
                        break;
                    }
                    case 3: {
                        n = this.m_iZorroX - 56;
                        if (this.m_iZorroLevel == 0) {
                            n2 = 2;
                            break;
                        }
                        n2 = 0;
                        break;
                    }
                    case 4: {
                        n = this.m_iZorroX - 72;
                        n2 = this.m_iZorroLevel;
                        break;
                    }
                    case 5: {
                        n = this.m_iZorroX + 40;
                        n2 = this.m_iZorroLevel;
                        break;
                    }
                    case 6: {
                        n = this.m_iZorroX + 56;
                        if (this.m_iZorroLevel == 1) {
                            n2 = 0;
                            break;
                        }
                        n2 = 1;
                        break;
                    }
                    case 7: {
                        n = this.m_iZorroX + 56;
                        if (this.m_iZorroLevel == 2) {
                            n2 = 0;
                            break;
                        }
                        n2 = 2;
                        break;
                    }
                    case 8: {
                        n = this.m_iZorroX + 72;
                        n2 = this.m_iZorroLevel;
                    }
                }
                if (this.ENEMY_walkAI(enemy, n2, n)) {
                    if (this.m_iZorroX < enemy.m_iX && enemy.m_bIsFacingRight || this.m_iZorroX > enemy.m_iX && !enemy.m_bIsFacingRight) {
                        this.ENEMY_doAction(enemy, 13);
                    } else if (enemy.m_iAIPassiveState == 1 || enemy.m_iAIPassiveState == 5) {
                        enemy.m_iAIState = 1;
                    } else {
                        enemy.m_iAttackCount = 0;
                    }
                }
            }
            if (enemy.m_iAIState == 1 && !enemy.m_bAIWait) {
                if (!this.m_cZorroFrameQueue.isEmpty() && this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] > 10 && this.m_bIsZorroFacingRight != enemy.m_bIsFacingRight) {
                    if (Math.abs(m_cRandom.nextInt() % 100) > 75) {
                        if (this.m_cZorroFrameQueue.m_cTopNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] == 11) {
                            this.ENEMY_doAction(enemy, 6);
                        } else {
                            this.ENEMY_doAction(enemy, 5);
                        }
                    }
                    return;
                }
                if (enemy.m_iAttackCount == 0) {
                    if (Math.abs(m_cRandom.nextInt() % 100) > 80) {
                        enemy.m_iAttackCount = Math.abs(m_cRandom.nextInt() % 4);
                    }
                } else {
                    --enemy.m_iAttackCount;
                    if (m_cRandom.nextInt() < 0) {
                        this.ENEMY_doAction(enemy, 3);
                    } else {
                        this.ENEMY_doAction(enemy, 4);
                    }
                }
            }
        }
    }

    private void ENEMY_update(Enemy enemy) {
        if (this.m_cEnemyFrameQueue[enemy.m_iFEId].isEmpty()) {
            enemy.m_iAction = 0;
        } else {
            if (this.m_cEnemyFrameQueue[enemy.m_iFEId].m_cTopNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] == 5) {
                enemy.m_bIsFacingRight = !enemy.m_bIsFacingRight;
            }
            enemy.m_iAction = this.m_cEnemyFrameQueue[enemy.m_iFEId].m_cTopNode.m_iFrameData[DEF_FRAMENODE_ACTION];
            this.m_cEnemyFrameQueue[enemy.m_iFEId].pumpQueue();
            if (!this.m_cEnemyFrameQueue[enemy.m_iFEId].isEmpty()) {
                this.ENEMY_move(enemy, this.m_cEnemyFrameQueue[enemy.m_iFEId].m_cTopNode.m_iFrameData[DEF_FRAMENODE_XMOVE], this.m_cEnemyFrameQueue[enemy.m_iFEId].m_cTopNode.m_iFrameData[DEF_FRAMENODE_YMOVE]);
                int n = 0;
                while (n < 3) {
                    if (this.iFloorLevel[n] == enemy.m_iY) {
                        enemy.m_iLevel = n;
                    }
                    ++n;
                }
            }
        }
    }

    private void ENEMY_draw(Enemy enemy, Graphics graphics, int n) {
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        byte by2 = 0;
        CFrameNode cFrameNode = null;
        cFrameNode = this.m_cEnemyFrameQueue[enemy.m_iFEId].isEmpty() ? this.m_cEnemyDefaultFrame[enemy.m_iFEId] : this.m_cEnemyFrameQueue[enemy.m_iFEId].m_cTopNode;
        n2 = enemy.m_iX - n;
        n3 = enemy.m_iY - cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2];
        if (enemy.m_bIsFacingRight) {
            by = cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2];
            by2 = cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2];
            graphics.setClip(n2 -= cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX], n3, (int)by, (int)by2);
            graphics.clipRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            graphics.drawImage(this.m_imgEnemyFrames, n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET2], n3 - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET2], 20);
        } else {
            by = cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2];
            by2 = cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2];
            graphics.setClip(n2 -= cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2] - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX], n3, (int)by, (int)by2);
            graphics.clipRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            graphics.drawImage(this.m_imgEnemyFrames, n2 + cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET2] - (m_iImageWidthEnemy[this.m_byEnemyType] - cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH2]), n3 - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET2] - m_iEnemyImageHeight[this.m_byEnemyType], 20);
        }
        n2 = enemy.m_iX - n;
        n3 = enemy.m_iY + cFrameNode.m_iFrameData[DEF_FRAMENODE_QSHIFT] - cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT1] - cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT2];
        if (enemy.m_bIsFacingRight) {
            n2 = n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX] + cFrameNode.m_iFrameData[DEF_FRAMENODE_HSHIFT];
            by = cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1];
            by2 = cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT1];
            graphics.setClip(n2, n3, (int)by, (int)by2);
            graphics.clipRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            graphics.drawImage(this.m_imgEnemyFrames, n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET1], n3 - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET1], 20);
        } else {
            n2 = n2 - cFrameNode.m_iFrameData[DEF_FRAMENODE_HSHIFT] - (cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1] - cFrameNode.m_iFrameData[DEF_FRAMENODE_CENTERX]);
            by = cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1];
            by2 = cFrameNode.m_iFrameData[DEF_FRAMENODE_HEIGHT1];
            graphics.setClip(n2, n3, (int)by, (int)by2);
            graphics.drawImage(this.m_imgEnemyFrames, n2 + cFrameNode.m_iFrameData[DEF_FRAMENODE_XOFFSET1] - (m_iImageWidthEnemy[this.m_byEnemyType] - cFrameNode.m_iFrameData[DEF_FRAMENODE_WIDTH1]), n3 - m_iEnemyImageHeight[this.m_byEnemyType] - cFrameNode.m_iFrameData[DEF_FRAMENODE_YOFFSET1], 20);
        }
        if (this.m_iComboInProgress <= 0 || this.m_iComboInProgress > 6) {
            graphics.setClip(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            graphics.clipRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            graphics.setColor(0x363636);
            graphics.drawRect(enemy.m_iX - n - 9, enemy.m_iY - 45, 18, 2);
            if (enemy.isHit) {
                switch (enemy.flashFrame++) {
                    case 0: {
                        graphics.setColor(-1);
                        break;
                    }
                    case 1: {
                        graphics.setColor(0xDD0000);
                        break;
                    }
                    case 2: {
                        graphics.setColor(-1);
                        break;
                    }
                    case 3: {
                        graphics.setColor(0xDD0000);
                        enemy.flashFrame = 0;
                        enemy.isHit = false;
                    }
                }
            } else {
                graphics.setColor(0xDD0000);
            }
            n2 = enemy.m_iHP / 6;
            if (n2 > 16) {
                n2 = 16;
            }
            if (n2 > 0) {
                graphics.drawLine(enemy.m_iX - n - 8, enemy.m_iY - 44, enemy.m_iX - n - 8 + n2, enemy.m_iY - 44);
            }
        }
    }

    private void ENEMY_move(Enemy enemy, int n, int n2) {
        if (!enemy.m_bIsFacingRight) {
            n = -n;
        }
        if (enemy.m_iX + n > 5 && enemy.m_iX + n < this.m_iRoomWidth - 5) {
            enemy.m_iX += n;
            if (n < 0) {
                enemy.move(true, 6, -n);
            } else {
                enemy.move(true, 2, n);
            }
        }
        enemy.m_iY += n2;
    }

    private void ENEMY_load(Enemy enemy) {
        this.m_cEnemyDefaultFrame[enemy.m_iFEId] = new CFrameNode(m_iActionArray[18][0]);
        this.m_cEnemyFrameQueue[enemy.m_iFEId] = new CFrameQueue();
    }

    private void ENEMY_unload(Enemy enemy) {
        this.m_cEnemyFrameQueue[enemy.m_iFEId] = null;
        this.m_cEnemyDefaultFrame[enemy.m_iFEId] = null;
    }

    private int ENEMY_isHit(Enemy enemy, int n, byte by) {
        CFrameNode cFrameNode = null;
        cFrameNode = this.m_cEnemyFrameQueue[enemy.m_iFEId].isEmpty() ? this.m_cEnemyDefaultFrame[enemy.m_iFEId] : this.m_cEnemyFrameQueue[enemy.m_iFEId].m_cTopNode;
        if (cFrameNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 12) {
            return 0;
        }
        if (n > enemy.m_iX - (m_iEnemyHitWidth >> 1) && n < enemy.m_iX + (m_iEnemyHitWidth >> 1)) {
            if (enemy.m_bIsFacingRight != this.m_bIsZorroFacingRight && cFrameNode.m_iFrameData[DEF_FRAMENODE_SPECIAL] == -1 && (cFrameNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 5 && by == 1 || cFrameNode.m_iFrameData[DEF_FRAMENODE_ACTION] == 6 && by == 0)) {
                MultiPlayer.playSound(3);
                if (enemy.m_iHP > 0) {
                    return 2;
                }
            }
            if (by != 3) {
                enemy.m_iHP = enemy.m_iHP - ((ZorroCanvas.bDifficultyNormal || ZorroCanvas.bArcadeMode ? 4 : 15) + (enemy.m_bIsFacingRight == this.m_bIsZorroFacingRight ? 3 : 1) * (enemy.bType == 0 ? this.m_iSwordPower - 6 : this.m_iSwordPower));
                if (ZorroCanvas.bArcadeMode) {
                    ZorroCanvas.iArcadeScore += 2;
                }
            } else {
                enemy.m_iHP -= 40;
            }
            if (this.m_iComboInProgress >= 0) {
                this.m_iZorroSpecialBlock += ZorroCanvas.bDifficultyNormal || ZorroCanvas.bArcadeMode ? 25 : 50;
            }
            if (enemy.m_iHP <= 0) {
                MultiPlayer.playSound(5);
                this.ENEMY_setAction(enemy, 15);
                enemy.m_iAIState = -1;
                enemy.m_iHP = 0;
            } else {
                this.ENEMY_setAction(enemy, 47);
                MultiPlayer.playSound(8);
                enemy.isHit = true;
            }
            this.m_bZorroSeen = true;
            return 1;
        }
        return 0;
    }

    private void ENEMY_doAction(Enemy enemy, int n) {
        if (this.m_cEnemyFrameQueue[enemy.m_iFEId].isEmpty()) {
            int n2;
            byte[][] byArray = null;
            enemy.m_iAction = n;
            switch (enemy.m_iAction) {
                case -1: 
                case 0: {
                    byArray = m_iActionArray[18];
                    break;
                }
                case 10: {
                    byArray = m_iActionArray[25];
                    break;
                }
                case 45: {
                    if (enemy.m_iLevel > 0) {
                        byArray = m_iActionArray[26];
                        n2 = 0;
                        while (n2 < 5) {
                            enemy.move(true, 0, 4);
                            ++n2;
                        }
                        break;
                    }
                    byArray = m_iActionArray[18];
                    break;
                }
                case 46: {
                    if (enemy.m_iLevel < 2) {
                        byArray = m_iActionArray[27];
                        n2 = 0;
                        while (n2 < 5) {
                            enemy.move(true, 4, 4);
                            ++n2;
                        }
                        break;
                    }
                    byArray = m_iActionArray[18];
                    break;
                }
                case 11: {
                    byArray = m_iActionArray[31];
                    break;
                }
                case 3: {
                    byArray = m_iActionArray[20];
                    break;
                }
                case 4: {
                    byArray = m_iActionArray[19];
                    break;
                }
                case 24: {
                    byArray = m_iActionArray[22];
                    break;
                }
                case 23: {
                    byArray = m_iActionArray[21];
                    break;
                }
                case 47: {
                    byArray = m_iActionArray[30];
                    break;
                }
                case 5: {
                    byArray = m_iActionArray[23];
                    break;
                }
                case 6: {
                    byArray = m_iActionArray[24];
                    break;
                }
                case 15: {
                    byArray = m_iActionArray[32];
                    break;
                }
                case 14: {
                    byArray = m_iActionArray[18];
                    enemy.m_bIsFacingRight = !enemy.m_bIsFacingRight;
                    break;
                }
                case 13: {
                    byArray = m_iActionArray[29];
                    break;
                }
                case 12: {
                    byArray = m_iActionArray[28];
                }
            }
            n2 = 0;
            while (n2 < byArray.length) {
                this.m_cEnemyFrameQueue[enemy.m_iFEId].addFrame(byArray[n2]);
                ++n2;
            }
        } else {
            enemy.m_iNextAction = n;
        }
    }

    private void ENEMY_setAction(Enemy enemy, int n) {
        this.m_cEnemyFrameQueue[enemy.m_iFEId].flushQueue();
        this.ENEMY_doAction(enemy, n);
    }

    private void loadFrames(String string, String string2) {
        m_iActionArray = new byte[33][][];
        System.gc();
        try {
            System.gc();
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            InputStream inputStream2 = this.getClass().getResourceAsStream("/" + string2);
            this.loadFrameBytes(inputStream, inputStream2);
            inputStream.close();
            inputStream = null;
            inputStream2.close();
            inputStream2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    private void unloadFrames() {
        m_iActionArray = null;
        m_iActionSize = null;
        System.gc();
    }

    private void loadFrameBytes(InputStream inputStream, InputStream inputStream2) {
        Object var3_3 = null;
        boolean bl = false;
        try {
            m_iActionSize = new byte[33];
            int n = 0;
            while (n < 18) {
                ZorroFightEngine.m_iActionSize[n] = (byte)inputStream.read();
                ++n;
            }
            int n2 = 0;
            while (n2 < 15) {
                ZorroFightEngine.m_iActionSize[n2 + 18] = (byte)inputStream2.read();
                ++n2;
            }
            int n3 = 0;
            while (n3 < 33) {
                int n4;
                ZorroFightEngine.m_iActionArray[n3] = new byte[m_iActionSize[n3]][16];
                if (n3 < 18) {
                    int n5 = 0;
                    while (n5 < m_iActionSize[n3]) {
                        n4 = 0;
                        while (n4 < 16) {
                            ZorroFightEngine.m_iActionArray[n3][n5][n4] = (byte)inputStream.read();
                            ++n4;
                        }
                        ++n5;
                    }
                } else {
                    n4 = 0;
                    while (n4 < m_iActionSize[n3]) {
                        int n6 = 0;
                        while (n6 < 16) {
                            ZorroFightEngine.m_iActionArray[n3][n4][n6] = (byte)inputStream2.read();
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }
        catch (Exception exception) {}
    }

    private class CFrameNode {
        int m_iRepeat = 0;
        public byte[] m_iFrameData = null;
        public CFrameNode m_next;

        public CFrameNode(byte[] byArray) {
            this.m_iRepeat = byArray[DEF_FRAMENODE_REPEAT];
            this.m_iFrameData = byArray;
            this.m_next = null;
        }
    }

    private class CFrameQueue {
        CFrameNode m_cTopNode;

        private CFrameQueue() {
        }

        public boolean isEmpty() {
            return this.m_cTopNode == null;
        }

        public void addFrame(byte[] byArray) {
            CFrameNode cFrameNode = new CFrameNode(byArray);
            if (this.m_cTopNode == null) {
                this.m_cTopNode = cFrameNode;
            } else {
                CFrameNode cFrameNode2 = this.m_cTopNode;
                while (cFrameNode2.m_next != null) {
                    cFrameNode2 = cFrameNode2.m_next;
                }
                cFrameNode2.m_next = cFrameNode;
            }
        }

        public void pumpQueue() {
            if (this.m_cTopNode.m_iRepeat > 0) {
                --this.m_cTopNode.m_iRepeat;
            } else {
                this.m_cTopNode = this.m_cTopNode.m_next;
            }
        }

        public void flushQueue() {
            while (this.m_cTopNode != null) {
                this.m_cTopNode = this.m_cTopNode.m_next;
            }
        }
    }
}

