/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tompacket;

import com.tomclaw.tompacket.MapUtil;
import com.tomclaw.tompacket.PacketBuilder;
import com.tomclaw.tompacket.TomOutputStream;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;

public class Packet {
    public ByteArrayOutputStream baos = new ByteArrayOutputStream();
    public TomOutputStream tos = new TomOutputStream(this.baos);
    public String mapFileName;
    public String mapBlockName;
    public static String className = "";
    public static String blockName = "PACKET_UNK";
    public static boolean isUniversal = true;
    public static int infoFlags = 0;

    public Packet(String mapFileName) {
        int delimiter = mapFileName.indexOf(":");
        if (delimiter != -1) {
            this.mapFileName = mapFileName.substring(0, delimiter) + ".tpt";
            this.mapBlockName = mapFileName.substring(delimiter + 1);
        } else {
            this.mapFileName = mapFileName + ".tpt";
            this.mapBlockName = null;
        }
    }

    public byte[] loadBlock() throws Throwable {
        byte t_tpVersion;
        InputStream is = PacketBuilder.openMapStream(this.mapFileName);
        DataInputStream dis = new DataInputStream(is);
        byte[] header = new byte[3];
        dis.readFully(header);
        if (ArrayUtil.equals(header, "TP#".getBytes()) && (t_tpVersion = dis.readByte()) == MapUtil.tpVersion) {
            int blockCount = dis.readChar();
            for (int i = 0; i < blockCount; ++i) {
                char blockSize = dis.readChar();
                blockName = dis.readUTF();
                isUniversal = dis.readBoolean();
                if (isUniversal && this.mapBlockName == null || blockName.equals(this.mapBlockName)) {
                    className = dis.readUTF();
                    infoFlags = dis.readInt();
                    int modelCount = dis.readChar();
                    for (int c = 0; c < modelCount; ++c) {
                        String caseDefValue;
                        byte[] string;
                        byte[] caseTypeBytes = new byte[3];
                        dis.readFully(caseTypeBytes);
                        String caseType = StringUtil.byteArrayToString(caseTypeBytes);
                        String caseName = dis.readUTF();
                        int prefixType = 0;
                        boolean bigEndian = true;
                        int encIndex = 0;
                        boolean strView = false;
                        if (caseName.endsWith("_STR")) {
                            strView = true;
                            caseName = caseName.substring(0, caseName.length() - 4);
                        }
                        if (caseName.endsWith("_LE")) {
                            bigEndian = false;
                            caseName = caseName.substring(0, caseName.length() - 3);
                        } else if (caseName.endsWith("_BE")) {
                            bigEndian = true;
                            caseName = caseName.substring(0, caseName.length() - 3);
                        }
                        if (caseName.startsWith("BYT_")) {
                            prefixType = 8;
                            caseName = caseName.substring(4);
                        } else if (caseName.startsWith("INT_")) {
                            prefixType = 16;
                            caseName = caseName.substring(4);
                        } else if (caseName.startsWith("LNG_")) {
                            prefixType = 32;
                            caseName = caseName.substring(4);
                        }
                        if (caseName.startsWith("WIN_")) {
                            encIndex = 0;
                            caseName = caseName.substring(4);
                        } else if (caseName.startsWith("UTF_")) {
                            encIndex = 1;
                            caseName = caseName.substring(4);
                        } else if (caseName.startsWith("UCS_")) {
                            encIndex = 2;
                            caseName = caseName.substring(4);
                        }
                        char caseLength = dis.readChar();
                        long packetLength = 0L;
                        boolean isNullLength = false;
                        if (caseLength == '\u0000' && PacketBuilder.checkNull(caseName)) continue;
                        if (PacketBuilder.checkNULL(caseName)) {
                            caseType = "UNK";
                        } else {
                            if (caseLength == MapUtil.SIZE_16BIT - 1) {
                                if (PacketBuilder.checkNull(caseName)) continue;
                                isNullLength = true;
                            }
                            if (strView) {
                                string = new byte[caseLength];
                                dis.readFully(string);
                                caseDefValue = StringUtil.byteArrayToString(string, true);
                                caseDefValue = PacketBuilder.checkString(caseName, caseDefValue);
                                packetLength = PacketBuilder.cacheMap(caseDefValue).getData().length;
                            }
                        }
                        if (caseType.equals(MapUtil.types[0])) {
                            byte caseDefValue2 = strView ? (byte)packetLength : (isNullLength ? (byte)0 : dis.readByte());
                            caseDefValue2 = strView ? caseDefValue2 : PacketBuilder.checkByte(caseName, caseDefValue2);
                            this.tos.write8(caseDefValue2);
                            continue;
                        }
                        if (caseType.equals(MapUtil.types[1])) {
                            char caseDefValue3 = isNullLength ? (char)'\u0000' : dis.readChar();
                            caseDefValue3 = PacketBuilder.checkChar(caseName, caseDefValue3);
                            this.tos.write8(caseDefValue3);
                            continue;
                        }
                        if (caseType.equals(MapUtil.types[2])) {
                            int caseDefValue4 = strView ? (int)packetLength : (isNullLength ? 0 : (int)dis.readChar());
                            caseDefValue4 = strView ? caseDefValue4 : PacketBuilder.checkInt(caseName, caseDefValue4);
                            this.tos.write16(caseDefValue4, bigEndian);
                            continue;
                        }
                        if (caseType.equals(MapUtil.types[3])) {
                            long caseDefValue5 = strView ? packetLength : (long)(isNullLength ? 0 : dis.readInt());
                            caseDefValue5 = strView ? caseDefValue5 : PacketBuilder.checkLong(caseName, caseDefValue5);
                            this.tos.write32((int)caseDefValue5, bigEndian);
                            continue;
                        }
                        if (caseType.equals(MapUtil.types[4])) {
                            string = new byte[caseLength];
                            if (!isNullLength) {
                                dis.readFully(string);
                            }
                            caseDefValue = isNullLength ? "" : StringUtil.byteArrayToString(string, true);
                            caseDefValue = PacketBuilder.checkString(caseName, caseDefValue);
                            byte[] out_string = null;
                            if (encIndex == 0) {
                                out_string = StringUtil.stringToByteArray(caseDefValue, false);
                            } else if (encIndex == 1) {
                                out_string = StringUtil.stringToByteArray(caseDefValue, true);
                            } else if (encIndex == 2) {
                                out_string = StringUtil.stringToUcs2beByteArray(caseDefValue);
                            }
                            if (prefixType == 8) {
                                this.tos.write8(out_string.length);
                            } else if (prefixType == 16) {
                                this.tos.write16(out_string.length, bigEndian);
                            } else if (prefixType == 32) {
                                this.tos.write32(out_string.length, bigEndian);
                            }
                            this.tos.write(out_string);
                            continue;
                        }
                        if (caseType.equals(MapUtil.types[5])) {
                            byte[] array = new byte[caseLength];
                            if (!isNullLength) {
                                dis.readFully(array);
                            }
                            array = PacketBuilder.checkArray(caseName, array);
                            this.tos.write(array);
                            continue;
                        }
                        if (caseType.equals(MapUtil.types[6])) {
                            string = new byte[caseLength];
                            if (!isNullLength) {
                                dis.readFully(string);
                            }
                            caseDefValue = isNullLength ? "" : StringUtil.byteArrayToString(string);
                            caseDefValue = PacketBuilder.checkString(caseName, caseDefValue);
                            Packet packet = PacketBuilder.cacheMap(caseDefValue);
                            this.tos.write(packet.getData());
                            continue;
                        }
                        dis.skipBytes(Math.abs(caseLength));
                    }
                    continue;
                }
                dis.skipBytes(blockSize);
            }
            this.tos.flush();
            return this.baos.toByteArray();
        }
        return null;
    }

    public byte[] getData() {
        return this.baos.toByteArray();
    }
}

