/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite.smiles;

import com.tomclaw.tcuilite.smiles.AnimSmile;
import com.tomclaw.tcuilite.smiles.CommSmile;
import com.tomclaw.tcuilite.smiles.StatSmile;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.StringUtil;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class Smiles {
    public static String smilesDatapath = "/res/smiles/tcui_smiles.dat";
    public static String smilesPath = "/res/smiles/";
    public static CommSmile[] smiles = null;
    public static Image tempImage;
    public static int averageWidth;
    public static int averageHeight;
    public static int smilesType;

    public static void readSmileData(boolean isBBAdapted) throws Throwable {
        DataInputStream is = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream(smilesDatapath));
        if (is != null) {
            smilesType = is.readChar();
            System.out.println("smilesType = " + smilesType);
            if (smilesType == 0) {
                int blocksCount = is.readChar();
                smiles = new AnimSmile[blocksCount];
                for (int i = 0; i < blocksCount; ++i) {
                    char length = is.readChar();
                    byte[] block = new byte[length];
                    is.read(block);
                    int offset = 0;
                    byte fileNameLength = DataUtil.get8(block, offset);
                    String fileName = DataUtil.byteArray2string(block, ++offset, fileNameLength);
                    int framesCount = DataUtil.get16(block, offset += fileNameLength);
                    offset += 2;
                    AnimSmile animSmile = new AnimSmile();
                    animSmile.fileName = fileName;
                    animSmile.framesDelay = new int[framesCount];
                    for (int c = 0; c < framesCount; ++c) {
                        int frameDelay;
                        animSmile.framesDelay[c] = frameDelay = DataUtil.get16(block, offset);
                        offset += 2;
                    }
                    int definitionCount = DataUtil.get8(block, offset);
                    ++offset;
                    animSmile.smileDefinitions = new String[definitionCount];
                    for (int c = 0; c < definitionCount; ++c) {
                        byte definitionLength = DataUtil.get8(block, offset);
                        String definition = DataUtil.byteArray2string(block, ++offset, definitionLength);
                        offset += definitionLength;
                        animSmile.smileDefinitions[c] = definition;
                    }
                    Smiles.smiles[i] = animSmile;
                }
            } else if (smilesType == 1) {
                String smilesFileName = is.readUTF();
                Image smilesImage = Image.createImage((String)smilesPath.concat(smilesFileName));
                smiles = new StatSmile[is.readChar()];
                StatSmile.image = smilesImage;
                for (int c = 0; c < smiles.length; ++c) {
                    char x = is.readChar();
                    char y = is.readChar();
                    char w = is.readChar();
                    char h = is.readChar();
                    StatSmile tempSmile = new StatSmile(x, y, w, h);
                    int determCount = is.readChar();
                    tempSmile.smileDefinitions = new String[determCount];
                    for (int i = 0; i < determCount; ++i) {
                        tempSmile.smileDefinitions[i] = is.readUTF();
                        if (!isBBAdapted) continue;
                        tempSmile.smileDefinitions[i] = StringUtil.replace(tempSmile.smileDefinitions[i], "[", "\\[");
                        tempSmile.smileDefinitions[i] = StringUtil.replace(tempSmile.smileDefinitions[i], "]", "\\]");
                    }
                    Smiles.smiles[c] = tempSmile;
                }
            }
        } else {
            throw new IOException();
        }
    }

    public static String replaceSmilesForCodes(String textWithSmileys) {
        for (int c = 0; c < smiles.length; ++c) {
            for (int j = 0; j < smiles[c].getSmileDefinitions().length; ++j) {
                int prevIndex = 0;
                for (int i = 0; i < textWithSmileys.length(); ++i) {
                    if (!textWithSmileys.regionMatches(true, i, smiles[c].getSmileDefinitions()[j], 0, smiles[c].getSmileDefinitions()[j].length())) continue;
                    textWithSmileys = textWithSmileys.substring(prevIndex, i) + "[smile=" + c + "/]" + textWithSmileys.substring(i + smiles[c].getSmileDefinitions()[j].length(), textWithSmileys.length());
                    prevIndex = 0;
                }
            }
        }
        return textWithSmileys;
    }

    public static void loadSmileARGB(AnimSmile animSmile) {
        try {
            tempImage = Image.createImage((String)smilesPath.concat(animSmile.fileName));
            animSmile.setWidth(tempImage.getWidth() / animSmile.framesDelay.length);
            animSmile.setHeight(tempImage.getHeight());
            animSmile.setFramesARGB(tempImage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        averageWidth = 38;
        averageHeight = 38;
        smilesType = -1;
    }
}

