/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.Dialog;
import com.tomclaw.tcuilite.DirectDraw;
import com.tomclaw.tcuilite.GObject;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.KeyEvent;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Soft;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class Window {
    public String name = null;
    public Screen screen = null;
    private GObject gObject = null;
    public Header header = null;
    public Soft soft = null;
    public Window s_prevWindow = null;
    public Window s_nextWindow = null;
    public boolean isPainted = false;
    public Dialog dialog = null;
    public long startTime = System.currentTimeMillis();
    public int mSecDelay = 500;
    public boolean isShowingDialog = false;
    public Hashtable keyEvents;
    public KeyEvent capKeyEvent = null;
    public Enumeration e;
    public DirectDraw directDraw_background = null;
    public DirectDraw directDraw_beforePopup = null;
    public DirectDraw directDraw_afterAll = null;

    public Window(Screen screen) {
        this.screen = screen;
    }

    public void prepareGraphics() {
        this.paint(Screen.lGraphics, this.screen.lCache.getWidth(), 0);
    }

    public void paint(Graphics g) {
        this.paint(g, 0, 0);
    }

    public void paint(Graphics g, int paintX, int paintY) {
        this.paint(g, paintX, paintY, false);
    }

    public void paint(Graphics g, int paintX, int paintY, boolean isBlock) {
        if (this.dialog != null && !this.isPainted || this.dialog == null || isBlock) {
            if (this.header != null && this.header.getWidth() != this.screen.getWidth()) {
                this.header.setLocation(0, 0);
                this.header.setSize(this.screen.getWidth(), 0);
            }
            if (this.soft != null && Soft.getWidth() != this.screen.getWidth()) {
                this.soft.setLocation(0, this.screen.getHeight() - this.soft.getHeight());
                this.soft.setSize(this.screen.getWidth(), this.soft.getHeight());
            }
            if (this.gObject != null) {
                if (this.gObject.getWidth() != this.screen.getWidth() || this.gObject.getHeight() != this.screen.getHeight() - (this.header != null ? this.header.getHeight() : 0) - (this.soft != null ? this.soft.getHeight() : 0)) {
                    this.gObject.setSize(this.screen.getWidth(), this.screen.getHeight() - (this.header != null ? this.header.getHeight() : 0) - (this.soft != null ? this.soft.getHeight() : 0));
                    this.gObject.setLocation(0, this.header != null ? this.header.getHeight() : 0);
                }
                this.gObject.repaint(g, paintX, paintY);
            }
            if (this.header != null) {
                this.header.paint(g, paintX, paintY);
            }
            if (this.directDraw_beforePopup != null) {
                this.directDraw_beforePopup.paint(g, paintX, paintY);
            }
            if (this.soft != null) {
                this.soft.paint(g, paintX, paintY);
            }
            this.isPainted = true;
        }
    }

    public void showDialog(Dialog dialog) {
        this.dialog = dialog;
        this.dialog.yOffset = Settings.DIALOG_SHOW_ANIMATION ? this.screen.getHeight() / 2 : 0;
        this.startTime = System.currentTimeMillis();
        this.isShowingDialog = true;
        this.screen.repaint(0);
    }

    public void closeDialog() {
        if (!Settings.DIALOG_SHOW_ANIMATION) {
            this.dialog = null;
            return;
        }
        this.dialog.yOffset = 0;
        this.startTime = System.currentTimeMillis();
        this.isShowingDialog = false;
        this.screen.repaint(0);
    }

    protected void keyPressed(int keyCode) {
        if (this.dialog != null) {
            this.dialog.keyPressed(keyCode);
            return;
        }
        if ((this.soft == null || !this.soft.isLeftPressed && !this.soft.isRightPressed) && this.keyEvents != null) {
            this.e = this.keyEvents.elements();
            while (this.e.hasMoreElements()) {
                KeyEvent keyEvent = (KeyEvent)this.e.nextElement();
                if (keyEvent.keyCode != keyCode) continue;
                keyEvent.actionPerformed();
                if (!keyEvent.isTotalCapture) break;
                return;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 1000001) {
            if (this.soft.isLeftPressed || !this.soft.isLeftPressed && !this.soft.isRightPressed) {
                if (!this.soft.isLeftPressed) {
                    this.soft.leftSoft.actionPerformed();
                }
                if (!this.soft.leftSoft.isEmpty()) {
                    this.soft.setLeftSoftPressed(!this.soft.isLeftPressed);
                }
            }
        } else if (Screen.getExtGameAct(keyCode) == 1000002) {
            if (this.soft.isRightPressed || !this.soft.isLeftPressed && !this.soft.isRightPressed) {
                if (!this.soft.isRightPressed) {
                    this.soft.rightSoft.actionPerformed();
                }
                if (!this.soft.rightSoft.isEmpty()) {
                    this.soft.setRightSoftPressed(!this.soft.isRightPressed);
                }
            }
        } else if (Screen.getExtGameAct(keyCode) == 1000002) {
            if (this.s_prevWindow != null) {
                this.screen.setActiveWindow(this.s_prevWindow);
            }
        } else if (this.soft != null && (this.soft.isLeftPressed || this.soft.isRightPressed)) {
            this.soft.keyPressed(keyCode);
        } else {
            this.gObject.keyPressed(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.capKeyEvent != null) {
            this.capKeyEvent.keyCode = keyCode;
            this.capKeyEvent.actionPerformed();
        }
        if (this.dialog != null) {
            this.dialog.keyReleased(keyCode);
            return;
        }
        if (Screen.getExtGameAct(keyCode) == 1000001) {
            if (this.soft.leftSoft.isEmpty()) {
                this.soft.setLeftSoftPressed(false);
            }
        } else if (Screen.getExtGameAct(keyCode) == 1000002) {
            if (this.soft.rightSoft.isEmpty()) {
                this.soft.setRightSoftPressed(false);
            }
        } else if (this.soft != null && (this.soft.isLeftPressed || this.soft.isRightPressed)) {
            this.soft.keyReleased(keyCode);
        } else {
            this.gObject.keyReleased(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.dialog != null) {
            this.dialog.keyRepeated(keyCode);
            return;
        }
        if (this.soft != null && (this.soft.isLeftPressed || this.soft.isRightPressed)) {
            this.soft.keyRepeated(keyCode);
        } else {
            this.gObject.keyRepeated(keyCode);
        }
    }

    protected boolean pointerDragged(int x, int y) {
        if (this.dialog != null) {
            return this.dialog.pointerDragged(x, y);
        }
        if (this.soft != null && (this.soft.isLeftPressed || this.soft.isRightPressed)) {
            return this.soft.pointerDragged(x, y);
        }
        return this.gObject.pointerDragged(x, y);
    }

    protected void pointerPressed(int x, int y) {
        if (this.dialog != null) {
            this.dialog.pointerPressed(x, y);
            return;
        }
        if (this.soft != null && x >= Soft.getX() && y >= Soft.getY() && x < Soft.getX() + Soft.getWidth() && y < Soft.getY() + this.soft.getHeight()) {
            if (x <= Soft.getX() + Soft.getWidth() / 2) {
                if (this.soft.isLeftPressed || !this.soft.isLeftPressed && !this.soft.isRightPressed) {
                    if (!this.soft.isLeftPressed) {
                        this.soft.leftSoft.actionPerformed();
                    }
                    this.soft.setLeftSoftPressed(!this.soft.isLeftPressed);
                }
            } else if (this.soft.isRightPressed || !this.soft.isLeftPressed && !this.soft.isRightPressed) {
                if (!this.soft.isRightPressed) {
                    this.soft.rightSoft.actionPerformed();
                }
                this.soft.setRightSoftPressed(!this.soft.isRightPressed);
            }
        } else if (this.soft != null && (this.soft.isLeftPressed || this.soft.isRightPressed)) {
            this.soft.pointerPressed(x, y);
        } else {
            this.gObject.pointerPressed(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.dialog != null) {
            this.dialog.pointerReleased(x, y);
            return;
        }
        if (this.soft != null && (this.soft.isLeftPressed || this.soft.isRightPressed)) {
            if (this.soft.isLeftPressed && this.soft.leftSoft.isEmpty()) {
                this.soft.setLeftSoftPressed(false);
            } else if (this.soft.isRightPressed && this.soft.rightSoft.isEmpty()) {
                this.soft.setRightSoftPressed(false);
            } else {
                this.soft.pointerReleased(x, y);
            }
            return;
        }
        this.gObject.pointerReleased(x, y);
    }

    public void setGObject(GObject gObject) {
        this.gObject = gObject;
        this.gObject.setTouchOrientation(this.screen.isPointerEvents);
    }

    public GObject getGObject() {
        return this.gObject;
    }

    public void addKeyEvent(KeyEvent keyEvent) {
        if (this.keyEvents == null) {
            this.keyEvents = new Hashtable();
        }
        this.keyEvents.put(keyEvent.description, keyEvent);
    }

    public void removeKeyEvent(String description) {
        if (this.keyEvents == null) {
            return;
        }
        if (this.keyEvents.containsKey(description)) {
            this.keyEvents.remove(this.keyEvents.get(description));
        }
    }

    public void removeAllKeyEvents() {
        if (this.keyEvents == null) {
            return;
        }
        this.keyEvents.clear();
    }

    public KeyEvent getKeyEvent(String description) {
        if (this.keyEvents != null && this.keyEvents.containsKey(description)) {
            return (KeyEvent)this.keyEvents.get(description);
        }
        return null;
    }

    public void windowActivated() {
    }
}

