/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.Popup;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.DrawUtil;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Soft {
    public String name = null;
    public static int softLine1 = 10843581;
    public static int softLine2 = 15719423;
    public static int softGradFrom = 14065391;
    public static int softGradTo = 5909611;
    public static int fontColor = 0xFFFFFF;
    public static int fontShadow = 0x424542;
    public static int x = 0;
    public static int y = 0;
    public static int width = 0;
    public static int height = 0;
    public PopupItem leftSoft = null;
    public PopupItem rightSoft = null;
    public boolean isLeftPressed = false;
    public boolean isRightPressed = false;
    public static int popupOverlayDividor = 3;
    public Vector activePopups = null;
    public Screen screen;
    private int pressedIndex = -1;

    public Soft(Screen screen) {
        this.screen = screen;
    }

    public void paint(Graphics g, int paintX, int paintY) {
        g.setFont(Theme.font);
        this.getHeight();
        g.setColor(softLine1);
        g.drawLine(paintX + x, paintY + y, paintX + x + width, paintY + y);
        g.setColor(softLine2);
        g.drawLine(paintX + x, paintY + y + 1, paintX + x + width, paintY + y + 1);
        DrawUtil.fillVerticalGradient(g, paintX + x, paintY + y + 2, width, height - 2, softGradFrom, softGradTo);
        if (this.leftSoft != null) {
            g.setColor(fontShadow);
            g.drawString(this.leftSoft.title, paintX + x + Theme.upSize + 1, paintY + y + 2 + Theme.upSize + 1, 20);
            g.setColor(fontColor);
            g.drawString(this.leftSoft.title, paintX + x + Theme.upSize, paintY + y + 2 + Theme.upSize, 20);
            if (this.isLeftPressed) {
                if (!this.leftSoft.isEmpty() && (this.activePopups == null || this.activePopups.isEmpty())) {
                    this.activePopups = new Vector();
                    this.addPopupToActive(this.leftSoft);
                }
            } else if (!this.isRightPressed) {
                this.isLeftPressed = false;
                this.activePopups = null;
            }
        }
        if (this.rightSoft != null) {
            g.setColor(fontShadow);
            g.drawString(this.rightSoft.title, paintX + x + width - Theme.upSize - Theme.font.stringWidth(this.rightSoft.title) + 1, paintY + y + 2 + Theme.upSize + 1, 20);
            g.setColor(fontColor);
            g.drawString(this.rightSoft.title, paintX + x + width - Theme.upSize - Theme.font.stringWidth(this.rightSoft.title), paintY + y + 2 + Theme.upSize, 20);
            if (this.isRightPressed) {
                if (!this.rightSoft.isEmpty() && (this.activePopups == null || this.activePopups.isEmpty())) {
                    this.activePopups = new Vector();
                    this.addPopupToActive(this.rightSoft);
                }
            } else if (!this.isLeftPressed) {
                this.isRightPressed = false;
                this.activePopups = null;
            }
        }
        this.paintPopups(g, paintX, paintY);
    }

    public void paintPopups(Graphics g, int paintX, int paintY) {
        if (this.activePopups != null && !this.activePopups.isEmpty()) {
            for (int c = 0; c < this.activePopups.size(); ++c) {
                Popup popup = (Popup)this.activePopups.elementAt(c);
                popup.repaint(g, paintX, paintY);
                g.setClip(0, 0, this.screen.getWidth(), this.screen.getHeight());
            }
        }
    }

    public void setLocation(int x, int y) {
        Soft.x = x;
        Soft.y = y;
    }

    public void setSize(int width, int height) {
        Soft.width = width;
        Soft.height = height;
    }

    public void setLeftSoftPressed(boolean isPressed) {
        this.isLeftPressed = isPressed;
    }

    public void setRightSoftPressed(boolean isPressed) {
        this.isRightPressed = isPressed;
    }

    public static int getX() {
        return x;
    }

    public static int getY() {
        return y;
    }

    public static int getWidth() {
        return width;
    }

    public int getHeight() {
        height = Theme.font.getHeight() + Theme.upSize * 2 + 2;
        return height;
    }

    public void keyPressed(int keyCode) {
        if (this.activePopups != null && !this.activePopups.isEmpty()) {
            ((Popup)this.activePopups.lastElement()).keyPressed(keyCode);
            if (Screen.getExtGameAct(keyCode) == 8 || Screen.getExtGameAct(keyCode) == 5) {
                PopupItem popupItem = (PopupItem)((Popup)this.activePopups.lastElement()).items.elementAt(((Popup)this.activePopups.lastElement()).selectedIndex);
                if (!popupItem.isEmpty()) {
                    this.addPopupToActive(popupItem);
                } else {
                    popupItem.actionPerformed();
                    this.isLeftPressed = false;
                    this.isRightPressed = false;
                }
            } else if (Screen.getExtGameAct(keyCode) == 2) {
                this.activePopups.removeElementAt(this.activePopups.size() - 1);
                if (this.activePopups.isEmpty()) {
                    this.isLeftPressed = false;
                    this.isRightPressed = false;
                }
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (this.activePopups != null && !this.activePopups.isEmpty()) {
            ((Popup)this.activePopups.lastElement()).keyReleased(keyCode);
        }
    }

    public void keyRepeated(int keyCode) {
        if (this.activePopups != null && !this.activePopups.isEmpty()) {
            ((Popup)this.activePopups.lastElement()).keyRepeated(keyCode);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.activePopups != null && !this.activePopups.isEmpty()) {
            Popup popup = (Popup)this.activePopups.lastElement();
            if (x < popup.getX() || y < popup.getY() || x > popup.getX() + popup.getWidth() || y > popup.getY() + popup.getHeight()) {
                this.activePopups.removeElementAt(this.activePopups.size() - 1);
                if (this.activePopups.isEmpty()) {
                    this.isLeftPressed = false;
                    this.isRightPressed = false;
                }
            } else {
                popup.pointerPressed(x, y);
                if (x < popup.getX() + popup.getWidth() - popup.repaintScrollWidth && !((PopupItem)popup.items.elementAt(popup.selectedIndex)).isEmpty()) {
                    this.pressedIndex = popup.selectedIndex;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        Popup popup;
        if (this.activePopups != null && !this.activePopups.isEmpty() && x >= (popup = (Popup)this.activePopups.lastElement()).getX() && y >= popup.getY() && x <= popup.getX() + popup.getWidth() && y <= popup.getY() + popup.getHeight()) {
            popup.pointerReleased(x, y);
            if (((PopupItem)popup.items.elementAt((int)popup.selectedIndex)).subPopup != null && !((PopupItem)popup.items.elementAt((int)popup.selectedIndex)).subPopup.items.isEmpty() && this.pressedIndex == popup.selectedIndex) {
                this.addPopupToActive((PopupItem)popup.items.elementAt(popup.selectedIndex));
                this.pressedIndex = -1;
            }
        }
    }

    public boolean pointerDragged(int x, int y) {
        if (this.activePopups != null && !this.activePopups.isEmpty()) {
            boolean toReturn = ((Popup)this.activePopups.lastElement()).pointerDragged(x, y);
            this.pressedIndex = -1;
            return toReturn;
        }
        return false;
    }

    public void addPopupToActive(PopupItem parentPopup) {
        Popup popup;
        block17: {
            block15: {
                block16: {
                    parentPopup.expandPerformed();
                    popup = parentPopup.subPopup;
                    if (!this.activePopups.isEmpty()) break block15;
                    popup.setTouchOrientation(this.screen.isPointerEvents);
                    popup.defineSize(this.screen.getHeight() - height);
                    if (!this.isLeftPressed) break block16;
                    popup.setLocation(x, y - popup.getHeight());
                    break block17;
                }
                if (!this.isRightPressed) break block17;
                popup.setLocation(x + this.screen.getWidth() - popup.getWidth() - 1, y - popup.getHeight());
                break block17;
            }
            Popup li_Popup = (Popup)this.activePopups.lastElement();
            for (int i = 0; i < li_Popup.items.size(); ++i) {
                PopupItem popupItem = (PopupItem)li_Popup.items.elementAt(i);
                if (popupItem.isEmpty() || popupItem.subPopup == null || !popupItem.subPopup.equals(popup)) continue;
                int h1 = li_Popup.y + (i * li_Popup.itemHeight - li_Popup.yOffset);
                popup.setTouchOrientation(this.screen.isPointerEvents);
                popup.defineSize(this.screen.getHeight() - height);
                int popupLocationX = 0;
                if (this.isLeftPressed) {
                    popupLocationX = li_Popup.x + li_Popup.width / popupOverlayDividor;
                    if (popupLocationX + popup.width > this.screen.getWidth() && li_Popup.x + li_Popup.width / popupOverlayDividor - popup.width < 0) {
                        popupLocationX = this.screen.getWidth() - popup.width;
                    } else if (popupLocationX + popup.width > this.screen.getWidth()) {
                        popupLocationX = li_Popup.x - popup.width;
                    }
                } else if (this.isRightPressed) {
                    popupLocationX = li_Popup.x - popup.getWidth() + (li_Popup.width - li_Popup.width / popupOverlayDividor);
                    if (popupLocationX < 0 && popupLocationX + popup.width > this.screen.getWidth()) {
                        popupLocationX = 0;
                    } else if (popupLocationX < 0) {
                        popupLocationX = li_Popup.x - li_Popup.width / popupOverlayDividor;
                    } else if (popupLocationX + popup.width > this.screen.getWidth()) {
                        popupLocationX = li_Popup.x - li_Popup.width / popupOverlayDividor;
                    }
                }
                if (h1 + popup.height > y && h1 > this.screen.getHeight() / 2 - height) {
                    if (h1 < popup.height) {
                        popup.setLocation(popupLocationX, this.screen.getHeight() - height - popup.height);
                        continue;
                    }
                    popup.setLocation(popupLocationX, h1 - popup.height + popup.itemHeight);
                    continue;
                }
                if (this.screen.getHeight() - height - h1 < popup.height) {
                    popup.setLocation(popupLocationX, this.screen.getHeight() - height - popup.height);
                    continue;
                }
                popup.setLocation(popupLocationX, h1);
            }
        }
        popup.soft = this;
        this.activePopups.addElement(popup);
    }
}

