/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.images.ImageGroup;
import com.tomclaw.images.Splitter;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.tcuilite.Window;
import java.util.Hashtable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Screen
extends Canvas {
    public static final int KEY_CODE_LEFT_MENU = 1000001;
    public static final int KEY_CODE_RIGHT_MENU = 1000002;
    public static final int KEY_CODE_BACK_BUTTON = 1000003;
    public static final int KEY_CODE_UNKNOWN = 1000004;
    public static final int REPAINT_STATE_PLAIN = 0;
    public static final int REPAINT_STATE_SMILE = 1;
    public static final int REPAINT_STATE_WAITING = 255;
    public static final String waitGroupPath = "/res/wait_group_img.png";
    public static final int waitGroupHash = "/res/wait_group_img.png".hashCode();
    public Window activeWindow = null;
    public Window t_nextWindow = null;
    public static Screen screen = null;
    public MIDlet midlet = null;
    public static Runtime runtime;
    public TextBox textBox;
    public Field field = null;
    public long startTime = 0L;
    public int mSecDelay = 200;
    public boolean d_isForvard = false;
    private boolean isWaitScreenState = false;
    public Hashtable hotkeys = new Hashtable();
    public boolean isPointerKinetic = false;
    public int actionSpeedX = 0;
    public int actionSpeedY = 0;
    public long prevTime = 0L;
    private Thread thread = null;
    public boolean isPointerEvents = false;
    public int prevTouchX = -1;
    public int prevTouchY = -1;
    public int touchDelta = 10;
    public boolean isDragAccepted = false;
    public boolean isSwitchMode = false;
    public boolean isSlideMode = false;
    public boolean isSlideAwaiting = false;
    public boolean isSlideRight = false;
    public boolean isSlideLeft = false;
    public int x_pointStart = 0;
    public int x_pointValue = 0;
    public int slideStep = 15;
    public boolean isDirectScroll = false;
    public int repaintState = 0;
    public Image wait;
    public static Graphics lGraphics;
    public Image lCache;
    public Image rCache;
    public long lastActivity;
    private int waitIndex;
    private Thread waitThread;
    private long waitRepaintTime;
    private ImageGroup waitGroup;
    private int waitDelay = 100;

    public Screen(MIDlet midlet) {
        this.midlet = midlet;
        screen = this;
        runtime = Runtime.getRuntime();
        this.isPointerEvents = this.hasPointerEvents();
        Theme.scrollWidth = this.isPointerEvents ? 15 : 5;
        this.setFullScreenMode(true);
        this.textBox = new TextBox("title", "text", 1024, 0);
        this.textBox.addCommand(new Command("OK", 4, 1));
        this.textBox.addCommand(new Command("Cancel", 3, 1));
        this.textBox.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == 4) {
                    Screen.this.getField().setCaption(Screen.this.textBox.getString());
                } else if (c.getCommandType() == 3) {
                    // empty if block
                }
                screen.showGraph();
                Screen.screen.textBox.setString("");
                Screen.screen.field = null;
            }
        });
        this.waitGroup = Splitter.splitImage(waitGroupPath, false);
        this.updateLastActivity();
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public void showTemp() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.textBox);
    }

    public void showGraph() {
        this.setFullScreenMode(true);
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
    }

    public void setActiveWindow(Window window) {
        this.startTime = 0L;
        this.d_isForvard = !this.d_isForvard;
        this.isSwitchMode = true;
        this.t_nextWindow = window;
        this.t_nextWindow.prepareGraphics();
        this.repaint();
    }

    public void setWaitScreenState(boolean isWaitScreenState) {
        if (this.isWaitScreenState != isWaitScreenState) {
            this.isWaitScreenState = isWaitScreenState;
            if (isWaitScreenState) {
                this.waitIndex = 0;
                this.waitRepaintTime = 0L;
                this.waitThread = new Thread(){

                    public void run() {
                        while (Screen.this.isWaitScreenState) {
                            Screen.this.repaint();
                            try {
                                2.sleep(Screen.this.waitDelay);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                };
                this.waitThread.setPriority(1);
                this.waitThread.start();
            } else {
                try {
                    this.waitThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.repaint();
        }
    }

    public boolean getWaitScreenState() {
        return this.isWaitScreenState;
    }

    public void paint(Graphics g) {
        try {
            if (this.lCache == null || this.lCache.getWidth() != this.getWidth() || this.lCache.getHeight() != this.getHeight()) {
                this.lCache = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                lGraphics = this.lCache.getGraphics();
            }
            if (this.isWaitScreenState) {
                if (System.currentTimeMillis() - this.waitRepaintTime >= 100L) {
                    g.drawImage(this.lCache, 0, 0, 20);
                    Splitter.drawImage(g, waitGroupHash, this.waitIndex, (this.getWidth() - this.waitGroup.size) / 2, this.getHeight() / 2, true);
                    ++this.waitIndex;
                    if (this.waitIndex == this.waitGroup.getCount()) {
                        this.waitIndex = 0;
                    }
                    this.waitRepaintTime = System.currentTimeMillis();
                }
                return;
            }
            if (this.repaintState == 1) {
                this.repaintState = 0;
                if (this.activeWindow.directDraw_background != null) {
                    this.activeWindow.directDraw_background.paint(g);
                }
                this.activeWindow.paint(lGraphics);
                g.drawImage(this.lCache, 0, 0, 20);
                if (this.activeWindow.directDraw_afterAll != null) {
                    this.activeWindow.directDraw_afterAll.paint(g);
                }
                return;
            }
            if (this.isSwitchMode) {
                if (this.activeWindow != null && Settings.SCREEN_SHOW_ANIMATION) {
                    int percent;
                    long time = System.currentTimeMillis();
                    if (this.startTime == 0L) {
                        this.startTime = time;
                    }
                    if ((percent = 100 - (int)(100L * (time - this.startTime) / (long)this.mSecDelay)) > 100 || percent < 0) {
                        this.switchWindow(lGraphics);
                        return;
                    }
                    if (this.d_isForvard) {
                        this.t_nextWindow.paint(lGraphics, screen.getWidth() * (this.d_isForvard ? 100 - percent : percent) / 100 - screen.getWidth(), 0, true);
                        this.activeWindow.paint(lGraphics, screen.getWidth() * (this.d_isForvard ? 100 - percent : percent) / 100, 0, true);
                    } else {
                        this.activeWindow.paint(lGraphics, screen.getWidth() * (this.d_isForvard ? 100 - percent : percent) / 100 - screen.getWidth(), 0, true);
                        this.t_nextWindow.paint(lGraphics, screen.getWidth() * (this.d_isForvard ? 100 - percent : percent) / 100, 0, true);
                    }
                } else {
                    this.switchWindow(null);
                    return;
                }
                g.drawImage(this.lCache, 0, 0, 20);
                this.repaint();
            } else if (this.isSlideMode) {
                if (this.x_pointValue == 0 || this.x_pointStart == 0) {
                    return;
                }
                if (this.x_pointStart - this.x_pointValue > 0 && this.activeWindow.s_nextWindow != null || this.x_pointStart - this.x_pointValue < 0 && this.activeWindow.s_prevWindow != null) {
                    if (this.x_pointStart - this.x_pointValue > 0 && (this.lCache == null || this.rCache == null) || this.isSlideLeft && this.x_pointStart - this.x_pointValue > 0) {
                        this.rCache = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                        this.activeWindow.paint(this.lCache.getGraphics());
                        this.activeWindow.s_nextWindow.paint(this.rCache.getGraphics());
                        this.isSlideRight = true;
                        this.isSlideLeft = false;
                    } else if (this.x_pointStart - this.x_pointValue < 0 && (this.lCache == null || this.rCache == null) || this.isSlideRight && this.x_pointStart - this.x_pointValue < 0) {
                        this.rCache = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                        this.activeWindow.s_prevWindow.paint(this.rCache.getGraphics());
                        this.activeWindow.paint(this.lCache.getGraphics());
                        this.isSlideRight = false;
                        this.isSlideLeft = true;
                    }
                    if (this.x_pointStart - this.x_pointValue >= this.getWidth()) {
                        this.activeWindow = this.activeWindow.s_nextWindow;
                        this.t_nextWindow = null;
                        this.isSlideMode = false;
                        this.rCache = null;
                        this.isSlideLeft = false;
                        this.isSlideRight = false;
                        this.activeWindow.windowActivated();
                        this.repaint();
                        return;
                    }
                    if (this.x_pointValue - this.x_pointStart >= this.getWidth()) {
                        this.activeWindow = this.activeWindow.s_prevWindow;
                        this.t_nextWindow = null;
                        this.isSlideMode = false;
                        this.rCache = null;
                        this.isSlideLeft = false;
                        this.isSlideRight = false;
                        this.activeWindow.windowActivated();
                        this.repaint();
                        return;
                    }
                    g.drawImage(this.x_pointStart - this.x_pointValue > 0 ? this.rCache : this.lCache, this.x_pointValue - this.x_pointStart + (this.x_pointStart - this.x_pointValue > 0 ? this.getWidth() : 0), 0, 20);
                    g.drawImage(this.x_pointStart - this.x_pointValue > 0 ? this.lCache : this.rCache, this.x_pointValue - this.x_pointStart - (this.x_pointStart - this.x_pointValue > 0 ? 0 : this.getWidth()), 0, 20);
                }
            } else if (this.activeWindow != null) {
                if (this.activeWindow.directDraw_background != null) {
                    this.activeWindow.directDraw_background.paint(g);
                }
                this.activeWindow.paint(lGraphics);
                g.drawImage(this.lCache, 0, 0, 20);
                if (this.activeWindow.dialog != null) {
                    if (Settings.DIALOG_SHOW_ANIMATION) {
                        if (this.activeWindow.isShowingDialog) {
                            this.activeWindow.dialog.yOffset = this.getHeight() - (int)((long)this.getHeight() * (System.currentTimeMillis() - this.activeWindow.startTime) / (long)this.activeWindow.mSecDelay);
                            if (this.activeWindow.dialog.yOffset <= 0) {
                                this.activeWindow.dialog.yOffset = 0;
                                this.activeWindow.dialog.paint(g);
                                g.setClip(0, 0, this.getWidth(), this.getHeight());
                                if (this.activeWindow.directDraw_afterAll != null) {
                                    this.activeWindow.directDraw_afterAll.paint(g);
                                }
                                return;
                            }
                        } else {
                            this.activeWindow.dialog.yOffset = 0 - (int)((long)this.getHeight() * (System.currentTimeMillis() - this.activeWindow.startTime) / (long)this.activeWindow.mSecDelay);
                            if (this.activeWindow.dialog.yOffset <= -this.getHeight() / 2 - this.activeWindow.dialog.height) {
                                this.activeWindow.dialog = null;
                            }
                        }
                    }
                    if (this.activeWindow.dialog != null) {
                        this.activeWindow.dialog.paint(g);
                        g.setClip(0, 0, this.getWidth(), this.getHeight());
                        if (this.activeWindow.directDraw_afterAll != null) {
                            this.activeWindow.directDraw_afterAll.paint(g);
                        }
                    }
                    if (!Settings.DIALOG_SHOW_ANIMATION) {
                        return;
                    }
                    this.repaint();
                } else if (this.activeWindow.directDraw_afterAll != null) {
                    this.activeWindow.directDraw_afterAll.paint(g);
                }
            }
        }
        catch (Throwable ex) {
            System.out.println("Screen: paint - " + ex.getMessage());
        }
    }

    public void switchWindow(Graphics g) {
        this.activeWindow = this.t_nextWindow;
        this.t_nextWindow = null;
        this.isSwitchMode = false;
        if (g != null) {
            this.activeWindow.paint(g, 0, 0, true);
        }
        this.activeWindow.windowActivated();
        this.repaint();
    }

    protected void keyPressed(int keyCode) {
        this.updateLastActivity();
        try {
            if (this.isWaitScreenState) {
                return;
            }
            if (Screen.getExtGameAct(keyCode) == 1000003 && this.activeWindow != null) {
                if (this.activeWindow.soft.isLeftPressed || this.activeWindow.soft.isRightPressed) {
                    this.activeWindow.soft.setLeftSoftPressed(false);
                    this.activeWindow.soft.setRightSoftPressed(false);
                } else if (this.activeWindow.s_prevWindow != null) {
                    this.setActiveWindow(this.activeWindow.s_prevWindow);
                }
                return;
            }
            if (this.hotkeys.containsKey(Integer.toString(keyCode)) && this.activeWindow != null && !this.activeWindow.soft.isLeftPressed && !this.activeWindow.soft.isRightPressed) {
                ((Runnable)this.hotkeys.get(Integer.toString(keyCode))).run();
            }
            this.activeWindow.keyPressed(keyCode);
            screen.repaint();
        }
        catch (Throwable ex) {
            System.out.println("Screen: keyPressed - " + ex.getMessage());
        }
    }

    protected void keyReleased(int keyCode) {
        this.updateLastActivity();
        try {
            if (this.isWaitScreenState) {
                return;
            }
            this.activeWindow.keyReleased(keyCode);
            screen.repaint();
        }
        catch (Throwable ex) {
            System.out.println("Screen: keyReleased - " + ex.getMessage());
        }
    }

    protected void keyRepeated(int keyCode) {
        this.updateLastActivity();
        try {
            if (this.isWaitScreenState) {
                return;
            }
            this.activeWindow.keyRepeated(keyCode);
            screen.repaint();
        }
        catch (Throwable ex) {
            System.out.println("Screen: keyRepeated - " + ex.getMessage());
        }
    }

    protected void pointerDragged(int x, int y) {
        this.updateLastActivity();
        try {
            if (this.isWaitScreenState) {
                return;
            }
            if (!(Math.abs(this.prevTouchX - x) <= this.touchDelta && Math.abs(this.prevTouchY - y) <= this.touchDelta || this.isSlideMode)) {
                if (Math.abs(this.prevTouchY - y) > this.slideStep) {
                    this.isSlideAwaiting = false;
                }
                if (this.isDirectScroll || Math.abs(this.prevTouchX - x) == 0 || Math.abs(this.prevTouchY - y) * 100 / Math.abs(this.prevTouchX - x) > 40) {
                    this.isDragAccepted = true;
                    this.activeWindow.pointerDragged(x, y);
                } else if (this.isSlideAwaiting) {
                    this.isSlideMode = true;
                    this.isDragAccepted = false;
                    this.x_pointStart = x;
                }
            } else if (this.isSlideMode) {
                this.x_pointValue = x;
            }
            screen.repaint();
        }
        catch (Throwable ex) {
            System.out.println("Screen: pointerDragged - " + ex.getMessage());
        }
    }

    protected void pointerPressed(int x, int y) {
        this.updateLastActivity();
        try {
            if (this.isWaitScreenState) {
                return;
            }
            this.isPointerKinetic = false;
            this.isSlideMode = false;
            this.isDirectScroll = false;
            this.isSlideLeft = false;
            this.isSlideRight = false;
            this.rCache = null;
            this.x_pointStart = 0;
            this.x_pointValue = 0;
            this.actionSpeedY = 0;
            this.actionSpeedX = 0;
            this.prevTime = System.currentTimeMillis();
            this.prevTouchX = x;
            this.prevTouchY = y;
            this.isSlideAwaiting = true;
            if (this.thread != null) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            this.activeWindow.pointerPressed(x, y);
            screen.repaint();
        }
        catch (Throwable ex) {
            System.out.println("Screen: pointerPressed - " + ex.getMessage());
        }
    }

    protected void pointerReleased(final int x, final int y) {
        this.updateLastActivity();
        try {
            if (this.isWaitScreenState) {
                return;
            }
            if (System.currentTimeMillis() != this.prevTime) {
                this.actionSpeedX = (int)((long)(1000 * (x - this.prevTouchX)) / (System.currentTimeMillis() - this.prevTime));
                this.actionSpeedY = (int)((long)(1000 * (y - this.prevTouchY)) / (System.currentTimeMillis() - this.prevTime));
            }
            if (!this.isSlideMode && !this.isDragAccepted) {
                if (this.isSlideMode) {
                    new Thread(){

                        public void run() {
                            Screen.this.autoSlide();
                        }
                    }.start();
                } else {
                    this.activeWindow.pointerReleased(x, y);
                    screen.repaint();
                }
                return;
            }
            if (Math.abs(this.actionSpeedX) > 100 || Math.abs(this.actionSpeedY) > 100) {
                this.isPointerKinetic = true;
                this.thread = new Thread(){

                    public void run() {
                        int x1 = x;
                        int y1 = y;
                        long time = System.currentTimeMillis();
                        while (Screen.this.isPointerKinetic && (Math.abs(Screen.this.actionSpeedX) > 100 || Math.abs(Screen.this.actionSpeedY) > 100)) {
                            if (Math.abs(Screen.this.actionSpeedX) > 100 && System.currentTimeMillis() != time) {
                                x1 = (int)((long)x1 + (long)Screen.this.actionSpeedX / (1000L / (System.currentTimeMillis() - time)));
                                Screen.this.actionSpeedX -= 10 * Screen.this.actionSpeedX / Math.abs(Screen.this.actionSpeedX);
                            }
                            if (Math.abs(Screen.this.actionSpeedY) > 100 && System.currentTimeMillis() != time) {
                                y1 = (int)((long)y1 + (long)Screen.this.actionSpeedY / (1000L / (System.currentTimeMillis() - time)));
                                Screen.this.actionSpeedY -= 10 * Screen.this.actionSpeedY / Math.abs(Screen.this.actionSpeedY);
                            }
                            time = System.currentTimeMillis();
                            if (Screen.this.isSlideMode) {
                                Screen.this.x_pointValue = x1;
                                screen.repaint();
                            } else {
                                if (Screen.this.x_pointValue != 0) {
                                    Screen.this.isPointerKinetic = false;
                                    return;
                                }
                                if (!Screen.this.activeWindow.pointerDragged(x1, y1)) {
                                    screen.repaint();
                                    break;
                                }
                            }
                            screen.repaint();
                            try {
                                4.sleep(10L);
                            }
                            catch (InterruptedException ex) {}
                        }
                        if (Screen.this.isSlideMode) {
                            Screen.this.autoSlide();
                            return;
                        }
                        Screen.this.isPointerKinetic = false;
                        Screen.this.activeWindow.pointerReleased(x1, y1);
                    }
                };
                this.thread.start();
            } else if (this.isSlideMode) {
                new Thread(){

                    public void run() {
                        Screen.this.autoSlide();
                    }
                }.start();
            } else {
                this.activeWindow.pointerReleased(x, y);
            }
            screen.repaint();
        }
        catch (Throwable ex) {
            System.out.println("Screen: pointerReleased - " + ex.getMessage());
        }
    }

    public void autoSlide() {
        boolean isSlideForward;
        int cycleFinl;
        int cycleStart;
        boolean directionLeft;
        int increment = this.getWidth() / 60;
        boolean bl = directionLeft = this.x_pointValue < this.x_pointStart;
        if (Math.abs(this.x_pointValue - this.x_pointStart) > this.getWidth() / 2) {
            cycleStart = directionLeft ? 0 : this.x_pointValue - this.x_pointStart;
            cycleFinl = directionLeft ? this.getWidth() - (this.x_pointStart - this.x_pointValue) : this.getWidth();
            isSlideForward = true;
        } else {
            cycleStart = directionLeft ? this.x_pointValue : this.x_pointStart;
            cycleFinl = directionLeft ? this.x_pointStart : this.x_pointValue;
            isSlideForward = false;
        }
        for (int c = cycleStart; c <= cycleFinl; c += increment) {
            this.x_pointValue = isSlideForward ? (directionLeft ? cycleFinl - c - (this.getWidth() - this.x_pointStart) : c + this.x_pointStart) : (directionLeft ? c : cycleStart + cycleFinl - c);
            screen.repaint();
            ++increment;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (isSlideForward && this.isSlideMode) {
            if (directionLeft && this.activeWindow.s_nextWindow != null) {
                this.activeWindow = this.activeWindow.s_nextWindow;
            } else if (this.activeWindow.s_prevWindow != null) {
                this.activeWindow = this.activeWindow.s_prevWindow;
            }
            this.t_nextWindow = null;
        }
        this.isSlideMode = false;
        this.rCache = null;
        this.isSlideLeft = false;
        this.isSlideRight = false;
        this.activeWindow.windowActivated();
        this.repaint();
    }

    public static int getExtGameAct(int keyCode) {
        try {
            int gameAct = screen.getGameAction(keyCode);
            switch (gameAct) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    return gameAct;
                }
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        try {
            String strCode = screen.getKeyName(keyCode).toLowerCase();
            if ("soft1".equals(strCode) || "soft 1".equals(strCode) || "soft_1".equals(strCode) || "softkey 1".equals(strCode) || "sk2(left)".equals(strCode) || strCode.startsWith("left soft")) {
                return 1000001;
            }
            if ("soft2".equals(strCode) || "soft 2".equals(strCode) || "soft_2".equals(strCode) || "softkey 4".equals(strCode) || "sk1(right)".equals(strCode) || strCode.startsWith("right soft")) {
                return 1000002;
            }
            if ("on/off".equals(strCode) || "back".equals(strCode)) {
                return 1000003;
            }
            if ("trackball".equals(strCode) || "enter".equals(strCode)) {
                return 8;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        switch (keyCode) {
            case -202: 
            case -21: 
            case -6: 
            case 21: 
            case 105: 
            case 113: 
            case 57345: {
                return 1000001;
            }
            case -203: 
            case -22: 
            case -7: 
            case 22: 
            case 106: 
            case 112: 
            case 57346: {
                return 1000002;
            }
            case -11: {
                return 1000003;
            }
        }
        try {
            int gameAct = screen.getGameAction(keyCode);
            if (gameAct > 0) {
                return gameAct;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1000004;
    }

    public static boolean isNumPadKey(int keyCode) {
        return keyCode >= 48 && keyCode <= 57 || keyCode == 42 || keyCode == 35;
    }

    public void repaint(int repaintState) {
        if (repaintState == 1 && this.repaintState == 0) {
            this.repaintState = repaintState;
            this.repaint();
        } else if (repaintState == 0) {
            this.repaint();
        }
    }

    private void updateLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }
}

