/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.RadioGroup;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Radio
extends PaneObject {
    public String caption = "";
    private String[] strings = new String[0];
    private static Image radioOffImg;
    private static Image radioOnImg;
    public boolean radioState = false;
    public boolean cancelledState = false;
    public int radioIndex = -1;
    public RadioGroup radioGroup = null;
    public boolean wasPressedAction = false;
    public static int foreColor;
    public static int actOuterLight;
    public static int actInnerLight;
    public int interlineheight = 2;

    public Radio(String caption, boolean state) {
        this.caption = caption;
        this.radioState = state;
        this.loadRadioImages();
    }

    private void loadRadioImages() {
        try {
            radioOffImg = Image.createImage((String)Settings.RADIO_OFF_IMAGE);
            radioOnImg = Image.createImage((String)Settings.RADIO_ON_IMAGE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void repaint(Graphics g) {
        if (this.isFocusable && this.isFocused) {
            g.setColor(actOuterLight);
            g.drawRect(this.x, this.y, this.width, this.height);
            g.setColor(actInnerLight);
            g.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
        }
        g.setFont(Theme.font);
        g.setColor(foreColor);
        g.drawImage(this.radioState ? radioOnImg : radioOffImg, this.x + Theme.upSize, this.y + this.height / 2, 6);
        for (int c = 0; c < this.strings.length; ++c) {
            g.drawString(this.strings[c], this.x + 2 + Theme.upSize + (radioOffImg.getWidth() + Theme.upSize), this.y + 2 + Theme.upSize + c * (Theme.font.getHeight() + this.interlineheight), 20);
        }
    }

    public void setSize(int width, int height) {
        if (this.width != width) {
            this.width = width;
            this.updateCaption();
        } else {
            this.width = width;
        }
        this.height = this.getHeight();
    }

    public int getHeight() {
        this.height = Theme.font.getHeight() + Theme.upSize * 2 + 4 + (this.strings.length - 1) * (Theme.font.getHeight() + this.interlineheight);
        return this.height;
    }

    public void keyPressed(int keyCode) {
        this.wasPressedAction = true;
    }

    public void keyReleased(int keyCode) {
        if (Screen.getExtGameAct(keyCode) == 8 && this.wasPressedAction) {
            this.radioGroup.setCombed(this);
            this.actionPerformed();
        }
        this.wasPressedAction = false;
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        this.cancelledState = false;
    }

    public void pointerReleased(int x, int y) {
        if (!this.cancelledState) {
            this.radioGroup.setCombed(this);
            this.actionPerformed();
        }
    }

    public void pointerDragged(int x, int y) {
        this.cancelledState = true;
    }

    public final void setCaption(String text) {
        this.caption = text;
        this.updateCaption();
    }

    public void updateCaption() {
        this.strings = StringUtil.wrapText(this.caption, this.width - (Theme.upSize + 4) * 2 - (radioOffImg.getWidth() + Theme.upSize), Theme.font);
    }

    public void setRadioGroup(RadioGroup radioGroup) {
        this.radioGroup = radioGroup;
    }

    public String getStringValue() {
        return this.radioState ? "true" : "false";
    }

    static {
        foreColor = 0x555555;
        actOuterLight = 12437503;
        actInnerLight = 9214719;
    }
}

