/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.PaneEvent;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Scroll;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.smiles.Smiles;
import com.tomclaw.utils.LogUtil;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Pane
extends Scroll {
    public Vector items = new Vector();
    private PaneObject paneObject;
    private int startIndex = 0;
    private int finlIndex = 0;
    public PaneObject actionObject;
    public Thread animationThread = null;
    private int focusedIndex = -1;
    public int psvLstFocusedIndex = -1;
    public PaneEvent actionPerformedEvent = null;
    public boolean isSelectedState = false;
    public static int backColor = 0xFFFFFF;
    private int yLocation = 0;
    public int moveStep = Theme.font.getHeight();

    public Pane(final Window window, boolean isAnimated) {
        this.repaintScrollWidth = Theme.scrollWidth;
        if (isAnimated && Smiles.smilesType == 0) {
            this.animationThread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(100L);
                                if (Screen.screen.activeWindow == null || !Screen.screen.activeWindow.equals(window) || Screen.screen.isSwitchMode || Screen.screen.isSlideMode || Screen.screen.activeWindow.soft.isLeftPressed || Screen.screen.activeWindow.soft.isRightPressed || Screen.screen.activeWindow.dialog != null || Pane.this.prevYDrag != -1) continue;
                                Screen.screen.repaint(1);
                            }
                        }
                        catch (InterruptedException ex) {
                            LogUtil.outMessage("Pane animation exception", true);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.animationThread.setPriority(1);
            this.animationThread.start();
        }
    }

    public void repaint(Graphics g) {
        this.repaint(g, 0, 0);
    }

    public void repaint(Graphics g, int paintX, int paintY) {
        g.setFont(Theme.font);
        g.setColor(backColor);
        g.fillRect(paintX + this.x, paintY + this.y, this.width, this.height);
        this.startIndex = -1;
        this.finlIndex = -1;
        this.yLocation = 0;
        for (int c = 0; c < this.items.size(); ++c) {
            this.paneObject = (PaneObject)this.items.elementAt(c);
            if (!this.paneObject.getVisible()) continue;
            this.paneObject.setSize(this.width - Theme.scrollWidth - 2, this.paneObject.getHeight());
            this.paneObject.setLocation(paintX + this.x, paintY + this.y + this.yLocation - this.yOffset);
            if (this.focusedIndex >= 0) {
                if (c == this.focusedIndex && this.paneObject.getFocusable()) {
                    this.paneObject.setFocused(true);
                    this.psvLstFocusedIndex = c;
                    this.focusedIndex = -2;
                } else {
                    this.paneObject.setFocused(false);
                }
            } else if (this.focusedIndex == -2) {
                this.paneObject.setFocused(false);
            } else if (this.focusedIndex == -1) {
                if (this.paneObject.getFocused() && this.paneObject.getFocusable()) {
                    this.focusedIndex = c;
                    this.psvLstFocusedIndex = c;
                } else {
                    this.paneObject.setFocused(false);
                }
            }
            if (paintY + this.y + this.yLocation + this.paneObject.getHeight() - this.yOffset > 0 && this.yLocation - this.yOffset < this.height) {
                if (this.startIndex == -1) {
                    this.startIndex = c;
                }
                this.paneObject.repaint(g);
            } else if (this.startIndex >= 0 && this.finlIndex == -1) {
                this.finlIndex = c;
            }
            this.yLocation += this.paneObject.getHeight() + 1;
        }
        this.focusedIndex = -1;
        this.totalHeight = this.yLocation;
        if (this.finlIndex == -1) {
            this.finlIndex = this.items.size() - 1;
        }
        super.repaint(g, paintX, paintY);
    }

    public void keyPressed(int keyCode) {
        if (this.items.isEmpty() && Screen.getExtGameAct(keyCode) != 8 && this.actionPerformedEvent != null) {
            return;
        }
        if (Screen.getExtGameAct(keyCode) == 1) {
            this.focusUp();
        } else if (Screen.getExtGameAct(keyCode) == 6) {
            this.focusDown();
        } else {
            this.paneObject = !this.items.isEmpty() ? this.getFocusedPaneObject() : null;
            if (Screen.getExtGameAct(keyCode) == 8 && this.actionPerformedEvent != null) {
                this.actionPerformedEvent.actionPerformed(this.paneObject);
            }
            if (this.paneObject != null) {
                this.paneObject.keyPressed(keyCode);
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (this.items.isEmpty()) {
            return;
        }
        if (Screen.getExtGameAct(keyCode) != 1 && Screen.getExtGameAct(keyCode) != 6) {
            this.paneObject = this.getFocusedPaneObject();
            if (this.paneObject != null) {
                this.paneObject.keyReleased(keyCode);
            }
        }
    }

    public void keyRepeated(int keyCode) {
        if (this.items.isEmpty()) {
            return;
        }
        if (Screen.getExtGameAct(keyCode) == 1) {
            this.focusUp();
        } else if (Screen.getExtGameAct(keyCode) == 6) {
            this.focusDown();
        } else {
            this.paneObject = this.getFocusedPaneObject();
            if (this.paneObject != null) {
                this.paneObject.keyRepeated(keyCode);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.actionObject = null;
        if (!this.items.isEmpty()) {
            if (x < this.x || y < this.y || x > this.x + this.width || y > this.y + this.height) {
                return;
            }
            if (x > this.x + this.width - Theme.scrollWidth) {
                this.isScrollAction = true;
            } else {
                this.isScrollAction = false;
                this.actionObject = this.getFocusedPaneObject(x, y);
                if (this.actionObject != null) {
                    this.actionObject.pointerPressed(x, y);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.items.isEmpty()) {
            if (this.actionPerformedEvent != null) {
                this.actionPerformedEvent.actionPerformed(this.actionObject);
            }
            return;
        }
        if (this.prevYDrag == -1 && this.isSelectedState && this.actionPerformedEvent != null) {
            this.actionPerformedEvent.actionPerformed(this.actionObject);
        }
        this.isSelectedState = true;
        this.prevYDrag = -1;
        if (this.actionObject != null) {
            this.actionObject.pointerReleased(x, y);
            this.actionObject = null;
        }
    }

    public boolean pointerDragged(int x, int y) {
        if (this.actionObject != null) {
            this.actionObject.pointerDragged(x, y);
            this.actionObject = null;
        }
        if (this.items.isEmpty() || this.totalHeight < this.height) {
            return false;
        }
        if (this.isScrollAction) {
            this.scrollStart = y - this.y - this.scrollHeight / 2;
            this.yOffset = this.scrollStart * this.totalHeight / this.height;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.totalHeight - this.height) {
                this.yOffset = this.totalHeight - this.height;
            } else {
                return true;
            }
            return false;
        }
        if (this.totalHeight > this.height) {
            if (this.prevYDrag == -1) {
                this.prevYDrag = this.yOffset + y;
                return true;
            }
            this.yOffset = this.prevYDrag - y;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.totalHeight - this.height) {
                this.yOffset = this.totalHeight - this.height;
            } else {
                return true;
            }
            return false;
        }
        return true;
    }

    public void focusDown() {
        if (this.items.isEmpty()) {
            return;
        }
        int t_FocusedIndex = -1;
        for (int c = 0; c <= this.finlIndex; ++c) {
            this.paneObject = (PaneObject)this.items.elementAt(c);
            if (!this.paneObject.getFocusable() || !this.paneObject.getVisible()) continue;
            if (this.paneObject.getFocused()) {
                t_FocusedIndex = c;
                continue;
            }
            if (t_FocusedIndex == -1) continue;
            if (c < this.startIndex || c > this.finlIndex || c == this.finlIndex && this.paneObject.getY() > this.y + this.height) break;
            this.paneObject.setFocused(true);
            if (this.paneObject.getY() + this.paneObject.getHeight() > this.y + this.height) {
                this.yOffset -= this.y - this.paneObject.getY() + (this.paneObject.getHeight() > this.height ? 0 : this.height - this.paneObject.getHeight() - 1);
            }
            this.paneObject = (PaneObject)this.items.elementAt(t_FocusedIndex);
            this.paneObject.setFocused(false);
            this.paneObject = null;
            break;
        }
        if (this.paneObject != null && this.totalHeight > this.height) {
            this.yOffset += this.totalHeight - this.height - this.yOffset > this.moveStep ? this.moveStep : this.totalHeight - this.height - this.yOffset;
            if (this.yOffset > this.totalHeight - this.height) {
                this.yOffset = this.totalHeight - this.height;
            }
        }
    }

    public void focusUp() {
        if (this.items.isEmpty()) {
            return;
        }
        int t_FocusedIndex = -1;
        for (int c = this.items.size() - 1; c >= this.startIndex; --c) {
            this.paneObject = (PaneObject)this.items.elementAt(c);
            if (!this.paneObject.getFocusable() || !this.paneObject.getVisible()) continue;
            if (this.paneObject.getFocused()) {
                t_FocusedIndex = c;
                continue;
            }
            if (t_FocusedIndex == -1) continue;
            if (c < this.startIndex || c > this.finlIndex) break;
            this.paneObject.setFocused(true);
            if (this.paneObject.getY() - this.y < 0) {
                this.yOffset -= this.y - this.paneObject.getY() + (this.paneObject.getHeight() > this.height ? this.height - this.paneObject.getHeight() - 1 : 0);
            }
            this.paneObject = (PaneObject)this.items.elementAt(t_FocusedIndex);
            this.paneObject.setFocused(false);
            this.paneObject = null;
            break;
        }
        if (this.paneObject != null && this.totalHeight > this.height) {
            this.yOffset -= this.yOffset > this.moveStep ? this.moveStep : this.yOffset;
        }
    }

    public PaneObject getFocusedPaneObject() {
        for (int c = this.startIndex; c <= this.finlIndex && c < this.items.size(); ++c) {
            this.paneObject = (PaneObject)this.items.elementAt(c);
            if (!this.paneObject.getFocusable() || !this.paneObject.getVisible() || !this.paneObject.getFocused()) continue;
            return this.paneObject;
        }
        return null;
    }

    public PaneObject getFocusedPaneObject(int x, int y) {
        for (int c = this.startIndex; c <= this.finlIndex; ++c) {
            this.paneObject = (PaneObject)this.items.elementAt(c);
            if (!this.paneObject.getFocusable() || !this.paneObject.getVisible() || this.paneObject.getX() > x || this.paneObject.getX() + this.paneObject.getWidth() < x || this.paneObject.getY() > y || this.paneObject.getY() + this.paneObject.getHeight() < y) continue;
            if (!this.paneObject.getFocused()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    if (i == c) continue;
                    this.paneObject = (PaneObject)this.items.elementAt(i);
                    this.paneObject.setFocused(false);
                }
                this.isSelectedState = false;
            }
            this.paneObject = (PaneObject)this.items.elementAt(c);
            if (!this.paneObject.getFocused()) {
                this.paneObject.setFocused(true);
            }
            return this.paneObject;
        }
        return null;
    }

    public void addItem(PaneObject paneObject) {
        this.items.addElement(paneObject);
    }

    public void setFocused(int focusedIndex) {
        this.focusedIndex = focusedIndex;
    }

    public int getFocused() {
        return this.focusedIndex;
    }
}

