/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.images.Splitter;
import com.tomclaw.tcuilite.GroupChild;
import com.tomclaw.tcuilite.GroupEvent;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.tcuilite.GroupRmsRenderer;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Scroll;
import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.DrawUtil;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Group
extends Scroll {
    public RecordStore recordStore;
    public GroupRmsRenderer groupRmsRenderer = null;
    public Vector items = new Vector();
    public int selectedRow = 0;
    public int selectedColumn = 0;
    static Image _plus;
    static Image minus;
    public int columnCount = 1;
    public int minWeight = -3;
    public int maxWeight = 0;
    public boolean isShowGroups = true;
    public boolean isHideEmptyGroups = false;
    public int startIndex = 0;
    public int finlIndex = 0;
    private int lineCounter = 0;
    private int columnMarker = 0;
    public int totalItemsCount = 0;
    public boolean isPointerAction = false;
    private GroupChild tempGroupChild;
    private GroupHeader tempGroupHeader;
    public int selectedRealGroup = -1;
    public int selectedRealIndex = -1;
    public GroupEvent actionPerformedEvent = null;
    private boolean retryRepaint = false;
    public boolean isSelectedState = false;
    public static int foreColor;
    public static int foreSelColor;
    public static int backColor;
    public static int hrLine;
    public static int selectedGradFrom;
    public static int selectedGradTo;
    public static int selectedUpOutline;
    public static int selectedBottomOutline;
    public int itemHeight;
    public int imageOffset = 0;
    public int[] imageLeftFileHash;
    public int[] imageRightFileHash;

    public Group() {
        this.loadGroupImages();
        this.repaintScrollWidth = Theme.scrollWidth;
    }

    public Group(String fileName) {
        this();
        this.openRecordStore(fileName);
    }

    private void loadGroupImages() {
        try {
            _plus = Image.createImage((String)Settings.GROUP_PLUS_IMAGE);
            minus = Image.createImage((String)Settings.GROUP_MINUS_IMAGE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addHeader(GroupHeader groupHeader) {
        this.items.addElement(groupHeader);
    }

    public void repaint(Graphics g) {
        this.repaint(g, 0, 0);
    }

    public void repaint(Graphics g, int paintX, int paintY) {
        this.itemHeight = Theme.font.getHeight() + Theme.upSize * 2;
        g.setColor(backColor);
        g.fillRect(paintX + this.x, paintY + this.y, this.width - Theme.scrollWidth, this.height);
        this.startIndex = this.yOffset / this.itemHeight;
        this.finlIndex = this.startIndex + this.height / this.itemHeight;
        this.lineCounter = -1;
        int t_childsCount = 0;
        if (this.isShowGroups) {
            for (int c = 0; c < this.items.size(); ++c) {
                this.tempGroupHeader = this.getElement(c);
                t_childsCount = this.tempGroupHeader.getChildsCount();
                if (this.tempGroupHeader.isGroupVisible && (!this.isHideEmptyGroups || t_childsCount != 0)) {
                    this.drawItem(g, paintX, paintY, this.tempGroupHeader.title, null, null, true, this.tempGroupHeader.isCollapsed, c, -1, -1, -1, false);
                }
                this.tempGroupHeader.row = this.lineCounter;
                this.tempGroupHeader.column = this.columnMarker;
                if (this.tempGroupHeader.isCollapsed && this.tempGroupHeader.isGroupVisible || !this.tempGroupHeader.isItemsVisible || t_childsCount <= 0) continue;
                int pseudoRealIndex = 0;
                for (int w = this.minWeight; w <= this.maxWeight; ++w) {
                    for (int i = 0; i < t_childsCount; ++i) {
                        this.tempGroupChild = (GroupChild)this.tempGroupHeader.childs.elementAt(i);
                        if (this.tempGroupChild.weight != w) continue;
                        this.drawItem(g, paintX, paintY, this.tempGroupChild.title, this.tempGroupChild.imageLeftIndex, this.tempGroupChild.imageRightIndex, false, false, c, pseudoRealIndex, i, t_childsCount, this.tempGroupChild.isBold);
                        ++pseudoRealIndex;
                    }
                }
            }
        } else {
            int pseudoRealIndex = 0;
            for (int w = this.minWeight; w <= this.maxWeight; ++w) {
                for (int c = 0; c < this.items.size(); ++c) {
                    this.tempGroupHeader = this.getElement(c);
                    if (!this.tempGroupHeader.isItemsVisible) continue;
                    t_childsCount += this.tempGroupHeader.getChildsCount();
                    for (int i = 0; i < this.tempGroupHeader.getChildsCount(); ++i) {
                        this.tempGroupChild = (GroupChild)this.tempGroupHeader.childs.elementAt(i);
                        if (this.tempGroupChild.weight != w) continue;
                        this.drawItem(g, paintX, paintY, this.tempGroupChild.title, this.tempGroupChild.imageLeftIndex, this.tempGroupChild.imageRightIndex, false, false, c, pseudoRealIndex, i, t_childsCount, this.tempGroupChild.isBold);
                        ++pseudoRealIndex;
                    }
                }
            }
        }
        this.totalItemsCount = this.lineCounter + 1;
        this.totalHeight = this.totalItemsCount * this.itemHeight;
        super.repaint(g, paintX, paintY);
        if (this.selectedRow >= this.totalItemsCount) {
            this.selectedRow = this.totalItemsCount - 1;
            this.retryRepaint = true;
        }
        if (this.yOffset != 0 && this.totalItemsCount * this.itemHeight - this.yOffset < this.height) {
            this.yOffset = this.totalItemsCount * this.itemHeight > this.height ? this.totalItemsCount * this.itemHeight - this.height : 0;
            this.retryRepaint = true;
        }
        if (this.retryRepaint) {
            this.retryRepaint = false;
            this.repaint(g, paintX, paintY);
        }
    }

    public void drawItem(Graphics g, int paintX, int paintY, String title, int[] imageLeftIndex, int[] imageRightIndex, boolean isHeader, boolean isCollapsed, int realGroup, int realIndex, int sequenceIndex, int groupItemsCount, boolean isBold) {
        int objX;
        if (!isBold) {
            g.setFont(Theme.font);
        } else {
            g.setFont(Theme.titleFont);
        }
        int objWidth = realIndex == -1 || this.columnCount == 1 || groupItemsCount - 1 == realIndex && realIndex - this.columnCount * (realIndex / this.columnCount) + 1 < this.columnCount ? this.width - 2 - Theme.scrollWidth : (this.width - 2 - Theme.scrollWidth) / this.columnCount;
        if (realIndex % this.columnCount == 0 || realIndex == -1 || this.columnCount == 1) {
            objX = paintX + this.x;
            ++this.lineCounter;
        } else {
            objX = paintX + this.x + objWidth * (realIndex - this.columnCount * (realIndex / this.columnCount)) + 1;
        }
        this.columnMarker = realIndex - this.columnCount * (realIndex / this.columnCount);
        int objY = paintY + this.y + this.lineCounter * this.itemHeight - this.yOffset;
        if (objY + this.itemHeight >= 0 && objY - (paintY + this.y) < this.height) {
            int c;
            g.setColor(hrLine);
            g.drawLine(paintX + this.x, objY + this.itemHeight, paintX + this.x + this.width, objY + this.itemHeight);
            if (this.lineCounter == this.selectedRow && (this.columnMarker == this.selectedColumn || isHeader || groupItemsCount - 1 == realIndex && this.columnMarker + 1 < this.columnCount)) {
                this.selectedRealGroup = realGroup;
                this.selectedRealIndex = sequenceIndex;
                DrawUtil.fillVerticalGradient(g, objX, objY, objWidth + 1, this.itemHeight, selectedGradFrom, selectedGradTo);
                g.setColor(selectedUpOutline);
                g.drawLine(objX, objY, objX + objWidth, objY);
                g.setColor(selectedBottomOutline);
                g.drawLine(objX, objY + this.itemHeight, objX + objWidth, objY + this.itemHeight);
                g.setColor(foreSelColor);
            } else {
                g.setColor(backColor);
                g.fillRect(objX, objY + 1, objWidth, this.itemHeight - 1);
                g.setColor(foreColor);
            }
            this.imageOffset = 0;
            if (this.imageLeftFileHash != null && this.imageLeftFileHash.length > 0 && imageLeftIndex != null && imageLeftIndex.length > 0) {
                for (c = 0; c < this.imageLeftFileHash.length && c < imageLeftIndex.length; ++c) {
                    if (imageLeftIndex[c] == -1) continue;
                    this.imageOffset += Splitter.drawImage(g, this.imageLeftFileHash[c], imageLeftIndex[c], objX + Theme.upSize + 1 + this.imageOffset, objY + 1 + this.itemHeight / 2, true);
                    if (this.imageOffset <= 0) continue;
                    ++this.imageOffset;
                }
                if (this.imageOffset > 0) {
                    this.imageOffset += Theme.upSize;
                }
            }
            g.drawString(title, objX + Theme.upSize + 1 + (isHeader ? _plus.getWidth() + Theme.upSize : 0) + this.imageOffset, objY + 1 + (this.itemHeight - Theme.font.getHeight()) / 2, 20);
            if (isHeader) {
                g.drawImage(isCollapsed ? _plus : minus, objX + Theme.upSize + 1, objY + 1 + (this.itemHeight - _plus.getHeight()) / 2, 20);
            }
            this.imageOffset = 0;
            if (this.imageRightFileHash != null && this.imageRightFileHash.length > 0 && imageRightIndex != null && imageRightIndex.length > 0) {
                for (c = 0; c < this.imageRightFileHash.length && c < imageRightIndex.length; ++c) {
                    if (imageRightIndex[c] == -1) continue;
                    if (this.imageOffset == 0) {
                        this.imageOffset = Splitter.getImageGroup((int)this.imageRightFileHash[c]).size;
                    }
                    this.imageOffset += Splitter.drawImage(g, this.imageRightFileHash[c], imageRightIndex[c], objX + objWidth - 1 - this.imageOffset, objY + 1 + this.itemHeight / 2, true);
                    if (this.imageOffset <= 0) continue;
                    ++this.imageOffset;
                }
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.isPointerAction = false;
        if (this.items.isEmpty()) {
            return;
        }
        if (Screen.getExtGameAct(keyCode) == 1) {
            --this.selectedRow;
            if (this.selectedRow < 0) {
                this.selectedRow = this.totalItemsCount - 1;
                if (this.totalItemsCount * this.itemHeight > this.height) {
                    this.yOffset = this.totalItemsCount * this.itemHeight - this.height;
                }
                return;
            }
            if (this.selectedRow - 1 < this.startIndex) {
                this.yOffset = this.selectedRow * this.itemHeight;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 6) {
            ++this.selectedRow;
            if (this.selectedRow >= this.totalItemsCount) {
                this.selectedRow = 0;
                this.yOffset = 0;
                return;
            }
            if (this.selectedRow >= this.finlIndex) {
                this.yOffset = (this.selectedRow + 1) * this.itemHeight - this.height;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 2) {
            --this.selectedColumn;
            if (this.selectedColumn < 0) {
                this.selectedColumn = this.columnCount - 1;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 5) {
            ++this.selectedColumn;
            if (this.selectedColumn >= this.columnCount) {
                this.selectedColumn = 0;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 8 && this.selectedRealGroup != -1) {
            this.tempGroupHeader = this.getElement(this.selectedRealGroup);
            if (this.selectedRealIndex != -1) {
                this.tempGroupChild = (GroupChild)this.tempGroupHeader.childs.elementAt(this.selectedRealIndex);
                if (this.actionPerformedEvent != null) {
                    this.actionPerformedEvent.actionPerformed(this.tempGroupChild);
                }
                this.tempGroupChild.actionPerformed();
            } else {
                this.tempGroupHeader.isCollapsed = !this.tempGroupHeader.isCollapsed;
                this.tempGroupHeader.actionPerformed();
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void pointerPressed(int x, int y) {
        this.isPointerAction = true;
        if (this.items.isEmpty()) {
            return;
        }
        if (x < this.x || y < this.y || x > this.x + this.width || y > this.y + this.height) {
            return;
        }
        if (x > this.x + this.width - Theme.scrollWidth) {
            this.isScrollAction = true;
            return;
        }
        this.isScrollAction = false;
        if (this.isSelectedState && this.selectedRealGroup != -1) {
            if (this.selectedRow == (this.yOffset + y - this.y) / this.itemHeight && this.selectedColumn == this.columnCount * x / (this.width - Theme.scrollWidth)) {
                this.tempGroupHeader = this.getElement(this.selectedRealGroup);
                if (this.selectedRealIndex != -1) {
                    this.tempGroupChild = (GroupChild)this.tempGroupHeader.childs.elementAt(this.selectedRealIndex);
                    if (this.actionPerformedEvent != null) {
                        this.actionPerformedEvent.actionPerformed(this.tempGroupChild);
                    }
                    this.tempGroupChild.actionPerformed();
                } else {
                    this.tempGroupHeader.isCollapsed = !this.tempGroupHeader.isCollapsed;
                    this.tempGroupHeader.actionPerformed();
                }
                return;
            }
            this.isSelectedState = false;
        }
        this.selectedRow = (this.yOffset + y - this.y) / this.itemHeight;
        this.selectedColumn = this.columnCount * x / (this.width - Theme.scrollWidth);
        this.isSelectedState = true;
    }

    public void pointerReleased(int x, int y) {
        this.prevYDrag = -1;
    }

    public boolean pointerDragged(int x, int y) {
        if (this.items.isEmpty()) {
            return false;
        }
        if (this.isScrollAction) {
            this.scrollStart = y - this.y - this.scrollHeight / 2;
            this.yOffset = this.scrollStart * (this.totalItemsCount * this.itemHeight) / this.height;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.totalItemsCount * this.itemHeight - this.height) {
                this.yOffset = this.totalItemsCount * this.itemHeight - this.height;
            } else {
                return true;
            }
            return false;
        }
        if (this.totalItemsCount * this.itemHeight > this.height) {
            if (this.prevYDrag == -1) {
                this.prevYDrag = this.yOffset + y;
                return true;
            }
            this.yOffset = this.prevYDrag - y;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.totalItemsCount * this.itemHeight - this.height) {
                this.yOffset = this.totalItemsCount * this.itemHeight - this.height;
            } else {
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean openRecordStore(String fileName) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)fileName, (boolean)false);
            this.items.setSize(this.recordStore.getNumRecords());
            return true;
        }
        catch (RecordStoreException ex) {
            this.recordStore = null;
            return false;
        }
    }

    public GroupHeader getElement(int index) {
        if (this.items.elementAt(index) != null) {
            return (GroupHeader)this.items.elementAt(index);
        }
        if (this.recordStore != null) {
            try {
                byte[] abyte0 = this.recordStore.getRecord(index + 1);
                GroupHeader groupHeader = this.groupRmsRenderer.getRmsGroupHeader(abyte0);
                this.items.setElementAt(groupHeader, index);
                return groupHeader;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        foreColor = 0x555555;
        foreSelColor = 0x555555;
        backColor = 0xFFFFFF;
        hrLine = 0xDDDDDD;
        selectedGradFrom = 0xDDDDFF;
        selectedGradTo = 0xBBAAEE;
        selectedUpOutline = 0xCCCCEE;
        selectedBottomOutline = 0xAAAACC;
    }
}

