/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.StringUtil;
import javax.microedition.lcdui.Graphics;

public class Field
extends PaneObject {
    public String caption = "";
    public String title = "";
    public int maxSize = 1024;
    public int constraints = 0;
    private String[] strings = new String[0];
    private boolean cancelledState = false;
    public static int foreColor = 0x555555;
    public static int backColor = 0xF5F5FF;
    public static int borderColor = 13944301;
    public static int actOuterLight = 12437503;
    public static int actInnerLight = 9214719;
    public int interlineheight = 2;

    public Field(String caption) {
        this.caption = caption;
    }

    public void repaint(Graphics g) {
        g.setColor(borderColor);
        g.drawRect(this.x + 2, this.y + 2, this.width - 4, this.height - 4);
        g.setColor(backColor);
        g.fillRect(this.x + 3, this.y + 3, this.width - 5, this.height - 5);
        if (this.isFocusable && this.isFocused) {
            g.setColor(actOuterLight);
            g.drawRect(this.x, this.y, this.width, this.height);
            g.setColor(actInnerLight);
            g.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
        }
        g.setFont(Theme.font);
        g.setColor(foreColor);
        for (int c = 0; c < this.strings.length; ++c) {
            g.drawString(this.strings[c], this.x + 2 + Theme.upSize, this.y + 2 + Theme.upSize + c * (Theme.font.getHeight() + this.interlineheight), 20);
        }
    }

    public void setSize(int width, int height) {
        if (this.width != width) {
            this.width = width;
            this.updateCaption();
        } else {
            this.width = width;
        }
        this.height = this.getHeight();
    }

    public void keyPressed(int keyCode) {
        if (Screen.getExtGameAct(keyCode) == 8) {
            this.showInputDialog();
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void showInputDialog() {
        Screen.screen.textBox.setTitle(this.title);
        Screen.screen.textBox.setMaxSize(this.maxSize);
        Screen.screen.textBox.setConstraints(this.constraints == 65536 ? 0 : this.constraints);
        Screen.screen.textBox.setString(this.caption);
        Screen.screen.setField(this);
        Screen.screen.showTemp();
        this.actionPerformed();
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        this.cancelledState = false;
    }

    public void pointerReleased(int x, int y) {
        if (!this.cancelledState) {
            this.showInputDialog();
        }
    }

    public void pointerDragged(int x, int y) {
        this.cancelledState = true;
    }

    public int getHeight() {
        this.height = Theme.font.getHeight() + Theme.upSize * 2 + 4 + (this.strings.length - 1) * (Theme.font.getHeight() + this.interlineheight);
        return this.height;
    }

    public final void setCaption(String text) {
        this.caption = text;
        this.updateCaption();
    }

    public void updateCaption() {
        this.strings = StringUtil.wrapText(this.caption, this.width - (Theme.upSize + 4) * 2, Theme.font, this.constraints == 65536);
    }

    public void setText(String caption) {
        this.caption = caption;
        this.updateCaption();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setConstraints(int constraints) {
        this.constraints = constraints;
    }

    public String getText() {
        return this.caption;
    }

    public String getTitle() {
        return this.title;
    }

    public int getmaxSize() {
        return this.maxSize;
    }

    public int getConstraints() {
        return this.constraints;
    }

    public String getStringValue() {
        return this.caption;
    }
}

