/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.DrawUtil;
import com.tomclaw.utils.StringUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Dialog {
    public String message;
    public int x;
    public int y;
    public int width;
    public int height;
    public int yOffset = 0;
    public int textOffset = 0;
    public Graphics imageGraphics;
    public String title;
    private String[] strings = new String[0];
    public int startY = -1;
    public int clipX;
    public int clipY;
    public int clipW;
    public int clipH;
    public Soft soft;
    public Screen screen;
    public static int titleColor = 0xDEDFDE;
    public static int textColor = 0xFFFFFF;
    public static int alphaBackColor = 657930;
    public static int plainBackColor = 0x292C29;
    public static int hrLineColor = 0;
    public static int hrLineShadow = 0x393839;
    public static int shadowColor = 657930;
    public static final int alphaBackIndex = -603979776;
    public static final int shadowIndex = Integer.MIN_VALUE;
    public static final int shadowSize = 10;
    public static final int interlineheight = 2;
    private int boldFontHeight;
    private int textFontHeight;
    private static Image shadowCorner;
    private Image shadowHorizontal;
    private Image shadowVertical;
    private Image back;

    public Dialog(Screen screen, Soft soft, String title, String message) {
        this.screen = screen;
        this.soft = soft;
        this.title = title;
        this.message = message;
        this.updateFontSize();
        this.initImageGraphics(screen.getWidth(), screen.getHeight());
    }

    public void paint(Graphics g) {
        if (this.screen != null && this.soft != null) {
            if (Soft.getWidth() != this.screen.getWidth()) {
                this.soft.setLocation(0, this.screen.getHeight() - this.soft.getHeight());
                this.soft.setSize(this.screen.getWidth(), this.soft.getHeight());
            }
            this.soft.paint(g, 0, 0);
        }
        if (Settings.DIALOG_DRAW_ALPHABACK && this.checkCache()) {
            g.drawImage(shadowCorner, this.x - 10, this.y - 10 + this.yOffset, 20);
            g.drawRegion(shadowCorner, 0, 0, 10, 10, 2, this.x + this.width, this.y - 10 + this.yOffset, 20);
            g.drawRegion(shadowCorner, 0, 0, 10, 10, 7, this.x + this.width, this.y + this.height + this.yOffset, 20);
            g.drawRegion(shadowCorner, 0, 0, 10, 10, 1, this.x - 10, this.y + this.height + this.yOffset, 20);
            g.drawImage(this.shadowVertical, this.x - 10, this.y + this.yOffset, 20);
            g.drawImage(this.shadowHorizontal, this.x, this.y - 10 + this.yOffset, 20);
            g.drawRegion(this.shadowVertical, 0, 0, 10, this.height, 2, this.x + this.width, this.y + this.yOffset, 20);
            g.drawRegion(this.shadowHorizontal, 0, 0, this.width, 10, 1, this.x, this.y + this.height + this.yOffset, 20);
            g.drawImage(this.back, this.x, this.y + this.yOffset, 20);
        } else {
            g.setColor(plainBackColor);
            g.fillRect(this.x, this.y + this.yOffset, this.width, this.height);
        }
        g.setColor(hrLineColor);
        g.drawLine(this.x + Theme.upSize, this.y + this.yOffset + this.boldFontHeight + Theme.upSize * 2, this.x + this.width - Theme.upSize * 2, this.y + this.yOffset + this.boldFontHeight + Theme.upSize * 2);
        g.setColor(hrLineShadow);
        g.drawLine(this.x + Theme.upSize, this.y + this.yOffset + this.boldFontHeight + Theme.upSize * 2 + 1, this.x + this.width - Theme.upSize * 2, this.y + this.yOffset + this.boldFontHeight + Theme.upSize * 2 + 1);
        g.setColor(titleColor);
        g.setFont(Theme.titleFont);
        g.drawString(this.title, this.x + 2 + Theme.upSize, this.y + this.yOffset + Theme.upSize, 20);
        g.setFont(Theme.font);
        this.clipY = this.y + this.yOffset + (this.boldFontHeight + Theme.upSize * 2 + 1) + 2 + Theme.upSize;
        this.clipX = this.x + 2 + Theme.upSize;
        this.clipW = this.width;
        this.clipH = this.height - Theme.upSize - this.clipY + this.y + this.yOffset;
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
        g.setColor(textColor);
        for (int c = this.textOffset / (this.textFontHeight + 2); c < Math.min(this.strings.length, (this.textOffset + this.clipH) / (this.textFontHeight + 2) + 1); ++c) {
            g.drawString(this.strings[c], this.x + 2 + Theme.upSize, this.clipY - this.textOffset + c * (this.textFontHeight + 2), 20);
        }
    }

    public void updateFontSize() {
        this.boldFontHeight = Theme.titleFont.getHeight();
        this.textFontHeight = Theme.font.getHeight();
    }

    public final void initImageGraphics(int width, int height) {
        this.width = width * 4 / 5;
        this.strings = StringUtil.wrapText(this.message, this.width - Theme.upSize * 2 - 4, Theme.titleFont);
        this.height = height * 4 / 5 < this.strings.length * this.textFontHeight ? height * 4 / 5 : this.textFontHeight + Theme.upSize * 2 + 4 + (this.strings.length - 1) * (this.textFontHeight + 2) + (this.boldFontHeight + Theme.upSize * 2 + 1);
        if (Settings.DIALOG_DRAW_ALPHABACK) {
            if (shadowCorner == null) {
                shadowCorner = DrawUtil.drawCornerShadow(shadowColor | Integer.MIN_VALUE, 10, 10, 0);
            }
            this.shadowVertical = DrawUtil.drawShadow(shadowColor | Integer.MIN_VALUE, 10, this.height, 0);
            this.shadowHorizontal = DrawUtil.drawShadow(shadowColor | Integer.MIN_VALUE, this.width, 10, 1);
            this.back = DrawUtil.fillShadow(alphaBackColor | 0xDC000000, this.width, this.height);
        }
        this.x = width / 2 - this.width + this.width / 2;
        this.y = height / 2 - this.height / 2;
    }

    public void keyPressed(int keyCode) {
        if (Screen.getExtGameAct(keyCode) == 1) {
            this.textOffset -= this.textFontHeight;
            this.correctTextOffset();
        } else if (Screen.getExtGameAct(keyCode) == 6) {
            this.textOffset += this.textFontHeight;
            this.correctTextOffset();
        } else if (Screen.getExtGameAct(keyCode) == 1000001) {
            if (this.soft != null && this.soft.leftSoft != null) {
                this.soft.leftSoft.actionPerformed();
            }
        } else if (Screen.getExtGameAct(keyCode) == 1000002 && this.soft != null && this.soft.rightSoft != null) {
            this.soft.rightSoft.actionPerformed();
        }
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        if (x > this.clipX && x < this.clipX + this.clipW && y > this.clipY && y < this.clipY + this.clipH) {
            this.startY = this.textOffset + y;
        } else if (this.soft != null && x >= Soft.getX() && y >= Soft.getY() && x < Soft.getX() + Soft.getWidth() && y < Soft.getY() + this.soft.getHeight()) {
            if (x <= Soft.getX() + Soft.getWidth() / 2) {
                this.soft.leftSoft.actionPerformed();
            } else {
                this.soft.rightSoft.actionPerformed();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        this.startY = -1;
        this.correctTextOffset();
    }

    public boolean pointerDragged(int x, int y) {
        if (this.startY != -1) {
            this.textOffset = this.startY - y;
            return this.correctTextOffset();
        }
        return false;
    }

    public boolean correctTextOffset() {
        if (this.textOffset < 0) {
            this.textOffset = 0;
            return false;
        }
        if (this.textOffset > this.strings.length * (this.textFontHeight + 2) - (this.height - Theme.upSize * 2 - (this.boldFontHeight + Theme.upSize * 2 + 1) - 2)) {
            this.textOffset = this.strings.length * (this.textFontHeight + 2) - (this.height - Theme.upSize * 2 - (this.boldFontHeight + Theme.upSize * 2 + 1) - 2);
            return false;
        }
        return true;
    }

    public static void clearCache() {
        shadowCorner = null;
    }

    private boolean checkCache() {
        return shadowCorner != null && this.shadowVertical != null && this.shadowHorizontal != null && this.back != null;
    }
}

