/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Stack;

public class XmlWriter {
    private OutputStream writer;
    private ByteArrayOutputStream baos;
    private Stack tags;
    boolean inside_tag;

    public XmlWriter(OutputStream out) throws UnsupportedEncodingException {
        this.writer = new DataOutputStream(out);
        this.baos = new ByteArrayOutputStream();
        this.tags = new Stack();
        this.inside_tag = false;
    }

    public void close() {
        try {
            this.writer.close();
            this.baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() throws IOException {
        if (this.inside_tag) {
            this.baos.write(62);
            this.inside_tag = false;
        }
        this.baos.flush();
        this.writer.write(this.baos.toByteArray());
        MidletMain.incrementDataCount(this.baos.size());
        this.baos.reset();
        this.writer.flush();
    }

    public void writeDirect(byte[] data) throws IOException {
        this.writer.write(data);
        this.writer.flush();
        MidletMain.incrementDataCount(data.length);
    }

    public void startTag(String tag) throws IOException {
        if (this.inside_tag) {
            this.baos.write(62);
        }
        this.baos.write(60);
        this.baos.write(tag.getBytes());
        this.tags.push(tag);
        this.inside_tag = true;
    }

    public void attribute(String atr, String value) throws IOException {
        if (value == null) {
            return;
        }
        this.baos.write(32);
        this.baos.write(atr.getBytes());
        this.baos.write("='".getBytes());
        this.writeEscaped(value);
        this.baos.write(39);
    }

    public void endTag() throws IOException {
        try {
            String tagname = (String)this.tags.pop();
            if (this.inside_tag) {
                this.baos.write("/>".getBytes());
                this.inside_tag = false;
            } else {
                this.baos.write("</".getBytes());
                this.baos.write(tagname.getBytes());
                this.baos.write(62);
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void text(String str) throws IOException {
        if (this.inside_tag) {
            this.baos.write(62);
            this.inside_tag = false;
        }
        this.writeEscaped(str);
    }

    private void writeEscaped(String str) throws IOException {
        this.baos.write(XmlWriter.encodeUTF(StringUtil.toXmlWellFormed(str)));
    }

    public static byte[] encodeUTF(String str) {
        LogUtil.outMessage("Encoding UTF");
        byte[] encoded = StringUtil.stringToByteArray(str, true);
        LogUtil.outMessage("UTF encoded");
        return encoded;
    }
}

