/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.main.InfoFrame;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.Identity;
import com.tomclaw.mandarin.xmpp.ServiceGroup;
import com.tomclaw.mandarin.xmpp.ServiceItem;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Group;
import com.tomclaw.tcuilite.GroupChild;
import com.tomclaw.tcuilite.GroupEvent;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import java.util.Vector;

public class ServicesFrame
extends Window {
    private Pane hostChangePane;
    private Field hostField;
    private Group servicesGroup;
    private PopupItem servicesPopup;
    private PopupItem hostChangePopup;
    private XmppAccountRoot xmppAccountRoot;
    private String requestId = "";
    private Vector services;
    private ServiceItem parentService;
    private ServiceGroup tempItemsHeader;

    public ServicesFrame(final XmppAccountRoot accountRoot) {
        super(MidletMain.screen);
        this.xmppAccountRoot = accountRoot;
        this.header = new Header(Localization.getMessage("SERVICES_FRAME"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(ServicesFrame.this.s_prevWindow);
            }
        };
        this.servicesPopup = new PopupItem(Localization.getMessage("MENU"));
        this.servicesPopup.addSubItem(new PopupItem(Localization.getMessage("CHANGE_HOST")){

            public void actionPerformed() {
                ServicesFrame.this.soft.rightSoft = ServicesFrame.this.hostChangePopup;
                ServicesFrame.this.setGObject(ServicesFrame.this.hostChangePane);
                MidletMain.screen.repaint();
            }
        });
        this.servicesPopup.addSubItem(new PopupItem(Localization.getMessage("SERVICES_ROOT")){

            public void actionPerformed() {
                ServicesFrame.this.hostChangePopup.actionPerformed();
            }
        });
        this.servicesPopup.addSubItem(new PopupItem(Localization.getMessage("REFRESH")){

            public void actionPerformed() {
                ServicesFrame.this.requestItems();
            }
        });
        this.servicesPopup.addSubItem(new PopupItem(Localization.getMessage("SERVICE_INFO")){

            public void actionPerformed() {
                int c;
                ServiceItem serviceItem = ServicesFrame.this.getSelectedItem();
                String[] param = new String[]{"SERV_JID", "SERV_NAME", "SERV_NODE", "SERV_IDENT", "SERV_FEAT"};
                String[] value = new String[]{serviceItem.jid == null ? "" : serviceItem.jid, serviceItem.name == null ? "" : serviceItem.name, serviceItem.node == null ? "" : serviceItem.node, "", ""};
                if (serviceItem.identityes != null) {
                    for (c = 0; c < serviceItem.identityes.size(); ++c) {
                        Identity identity = (Identity)serviceItem.identityes.elementAt(c);
                        if (c > 0) {
                            value[3] = value[3] + "\n";
                        }
                        value[3] = value[3] + identity.name;
                    }
                }
                if (serviceItem.features != null) {
                    for (c = 0; c < serviceItem.features.size(); ++c) {
                        String feature = (String)serviceItem.features.elementAt(c);
                        if (c > 0) {
                            value[4] = value[4] + "\n";
                        }
                        value[4] = value[4] + feature;
                    }
                }
                InfoFrame infoFrame = new InfoFrame(param, value);
                infoFrame.s_prevWindow = ServicesFrame.this;
                MidletMain.screen.setActiveWindow(infoFrame);
            }
        });
        this.soft.rightSoft = this.hostChangePopup = new PopupItem(Localization.getMessage("SEARCH")){

            public void actionPerformed() {
                MidletMain.screen.setWaitScreenState(true);
                ServicesFrame.this.soft.rightSoft = ServicesFrame.this.servicesPopup;
                ServicesFrame.this.setGObject(ServicesFrame.this.servicesGroup);
                MidletMain.screen.repaint();
                ServicesFrame.this.parentService = new ServiceItem(ServicesFrame.this.hostField.getText(), null, ServicesFrame.this.hostField.getText());
                ServicesFrame.this.requestId = "srvfrm_host".concat(accountRoot.xmppSession.getId());
                XmppSender.queryingForInformation(accountRoot.xmppSession, ((ServicesFrame)ServicesFrame.this).parentService.jid, ServicesFrame.this.requestId);
            }
        };
        this.hostChangePane = new Pane(null, false);
        Label notifyLabel = new Label(Localization.getMessage("ACCOUNT_HOST").concat(":"));
        notifyLabel.setTitle(true);
        this.hostChangePane.addItem(notifyLabel);
        this.hostChangePane.addItem(new Label(accountRoot.host));
        notifyLabel = new Label(Localization.getMessage("SERVICES_HOST").concat(":"));
        notifyLabel.setTitle(true);
        this.hostChangePane.addItem(notifyLabel);
        this.hostField = new Field(accountRoot.domain);
        this.hostField.setFocusable(true);
        this.hostField.setFocused(true);
        this.hostField.title = Localization.getMessage("SERVICES_FRAME");
        this.hostChangePane.addItem(this.hostField);
        this.servicesGroup = new Group();
        this.servicesGroup.actionPerformedEvent = new GroupEvent(){

            public void actionPerformed(GroupChild gc) {
                if (((ServiceItem)gc).containsFeature("http://jabber.org/protocol/disco#items")) {
                    ServicesFrame.this.parentService = (ServiceItem)gc;
                    ServicesFrame.this.requestItems();
                } else {
                    Handler.showNotify(Localization.getMessage("ITEM_EMPTY"));
                }
            }
        };
        this.setGObject(this.hostChangePane);
        if (accountRoot.statusIndex == XmppStatusUtil.offlineIndex) {
            Handler.showFail(Localization.getMessage("NO_CONNECTION"));
        }
    }

    public void requestItems() {
        LogUtil.outMessage("Info support: " + this.parentService.containsFeature("http://jabber.org/protocol/disco#info"));
        if (this.parentService.containsFeature("http://jabber.org/protocol/disco#items")) {
            MidletMain.screen.setWaitScreenState(true);
            this.requestId = "srvfrm_items".concat(this.xmppAccountRoot.xmppSession.getId());
            XmppSender.requesingAllItems(this.xmppAccountRoot.xmppSession, this.parentService.jid, this.parentService.node, this.requestId);
            new Thread(){

                public void run() {
                    String id = ServicesFrame.this.requestId;
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MidletMain.screen.setWaitScreenState(false);
                    if (id.equals(ServicesFrame.this.requestId)) {
                        Handler.showNotify(Localization.getMessage("SOME_SERVICES_UNAVAILABLE"));
                    }
                }
            }.start();
        } else {
            Handler.showNotify(Localization.getMessage("ITEM_EMPTY"));
        }
    }

    public void setServicesList(XmppAccountRoot xmppAccountRoot, Vector services, String id) {
        if (xmppAccountRoot.equals(this.xmppAccountRoot) && id.equals(this.requestId)) {
            this.services = services;
            this.servicesGroup.items.removeAllElements();
            this.servicesGroup.yOffset = 0;
            this.tempItemsHeader = new ServiceGroup("unclassified", Localization.getMessage("UNCLASSIFIED"));
            this.tempItemsHeader.setChilds(services);
            this.servicesGroup.addHeader(this.tempItemsHeader);
            if (this.parentService.containsFeature("http://jabber.org/protocol/disco#info")) {
                LogUtil.outMessage("http://jabber.org/protocol/disco#info supported");
                for (int c = 0; c < services.size(); ++c) {
                    String qfiId = "srvfrm_info".concat(xmppAccountRoot.xmppSession.getId());
                    XmppSender.queryingForInformation(this.xmppAccountRoot.xmppSession, ((ServiceItem)services.elementAt((int)c)).jid, qfiId);
                }
            } else {
                LogUtil.outMessage("No http://jabber.org/protocol/disco#info supported");
                this.requestId = "";
                MidletMain.screen.setWaitScreenState(false);
            }
        }
    }

    public void setServiceInfo(XmppAccountRoot xmppAccountRoot, String from, String id, Vector identityes, Vector features) {
        if (xmppAccountRoot.equals(this.xmppAccountRoot)) {
            LogUtil.outMessage("Received service info");
            for (int c = 0; c < this.services.size(); ++c) {
                ServiceGroup serviceGroup;
                ServiceItem t_Service = (ServiceItem)this.services.elementAt(c);
                t_Service.identityes = identityes;
                t_Service.features = features;
                Identity identity = identityes.isEmpty() ? new Identity("unclassified", "unknown", "none") : (Identity)t_Service.identityes.firstElement();
                if (!t_Service.jid.equals(from)) continue;
                boolean isGroupFoundFlag = false;
                for (int i = 0; i < this.servicesGroup.items.size(); ++i) {
                    serviceGroup = (ServiceGroup)this.servicesGroup.items.elementAt(i);
                    if (!serviceGroup.category.equals(identity.category)) continue;
                    isGroupFoundFlag = true;
                    serviceGroup.addChild(t_Service);
                    break;
                }
                if (!isGroupFoundFlag) {
                    serviceGroup = new ServiceGroup(identity.category, identity.category);
                    serviceGroup.addChild(t_Service);
                    this.servicesGroup.addHeader(serviceGroup);
                }
                this.services.removeElementAt(c);
                break;
            }
            if (this.services.isEmpty()) {
                this.requestId = "";
                MidletMain.screen.setWaitScreenState(false);
            }
        }
    }

    public void setNoServiceInfo(XmppAccountRoot xmppAccountRoot, String from, String id) {
        if (xmppAccountRoot.equals(this.xmppAccountRoot)) {
            LogUtil.outMessage("Received NO service info");
            for (int c = 0; c < this.services.size(); ++c) {
                ServiceItem t_Service = (ServiceItem)this.services.elementAt(c);
                if (!t_Service.jid.equals(from)) continue;
                this.tempItemsHeader.addChild(t_Service);
                this.services.removeElementAt(c);
                break;
            }
            if (this.services.isEmpty()) {
                this.requestId = "";
                MidletMain.screen.setWaitScreenState(false);
            }
        }
    }

    public void setHostInfo(XmppAccountRoot xmppAccountRoot, String id, Vector identityes, Vector features) {
        if (this.xmppAccountRoot.equals(xmppAccountRoot) && id.equals(this.requestId)) {
            LogUtil.outMessage("Received host info, features: " + features.size() + " identityes: " + identityes.size());
            this.parentService.features = features;
            this.parentService.identityes = identityes;
            this.requestItems();
        }
    }

    public ServiceItem getSelectedItem() {
        try {
            if (this.servicesGroup.selectedRealGroup >= 0 && this.servicesGroup.selectedRealGroup < this.servicesGroup.items.size() && this.servicesGroup.selectedRealIndex >= 0 && this.servicesGroup.selectedRealIndex < ((ServiceGroup)this.servicesGroup.items.elementAt(this.servicesGroup.selectedRealGroup)).getChildsCount()) {
                return (ServiceItem)((ServiceGroup)this.servicesGroup.items.elementAt(this.servicesGroup.selectedRealGroup)).getChilds().elementAt(this.servicesGroup.selectedRealIndex);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }
}

