/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.main.ChatTab;
import com.tomclaw.mandarin.main.InfoFrame;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.Bookmark;
import com.tomclaw.mandarin.xmpp.BookmarkEditorFrame;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppGroup;
import com.tomclaw.mandarin.xmpp.XmppItem;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.ListEvent;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import java.io.IOException;
import java.util.Vector;

public class BookmarksFrame
extends Window {
    private XmppAccountRoot xmppAccountRoot;
    private List bookmarksList;
    private String requestId = "";
    private Bookmark bookmark;

    public BookmarksFrame(XmppAccountRoot xmppAccountRoot) {
        super(MidletMain.screen);
        this.xmppAccountRoot = xmppAccountRoot;
        this.header = new Header(Localization.getMessage("BOOKMARKS_FRAME"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(BookmarksFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("MENU"));
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("ADD_BOOKMARK")){

            public void actionPerformed() {
                BookmarkEditorFrame bookmarkEditorFrame = new BookmarkEditorFrame(null);
                bookmarkEditorFrame.s_prevWindow = BookmarksFrame.this;
                MidletMain.screen.setActiveWindow(bookmarkEditorFrame);
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("EDIT_BOOKMARK")){

            public void actionPerformed() {
                if (((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex != -1 && ((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex < ((BookmarksFrame)BookmarksFrame.this).bookmarksList.items.size()) {
                    Bookmark bookmark = (Bookmark)BookmarksFrame.this.bookmarksList.getElement(((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex);
                    BookmarkEditorFrame bookmarkEditorFrame = new BookmarkEditorFrame(bookmark);
                    bookmarkEditorFrame.s_prevWindow = BookmarksFrame.this;
                    MidletMain.screen.setActiveWindow(bookmarkEditorFrame);
                }
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("REMOVE_BOOKMARK")){

            public void actionPerformed() {
                if (((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex != -1 && ((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex < ((BookmarksFrame)BookmarksFrame.this).bookmarksList.items.size()) {
                    ((BookmarksFrame)BookmarksFrame.this).bookmarksList.items.removeElementAt(((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex);
                    BookmarksFrame.this.saveBookmarks();
                }
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("INFO_BOOKMARK")){

            public void actionPerformed() {
                if (((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex != -1 && ((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex < ((BookmarksFrame)BookmarksFrame.this).bookmarksList.items.size()) {
                    String[] value;
                    String[] param;
                    Bookmark bookmark = (Bookmark)BookmarksFrame.this.bookmarksList.getElement(((BookmarksFrame)BookmarksFrame.this).bookmarksList.selectedIndex);
                    if (bookmark.password != null) {
                        param = new String[]{"BKMRK_JID", "BKMRK_NAME", "BKMRK_NICK", "BKMRK_PASSWORD", "BKMRK_MINIMIZE", "BKMRK_AUTOJOIN"};
                        value = new String[]{bookmark.jid, bookmark.name, bookmark.nick, bookmark.password, bookmark.minimize ? Localization.getMessage("TRUE") : Localization.getMessage("FALSE"), bookmark.autojoin ? Localization.getMessage("TRUE") : Localization.getMessage("FALSE")};
                    } else {
                        param = new String[]{"BKMRK_JID", "BKMRK_NAME", "BKMRK_NICK", "BKMRK_MINIMIZE", "BKMRK_AUTOJOIN"};
                        value = new String[]{bookmark.jid, bookmark.name, bookmark.nick, bookmark.minimize ? Localization.getMessage("TRUE") : Localization.getMessage("FALSE"), bookmark.autojoin ? Localization.getMessage("TRUE") : Localization.getMessage("FALSE")};
                    }
                    InfoFrame infoFrame = new InfoFrame(param, value);
                    infoFrame.s_prevWindow = BookmarksFrame.this;
                    MidletMain.screen.setActiveWindow(infoFrame);
                }
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("JOIN_BOOKMARK")){

            public void actionPerformed() {
                BookmarksFrame.this.joinBookmark();
            }
        });
        this.bookmarksList = new List();
        this.bookmarksList.listEvent = new ListEvent(){

            public void actionPerformed(ListItem li) {
                BookmarksFrame.this.joinBookmark();
            }
        };
        this.setGObject(this.bookmarksList);
        this.requestBookmarks();
    }

    public void joinBookmark() {
        if (this.bookmarksList.selectedIndex != -1 && this.bookmarksList.selectedIndex < this.bookmarksList.items.size()) {
            this.bookmark = (Bookmark)this.bookmarksList.getElement(this.bookmarksList.selectedIndex);
            MidletMain.screen.setWaitScreenState(true);
            this.requestId = "groupchat_join_".concat(this.xmppAccountRoot.xmppSession.getId());
            try {
                XmppSender.joinConfrence(this.xmppAccountRoot.xmppSession, this.requestId, this.bookmark.jid, this.bookmark.nick, this.bookmark.password);
            }
            catch (IOException ex) {
                LogUtil.outMessage("Error while conference join: " + ex.getMessage());
                Handler.showError(Localization.getMessage("IO_EXCEPTION"));
            }
        }
    }

    public final void requestBookmarks() {
        MidletMain.screen.setWaitScreenState(true);
        new Thread(){

            public void run() {
                String id = BookmarksFrame.this.requestId;
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MidletMain.screen.setWaitScreenState(false);
                if (id.equals(BookmarksFrame.this.requestId)) {
                    Handler.showError(Localization.getMessage("NO_RESPONSE"));
                }
            }
        }.start();
        this.requestId = "bookmrksfrm_get".concat(this.xmppAccountRoot.xmppSession.getId());
        XmppSender.requesBookmarks(this.xmppAccountRoot.xmppSession, this.requestId);
        this.bookmark = null;
    }

    public void setBookmarkStatus(XmppAccountRoot xmppAccountRoot, String jid) {
        if (this.bookmark != null && xmppAccountRoot.equals(xmppAccountRoot) && jid.equals(this.bookmark.jid)) {
            if (xmppAccountRoot.conferenceGroup == null || !xmppAccountRoot.getBuddyItems().contains(xmppAccountRoot.conferenceGroup)) {
                xmppAccountRoot.conferenceGroup = new XmppGroup(Localization.getMessage("CONFERENCE_GROUP"));
                xmppAccountRoot.getBuddyItems().addElement(xmppAccountRoot.conferenceGroup);
            }
            XmppItem conferenceItem = new XmppItem(this.bookmark.jid, this.bookmark.name);
            conferenceItem.isGroupChat = true;
            conferenceItem.getResource("");
            conferenceItem.updateUiData();
            conferenceItem.groupChatNick = this.bookmark.nick;
            ChatTab chatTab = MidletMain.chatFrame.getChatTab(xmppAccountRoot, this.bookmark.jid, "");
            if (chatTab != null) {
                chatTab.buddyItem = conferenceItem;
                chatTab.resource = conferenceItem.getResource("");
                chatTab.updateChatCaption();
            }
            xmppAccountRoot.removeBuddyItem(conferenceItem.userId);
            xmppAccountRoot.conferenceGroup.addChild(conferenceItem);
            xmppAccountRoot.xmppSession.roster.put(conferenceItem.userId, conferenceItem);
            xmppAccountRoot.updateMainFrameUI();
            MidletMain.screen.setWaitScreenState(false);
            this.bookmark = null;
            MidletMain.screen.setActiveWindow(this.s_prevWindow);
        }
    }

    public void setBookmarkError(XmppAccountRoot xmppAccountRoot, String id, String errorText, int errorId) {
        if (xmppAccountRoot.equals(this.xmppAccountRoot) && id.equals(this.requestId)) {
            MidletMain.screen.setWaitScreenState(false);
            switch (errorId) {
                case 1: {
                    Handler.showError(Localization.getMessage(errorText));
                    this.bookmark = null;
                }
            }
        }
    }

    public void setBookmarks(XmppAccountRoot xmppAccountRoot, String id, Vector bookmarks) {
        LogUtil.outMessage("setBookmarks");
        if (this.xmppAccountRoot.equals(xmppAccountRoot) && this.requestId.equals(id)) {
            if (bookmarks != null) {
                this.bookmarksList.items = bookmarks;
                this.bookmarksList.yOffset = 0;
                this.bookmarksList.selectedIndex = 0;
            }
            this.requestId = "";
            MidletMain.screen.setWaitScreenState(false);
        }
    }

    public void removeBookmark(Bookmark bookmark) {
        this.bookmarksList.items.removeElement(bookmark);
        MidletMain.screen.repaint();
    }

    public void setBookmark(Bookmark bookmark) {
        if (!this.bookmarksList.items.contains(bookmark)) {
            this.bookmarksList.addItem(bookmark);
        }
        MidletMain.screen.repaint();
    }

    public void saveBookmarks() {
        MidletMain.screen.setWaitScreenState(true);
        this.requestId = "bookmrksfrm_set".concat(this.xmppAccountRoot.xmppSession.getId());
        XmppSender.sendBookmarks(this.xmppAccountRoot.xmppSession, this.requestId, this.bookmarksList.items);
    }
}

