/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.mmp;

import com.tomclaw.mandarin.core.BuddyInfo;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.mmp.MmpAccountRoot;
import com.tomclaw.mandarin.mmp.MmpGroup;
import com.tomclaw.mandarin.mmp.MmpItem;
import com.tomclaw.mandarin.mmp.MmpPacketSender;
import com.tomclaw.mandarin.mmp.MmpStatusUtil;
import com.tomclaw.mandarin.mmp.Packet;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.Base64;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;

public class MmpPacketParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parsePacket(MmpAccountRoot mmpAccountRoot, Packet packet) {
        String[] fields;
        long fieldNum;
        int offset;
        block95: {
            String buddyMask;
            String groupMask;
            long groupCount;
            packet.dumpPacketData();
            LogUtil.outMessage("packet.msg = " + packet.msg);
            offset = 0;
            if (packet.msg == 4151L) {
                long reqStatus = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                if (reqStatus != 0L) return;
                groupCount = DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                int maskLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                groupMask = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, maskLength), false);
                offset += maskLength;
                maskLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset, true);
                buddyMask = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, maskLength), false);
                offset += maskLength;
            } else {
                if (packet.msg == 4116L) {
                    mmpAccountRoot.session.pingDelay = DataUtil.get32_reversed(packet.data.byteString, 0, true);
                    return;
                }
                if (packet.msg == 4115L) {
                    if (DataUtil.get32_reversed(packet.data.byteString, 0, true) == 16L) {
                        // empty if block
                    }
                    mmpAccountRoot.session.disconnect();
                    return;
                }
                if (packet.msg == 4111L) {
                    long userStatus = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    int nameLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                    String statusIdString = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), false);
                    offset += nameLength;
                    nameLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    String statusString = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), false);
                    offset += nameLength;
                    nameLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    String statusDescr = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), false);
                    offset += nameLength;
                    nameLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    String userMail = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), false);
                    long clientFlags = DataUtil.get32_reversed(packet.data.byteString, offset += nameLength, true);
                    nameLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                    String clientIdString = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), false);
                    offset += nameLength;
                    LogUtil.outMessage("userMail = " + userMail);
                    LogUtil.outMessage("userStatus = " + userStatus);
                    LogUtil.outMessage("statusIdString = " + statusIdString);
                    LogUtil.outMessage("statusString = " + statusString);
                    LogUtil.outMessage("statusDescr = " + statusDescr);
                    LogUtil.outMessage("clientFlags = " + clientFlags);
                    LogUtil.outMessage("clientIdString = " + clientIdString);
                    try {
                        Handler.setMailStatus(mmpAccountRoot, userMail, MmpStatusUtil.getStatus(MmpStatusUtil.getStatusIndex(statusIdString)));
                        return;
                    }
                    catch (Throwable ex1) {
                        return;
                    }
                }
                if (packet.msg == 4105L) {
                    int msgType;
                    byte[] cookie = DataUtil.getByteArray(packet.data.byteString, offset, 4);
                    long flags = DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                    int stringLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                    String userMail = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, stringLength), false);
                    offset += stringLength;
                    stringLength = (int)DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    String messageText = null;
                    byte[] bArray = DataUtil.getByteArray(packet.data.byteString, offset += 4, stringLength);
                    LogUtil.outMessage("flags = " + flags);
                    LogUtil.outMessage("encoding = " + (int)((flags & 0xFFFFFFFFFFFF0000L) >> 16));
                    switch (StringUtil.determEncoding(bArray)) {
                        case 1: {
                            messageText = StringUtil.ucs2leByteArrayToString(bArray);
                            break;
                        }
                        case 2: {
                            messageText = StringUtil.byteArray1251ToString(bArray, 0, stringLength);
                            break;
                        }
                    }
                    offset += stringLength;
                    LogUtil.outMessage("msgType == " + Long.toString(flags, 16) + " XORed: " + Long.toString(flags & 0xFFL, 16));
                    if ((flags & 0xFFL) == 12L) {
                        msgType = 1;
                        try {
                            LogUtil.outMessage("bArray: " + StringUtil.byteArrayToString(bArray));
                            byte[] unBase64 = Base64.decode(StringUtil.byteArrayToString(bArray));
                            LogUtil.outMessage(HexUtil.bytesToString(unBase64));
                            byte[] data = ArrayUtil.copyOfRange(unBase64, 12, unBase64.length);
                            switch (StringUtil.determEncoding(data)) {
                                case 1: {
                                    messageText = StringUtil.ucs2leByteArrayToString(data);
                                    break;
                                }
                                case 2: {
                                    messageText = StringUtil.byteArray1251ToString(data, 0, data.length);
                                    break;
                                }
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        LogUtil.outMessage("ChatItem.TYPE_AUTH_REQ_MSG");
                    } else if ((flags & 0xFFL) == 64L) {
                        msgType = 5;
                    } else {
                        if ((flags & 0xFF00L) == 1024L) {
                            Handler.setBuddyTypingStatus(mmpAccountRoot, userMail, null, false, true);
                            return;
                        }
                        if ((flags & 0xFF00L) == 16384L) {
                            msgType = 4;
                            messageText = Localization.getMessage("WAKEUP_TEXT");
                        } else {
                            msgType = 7;
                            if ((flags & 0xFFL) != 4L) {
                                try {
                                    MmpPacketSender.MRIM_CS_MESSAGE_RECV(mmpAccountRoot, userMail, cookie);
                                }
                                catch (Throwable ex) {
                                    LogUtil.outMessage(ex.getMessage(), true);
                                }
                            }
                        }
                    }
                    Handler.recMess(mmpAccountRoot, userMail, null, null, messageText, cookie, msgType);
                    return;
                }
                if (packet.msg == 4114L) {
                    long status = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    offset += 4;
                    if (status == 0L) {
                        LogUtil.outMessage("Message delivered");
                        byte[] temp = new byte[8];
                        DataUtil.put32(temp, 0, packet.seq);
                        Handler.msgAck(mmpAccountRoot, null, null, temp);
                        return;
                    }
                    if (status == 32771L) {
                        return;
                    }
                    if (status == 32769L) {
                        return;
                    }
                    if (status == 32772L) {
                        return;
                    }
                    if (status == 32773L) {
                        return;
                    }
                    if (status != 32774L) return;
                    return;
                }
                if (packet.msg == 4122L || packet.msg == 4124L) {
                    long status = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    offset += 4;
                    String errorString = null;
                    Cookie cookie = new Cookie(packet.seq);
                    if (status == 0L) {
                        Handler.setMainFrameAction(mmpAccountRoot, Localization.getMessage("CONTACT_OPER_SUCCESS"));
                        if (packet.data.byteString.length >= offset + 4) {
                            long contactId = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                            offset += 4;
                            Hashtable<String, Long> params = new Hashtable<String, Long>();
                            params.put("contactId", new Long(contactId));
                            Handler.processQueueAction(mmpAccountRoot, cookie, params);
                            return;
                        }
                        if (packet.msg == 4124L) {
                            Hashtable<String, Long> params = new Hashtable<String, Long>();
                            params.put("contactId", new Long(0L));
                            Handler.processQueueAction(mmpAccountRoot, cookie, params);
                            return;
                        }
                    } else {
                        errorString = status == 1L ? "CONTACT_OPER_ERROR" : (status == 2L ? "CONTACT_OPER_INTERR" : (status == 3L ? "CONTACT_OPER_NO_SUCH_USER" : (status == 4L ? "CONTACT_OPER_INVALID_INFO" : (status == 5L ? "CONTACT_OPER_USER_EXISTS" : (status == 6L ? "CONTACT_OPER_GROUP_LIMIT" : "CONTACT_OPER_ERROR")))));
                    }
                    Handler.cancelQueueAction(mmpAccountRoot, cookie, errorString);
                    return;
                }
                if (packet.msg != 4136L) return;
                long status = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                offset += 4;
                if (status == 1L) {
                    fieldNum = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                    long maxRows = DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                    long servTime = DataUtil.get32_reversed(packet.data.byteString, offset += 4, true);
                    offset += 4;
                    fields = new String[(int)fieldNum];
                    int c = 0;
                    while ((long)c < fieldNum) {
                        long fieldLength = DataUtil.get32_reversed(packet.data.byteString, offset, true);
                        fields[c] = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, (int)fieldLength));
                        offset = (int)((long)offset + fieldLength);
                        ++c;
                    }
                    break block95;
                } else {
                    if (status == 0L) {
                        return;
                    }
                    if (status != 3L) return;
                    return;
                }
            }
            Vector<MmpGroup> buddyList = new Vector<MmpGroup>();
            long contactIdIncrm = 0L;
            int c = 0;
            while (true) {
                if ((long)c >= groupCount) break;
                MmpGroup mmpGroup = new MmpGroup("");
                ++contactIdIncrm;
                mmpGroup.contactId = mmpGroup.contactId;
                block30: for (int i = 0; i < groupMask.length(); ++i) {
                    switch (i) {
                        case 0: {
                            mmpGroup.flags = (int)DataUtil.get32(packet.data.byteString, offset, false);
                            offset += 4;
                            continue block30;
                        }
                        case 1: {
                            int nameLength = (int)DataUtil.get32(packet.data.byteString, offset, false);
                            mmpGroup.userId = StringUtil.byteArray1251ToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), 0, nameLength);
                            offset += nameLength;
                            continue block30;
                        }
                        default: {
                            if (groupMask.charAt(i) == 'u') {
                                offset += 4;
                                continue block30;
                            }
                            if (groupMask.charAt(i) != 's') continue block30;
                            offset += 4 + (int)DataUtil.get32(packet.data.byteString, offset, false);
                        }
                    }
                }
                LogUtil.outMessage("Group (" + mmpGroup.userId + ") flags: " + mmpGroup.flags + ") contactId: " + mmpGroup.contactId);
                if (((long)mmpGroup.flags & 1L) == 0L) {
                    LogUtil.outMessage("name: " + mmpGroup.userId + " id: " + mmpGroup.contactId + " flags: " + mmpGroup.flags);
                    buddyList.addElement(mmpGroup);
                }
                ++c;
            }
            MmpGroup phonesGroup = new MmpGroup(Localization.getMessage("TELEPHONE_CONTACTS"));
            buddyList.addElement(phonesGroup);
            mmpAccountRoot.phoneGroup = phonesGroup;
            MmpGroup othersGroup = new MmpGroup(Localization.getMessage("OTHER_CONTACTS"));
            buddyList.addElement(othersGroup);
            contactIdIncrm = 20L;
            while (true) {
                MmpItem mmpItem;
                block98: {
                    block97: {
                        block96: {
                            if (offset >= packet.data.length()) {
                                Handler.setBuddyList(mmpAccountRoot, buddyList, null, -1, 0, null);
                                return;
                            }
                            mmpItem = new MmpItem("");
                            ++contactIdIncrm;
                            mmpItem.contactId = mmpItem.contactId;
                            block32: for (int i = 0; i < buddyMask.length(); ++i) {
                                switch (i) {
                                    case 0: {
                                        mmpItem.flags = DataUtil.get32(packet.data.byteString, offset, false);
                                        offset += 4;
                                        continue block32;
                                    }
                                    case 1: {
                                        mmpItem.groupId = DataUtil.get32(packet.data.byteString, offset, false);
                                        offset += 4;
                                        continue block32;
                                    }
                                    case 2: {
                                        int nameLength = (int)DataUtil.get32(packet.data.byteString, offset, false);
                                        mmpItem.userId = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), false);
                                        offset += nameLength;
                                        continue block32;
                                    }
                                    case 3: {
                                        int nameLength = (int)DataUtil.get32(packet.data.byteString, offset, false);
                                        mmpItem.userNick = StringUtil.byteArray1251ToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), 0, nameLength);
                                        offset += nameLength;
                                        continue block32;
                                    }
                                    case 4: {
                                        mmpItem.servFlags = DataUtil.get32(packet.data.byteString, offset, false);
                                        offset += 4;
                                        continue block32;
                                    }
                                    case 5: {
                                        mmpItem.setStatusIndex(MmpStatusUtil.getStatusIndex(DataUtil.get32(packet.data.byteString, offset, false)), null);
                                        offset += 4;
                                        continue block32;
                                    }
                                    case 6: {
                                        int nameLength = (int)DataUtil.get32(packet.data.byteString, offset, false);
                                        mmpItem.userPhone = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset += 4, nameLength), false);
                                        offset += nameLength;
                                        continue block32;
                                    }
                                    case 7: {
                                        int length = (int)DataUtil.get32(packet.data.byteString, offset, false);
                                        offset += 4;
                                        if (length <= 0) continue block32;
                                        String statusIdString = StringUtil.byteArrayToString(DataUtil.getByteArray(packet.data.byteString, offset, length), false);
                                        offset += length;
                                        if (StringUtil.isNullOrEmpty(statusIdString)) continue block32;
                                        mmpItem.setStatusIndex(MmpStatusUtil.getStatusIndex(statusIdString), null);
                                        continue block32;
                                    }
                                    default: {
                                        if (buddyMask.charAt(i) == 'u') {
                                            offset += 4;
                                            continue block32;
                                        }
                                        if (buddyMask.charAt(i) != 's') continue block32;
                                        int length = (int)DataUtil.get32(packet.data.byteString, offset, false);
                                        offset += 4;
                                        offset += length;
                                    }
                                }
                            }
                            LogUtil.outMessage(mmpItem.userNick + "(" + mmpItem.userId + ") >>" + mmpItem.groupId + " [" + mmpItem.flags + "] status = " + mmpItem.getStatusIndex() + " id: " + mmpItem.contactId);
                            if (0L != (mmpItem.flags & 1L)) continue;
                            if ((mmpItem.flags & 0x100000L) != 0L) break block96;
                            break block97;
                        }
                        if ((mmpItem.flags & 0x100000L) == 0L) break block98;
                        mmpItem.setIsPhone(true);
                        mmpItem.userId = mmpItem.userPhone;
                        phonesGroup.addChild(mmpItem);
                        mmpItem = null;
                        break block98;
                    }
                    for (int c2 = 0; c2 < buddyList.size(); ++c2) {
                        if ((long)((MmpGroup)buddyList.elementAt(c2)).getId() != mmpItem.groupId) continue;
                        ((MmpGroup)buddyList.elementAt(c2)).addChild(mmpItem);
                        mmpItem = null;
                        break;
                    }
                }
                if (mmpItem == null || DataUtil.reverseLong(mmpItem.flags) == 1L) continue;
                othersGroup.addChild(mmpItem);
            }
        }
        BuddyInfo buddyInfo = new BuddyInfo();
        int c = 0;
        while (true) {
            if ((long)c >= fieldNum) {
                buddyInfo.avatar = MmpPacketParser.downloadAvatar(buddyInfo.buddyId);
                Handler.showUserShortInfo(mmpAccountRoot, buddyInfo);
                return;
            }
            long fieldLength = DataUtil.get32_reversed(packet.data.byteString, offset, true);
            byte[] value = DataUtil.getByteArray(packet.data.byteString, offset += 4, (int)fieldLength);
            offset = (int)((long)offset + fieldLength);
            if (fields[c].equals("Username")) {
                buddyInfo.buddyId = StringUtil.byteArrayToString(value);
            } else if (fields[c].equals("Domain")) {
                buddyInfo.buddyId = buddyInfo.buddyId + "@" + StringUtil.byteArrayToString(value);
            } else if (fields[c].equals("Nickname")) {
                buddyInfo.nickName = StringUtil.ucs2leByteArrayToString(value);
            } else if (fields[c].equals("FirstName")) {
                buddyInfo.addKeyValue("FIRST_NAME_LABEL", StringUtil.ucs2leByteArrayToString(value));
            } else if (fields[c].equals("LastName")) {
                buddyInfo.addKeyValue("LAST_NAME_LABEL", StringUtil.ucs2leByteArrayToString(value));
            } else if (fields[c].equals("Sex")) {
                byte sexValue;
                byte by = sexValue = value.length > 0 ? value[0] : (byte)0;
                String sexString = sexValue == 49 ? Localization.getMessage("GENDER_MALE") : (sexValue == 50 ? Localization.getMessage("GENDER_FEMALE") : Localization.getMessage("GENDER_UNK"));
                buddyInfo.addKeyValue("GENDER_LABEL", sexString);
            } else if (fields[c].equals("Birthday")) {
                buddyInfo.addKeyValue("BIRTH_DATE_LABEL", StringUtil.byteArrayToString(value));
            } else if (!fields[c].equals("City_id")) {
                if (fields[c].equals("Location")) {
                    buddyInfo.addKeyValue("LOCATION", StringUtil.ucs2leByteArrayToString(value));
                } else if (!(fields[c].equals("Zodiac") || fields[c].equals("BMonth") || fields[c].equals("BDay") || fields[c].equals("Country_id"))) {
                    if (fields[c].equals("Phone")) {
                        buddyInfo.addKeyValue("VALIDATED_CELLULAR_LABEL", StringUtil.ucs2leByteArrayToString(value));
                    } else if (!fields[c].equals("mrim_status") && !fields[c].equals("status_uri")) {
                        if (fields[c].equals("status_title")) {
                            buddyInfo.addKeyValue("STATUSTITLE", StringUtil.ucs2leByteArrayToString(value));
                        } else if (fields[c].equals("status_desc")) {
                            buddyInfo.addKeyValue("STATUSDESC", StringUtil.ucs2leByteArrayToString(value));
                        } else if (fields[c].equals("ua_features")) {
                            // empty if block
                        }
                    }
                }
            }
            ++c;
        }
    }

    public static Image downloadAvatar(String email) {
        int domainIndex = email.indexOf("@");
        int domainDotIndex = email.indexOf(46, domainIndex);
        if (domainIndex != -1 && domainDotIndex != -1) {
            String userName = email.substring(0, domainIndex);
            String domain = email.substring(domainIndex + 1, domainDotIndex);
            try {
                HttpConnection http = (HttpConnection)Connector.open((String)("http://buddyicon.foto.mail.ru/" + domain + "/" + userName + "/_avatar"), (int)1, (boolean)true);
                LogUtil.outMessage("http://buddyicon.foto.mail.ru/" + domain + "/" + userName + "/_avatar");
                http.setRequestMethod("GET");
                if (http.getResponseCode() == 200) {
                    int read;
                    InputStream stream = http.openInputStream();
                    ArrayUtil array = new ArrayUtil();
                    byte[] buffer = new byte[4096];
                    while ((read = stream.read(buffer)) >= 0) {
                        array.append(buffer, 0, read);
                    }
                    return Image.createImage((byte[])array.byteString, (int)0, (int)array.length());
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return null;
    }
}

