/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.mmp;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.mmp.MmpGroup;
import com.tomclaw.mandarin.mmp.MmpItem;
import com.tomclaw.mandarin.mmp.MmpPacketSender;
import com.tomclaw.mandarin.mmp.MmpSession;
import com.tomclaw.mandarin.mmp.MmpStatusUtil;
import com.tomclaw.mandarin.net.IncorrectAddressException;
import com.tomclaw.mandarin.net.NetConnection;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.Base64;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;

public class MmpAccountRoot
extends AccountRoot {
    public Stack queueActionStack;
    public MmpGroup phoneGroup = null;
    public MmpSession session;

    public MmpAccountRoot(String userId) {
        super(userId);
    }

    public void construct() {
        this.host = "mrim.mail.ru";
        this.port = "2042";
    }

    public void initSpecialData() {
        this.session = new MmpSession(this);
    }

    public void saveSpecialSettings() throws Throwable {
    }

    public void show() {
    }

    public String getAccType() {
        return "mmp";
    }

    public void sendTypingStatus(String userId, boolean b) {
    }

    public byte[] sendMessage(BuddyItem buddyItem, String string, String resource) {
        byte[] cookie = new byte[8];
        if (buddyItem.isPhone()) {
            String userPhone = buddyItem.getUserId();
            if (!userPhone.startsWith("+")) {
                userPhone = userPhone + "+";
            }
            MmpPacketSender.MRIM_CS_SMS_MESSAGE(this, userPhone, string);
        } else {
            LogUtil.outMessage(">>> contactItem.getUserId()=" + buddyItem.getUserId());
            cookie = MmpPacketSender.MRIM_CS_MESSAGE(this, buddyItem.getUserId(), string, 40L, " ");
        }
        return cookie;
    }

    public void sendWakeup(BuddyItem buddyItem) throws IOException {
        LogUtil.outMessage(">>> contactItem.getUserId()=" + buddyItem.getUserId());
        MmpPacketSender.MRIM_CS_MESSAGE(this, buddyItem.getUserId(), Localization.getMessage("WAKE_UP_NOT_SUPPORTED"), -2143289344L, "eNptUsFugkAQJaYnE/9h0nOji6Kx+g29ND3uBXFBUgSDa3sw/lv7Cf7BalklWFCgaZtoSheMSY297Jt9M/PezmRLkiQ1SpI0xS7VZazaY7M4tJEh15sy7hNdR/lpqbYhI+V2inXHprRniQBh3TYtrGsD1R0TWkcKPKgDZ6h2Z7NKeYo1x3JcUdrFLukjbLiE2Aj3rAlBBVVvNo9kHuS0wPPE32p0XosuVU/t4t0FKzcb/7mdaIFFIr+fJU46LeXIC8zplnJpKdfbXTErfjLJ86Np9xU80WQ8Ut1+sZ6x3MZar4E1sdsewiPXoUSjlfI8WvCYe6EfwDba7hO2iTNYshh2bL1IPT853EDkhSyIIC34NE5YGC03PGRFvOPLbyZa+C72M7hTTat6P4GXNx4mDBZ8LWQ9j+9WgQ8faRh8+j5cvwrhzUF4XldhHrAvlhxAaKY/RxkBe3iPVjzhsPZ4fOjAgNJRp1ZTDWLT6jA3cSe1fDqolGdX4utkWSb9AlobC7Q=");
    }

    public MmpItem setBuddyStatus(String buddyId, long buddyStatus) {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            GroupHeader groupItem = (GroupHeader)this.buddyItems.elementAt(c);
            for (int i = 0; i < groupItem.getChildsCount(); ++i) {
                if (!((MmpItem)groupItem.getChilds().elementAt((int)i)).userId.equals(buddyId)) continue;
                ((MmpItem)groupItem.getChilds().elementAt(i)).setStatusIndex(MmpStatusUtil.getStatusIndex(buddyStatus), null);
                ((MmpItem)groupItem.getChilds().elementAt(i)).updateUiData();
                this.updateMainFrameBuddyList();
                return (MmpItem)groupItem.getChilds().elementAt(i);
            }
        }
        return null;
    }

    public long getBuddyStatus(String buddyId) {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            GroupHeader groupItem = (GroupHeader)this.buddyItems.elementAt(c);
            for (int i = 0; i < groupItem.getChildsCount(); ++i) {
                if (!((MmpItem)groupItem.getChilds().elementAt((int)i)).userId.equals(buddyId)) continue;
                return MmpStatusUtil.getStatus(((MmpItem)groupItem.getChilds().elementAt(i)).getStatusIndex());
            }
        }
        return 0L;
    }

    public void updateMainFrameBuddyList() {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            if (this.buddyItems.elementAt(c) instanceof MmpGroup) {
                ((MmpGroup)this.buddyItems.elementAt(c)).updateUiData();
            }
            for (int i = 0; i < ((GroupHeader)this.buddyItems.elementAt(c)).getChildsCount(); ++i) {
                ((MmpItem)((GroupHeader)this.buddyItems.elementAt(c)).getChilds().elementAt(i)).updateUiData();
            }
        }
        this.updateMainFrameUI();
    }

    public void connectAction(final int statusIndex) {
        if (this.isConnecting || this.statusIndex != 0) {
            return;
        }
        this.isConnecting = true;
        new Thread(){

            public void run() {
                try {
                    do {
                        if (MidletMain.httpHiddenPing > 0) {
                            try {
                                NetConnection.httpPing("http://www.mail.ru");
                            }
                            catch (IOException ex) {
                                LogUtil.outMessage("HTTP hidden connection failed");
                            }
                        }
                        try {
                            if (MmpAccountRoot.this.session.login_stage(MmpAccountRoot.this.host + ":" + MmpAccountRoot.this.port, MmpAccountRoot.this.userId, MmpAccountRoot.this.userPassword, MmpStatusUtil.getStatus(statusIndex), "")) {
                                MmpAccountRoot.this.statusIndex = statusIndex;
                                LogUtil.outMessage("Updating status in AccountStatus");
                                MidletMain.mainFrame.updateAccountsStatus();
                                Handler.setConnectionStage(MmpAccountRoot.this, 10);
                            }
                            MmpAccountRoot.this.isConnecting = false;
                            return;
                        }
                        catch (IOException ex) {
                            LogUtil.outMessage("IO Exception");
                            Handler.showError(Localization.getMessage("IO_EXCEPTION"));
                        }
                        catch (IncorrectAddressException ex) {
                            LogUtil.outMessage("Incorrect address");
                            Handler.showError(Localization.getMessage("INCORRECT_ADDRESS"));
                        }
                        catch (Throwable ex) {
                            LogUtil.outMessage("Throwable");
                            Handler.showError(Localization.getMessage("THROWABLE"));
                        }
                        Thread.sleep(MidletMain.reconnectTime);
                    } while (MidletMain.autoReconnect);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MmpAccountRoot.this.isConnecting = false;
            }
        }.start();
    }

    public void setTreeItems(Vector buddyList) {
        this.buddyItems = buddyList;
    }

    public String getStatusImages() {
        return "/res/groups/img_mmpstatus.png";
    }

    public void setPrivateItems(Vector privateList) {
    }

    public void setStatusText(String statusText, boolean isStatusReadable) {
        super.setStatusText(statusText, isStatusReadable);
        MmpPacketSender.MRIM_CS_CHANGE_STATUS(this, MmpStatusUtil.getStatus(this.statusIndex), statusText);
    }

    public BuddyGroup getGroupInstance() {
        return new MmpGroup();
    }

    public BuddyItem getBuddyInstance() {
        return new MmpItem();
    }

    public Cookie addGroup(BuddyGroup buddyGroup) {
        MmpGroup mmpGroup = (MmpGroup)buddyGroup;
        mmpGroup.contactId = this.getGroupContactId();
        mmpGroup.flags = this.getNextGroupId();
        Cookie cookie = MmpPacketSender.MRIM_CS_ADD_CONTACT(this, mmpGroup.flags, 0L, new byte[0], StringUtil.string1251ToByteArray(mmpGroup.getUserId()), new byte[0]);
        return cookie;
    }

    public Cookie addBuddy(BuddyItem buddyItem, BuddyGroup buddyGroup) {
        Cookie cookie;
        if (buddyItem.isPhone()) {
            buddyItem.setUserPhone(buddyItem.getUserId());
            ((MmpItem)buddyItem).flags = 0x100000L;
            cookie = MmpPacketSender.MRIM_CS_ADD_CONTACT(this, 0x100000L, 0x67000000L, "phone".getBytes(), StringUtil.string1251ToByteArray(buddyItem.getUserNick()), buddyItem.getUserId().getBytes());
        } else {
            cookie = MmpPacketSender.MRIM_CS_ADD_CONTACT(this, 0L, ((MmpGroup)buddyGroup).getId(), buddyItem.getUserId().getBytes(), StringUtil.string1251ToByteArray(buddyItem.getUserNick()), new byte[0]);
        }
        return cookie;
    }

    public Cookie renameBuddy(String itemName, BuddyItem buddyItem, String phones) {
        String buddyId = buddyItem.isPhone() ? "phone" : ((MmpItem)buddyItem).userId;
        return MmpPacketSender.MRIM_CS_MODIFY_CONTACT(this, ((MmpItem)buddyItem).contactId, ((MmpItem)buddyItem).flags, ((MmpItem)buddyItem).groupId, buddyId.getBytes(), StringUtil.string1251ToByteArray(itemName), phones == null ? "" : phones);
    }

    public Cookie renameGroup(String itemName, BuddyGroup buddyGroup) {
        return MmpPacketSender.MRIM_CS_MODIFY_CONTACT(this, ((MmpGroup)buddyGroup).contactId, ((MmpGroup)buddyGroup).flags, 0L, StringUtil.string1251ToByteArray(((MmpGroup)buddyGroup).userId), StringUtil.string1251ToByteArray(itemName), "");
    }

    public void requestAuth(String requestText, BuddyItem buddyItem) {
        byte[] data = StringUtil.string1251ToByteArray(requestText);
        String reasonText = "AgAAAAAAAAAGAAAA".concat(Base64.encode(data, 0, data.length));
        LogUtil.outMessage(reasonText);
        MmpPacketSender.MRIM_CS_MESSAGE(this, buddyItem.getUserId(), reasonText, DataUtil.reverseLong(12L), "");
    }

    public void acceptAuthorization(BuddyItem buddyItem) {
        MmpPacketSender.MRIM_CS_AUTHORIZE(this, buddyItem.getUserId());
    }

    public void requestInfo(String userId, int reqSeqNum) {
        MmpPacketSender.MRIM_CS_WP_REQUEST(this, userId);
    }

    public Cookie removeBuddy(BuddyItem buddyItem) {
        String phones = buddyItem.isPhone() ? buddyItem.getUserPhone() : "";
        String buddyId = buddyItem.isPhone() ? "phone" : ((MmpItem)buddyItem).userId;
        return MmpPacketSender.MRIM_CS_MODIFY_CONTACT(this, ((MmpItem)buddyItem).contactId, ((MmpItem)buddyItem).flags | 1L, ((MmpItem)buddyItem).groupId, buddyId.getBytes(), StringUtil.string1251ToByteArray(((MmpItem)buddyItem).userNick), phones == null ? "" : phones);
    }

    public Cookie removeGroup(BuddyGroup groupHeader) {
        return MmpPacketSender.MRIM_CS_MODIFY_CONTACT(this, ((MmpGroup)groupHeader).contactId, (long)((MmpGroup)groupHeader).flags | 1L, 0L, StringUtil.string1251ToByteArray(((MmpGroup)groupHeader).userId), StringUtil.string1251ToByteArray(((MmpGroup)groupHeader).userId), "");
    }

    public DirectConnection getDirectConnectionInstance() {
        return null;
    }

    public int getNextBuddyId() {
        return (int)(2L | new Random(System.currentTimeMillis()).nextLong() & 0xFFFFFFFFFFFF0000L);
    }

    public int getNextGroupId() {
        return (int)((long)(this.buddyItems.size() << 24) | 2L);
    }

    public int getGroupContactId() {
        int groupsCount = this.buddyItems.size();
        block0: for (int contactId = 0; contactId < 20; ++contactId) {
            for (int c = 0; c <= groupsCount; ++c) {
                if (c == groupsCount) {
                    return contactId;
                }
                if (((MmpGroup)this.buddyItems.elementAt((int)c)).contactId == (long)contactId) continue block0;
            }
        }
        return 0;
    }

    public String getStatusDescr(int statusIndex) {
        return MmpStatusUtil.getStatusDescr(statusIndex);
    }
}

