/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.RichContent;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.TabItem;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.tcuilite.smiles.Smiles;

public class TrafficInfoFrame
extends Window {
    private Pane pane;
    private Label dataCount;
    private Label moneyCount;

    public TrafficInfoFrame() {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("TRAFFIC_INFO_FRAME"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(TrafficInfoFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("MENU"));
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("SETUP")){

            public void actionPerformed() {
                MidletMain.settingsFrame.settingsTab.selectedIndex = 4;
                MidletMain.settingsFrame.settingsTab.setGObject(MidletMain.settingsFrame.panes[MidletMain.settingsFrame.settingsTab.selectedIndex]);
                MidletMain.settingsFrame.settingsTab.xOffset = ((TabItem)MidletMain.settingsFrame.settingsTab.items.elementAt((int)MidletMain.settingsFrame.settingsTab.selectedIndex)).x;
                MidletMain.screen.setActiveWindow(MidletMain.settingsFrame);
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("RESET")){

            public void actionPerformed() {
                MidletMain.dataCount = 0L;
                TrafficInfoFrame.this.updateDataCount(true);
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("UPDATE")){

            public void actionPerformed() {
                TrafficInfoFrame.this.updateDataCount(true);
            }
        });
        this.pane = new Pane(this, true);
        this.addLabels("TRAFFIC_COUNTER_STATUS", Localization.getMessage(MidletMain.isCountData ? "ENABLED" : "DISABLED"));
        this.dataCount = this.addLabels("TRAFFIC_SIZE", "0 [KiB]");
        this.moneyCount = this.addLabels("MONEY_SIZE", "0 [C.U.]");
        this.updateDataCount(false);
        this.setGObject(this.pane);
    }

    public final void updateDataCount(boolean isRepaint) {
        String dataString = MidletMain.dataCount < 1024L ? String.valueOf((int)MidletMain.dataCount) + " B :(" : (MidletMain.dataCount < 0x100000L ? String.valueOf((int)MidletMain.dataCount / 1024) + " KiB :)" : (MidletMain.dataCount < 0x40000000L ? String.valueOf((int)MidletMain.dataCount / 0x100000) + " MiB %)" : String.valueOf((int)MidletMain.dataCount / 0x40000000) + " GiB *CRAZY*"));
        dataString = Smiles.replaceSmilesForCodes(dataString);
        this.updateLabels(this.dataCount, "TRAFFIC_SIZE", dataString);
        this.updateLabels(this.moneyCount, "MONEY_SIZE", (long)MidletMain.dataCost * MidletMain.dataCount / 0x100000L + " C.U.");
        this.moneyCount.updateCaption();
        if (isRepaint) {
            this.prepareGraphics();
            MidletMain.screen.repaint();
        }
    }

    private Label addLabels(String title, String descr) {
        Label label = this.updateLabels(new Label(new RichContent("")), title, descr);
        this.pane.addItem(label);
        return label;
    }

    private Label updateLabels(Label label, String title, String descr) {
        label.getContent().setText("[p][b]" + Localization.getMessage(title) + ": [/b]" + descr + "[/p]");
        label.updateCaption();
        return label;
    }
}

