/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.bingear.GroupNotFoundException;
import com.tomclaw.bingear.IncorrectValueException;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.core.IconsType;
import com.tomclaw.mandarin.main.FileBrowserFrame;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Button;
import com.tomclaw.tcuilite.Check;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.GObject;
import com.tomclaw.tcuilite.Gauge;
import com.tomclaw.tcuilite.KeyEvent;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.tcuilite.RadioGroup;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Tab;
import com.tomclaw.tcuilite.TabEvent;
import com.tomclaw.tcuilite.TabItem;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import java.util.Hashtable;

public class SettingsFrame
extends Window {
    public Tab settingsTab;
    public GObject[] panes;
    public String[] keysCaption = null;
    public int[] keyValues = null;
    private Field loggerServerHost;
    private Field loggerFile;
    private Check outToSocket;
    private Check outToFile;
    public Check soundEnabled;
    private Check onOnline;
    private Check onOffline;
    private Check onIncoming;
    private Check onOutgoing;
    private Gauge volumeLevel;
    private Field vibrateDelay;
    private Check expandOnIncoming;
    private Check alarmRepliesOnly;
    private Check autoAcceptFiles;
    public Field acceptFilesFolder;
    private Check isHttpPing;
    private Field socketPingDelay;
    private Field httpPingDelay;
    private Check autoReconnect;
    private Check storeHistory;
    private RadioGroup columnCount;
    private Check isSortOnline;
    private Check isRaiseUnread;
    private Check isRemoveResources;
    private Field gmtOffset;
    private Check switchTime;
    private Check useEffects;
    private Check countData;
    private Field costValue;
    private Label dataCount;
    RadioGroup themesGroup;
    private Check statusChange;
    private Check xStatusRead;
    private Check mStatusRead;
    private Check fileTransfer;
    private boolean isCancelFirstPression = true;

    public SettingsFrame() {
        super(MidletMain.screen);
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(MidletMain.mainFrame);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("SAVE")){

            public void actionPerformed() {
                try {
                    if (MidletMain.isTest) {
                        MidletMain.settings.addGroup("Logger");
                        MidletMain.settings.addItem("Logger", "outToSocket", SettingsFrame.this.outToSocket.getState() ? "true" : "false");
                        MidletMain.settings.addItem("Logger", "outToFile", SettingsFrame.this.outToFile.getState() ? "true" : "false");
                        MidletMain.settings.addItem("Logger", "loggerServerHost", SettingsFrame.this.loggerServerHost.getText());
                        MidletMain.settings.addItem("Logger", "loggerFile", SettingsFrame.this.loggerFile.getText());
                    }
                    MidletMain.settings.addGroup("Alarm");
                    MidletMain.settings.addItem("Alarm", "soundEnabled", SettingsFrame.this.soundEnabled.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Alarm", "onOnline", SettingsFrame.this.onOnline.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Alarm", "onOffline", SettingsFrame.this.onOffline.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Alarm", "onIncoming", SettingsFrame.this.onIncoming.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Alarm", "onOutgoing", SettingsFrame.this.onOutgoing.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Alarm", "volumeLevel", String.valueOf(((SettingsFrame)SettingsFrame.this).volumeLevel.value));
                    MidletMain.settings.addItem("Alarm", "vibrateDelay", SettingsFrame.this.vibrateDelay.getText());
                    MidletMain.settings.addItem("Alarm", "expandOnIncoming", SettingsFrame.this.expandOnIncoming.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Alarm", "alarmRepliesOnly", SettingsFrame.this.alarmRepliesOnly.getState() ? "true" : "false");
                    MidletMain.settings.addGroup("Filetransfer");
                    MidletMain.settings.addItem("Filetransfer", "autoAcceptFiles", SettingsFrame.this.autoAcceptFiles.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Filetransfer", "acceptFilesFolder", SettingsFrame.this.acceptFilesFolder.getText());
                    MidletMain.settings.addGroup("Network");
                    MidletMain.settings.addItem("Network", "autoReconnect", SettingsFrame.this.autoReconnect.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Network", "isHttpPing", SettingsFrame.this.isHttpPing.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Network", "httpPingDelay", SettingsFrame.this.httpPingDelay.getText());
                    MidletMain.settings.addItem("Network", "socketPingDelay", SettingsFrame.this.socketPingDelay.getText());
                    MidletMain.settings.addGroup("General");
                    MidletMain.settings.addItem("General", "storeHistory", SettingsFrame.this.storeHistory.getState() ? "true" : "false");
                    MidletMain.settings.addItem("General", "isSortOnline", SettingsFrame.this.isSortOnline.getState() ? "true" : "false");
                    MidletMain.settings.addItem("General", "isRaiseUnread", SettingsFrame.this.isRaiseUnread.getState() ? "true" : "false");
                    MidletMain.settings.addItem("General", "isRemoveResources", SettingsFrame.this.isRemoveResources.getState() ? "true" : "false");
                    MidletMain.settings.addItem("General", "switchTime", SettingsFrame.this.switchTime.getState() ? "true" : "false");
                    MidletMain.settings.addItem("General", "gmtOffset", SettingsFrame.this.gmtOffset.getText());
                    MidletMain.settings.addItem("General", "columnCount", String.valueOf(SettingsFrame.this.columnCount.getCombed()));
                    MidletMain.settings.addItem("General", "useEffects", SettingsFrame.this.useEffects.getState() ? "true" : "false");
                    MidletMain.settings.addGroup("Tarification");
                    MidletMain.settings.addItem("Tarification", "countData", SettingsFrame.this.countData.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Tarification", "costValue", SettingsFrame.this.costValue.getText());
                    MidletMain.settings.addItem("Themes", "selectedTheme", "_" + SettingsFrame.this.themesGroup.getCombed());
                    MidletMain.settings.addGroup("Hotkeys");
                    for (int c = 0; c < SettingsFrame.this.keysCaption.length; ++c) {
                        MidletMain.settings.addItem("Hotkeys", SettingsFrame.this.keysCaption[c], Integer.toString(SettingsFrame.this.keyValues[c]));
                    }
                    MidletMain.settings.addGroup("Spy");
                    MidletMain.settings.addItem("Spy", "statusChange", SettingsFrame.this.statusChange.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Spy", "xStatusRead", SettingsFrame.this.xStatusRead.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Spy", "mStatusRead", SettingsFrame.this.mStatusRead.getState() ? "true" : "false");
                    MidletMain.settings.addItem("Spy", "fileTransfer", SettingsFrame.this.fileTransfer.getState() ? "true" : "false");
                }
                catch (GroupNotFoundException ex) {
                    LogUtil.outMessage("GroupNotFoundException: " + ex.getMessage());
                }
                catch (IncorrectValueException ex) {
                    LogUtil.outMessage("IncorrectValueException: " + ex.getMessage());
                }
                MidletMain.saveRmsData(false, true, false);
                MidletMain.updateAlarmSettings();
                MidletMain.updateFiletransferSettings();
                MidletMain.updateNetworkSettings();
                MidletMain.updateGeneralSettings();
                MidletMain.updateTarificationSettings();
                MidletMain.updateHotkeysSettings();
                MidletMain.updateThemesSettings();
                MidletMain.updateSpySettings();
                MidletMain.mainFrame.updateActiveAccountRoot();
                MidletMain.screen.setActiveWindow(MidletMain.mainFrame);
            }
        };
        this.settingsTab = new Tab(this.screen);
        this.initPanes();
        this.settingsTab.setGObject(this.panes[0]);
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("GENERAL"), IconsType.HASH_MAIN, 12));
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("NETWORK"), IconsType.HASH_MAIN, 16));
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("ALARM"), IconsType.HASH_MAIN, 24));
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("FILE_TRANSFER"), IconsType.HASH_MAIN, 2));
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("TARIFICATION"), IconsType.HASH_MAIN, 20));
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("HOT_KEYS"), IconsType.HASH_MAIN, 23));
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("THEMES"), IconsType.HASH_MAIN, 12));
        this.settingsTab.addTabItem(new TabItem(Localization.getMessage("SERVICE_MESSAGES"), IconsType.HASH_MAIN, 11));
        if (MidletMain.isTest) {
            this.settingsTab.addTabItem(new TabItem(Localization.getMessage("LOGGER"), IconsType.HASH_MAIN, 11));
        }
        this.settingsTab.tabEvent = new TabEvent(){

            public void stateChanged(int pervIndex, int currIndex, int totalItems) {
                SettingsFrame.this.settingsTab.setGObject(SettingsFrame.this.panes[currIndex]);
            }
        };
        this.settingsTab.selectedIndex = 0;
        this.startUpdateDataThread();
        this.setGObject(this.settingsTab);
    }

    public final void startUpdateDataThread() {
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        4.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!MidletMain.screen.activeWindow.equals(SettingsFrame.this)) continue;
                    SettingsFrame.this.updateDataCount();
                }
            }
        }.start();
    }

    public final void initPanes() {
        this.panes = new GObject[MidletMain.isTest ? 9 : 8];
        if (MidletMain.isTest) {
            this.panes[8] = new Pane(null, false);
            this.panes[8].setTouchOrientation(MidletMain.screen.isPointerEvents);
            Label label1 = new Label(Localization.getMessage("LOGGER_SERVER_HOST_PORT"));
            label1.setTitle(true);
            ((Pane)this.panes[8]).addItem(label1);
            this.outToSocket = new Check(Localization.getMessage("OUT_TO_SOCKET"), MidletMain.getBoolean(MidletMain.settings, "Logger", "outToSocket"));
            this.outToSocket.setFocusable(true);
            this.outToSocket.setFocused(true);
            ((Pane)this.panes[8]).addItem(this.outToSocket);
            this.loggerServerHost = new Field(MidletMain.getString(MidletMain.settings, "Logger", "loggerServerHost"));
            this.loggerServerHost.setFocusable(true);
            ((Pane)this.panes[8]).addItem(this.loggerServerHost);
            Label label2 = new Label(Localization.getMessage("LOGGER_FILE"));
            label2.setTitle(true);
            ((Pane)this.panes[8]).addItem(label2);
            this.outToFile = new Check(Localization.getMessage("OUT_TO_FILE"), MidletMain.getBoolean(MidletMain.settings, "Logger", "outToFile"));
            this.outToFile.setFocusable(true);
            ((Pane)this.panes[8]).addItem(this.outToFile);
            this.loggerFile = new Field(MidletMain.getString(MidletMain.settings, "Logger", "loggerFile"));
            this.loggerFile.setFocusable(true);
            ((Pane)this.panes[8]).addItem(this.loggerFile);
        }
        this.panes[0] = new Pane(null, false);
        this.panes[0].setTouchOrientation(MidletMain.screen.isPointerEvents);
        this.storeHistory = new Check(Localization.getMessage("STORE_HISTORY"), MidletMain.getBoolean(MidletMain.settings, "General", "storeHistory"));
        this.storeHistory.setFocusable(true);
        this.storeHistory.setFocused(true);
        ((Pane)this.panes[0]).addItem(this.storeHistory);
        ((Pane)this.panes[0]).addItem(new Label(Localization.getMessage("COLUMNS_NOTE")));
        this.columnCount = new RadioGroup();
        for (int c = 1; c <= 5; ++c) {
            Radio radio = new Radio(String.valueOf(c), false);
            radio.setFocusable(true);
            this.columnCount.addRadio(radio);
            ((Pane)this.panes[0]).addItem(radio);
        }
        this.columnCount.setCombed(MidletMain.getInteger(MidletMain.settings, "General", "columnCount"));
        this.isSortOnline = new Check(Localization.getMessage("SORT_ONLINE"), MidletMain.getBoolean(MidletMain.settings, "General", "isSortOnline"));
        this.isSortOnline.setFocusable(true);
        ((Pane)this.panes[0]).addItem(this.isSortOnline);
        this.isRaiseUnread = new Check(Localization.getMessage("RAISE_UNREAD"), MidletMain.getBoolean(MidletMain.settings, "General", "isRaiseUnread"));
        this.isRaiseUnread.setFocusable(true);
        ((Pane)this.panes[0]).addItem(this.isRaiseUnread);
        this.isRemoveResources = new Check(Localization.getMessage("REMOVE_OFFLINE_RESOURCES"), MidletMain.getBoolean(MidletMain.settings, "General", "isRemoveResources"));
        this.isRemoveResources.setFocusable(true);
        ((Pane)this.panes[0]).addItem(this.isRemoveResources);
        ((Pane)this.panes[0]).addItem(new Label(Localization.getMessage("GMT_TIME_OFFSET")));
        this.gmtOffset = new Field(MidletMain.getString(MidletMain.settings, "General", "gmtOffset"));
        this.gmtOffset.setConstraints(2);
        this.gmtOffset.setFocusable(true);
        ((Pane)this.panes[0]).addItem(this.gmtOffset);
        this.switchTime = new Check(Localization.getMessage("SWITCH_TIME"), MidletMain.getBoolean(MidletMain.settings, "General", "switchTime"));
        this.switchTime.setFocusable(true);
        ((Pane)this.panes[0]).addItem(this.switchTime);
        this.useEffects = new Check(Localization.getMessage("USE_EFFECTS"), MidletMain.getBoolean(MidletMain.settings, "General", "useEffects"));
        this.useEffects.setFocusable(true);
        ((Pane)this.panes[0]).addItem(this.useEffects);
        this.panes[1] = new Pane(null, false);
        this.panes[1].setTouchOrientation(MidletMain.screen.isPointerEvents);
        Label label7 = new Label(Localization.getMessage("PING_NOTE"));
        label7.setTitle(true);
        ((Pane)this.panes[1]).addItem(label7);
        this.isHttpPing = new Check(Localization.getMessage("HTTP_PING"), MidletMain.getBoolean(MidletMain.settings, "Network", "isHttpPing"));
        this.isHttpPing.setFocusable(true);
        this.isHttpPing.setFocused(true);
        ((Pane)this.panes[1]).addItem(this.isHttpPing);
        ((Pane)this.panes[1]).addItem(new Label(Localization.getMessage("HTTP_PING_DELAY")));
        this.httpPingDelay = new Field(MidletMain.getString(MidletMain.settings, "Network", "httpPingDelay"));
        this.httpPingDelay.setConstraints(2);
        this.httpPingDelay.setFocusable(true);
        ((Pane)this.panes[1]).addItem(this.httpPingDelay);
        ((Pane)this.panes[1]).addItem(new Label(Localization.getMessage("SOCKET_PING_DELAY")));
        this.socketPingDelay = new Field(MidletMain.getString(MidletMain.settings, "Network", "socketPingDelay"));
        this.socketPingDelay.setConstraints(2);
        this.socketPingDelay.setFocusable(true);
        ((Pane)this.panes[1]).addItem(this.socketPingDelay);
        ((Pane)this.panes[1]).addItem(new Label(Localization.getMessage("AUTO_RECONNECT_NOTE")));
        this.autoReconnect = new Check(Localization.getMessage("AUTO_RECONNECT"), MidletMain.getBoolean(MidletMain.settings, "Network", "autoReconnect"));
        this.autoReconnect.setFocusable(true);
        ((Pane)this.panes[1]).addItem(this.autoReconnect);
        this.panes[2] = new Pane(null, false);
        this.panes[2].setTouchOrientation(MidletMain.screen.isPointerEvents);
        this.soundEnabled = new Check(Localization.getMessage("SOUND_ENABLED"), MidletMain.getBoolean(MidletMain.settings, "Alarm", "soundEnabled"));
        this.soundEnabled.setFocusable(true);
        this.soundEnabled.setFocused(true);
        ((Pane)this.panes[2]).addItem(this.soundEnabled);
        Label label3 = new Label(Localization.getMessage("SETTINGS_SOUNDS"));
        label3.setTitle(true);
        ((Pane)this.panes[2]).addItem(label3);
        this.onOnline = new Check(Localization.getMessage("ON_ONLINE"), MidletMain.getBoolean(MidletMain.settings, "Alarm", "onOnline"));
        this.onOnline.setFocusable(true);
        this.onOnline.setFocused(true);
        ((Pane)this.panes[2]).addItem(this.onOnline);
        this.onOffline = new Check(Localization.getMessage("ON_OFFLINE"), MidletMain.getBoolean(MidletMain.settings, "Alarm", "onOffline"));
        this.onOffline.setFocusable(true);
        ((Pane)this.panes[2]).addItem(this.onOffline);
        this.onIncoming = new Check(Localization.getMessage("ON_INCOMING"), MidletMain.getBoolean(MidletMain.settings, "Alarm", "onIncoming"));
        this.onIncoming.setFocusable(true);
        ((Pane)this.panes[2]).addItem(this.onIncoming);
        this.onOutgoing = new Check(Localization.getMessage("ON_OUTGOING"), MidletMain.getBoolean(MidletMain.settings, "Alarm", "onOutgoing"));
        this.onOutgoing.setFocusable(true);
        ((Pane)this.panes[2]).addItem(this.onOutgoing);
        this.volumeLevel = new Gauge(Localization.getMessage("VOLUME_LEVEL"));
        this.volumeLevel.setFocusable(true);
        this.volumeLevel.setValue(MidletMain.getInteger(MidletMain.settings, "Alarm", "volumeLevel"));
        ((Pane)this.panes[2]).addItem(this.volumeLevel);
        Label label4 = new Label(Localization.getMessage("SETTINGS_VIBRATE"));
        label4.setTitle(true);
        ((Pane)this.panes[2]).addItem(label4);
        ((Pane)this.panes[2]).addItem(new Label(Localization.getMessage("VIBRATE_DELAY")));
        this.vibrateDelay = new Field(MidletMain.getString(MidletMain.settings, "Alarm", "vibrateDelay"));
        this.vibrateDelay.setConstraints(2);
        this.vibrateDelay.setFocusable(true);
        ((Pane)this.panes[2]).addItem(this.vibrateDelay);
        Label label5 = new Label(Localization.getMessage("EXPAND_NOTE"));
        label5.setTitle(true);
        ((Pane)this.panes[2]).addItem(label5);
        this.expandOnIncoming = new Check(Localization.getMessage("EXPAND_ON_INCOMING"), MidletMain.getBoolean(MidletMain.settings, "Alarm", "expandOnIncoming"));
        this.expandOnIncoming.setFocusable(true);
        ((Pane)this.panes[2]).addItem(this.expandOnIncoming);
        this.alarmRepliesOnly = new Check(Localization.getMessage("ALARM_REPLIES_ONLY"), MidletMain.getBoolean(MidletMain.settings, "Alarm", "alarmRepliesOnly"));
        this.alarmRepliesOnly.setFocusable(true);
        ((Pane)this.panes[2]).addItem(this.alarmRepliesOnly);
        this.panes[3] = new Pane(null, false);
        this.panes[3].setTouchOrientation(MidletMain.screen.isPointerEvents);
        Label label6 = new Label(Localization.getMessage("FILETRANSFER_NOTE"));
        label6.setTitle(true);
        ((Pane)this.panes[3]).addItem(label6);
        this.autoAcceptFiles = new Check(Localization.getMessage("AUTO_FILE_ACCEPT"), MidletMain.getBoolean(MidletMain.settings, "Filetransfer", "autoAcceptFiles"));
        this.autoAcceptFiles.setFocusable(true);
        this.autoAcceptFiles.setFocused(true);
        ((Pane)this.panes[3]).addItem(this.autoAcceptFiles);
        ((Pane)this.panes[3]).addItem(new Label(Localization.getMessage("INCOMING_FILE_FOLDER")));
        this.acceptFilesFolder = new Field(MidletMain.getString(MidletMain.settings, "Filetransfer", "acceptFilesFolder"));
        this.acceptFilesFolder.setFocusable(true);
        ((Pane)this.panes[3]).addItem(this.acceptFilesFolder);
        Button button = new Button(Localization.getMessage("SELECT_FOLDER")){

            public void actionPerformed() {
                FileBrowserFrame fileBrowserFrame = new FileBrowserFrame(1, null, null);
                fileBrowserFrame.s_prevWindow = SettingsFrame.this;
                MidletMain.screen.setActiveWindow(fileBrowserFrame);
            }
        };
        button.setFocusable(true);
        ((Pane)this.panes[3]).addItem(button);
        this.panes[4] = new Pane(null, false);
        this.panes[4].setTouchOrientation(MidletMain.screen.isPointerEvents);
        Label label8 = new Label(Localization.getMessage("TARIFICATION_NOTE"));
        label8.setTitle(true);
        ((Pane)this.panes[4]).addItem(label8);
        this.countData = new Check(Localization.getMessage("COUNT_DATA"), MidletMain.getBoolean(MidletMain.settings, "Tarification", "countData"));
        this.countData.setFocusable(true);
        this.countData.setFocused(true);
        ((Pane)this.panes[4]).addItem(this.countData);
        ((Pane)this.panes[4]).addItem(new Label(Localization.getMessage("DATA_COST")));
        this.costValue = new Field(MidletMain.getString(MidletMain.settings, "Tarification", "costValue"));
        this.costValue.setConstraints(2);
        this.costValue.setFocusable(true);
        ((Pane)this.panes[4]).addItem(this.costValue);
        Label label9 = new Label(Localization.getMessage("TARIFICATION_STATUS"));
        label9.setTitle(true);
        ((Pane)this.panes[4]).addItem(label9);
        this.dataCount = new Label("0 [KiB]");
        this.updateDataCount();
        ((Pane)this.panes[4]).addItem(this.dataCount);
        Button button1 = new Button(Localization.getMessage("RESET_DATA_COUNT")){

            public void actionPerformed() {
                MidletMain.dataCount = 0L;
                SettingsFrame.this.updateDataCount();
            }
        };
        button1.setFocusable(true);
        ((Pane)this.panes[4]).addItem(button1);
        this.panes[5] = new List();
        this.panes[5].setTouchOrientation(MidletMain.screen.isPointerEvents);
        this.keyValues = new int[29];
        this.keysCaption = new String[29];
        this.keysCaption[0] = "KEY_LOCKSCREEN";
        this.keysCaption[1] = "KEY_CLIENTINFO";
        this.keysCaption[2] = "KEY_BUDDYINFO";
        this.keysCaption[3] = "KEY_DIALOG";
        this.keysCaption[4] = "KEY_STATUSES";
        this.keysCaption[5] = "KEY_REMOVE";
        this.keysCaption[6] = "KEY_SENDFILE";
        this.keysCaption[7] = "KEY_SENDPHOTO";
        this.keysCaption[8] = "KEY_RENAME";
        this.keysCaption[9] = "KEY_SOUNDS";
        this.keysCaption[10] = "KEY_FILTERGROUPS";
        this.keysCaption[11] = "KEY_FILTEROFFLINE";
        this.keysCaption[12] = "KEY_SERVMESSAGES";
        this.keysCaption[13] = "KEY_LEFTACCOUNT";
        this.keysCaption[14] = "KEY_RIGHTACCOUNT";
        this.keysCaption[15] = "KEY_MINIMIZE";
        this.keysCaption[16] = "KEY_WRITE";
        this.keysCaption[17] = "KEY_COPY";
        this.keysCaption[18] = "KEY_PASTE";
        this.keysCaption[19] = "KEY_APPEND";
        this.keysCaption[20] = "KEY_CLEARCHAT";
        this.keysCaption[21] = "KEY_CLOSECHAT";
        this.keysCaption[22] = "KEY_BUDDYLIST_TOP";
        this.keysCaption[23] = "KEY_BUDDYLIST_BOTTOM";
        this.keysCaption[24] = "KEY_BUDDYLIST_SCREEN_HIGHER";
        this.keysCaption[25] = "KEY_BUDDYLIST_SCREEN_LOWER";
        this.keysCaption[26] = "KEY_REPLY";
        this.keysCaption[27] = "KEY_CHAT_SCREEN_TOP";
        this.keysCaption[28] = "KEY_CHAT_SCREEN_BOTTOM";
        for (int c = 0; c < this.keysCaption.length; ++c) {
            ListItem tempListItem = new ListItem(Localization.getMessage(this.keysCaption[c])){

                public void actionPerformed() {
                    SettingsFrame.this.isCancelFirstPression = true;
                    Handler.showDialog(Localization.getMessage(SettingsFrame.this.keysCaption[((List)SettingsFrame.this.panes[5]).selectedIndex]), Localization.getMessage("PRESS_KEY"));
                    SettingsFrame.this.setCapEvent();
                }
            };
            ((List)this.panes[5]).addItem(tempListItem);
            this.keyValues[c] = MidletMain.getInteger(MidletMain.settings, "Hotkeys", this.keysCaption[c]);
            if (this.keyValues[c] == 0) continue;
            try {
                tempListItem.descr = MidletMain.screen.getKeyName(this.keyValues[c]);
            }
            catch (Throwable ex1) {
                tempListItem.descr = "\"" + this.keyValues[c] + "\"";
            }
            LogUtil.outMessage("HotKeyCode " + this.keysCaption[c] + " = " + this.keyValues[c]);
        }
        this.panes[6] = new Pane(null, false);
        this.panes[6].setTouchOrientation(MidletMain.screen.isPointerEvents);
        Label label10 = new Label(Localization.getMessage("SELECT_THEME_NOTE"));
        label10.setTitle(true);
        ((Pane)this.panes[6]).addItem(label10);
        this.themesGroup = new RadioGroup();
        try {
            Hashtable themes = MidletMain.settings.getGroup("Themes");
            if (themes == null) {
                themes = new Hashtable();
            }
            String selectedTheme = MidletMain.getString(MidletMain.settings, "Themes", "selectedTheme");
            for (int c = 0; c < themes.size() - 1; ++c) {
                String themePath = (String)themes.get("_" + c);
                String themeName = Theme.loadTitle(themePath);
                Radio radio = new Radio(themeName, selectedTheme.equals("_" + c));
                radio.setFocusable(true);
                radio.setFocused(true);
                this.themesGroup.addRadio(radio);
                ((Pane)this.panes[6]).addItem(radio);
            }
        }
        catch (IncorrectValueException ex) {
        }
        catch (GroupNotFoundException ex) {
            // empty catch block
        }
        this.panes[7] = new Pane(null, false);
        this.panes[7].setTouchOrientation(MidletMain.screen.isPointerEvents);
        Label label11 = new Label(Localization.getMessage("SELECT_SPY_EVENTS_NOTE"));
        label11.setTitle(true);
        ((Pane)this.panes[7]).addItem(label11);
        this.statusChange = new Check(Localization.getMessage("TYPE_STATUS_CHANGE"), MidletMain.getBoolean(MidletMain.settings, "Spy", "statusChange"));
        this.statusChange.setFocusable(true);
        this.statusChange.setFocused(true);
        ((Pane)this.panes[7]).addItem(this.statusChange);
        this.xStatusRead = new Check(Localization.getMessage("TYPE_XSTATUS_READ"), MidletMain.getBoolean(MidletMain.settings, "Spy", "xStatusRead"));
        this.xStatusRead.setFocusable(true);
        ((Pane)this.panes[7]).addItem(this.xStatusRead);
        this.mStatusRead = new Check(Localization.getMessage("TYPE_MSTATUS_READ"), MidletMain.getBoolean(MidletMain.settings, "Spy", "mStatusRead"));
        this.mStatusRead.setFocusable(true);
        ((Pane)this.panes[7]).addItem(this.mStatusRead);
        this.fileTransfer = new Check(Localization.getMessage("TYPE_FILETRANSFER"), MidletMain.getBoolean(MidletMain.settings, "Spy", "fileTransfer"));
        this.fileTransfer.setFocusable(true);
        ((Pane)this.panes[7]).addItem(this.fileTransfer);
    }

    public void setCapEvent() {
        this.capKeyEvent = new KeyEvent(0, "", false){

            public void actionPerformed() {
                if (Screen.getExtGameAct(this.keyCode) != 8 && Screen.getExtGameAct(this.keyCode) != 1000001 && Screen.getExtGameAct(this.keyCode) != 1000002) {
                    SettingsFrame.this.keyValues[((List)SettingsFrame.this.panes[5]).selectedIndex] = this.keyCode;
                    LogUtil.outMessage("capKeyCode = " + this.keyCode);
                    SettingsFrame.this.closeDialog();
                    SettingsFrame.this.capKeyEvent = null;
                    SettingsFrame.this.updateHotkeysParam();
                    MidletMain.screen.repaint();
                } else if (!SettingsFrame.this.isCancelFirstPression) {
                    SettingsFrame.this.keyValues[((List)SettingsFrame.this.panes[5]).selectedIndex] = 0;
                    LogUtil.outMessage("cancelled index " + ((List)SettingsFrame.this.panes[5]).selectedIndex);
                    SettingsFrame.this.closeDialog();
                    SettingsFrame.this.capKeyEvent = null;
                    SettingsFrame.this.updateHotkeysParam();
                    MidletMain.screen.repaint();
                } else {
                    SettingsFrame.this.isCancelFirstPression = false;
                }
            }
        };
    }

    public void updateHotkeysParam() {
        for (int c = 0; c < this.keysCaption.length; ++c) {
            ListItem tempListItem = ((List)this.panes[5]).getElement(c);
            if (this.keyValues[c] != 0) {
                try {
                    tempListItem.descr = MidletMain.screen.getKeyName(this.keyValues[c]);
                }
                catch (Throwable ex1) {
                    tempListItem.descr = "\"" + this.keyValues[c] + "\"";
                }
                LogUtil.outMessage("HotKeyCode " + this.keysCaption[c] + " = " + this.keyValues[c]);
                continue;
            }
            tempListItem.descr = null;
        }
    }

    public void updateDataCount() {
        String dataString = MidletMain.dataCount < 1024L ? String.valueOf((int)MidletMain.dataCount) + " [B]" : (MidletMain.dataCount < 0x100000L ? String.valueOf((int)MidletMain.dataCount / 1024) + " [KiB]" : (MidletMain.dataCount < 0x40000000L ? String.valueOf((int)MidletMain.dataCount / 0x100000) + " [MiB]" : String.valueOf((int)MidletMain.dataCount / 0x40000000) + " [GiB] *CRAZY*"));
        this.dataCount.setCaption(dataString);
        this.dataCount.updateCaption();
        this.prepareGraphics();
        MidletMain.screen.repaint();
    }
}

