/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Check;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;

public class SetStatusTextFrame
extends Window {
    private Field textField;
    private Check readableCheck;

    public SetStatusTextFrame(final AccountRoot accountRoot, final int statusIndex) {
        super(MidletMain.screen);
        boolean isReadableEnabled = !accountRoot.getAccType().toUpperCase().equals("MMP");
        final String groupHeader = "PStatus_".concat(accountRoot.getAccType().toUpperCase());
        this.header = new Header(Localization.getMessage("STATUS_TEXT"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(SetStatusTextFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("APPLY")){

            public void actionPerformed() {
                MidletMain.screen.setWaitScreenState(true);
                try {
                    if (MidletMain.statuses.getGroup(groupHeader) == null) {
                        MidletMain.statuses.addGroup(groupHeader);
                    }
                    MidletMain.statuses.addItem(groupHeader, String.valueOf(statusIndex), SetStatusTextFrame.this.textField.getText().concat("&rdb").concat(SetStatusTextFrame.this.readableCheck.getState() ? "true" : "false"));
                    MidletMain.saveRmsData(false, false, true);
                    accountRoot.setStatusText(SetStatusTextFrame.this.textField.getText(), SetStatusTextFrame.this.readableCheck.getState());
                    MidletMain.screen.setWaitScreenState(false);
                    MidletMain.screen.setActiveWindow(SetStatusTextFrame.this.s_prevWindow);
                    return;
                }
                catch (Throwable ex) {
                    LogUtil.outMessage(ex);
                    MidletMain.screen.setWaitScreenState(false);
                    return;
                }
            }
        };
        Pane pane = new Pane(null, false);
        Label statusHeader = new Label(Localization.getMessage("PLAIN_STATUS_TEXT"));
        statusHeader.setHeader(true);
        pane.addItem(statusHeader);
        pane.addItem(new Label(Localization.getMessage(accountRoot.getStatusDescr(statusIndex)).concat(":")));
        String statusText = MidletMain.getString(MidletMain.statuses, groupHeader, String.valueOf(statusIndex));
        if (statusText == null) {
            statusText = "";
        }
        this.textField = new Field(statusText.substring(0, statusText.indexOf("&rdb") == -1 ? statusText.length() : statusText.indexOf("&rdb")));
        this.textField.setFocusable(true);
        this.textField.setFocused(true);
        pane.addItem(this.textField);
        this.readableCheck = new Check(Localization.getMessage("STATUS_READABLE"), statusText.indexOf("&rdb") == -1 ? false : statusText.substring(statusText.indexOf("&rdb") + 4).equals("true"));
        this.readableCheck.setFocusable(true);
        this.readableCheck.setState(true);
        if (isReadableEnabled) {
            pane.addItem(this.readableCheck);
        }
        this.setGObject(pane);
    }
}

