/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.main.TransactionItemFrame;
import com.tomclaw.tcuilite.Check;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.tcuilite.RadioGroup;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import javax.microedition.amms.control.camera.CameraControl;
import javax.microedition.amms.control.camera.FlashControl;
import javax.microedition.amms.control.camera.FocusControl;
import javax.microedition.amms.control.camera.SnapshotControl;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;

public class PhotoPreparingFrame
extends Window {
    public RadioGroup resolutionsGroup;
    public RadioGroup exposureModesGroup;
    public RadioGroup flashModesGroup;
    public Check isAutoFocus;
    public Check isMacroFocus;
    public Player mPlayer;
    public AccountRoot accountRoot;
    public String buddyId;
    private CameraControl camera;
    private FlashControl flash;
    private FocusControl focus;
    private SnapshotControl snapshot;

    public PhotoPreparingFrame(final AccountRoot accountRoot, String buddyId) {
        super(MidletMain.screen);
        Label label2;
        this.accountRoot = accountRoot;
        this.buddyId = buddyId;
        this.header = new Header(Localization.getMessage("PHOTO_PREPARING"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(PhotoPreparingFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("SNAPSHOT")){

            public void actionPerformed() {
                MidletMain.isPhotoActive = true;
                try {
                    VideoControl mVideoControl = (VideoControl)PhotoPreparingFrame.this.mPlayer.getControl("VideoControl");
                    final Canvas canvas = new Canvas(){

                        protected void paint(Graphics g) {
                            g.setColor(0xFFFFFF);
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                    };
                    mVideoControl.initDisplayMode(1, (Object)canvas);
                    try {
                        mVideoControl.setDisplayLocation(2, 2);
                        mVideoControl.setDisplaySize(MidletMain.screen.getWidth() - 4, MidletMain.screen.getHeight() - 4);
                    }
                    catch (MediaException me) {
                        try {
                            mVideoControl.setDisplayFullScreen(true);
                        }
                        catch (MediaException me2) {
                            // empty catch block
                        }
                    }
                    mVideoControl.setVisible(true);
                    final Command okCommand = new Command(Localization.getMessage("SNAP"), 4, 1);
                    final Command cancelCommand = new Command(Localization.getMessage("CANCEL"), 3, 1);
                    final Command sendCommand = new Command(Localization.getMessage("SEND"), 8, 1);
                    final Command retryCommand = new Command(Localization.getMessage("RETRY"), 6, 1);
                    canvas.addCommand(okCommand);
                    canvas.addCommand(cancelCommand);
                    canvas.setCommandListener(new CommandListener(){

                        public void commandAction(Command c, Displayable d) {
                            if (c.getCommandType() == 4) {
                                if ((this).PhotoPreparingFrame.this.exposureModesGroup != null) {
                                    PhotoPreparingFrame.this.camera.setExposureMode(PhotoPreparingFrame.this.camera.getSupportedExposureModes()[(this).PhotoPreparingFrame.this.exposureModesGroup.getCombed()]);
                                }
                                PhotoPreparingFrame.this.camera.setStillResolution((this).PhotoPreparingFrame.this.resolutionsGroup.getCombed() * 2);
                                if ((this).PhotoPreparingFrame.this.flashModesGroup != null) {
                                    PhotoPreparingFrame.this.flash.setMode(PhotoPreparingFrame.this.flash.getSupportedModes()[(this).PhotoPreparingFrame.this.flashModesGroup.getCombed()]);
                                }
                                if ((this).PhotoPreparingFrame.this.isAutoFocus != null && (this).PhotoPreparingFrame.this.isAutoFocus.getState()) {
                                    try {
                                        PhotoPreparingFrame.this.focus.setFocus(-1000);
                                    }
                                    catch (MediaException ex) {
                                        // empty catch block
                                    }
                                }
                                if ((this).PhotoPreparingFrame.this.isMacroFocus != null) {
                                    try {
                                        PhotoPreparingFrame.this.focus.setMacro((this).PhotoPreparingFrame.this.isMacroFocus.getState());
                                    }
                                    catch (MediaException ex) {
                                        // empty catch block
                                    }
                                }
                                PhotoPreparingFrame.this.snapshot = (SnapshotControl)(this).PhotoPreparingFrame.this.mPlayer.getControl("javax.microedition.amms.control.camera.SnapshotControl");
                                try {
                                    PhotoPreparingFrame.this.snapshot.setDirectory(MidletMain.incomingFilesFolder);
                                    PhotoPreparingFrame.this.snapshot.setFilePrefix("MND".concat(String.valueOf(System.currentTimeMillis())));
                                    PhotoPreparingFrame.this.snapshot.setFileSuffix(".jpg");
                                    PhotoPreparingFrame.this.snapshot.start(-1);
                                }
                                catch (Throwable ex1) {
                                    Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                                    PhotoPreparingFrame.this.closePlayer();
                                    Handler.showError(Localization.getMessage("LOCAL_FILE_IO_EXCEPTION"));
                                }
                            } else if (c.getCommandType() == 3) {
                                Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                                PhotoPreparingFrame.this.closePlayer();
                                MidletMain.screen.setActiveWindow((this).PhotoPreparingFrame.this.s_prevWindow);
                            } else if (c.getCommandType() == 8) {
                                PhotoPreparingFrame.this.snapshot.unfreeze(true);
                            } else if (c.getCommandType() == 6) {
                                PhotoPreparingFrame.this.snapshot.unfreeze(false);
                                canvas.removeCommand(sendCommand);
                                canvas.removeCommand(retryCommand);
                                canvas.addCommand(okCommand);
                                canvas.addCommand(cancelCommand);
                            }
                            System.gc();
                        }
                    });
                    PhotoPreparingFrame.this.mPlayer.start();
                    PhotoPreparingFrame.this.mPlayer.addPlayerListener(new PlayerListener(){

                        public void playerUpdate(Player player, String event, Object eventData) {
                            LogUtil.outMessage("event = " + event);
                            if (event.equals("SHOOTING_STOPPED")) {
                                try {
                                    if (eventData == null) {
                                        Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                                        PhotoPreparingFrame.this.closePlayer();
                                        MidletMain.screen.setActiveWindow((this).PhotoPreparingFrame.this.s_prevWindow);
                                        Handler.showError(Localization.getMessage("PHONE_SUPPORT_EXCEPTION"));
                                        return;
                                    }
                                    String fileName = (String)eventData;
                                    if (fileName.indexOf("/") != -1) {
                                        fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                                    }
                                    LogUtil.outMessage("Connecting file: " + MidletMain.incomingFilesFolder.concat(fileName));
                                    FileConnection fileConnection = (FileConnection)Connector.open((String)"file://".concat(MidletMain.incomingFilesFolder.concat(fileName)), (int)1);
                                    LogUtil.outMessage("Connected: " + fileConnection.getPath());
                                    String fileLocation = fileConnection.getPath();
                                    long fileSize = fileConnection.fileSize();
                                    if (fileName != null && accountRoot.getStatusIndex() != 0) {
                                        final DirectConnection directConnection = accountRoot.getDirectConnectionInstance();
                                        directConnection.setIsReceivingFile(false);
                                        directConnection.setTransactionInfo(StringUtil.stringToByteArray(fileName, true), fileLocation, fileSize, (this).PhotoPreparingFrame.this.buddyId);
                                        directConnection.generateCookie();
                                        accountRoot.getTransactionManager().addTransaction(directConnection);
                                        new Thread(){

                                            public void run() {
                                                try {
                                                    directConnection.sendFile();
                                                }
                                                catch (IOException ex) {
                                                    LogUtil.outMessage("IOException: " + ex.getMessage(), true);
                                                }
                                                catch (InterruptedException ex) {
                                                    LogUtil.outMessage("InterruptedException: " + ex.getMessage(), true);
                                                }
                                            }
                                        }.start();
                                        (this).accountRoot.getTransactionsFrame().transactionItemFrame = new TransactionItemFrame(directConnection);
                                        (this).accountRoot.getTransactionsFrame().transactionItemFrame.s_prevWindow = accountRoot.getTransactionsFrame();
                                        MidletMain.screen.setActiveWindow((this).accountRoot.getTransactionsFrame().transactionItemFrame);
                                    }
                                    Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                                    PhotoPreparingFrame.this.closePlayer();
                                }
                                catch (Throwable ex) {
                                    Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                                    PhotoPreparingFrame.this.closePlayer();
                                    MidletMain.screen.setActiveWindow((this).PhotoPreparingFrame.this.s_prevWindow);
                                    Handler.showError(Localization.getMessage("LOCAL_FILE_IO_EXCEPTION").concat(" ").concat(ex.getMessage()));
                                }
                            } else if (event.equals("STORAGE_ERROR")) {
                                Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                                PhotoPreparingFrame.this.closePlayer();
                                MidletMain.screen.setActiveWindow((this).PhotoPreparingFrame.this.s_prevWindow);
                                Handler.showError(Localization.getMessage("LOCAL_FILE_IO_EXCEPTION").concat(" STORAGE_EXCEPTION"));
                            } else if (event.equals("WAITING_UNFREEZE")) {
                                canvas.removeCommand(okCommand);
                                canvas.removeCommand(cancelCommand);
                                canvas.addCommand(sendCommand);
                                canvas.addCommand(retryCommand);
                            }
                        }
                    });
                    Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)canvas);
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
        };
        Pane pane = new Pane(null, false);
        Label label1 = new Label(Localization.getMessage("SELECT_RESOLUTION"));
        label1.setFocusable(false);
        label1.setTitle(true);
        pane.addItem(label1);
        this.resolutionsGroup = new RadioGroup();
        this.createPlayer();
        this.camera = (CameraControl)this.mPlayer.getControl("javax.microedition.amms.control.camera.CameraControl");
        int[] resolutions = this.camera.getSupportedStillResolutions();
        for (int c = 0; c < resolutions.length; c += 2) {
            Radio radio = new Radio(resolutions[c] + " x " + resolutions[c + 1], false);
            radio.setFocusable(true);
            if (c == 0) {
                radio.setFocused(true);
            }
            this.resolutionsGroup.addRadio(radio);
            pane.addItem(radio);
        }
        this.resolutionsGroup.setCombed(0);
        String[] exposures = this.camera.getSupportedExposureModes();
        if (exposures != null && exposures.length > 0) {
            this.exposureModesGroup = new RadioGroup();
            label2 = new Label(Localization.getMessage("SELECT_EXPOSURE"));
            label2.setFocusable(false);
            label2.setTitle(true);
            pane.addItem(label2);
            for (int c = 0; c < exposures.length; ++c) {
                String title = Localization.getMessage(exposures[c].toUpperCase());
                if (title.equals("???")) {
                    title = exposures[c];
                }
                Radio radio = new Radio(title, false);
                radio.setFocusable(true);
                this.exposureModesGroup.addRadio(radio);
                pane.addItem(radio);
            }
            this.exposureModesGroup.setCombed(0);
        }
        this.flash = (FlashControl)this.mPlayer.getControl("javax.microedition.amms.control.camera.FlashControl");
        if (this.flash != null) {
            int[] modes = this.flash.getSupportedModes();
            this.flashModesGroup = new RadioGroup();
            Label label22 = new Label(Localization.getMessage("SELECT_FLASH_MODE"));
            label22.setFocusable(false);
            label22.setTitle(true);
            pane.addItem(label22);
            for (int c = 0; c < modes.length; ++c) {
                String title = "Mode-" + modes[c];
                if (modes[c] == 2) {
                    title = Localization.getMessage("AUTO");
                } else if (modes[c] == 3) {
                    title = Localization.getMessage("AUTO_WITH_REDEYEREDUCE");
                } else if (modes[c] == 6) {
                    title = Localization.getMessage("FILLIN");
                } else if (modes[c] == 4) {
                    title = Localization.getMessage("FORCE");
                } else if (modes[c] == 5) {
                    title = Localization.getMessage("FORCE_WITH_REDEYEREDUCE");
                } else if (modes[c] == 1) {
                    title = Localization.getMessage("OFF");
                }
                Radio radio = new Radio(title, false);
                radio.setFocusable(true);
                this.flashModesGroup.addRadio(radio);
                pane.addItem(radio);
            }
            this.flashModesGroup.setCombed(0);
        }
        this.focus = (FocusControl)this.mPlayer.getControl("javax.microedition.amms.control.camera.FocusControl");
        if (this.focus != null) {
            label2 = new Label(Localization.getMessage("SELECT_FOCUS_MODE"));
            label2.setFocusable(false);
            label2.setTitle(true);
            pane.addItem(label2);
            if (this.focus.isAutoFocusSupported()) {
                this.isAutoFocus = new Check(Localization.getMessage("AUTO_FOCUS"), true);
                this.isAutoFocus.setFocusable(true);
                pane.addItem(this.isAutoFocus);
            }
            if (this.focus.isMacroSupported()) {
                this.isMacroFocus = new Check(Localization.getMessage("MACRO_FOCUS"), false);
                this.isMacroFocus.setFocusable(true);
                pane.addItem(this.isMacroFocus);
            }
        }
        this.setGObject(pane);
    }

    public final void createPlayer() {
        if (this.mPlayer != null) {
            this.closePlayer();
        }
        try {
            this.mPlayer = Manager.createPlayer((String)"capture://video");
            this.mPlayer.realize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void closePlayer() {
        try {
            try {
                this.mPlayer.stop();
            }
            catch (MediaException ex) {
                // empty catch block
            }
            this.mPlayer.deallocate();
            this.mPlayer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
        MidletMain.isPhotoActive = false;
    }
}

