/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.ChatItem;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.ListEvent;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.rms.RecordStore;

public class HistoryFrame
extends Window {
    private List list;
    private Pane pane;
    private ChatItem chatItem;
    private Soft chatSoft;
    private Soft listSoft;

    public HistoryFrame(final String accType, final String buddyId) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("HISTORY_FRAME_FOR").concat(" ").concat(buddyId));
        this.soft = this.listSoft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                try {
                    ((HistoryFrame)HistoryFrame.this).list.recordStore.closeRecordStore();
                }
                catch (Throwable ex) {
                    LogUtil.outMessage(HistoryFrame.this.getClass(), ex);
                }
                MidletMain.screen.setActiveWindow(HistoryFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("MENU"));
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("APPEND")){

            public void actionPerformed() {
                try {
                    ChatItem chatItem = MidletMain.historyRmsRenderer.getRmsItem(((HistoryFrame)HistoryFrame.this).list.recordStore.getRecord(((HistoryFrame)HistoryFrame.this).list.selectedIndex + 1), HistoryFrame.this.pane);
                    MidletMain.buffer = MidletMain.buffer + "\n[".concat(chatItem.buddyNick).concat("]\n ").concat(chatItem.itemDateTime).concat(" \n").concat(chatItem.text);
                }
                catch (Throwable ex) {
                    LogUtil.outMessage(HistoryFrame.this.getClass(), ex);
                }
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("COPY")){

            public void actionPerformed() {
                try {
                    ChatItem chatItem = MidletMain.historyRmsRenderer.getRmsItem(((HistoryFrame)HistoryFrame.this).list.recordStore.getRecord(((HistoryFrame)HistoryFrame.this).list.selectedIndex + 1), HistoryFrame.this.pane);
                    MidletMain.buffer = "[".concat(chatItem.buddyNick).concat("]\n ").concat(chatItem.itemDateTime).concat(" \n").concat(chatItem.text);
                }
                catch (Throwable ex) {
                    LogUtil.outMessage(HistoryFrame.this.getClass(), ex);
                }
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("CLEAR_HISTORY")){

            public void actionPerformed() {
                try {
                    String rsName = ((HistoryFrame)HistoryFrame.this).list.recordStore.getName();
                    ((HistoryFrame)HistoryFrame.this).list.recordStore.closeRecordStore();
                    RecordStore.deleteRecordStore((String)rsName);
                    ((HistoryFrame)HistoryFrame.this).list.recordStore = RecordStore.openRecordStore((String)rsName, (boolean)true);
                    ((HistoryFrame)HistoryFrame.this).list.recordStore.closeRecordStore();
                    ((HistoryFrame)HistoryFrame.this).list.items.removeAllElements();
                }
                catch (Throwable ex) {
                    LogUtil.outMessage(HistoryFrame.this.getClass(), ex);
                }
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("EXPORT_HISTORY")){

            public void actionPerformed() {
                String cmplTitle = "ERROR";
                String cmplMessage = "EXPORT_FAILED";
                String filePath = "";
                try {
                    filePath = MidletMain.incomingFilesFolder + accType + buddyId.hashCode() + ".html";
                    FileConnection file = (FileConnection)Connector.open((String)("file://" + filePath));
                    LogUtil.outMessage("Export to: file://" + filePath + "\n" + file.getPath());
                    if (file.exists()) {
                        file.delete();
                    }
                    file.create();
                    DataOutputStream outputStream = file.openDataOutputStream();
                    outputStream.write("<html>\n\t<head>\n".getBytes());
                    outputStream.write("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html\"; charset=\"UTF-8\">\n".getBytes());
                    outputStream.write("\t\t<meta name=\"Generator\" content=\"TomClaw Mandarin IM\">\n".getBytes());
                    outputStream.write(("\t\t<meta name=\"author\" content=\"" + buddyId + "\">\n").getBytes());
                    outputStream.write("\t\t<style type=\"text/css\">\n".getBytes());
                    outputStream.write("\t\t\t.o { color: blue; }\n".getBytes());
                    outputStream.write("\t\t\t.i { color: red; }\n".getBytes());
                    outputStream.write("\t\t\t.t { color: green; font-style: italic; }\n".getBytes());
                    outputStream.write("\t\t\t.m { color: black; }\n".getBytes());
                    outputStream.write("\t\t</style>\n".getBytes());
                    outputStream.write(("\t\t<title>" + buddyId + "</title>\n").getBytes());
                    outputStream.write("\t</head>\n\t<body>\n".getBytes());
                    try {
                        for (int c = 0; c < ((HistoryFrame)HistoryFrame.this).list.items.size(); ++c) {
                            ChatItem chatItem = MidletMain.historyRmsRenderer.getRmsItem(((HistoryFrame)HistoryFrame.this).list.recordStore.getRecord(c + 1), HistoryFrame.this.pane);
                            outputStream.write(("\t\t<div class=\"" + (chatItem.buddyId.equals(buddyId) ? "o" : "i") + "\"><b>").getBytes());
                            outputStream.write(StringUtil.stringToByteArray(chatItem.buddyNick + " [" + chatItem.buddyId + "]", true));
                            outputStream.write("</b></div>\n".getBytes());
                            outputStream.write(("\t\t<div class=\"t\">" + chatItem.itemDateTime + "</div>\n").getBytes());
                            outputStream.write("\t\t<div class=\"m\">".getBytes());
                            outputStream.write(StringUtil.stringToByteArray(StringUtil.replace(chatItem.text, "\n", "<br>"), true));
                            outputStream.write("</div>".getBytes());
                            outputStream.write("<hr>\n\n".getBytes());
                        }
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    outputStream.write("\n\t</body>\n</html>".getBytes());
                    outputStream.close();
                    file.close();
                    cmplTitle = "COMPLETE";
                    cmplMessage = "EXPORT_COMPLETE";
                }
                catch (Throwable ex) {
                    LogUtil.outMessage("Export error: " + ex.getMessage());
                }
                Handler.showDialog(Localization.getMessage(cmplTitle), Localization.getMessage(cmplMessage) + " " + filePath);
            }
        });
        this.list = new List(accType + buddyId.hashCode() + ".his");
        this.list.listRmsRenderer = MidletMain.historyRmsRenderer;
        this.list.listEvent = new ListEvent(){

            public void actionPerformed(ListItem li) {
                try {
                    if (HistoryFrame.this.pane == null) {
                        HistoryFrame.this.initPane();
                    } else {
                        ((HistoryFrame)HistoryFrame.this).pane.items.removeAllElements();
                    }
                    HistoryFrame.this.setGObject(HistoryFrame.this.pane);
                    HistoryFrame.this.chatItem = MidletMain.historyRmsRenderer.getRmsItem(((HistoryFrame)HistoryFrame.this).list.recordStore.getRecord(((HistoryFrame)HistoryFrame.this).list.selectedIndex + 1), HistoryFrame.this.pane);
                    HistoryFrame.this.pane.addItem(HistoryFrame.this.chatItem);
                    HistoryFrame.this.soft = HistoryFrame.this.chatSoft;
                }
                catch (Throwable ex) {
                    LogUtil.outMessage(HistoryFrame.this.getClass(), ex);
                }
            }
        };
        this.setGObject(this.list);
    }

    public void initPane() {
        this.pane = new Pane(this, true);
        this.chatSoft = new Soft(MidletMain.screen);
        this.chatSoft.leftSoft = new PopupItem(Localization.getMessage("NEXT")){

            public void actionPerformed() {
                if (((HistoryFrame)HistoryFrame.this).list.selectedIndex < ((HistoryFrame)HistoryFrame.this).list.items.size() - 1) {
                    ++((HistoryFrame)HistoryFrame.this).list.selectedIndex;
                    ((HistoryFrame)HistoryFrame.this).list.listEvent.actionPerformed(null);
                }
            }
        };
        this.chatSoft.rightSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                HistoryFrame.this.soft = HistoryFrame.this.listSoft;
                HistoryFrame.this.setGObject(HistoryFrame.this.list);
            }
        };
    }
}

