/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.core.IconsType;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.main.TransactionItemFrame;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.ListEvent;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import com.tomclaw.utils.TimeUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class FileBrowserFrame
extends Window {
    private List filesList = null;
    private FileConnection fileConnection;
    private String systemPath = "";
    private final int manType;

    public FileBrowserFrame(final int manType, final AccountRoot accountRoot, final String buddyId) {
        super(MidletMain.screen);
        PopupItem menuItem;
        PopupItem openItem;
        this.manType = manType;
        this.header = new Header(Localization.getMessage("FILE_BROWSER_FRAME"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = openItem = new PopupItem(Localization.getMessage("OPEN_ITEM")){

            public void actionPerformed() {
                ((FileBrowserFrame)FileBrowserFrame.this).filesList.listEvent.actionPerformed(null);
            }
        };
        this.soft.rightSoft = menuItem = new PopupItem(Localization.getMessage("MENU_ITEM"));
        PopupItem backItem = new PopupItem(Localization.getMessage("CANCEL_ITEM")){

            public void actionPerformed() {
                if (FileBrowserFrame.this.s_prevWindow != null) {
                    MidletMain.screen.setActiveWindow(FileBrowserFrame.this.s_prevWindow);
                }
            }
        };
        this.soft.rightSoft.addSubItem(backItem);
        if (manType == 0) {
            PopupItem infoPopupItem = new PopupItem(Localization.getMessage("INFO_ITEM")){

                public void actionPerformed() {
                    boolean isFolder;
                    String __selectedString = ((ListItem)((FileBrowserFrame)FileBrowserFrame.this).filesList.items.elementAt((int)((FileBrowserFrame)FileBrowserFrame.this).filesList.selectedIndex)).title;
                    if (__selectedString.hashCode() != "...".hashCode() && !(isFolder = __selectedString.endsWith("/"))) {
                        String filePath = "/".concat(FileBrowserFrame.this.systemPath).concat(__selectedString);
                        try {
                            FileConnection fileConnection = (FileConnection)Connector.open((String)"file://".concat(filePath), (int)1);
                            if (!fileConnection.exists()) {
                                return;
                            }
                            String fileInfoString = Localization.getMessage("FILE_NAME").concat(":").concat(__selectedString).concat("\n ").concat(Localization.getMessage("FILE_SIZE")).concat(":").concat(fileConnection.fileSize() + " KiB").concat("\n").concat(Localization.getMessage("MOD_DATETIME")).concat(":").concat(TimeUtil.getDateString(fileConnection.lastModified(), true)).concat("\n ").concat(Localization.getMessage("FILE_FOLDER")).concat(":").concat(filePath).concat("\n");
                            Handler.showInfo(fileInfoString);
                        }
                        catch (IOException ex) {
                            LogUtil.outMessage("Local file error: " + ex.getMessage(), true);
                        }
                    }
                }
            };
            this.soft.rightSoft.addSubItem(infoPopupItem);
        }
        if (manType == 1) {
            PopupItem selectItem = new PopupItem(Localization.getMessage("SELECT_ITEM")){

                public void actionPerformed() {
                    String __selectedString = ((ListItem)((FileBrowserFrame)FileBrowserFrame.this).filesList.items.elementAt((int)((FileBrowserFrame)FileBrowserFrame.this).filesList.selectedIndex)).title;
                    if (__selectedString.hashCode() != "...".hashCode()) {
                        boolean isFolder = __selectedString.endsWith("/");
                        if (isFolder && manType == 1) {
                            MidletMain.settingsFrame.acceptFilesFolder.setText("/".concat(FileBrowserFrame.this.systemPath).concat(__selectedString));
                            MidletMain.settingsFrame.acceptFilesFolder.updateCaption();
                            MidletMain.settingsFrame.prepareGraphics();
                            MidletMain.screen.setActiveWindow(MidletMain.settingsFrame);
                        }
                    } else if (manType == 1) {
                        MidletMain.settingsFrame.acceptFilesFolder.setText("/".concat(FileBrowserFrame.this.systemPath));
                        MidletMain.settingsFrame.acceptFilesFolder.updateCaption();
                        MidletMain.settingsFrame.prepareGraphics();
                        MidletMain.screen.setActiveWindow(MidletMain.settingsFrame);
                    }
                }
            };
            this.soft.rightSoft.addSubItem(selectItem);
        }
        this.filesList = new List();
        this.filesList.listEvent = new ListEvent(){

            public void actionPerformed(ListItem li) {
                String __selectedString = ((ListItem)((FileBrowserFrame)FileBrowserFrame.this).filesList.items.elementAt((int)((FileBrowserFrame)FileBrowserFrame.this).filesList.selectedIndex)).title;
                if (__selectedString.hashCode() != "...".hashCode()) {
                    boolean isFolder = __selectedString.endsWith("/");
                    if (!isFolder) {
                        if (manType == 0) {
                            String filePath = "/".concat(FileBrowserFrame.this.systemPath).concat(__selectedString);
                            try {
                                FileConnection fileConnection = (FileConnection)Connector.open((String)"file://".concat(filePath), (int)1);
                                if (!fileConnection.exists()) {
                                    return;
                                }
                                String fileName = __selectedString;
                                String fileLocation = "/".concat(FileBrowserFrame.this.systemPath);
                                long fileSize = fileConnection.fileSize();
                                if (fileName != null && accountRoot.getStatusIndex() != 0) {
                                    final DirectConnection directConnection = accountRoot.getDirectConnectionInstance();
                                    directConnection.setIsReceivingFile(false);
                                    directConnection.setTransactionInfo(StringUtil.stringToByteArray(fileName, true), fileLocation, fileSize, buddyId);
                                    directConnection.generateCookie();
                                    accountRoot.getTransactionManager().addTransaction(directConnection);
                                    new Thread(){

                                        public void run() {
                                            try {
                                                directConnection.sendFile();
                                            }
                                            catch (Throwable ex) {
                                                LogUtil.outMessage("IOException: " + ex.getMessage(), true);
                                            }
                                        }
                                    }.start();
                                    accountRoot.getTransactionsFrame().transactionItemFrame = new TransactionItemFrame(directConnection);
                                    accountRoot.getTransactionsFrame().transactionItemFrame.s_prevWindow = accountRoot.getTransactionsFrame();
                                    MidletMain.screen.setActiveWindow(accountRoot.getTransactionsFrame().transactionItemFrame);
                                }
                                MidletMain.screen.setActiveWindow(FileBrowserFrame.this.s_prevWindow);
                                return;
                            }
                            catch (IOException ex) {
                                LogUtil.outMessage("Local file error: " + ex.getMessage(), true);
                            }
                        }
                    } else {
                        FileBrowserFrame.this.systemPath = FileBrowserFrame.this.systemPath + __selectedString;
                        FileBrowserFrame.this.readLevel(FileBrowserFrame.this.systemPath);
                    }
                } else {
                    FileBrowserFrame.this.getLowerLevel();
                    FileBrowserFrame.this.readLevel(FileBrowserFrame.this.systemPath);
                }
                MidletMain.screen.repaint(0);
            }
        };
        this.setGObject(this.filesList);
        this.readLevel(this.systemPath);
    }

    public void getLowerLevel() {
        String lastPath = new String();
        String newPath = "";
        for (int c = 0; c < this.systemPath.length(); ++c) {
            if (this.systemPath.charAt(c) != '/') continue;
            lastPath = newPath;
            char[] pathGet = new char[c];
            this.systemPath.getChars(0, c, pathGet, 0);
            newPath = String.valueOf(pathGet);
        }
        this.systemPath = lastPath + "/";
    }

    public final boolean readLevel(String levelPath) {
        if (levelPath.length() > 1) {
            return this.readFiles(levelPath);
        }
        this.readRoots();
        return true;
    }

    public boolean readFiles(String filePath) {
        try {
            this.fileConnection = (FileConnection)Connector.open((String)("file:///" + filePath), (int)1);
            LogUtil.outMessage("Establising: file:///" + filePath + ". Is direcory: " + this.fileConnection.isDirectory());
            if (this.fileConnection.isDirectory()) {
                this.outEnumeration(this.fileConnection.list());
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void readRoots() {
        this.outEnumeration(FileSystemRegistry.listRoots());
        this.systemPath = "";
    }

    public void outEnumeration(Enumeration enumeration) {
        try {
            Vector<ListItem> files = new Vector<ListItem>();
            this.filesList.items.removeAllElements();
            ListItem upItem = new ListItem("...");
            upItem.imageFileHash = IconsType.HASH_FILES;
            upItem.imageIndex = 8;
            this.filesList.addItem(upItem);
            while (enumeration.hasMoreElements()) {
                String nextelement = (String)enumeration.nextElement();
                boolean isDirectory = nextelement.charAt(nextelement.length() - 1) == '/';
                int image = isDirectory && this.systemPath.length() > 1 ? 6 : (!isDirectory ? 7 : 5);
                ListItem menuItem = new ListItem(nextelement);
                menuItem.imageFileHash = IconsType.HASH_FILES;
                menuItem.imageIndex = image;
                if (image != 7) {
                    this.filesList.addItem(menuItem);
                    continue;
                }
                files.addElement(menuItem);
            }
            switch (this.manType) {
                case 0: {
                    break;
                }
                case 1: {
                    files = new Vector();
                    break;
                }
                case 2: {
                    files = new Vector();
                    break;
                }
            }
            for (int c = 0; c < files.size(); ++c) {
                this.filesList.addItem((ListItem)files.elementAt(c));
            }
            this.filesList.selectedIndex = 0;
            if (this.filesList.items.size() >= 0) {
                this.filesList.selectedIndex = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

