/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.main.ChatTab;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.main.SmilesFrame;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppItem;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import com.tomclaw.tcuilite.ChatItem;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.tcuilite.KeyEvent;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PaneEvent;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Tab;
import com.tomclaw.tcuilite.TabEvent;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.tcuilite.smiles.Smiles;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import com.tomclaw.utils.TimeUtil;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ChatFrame
extends Window {
    public Tab chatTabs;
    public Pane chatPane;
    public TextBox textBox;
    public int maxSize = 2048;
    public PopupItem hyperlinkPopupItem;
    public PopupItem authAcceptPopupItem;
    public PopupItem replyItem;
    public char[] http_den_sym = new char[]{' ', '\n', '\r', '\t', '!', '\"', '#', '\'', '*', ',', ';', '<', '>', '[', ']', '^', '`', '{', '|', '}'};

    public ChatFrame() {
        super(MidletMain.screen);
        this.addKeyEvent(new KeyEvent(0, "KEY_WRITE", true){

            public void actionPerformed() {
                ChatTab chatTab = ChatFrame.this.getSelectedChatTab();
                if (chatTab == null) {
                    return;
                }
                ChatFrame.this.textBox.setTitle(chatTab.title);
                chatTab.accountRoot.sendTypingStatus(chatTab.buddyItem.getUserId(), true);
                Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)ChatFrame.this.textBox);
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_COPY", true){

            public void actionPerformed() {
                if (!ChatFrame.this.chatPane.items.isEmpty() && ChatFrame.this.chatPane.psvLstFocusedIndex >= 0 && ChatFrame.this.chatPane.psvLstFocusedIndex < ChatFrame.this.chatPane.items.size()) {
                    ChatItem chatItem = (ChatItem)ChatFrame.this.chatPane.items.elementAt(ChatFrame.this.chatPane.psvLstFocusedIndex);
                    MidletMain.buffer = "[".concat(chatItem.buddyNick).concat("]\n ").concat(chatItem.itemDateTime).concat(" \n").concat(ChatFrame.getMessageText(chatItem));
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_PASTE", true){

            public void actionPerformed() {
                ChatTab chatTab = ChatFrame.this.getSelectedChatTab();
                if (chatTab == null) {
                    return;
                }
                ChatFrame.this.textBox.setTitle(chatTab.title);
                chatTab.accountRoot.sendTypingStatus(chatTab.buddyItem.getUserId(), true);
                ChatFrame.this.textBox.setString(MidletMain.buffer);
                Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)ChatFrame.this.textBox);
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_APPEND", true){

            public void actionPerformed() {
                if (!ChatFrame.this.chatPane.items.isEmpty() && ChatFrame.this.chatPane.psvLstFocusedIndex >= 0 && ChatFrame.this.chatPane.psvLstFocusedIndex < ChatFrame.this.chatPane.items.size()) {
                    ChatItem chatItem = (ChatItem)ChatFrame.this.chatPane.items.elementAt(ChatFrame.this.chatPane.psvLstFocusedIndex);
                    MidletMain.buffer = MidletMain.buffer + "\n[".concat(chatItem.buddyNick).concat("]\n ").concat(chatItem.itemDateTime).concat(" \n").concat(ChatFrame.getMessageText(chatItem));
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_CLEARCHAT", true){

            public void actionPerformed() {
                ((ChatTab)ChatFrame.this.chatTabs.items.elementAt((int)ChatFrame.this.chatTabs.selectedIndex)).chatItems.removeAllElements();
                System.gc();
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_CLOSECHAT", true){

            public void actionPerformed() {
                ChatTab chatTab = (ChatTab)ChatFrame.this.chatTabs.items.elementAt(ChatFrame.this.chatTabs.selectedIndex);
                if (chatTab.buddyItem instanceof XmppItem && !chatTab.resource.resource.equals("") && MidletMain.isRemoveResources && chatTab.resource.statusIndex == XmppStatusUtil.offlineIndex) {
                    ((XmppItem)chatTab.buddyItem).removeResource(chatTab.resource.resource);
                    ((XmppItem)chatTab.buddyItem).updateUiData();
                }
                chatTab.chatItems = null;
                ChatFrame.this.removeChatTab(ChatFrame.this.chatTabs.selectedIndex);
                if (ChatFrame.this.chatTabs.items.isEmpty()) {
                    MidletMain.screen.setActiveWindow(ChatFrame.this.s_prevWindow);
                    ChatFrame.this.s_prevWindow.s_nextWindow = null;
                    return;
                }
                if (ChatFrame.this.chatTabs.selectedIndex >= ChatFrame.this.chatTabs.items.size() - 1) {
                    ChatFrame.this.chatTabs.tabEvent.stateChanged(ChatFrame.this.chatTabs.selectedIndex, ChatFrame.this.chatTabs.items.size() - 1, ChatFrame.this.chatTabs.items.size());
                    ChatFrame.this.chatTabs.selectedIndex = ChatFrame.this.chatTabs.items.size() - 1;
                } else {
                    ChatFrame.this.chatTabs.tabEvent.stateChanged(ChatFrame.this.chatTabs.selectedIndex, ChatFrame.this.chatTabs.selectedIndex, ChatFrame.this.chatTabs.items.size());
                }
                ChatFrame.this.chatTabs.xOffset = ChatFrame.this.chatTabs.totalWidth > MidletMain.screen.getWidth() ? ChatFrame.this.chatTabs.totalWidth - MidletMain.screen.getWidth() : 0;
                System.gc();
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_REPLY", true){

            public void actionPerformed() {
                if (!ChatFrame.this.chatPane.items.isEmpty() && ChatFrame.this.chatPane.psvLstFocusedIndex >= 0 && ChatFrame.this.chatPane.psvLstFocusedIndex < ChatFrame.this.chatPane.items.size()) {
                    ChatItem chatItem = (ChatItem)ChatFrame.this.chatPane.items.elementAt(ChatFrame.this.chatPane.psvLstFocusedIndex);
                    ChatTab chatTab = ChatFrame.this.getSelectedChatTab();
                    if (chatTab == null) {
                        return;
                    }
                    ChatFrame.this.textBox.setTitle(chatTab.title);
                    ChatFrame.this.textBox.setString(chatItem.buddyNick.concat(": "));
                    Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)ChatFrame.this.textBox);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_CHAT_SCREEN_TOP", true){

            public void actionPerformed() {
                ChatFrame.this.chatPane.yOffset = 0;
                if (!ChatFrame.this.chatPane.items.isEmpty()) {
                    ChatFrame.this.chatPane.setFocused(0);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_CHAT_SCREEN_BOTTOM", true){

            public void actionPerformed() {
                int maxOffset = ChatFrame.this.chatPane.getTotalHeight() - ChatFrame.this.chatPane.height;
                if (maxOffset < 0) {
                    maxOffset = 0;
                }
                ChatFrame.this.chatPane.yOffset = maxOffset;
                if (!ChatFrame.this.chatPane.items.isEmpty()) {
                    ChatFrame.this.chatPane.setFocused(ChatFrame.this.chatPane.items.size() - 1);
                }
            }
        });
        this.textBox = new TextBox("", "", this.maxSize, 0);
        this.textBox.addCommand(new Command(Localization.getMessage("SEND"), 4, 4));
        this.textBox.addCommand(new Command(Localization.getMessage("BACK"), 2, 3));
        this.textBox.addCommand(new Command(Localization.getMessage("SMILES"), 5, 2));
        this.textBox.addCommand(new Command(Localization.getMessage("CLEAR"), 7, 1));
        this.textBox.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                switch (c.getCommandType()) {
                    case 4: {
                        ChatTab chatTab = ChatFrame.this.getSelectedChatTab();
                        if (chatTab == null) {
                            return;
                        }
                        if (!StringUtil.isEmptyOrNull(ChatFrame.this.textBox.getString()) && chatTab.accountRoot.getStatusIndex() != -1) {
                            byte[] msgCookie = chatTab.accountRoot.sendMessage(chatTab.buddyItem, ChatFrame.this.textBox.getString(), chatTab.resource == null ? "" : chatTab.resource.resource);
                            if (!(chatTab.buddyItem instanceof XmppItem) || !((XmppItem)chatTab.buddyItem).isGroupChat || chatTab.resource != null && chatTab.resource.resource.length() != 0) {
                                ChatFrame.this.addChatItem(chatTab, null, ChatFrame.this.textBox.getString(), msgCookie, 7, false);
                            }
                            ChatFrame.this.textBox.setString("");
                        }
                        ChatFrame.this.prepareGraphics();
                        MidletMain.screen.activeWindow = MidletMain.chatFrame;
                        Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                        MidletMain.screen.setFullScreenMode(true);
                        chatTab.accountRoot.sendTypingStatus(chatTab.buddyItem.getUserId(), false);
                        break;
                    }
                    case 7: {
                        ChatFrame.this.textBox.setString("");
                        break;
                    }
                    case 2: {
                        MidletMain.screen.activeWindow = MidletMain.chatFrame;
                        ChatTab chatTab = ChatFrame.this.getSelectedChatTab();
                        if (chatTab == null) {
                            return;
                        }
                        ChatFrame.this.prepareGraphics();
                        Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                        MidletMain.screen.setFullScreenMode(true);
                        chatTab.accountRoot.sendTypingStatus(chatTab.buddyItem.getUserId(), false);
                        break;
                    }
                    case 5: {
                        if (MidletMain.smilesFrame == null) {
                            MidletMain.smilesFrame = new SmilesFrame();
                        }
                        Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                        MidletMain.smilesFrame.prepareGraphics();
                        MidletMain.screen.setFullScreenMode(true);
                        MidletMain.screen.activeWindow = MidletMain.smilesFrame;
                        MidletMain.screen.repaint(0);
                    }
                }
            }
        });
        this.soft = new Soft(MidletMain.screen);
        this.hyperlinkPopupItem = new PopupItem(Localization.getMessage("GO_TO_HYPERLINK"));
        this.replyItem = new PopupItem(Localization.getMessage("REPLY")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_REPLY").actionPerformed();
            }
        };
        this.authAcceptPopupItem = new PopupItem(Localization.getMessage("AUTH_ACCEPT")){

            public void actionPerformed() {
                ChatTab chatTab;
                if (!ChatFrame.this.chatPane.items.isEmpty() && ChatFrame.this.chatPane.psvLstFocusedIndex >= 0 && ChatFrame.this.chatPane.psvLstFocusedIndex < ChatFrame.this.chatPane.items.size() && (chatTab = ChatFrame.this.getSelectedChatTab()) != null) {
                    chatTab.accountRoot.acceptAuthorization(chatTab.buddyItem);
                }
            }
        };
        this.replyItem = new PopupItem(Localization.getMessage("REPLY")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_REPLY").actionPerformed();
            }
        };
        this.soft.leftSoft = new PopupItem(Localization.getMessage("MENU")){

            public void actionPerformed() {
                ChatTab chatTab;
                boolean isLinkPresent = false;
                if (!ChatFrame.this.hyperlinkPopupItem.isEmpty()) {
                    ChatFrame.this.hyperlinkPopupItem.subPopup.items.removeAllElements();
                    ChatFrame.this.hyperlinkPopupItem.subPopup.selectedIndex = 0;
                }
                ChatItem chatItem = null;
                if (!ChatFrame.this.chatPane.items.isEmpty() && ChatFrame.this.chatPane.psvLstFocusedIndex >= 0 && ChatFrame.this.chatPane.psvLstFocusedIndex < ChatFrame.this.chatPane.items.size()) {
                    int linkPoint;
                    chatItem = (ChatItem)ChatFrame.this.chatPane.items.elementAt(ChatFrame.this.chatPane.psvLstFocusedIndex);
                    int offset = 0;
                    String msgText = chatItem.bbResult.originalString;
                    while ((linkPoint = msgText.indexOf("http://", offset)) != -1) {
                        int linkEnd = msgText.length();
                        for (int c = 0; c < ChatFrame.this.http_den_sym.length; ++c) {
                            int t_linkEnd = Math.min(linkEnd, msgText.indexOf(ChatFrame.this.http_den_sym[c], linkPoint));
                            if (t_linkEnd <= 0) continue;
                            linkEnd = t_linkEnd;
                        }
                        if (linkPoint < 0) {
                            linkPoint = 0;
                        }
                        final String hyperlink = msgText.substring(linkPoint, linkEnd);
                        offset = linkEnd;
                        if (hyperlink.length() >= 256) continue;
                        isLinkPresent = true;
                        ChatFrame.this.hyperlinkPopupItem.addSubItem(new PopupItem(hyperlink){

                            public void actionPerformed() {
                                try {
                                    MidletMain.midletMain.platformRequest(hyperlink);
                                }
                                catch (ConnectionNotFoundException ex) {
                                    LogUtil.outMessage("Unable to go to " + hyperlink + " cause " + ex.getMessage());
                                }
                            }
                        });
                        LogUtil.outMessage(hyperlink);
                    }
                }
                if (ChatFrame.this.soft.leftSoft.subPopup.items.contains(ChatFrame.this.hyperlinkPopupItem)) {
                    if (!isLinkPresent) {
                        ChatFrame.this.soft.leftSoft.subPopup.items.removeElement(ChatFrame.this.hyperlinkPopupItem);
                    }
                } else if (isLinkPresent) {
                    ChatFrame.this.soft.leftSoft.subPopup.items.insertElementAt(ChatFrame.this.hyperlinkPopupItem, 1);
                }
                if (ChatFrame.this.soft.leftSoft.subPopup.items.contains(ChatFrame.this.authAcceptPopupItem)) {
                    if (chatItem == null || chatItem.itemType != 1) {
                        ChatFrame.this.soft.leftSoft.subPopup.items.removeElement(ChatFrame.this.authAcceptPopupItem);
                    }
                } else if (chatItem != null && chatItem.itemType == 1) {
                    ChatFrame.this.soft.leftSoft.subPopup.items.insertElementAt(ChatFrame.this.authAcceptPopupItem, 1);
                }
                if ((chatTab = ChatFrame.this.getSelectedChatTab()) != null) {
                    if (chatTab.buddyItem instanceof XmppItem && ((XmppItem)chatTab.buddyItem).isGroupChat) {
                        if (!ChatFrame.this.soft.leftSoft.subPopup.items.contains(ChatFrame.this.replyItem)) {
                            ChatFrame.this.soft.leftSoft.addSubItem(ChatFrame.this.replyItem);
                        }
                    } else if (!ChatFrame.this.soft.leftSoft.isEmpty()) {
                        ChatFrame.this.soft.leftSoft.subPopup.items.removeElement(ChatFrame.this.replyItem);
                    }
                }
            }
        };
        this.soft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("WRITE")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_WRITE").actionPerformed();
            }
        });
        this.soft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("CLEAR")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_CLEARCHAT").actionPerformed();
            }
        });
        this.soft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("COPY")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_COPY").actionPerformed();
            }
        });
        this.soft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("APPEND")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_APPEND").actionPerformed();
            }
        });
        this.soft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("PASTE")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_PASTE").actionPerformed();
            }
        });
        this.soft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("CLOSE")){

            public void actionPerformed() {
                ChatFrame.this.getKeyEvent("KEY_CLOSECHAT").actionPerformed();
            }
        });
        this.soft.rightSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(MidletMain.mainFrame);
            }
        };
        this.chatTabs = new Tab(this.screen);
        this.chatTabs.tabEvent = new TabEvent(){

            public void stateChanged(int prevIndex, int currIndex, int totlItems) {
                try {
                    LogUtil.outMessage("totlItems = " + totlItems);
                    LogUtil.outMessage("prevIndex = " + prevIndex);
                    ChatTab t_ChatTab = (ChatTab)ChatFrame.this.chatTabs.items.elementAt(currIndex);
                    if (t_ChatTab.chatItems == null) {
                        t_ChatTab.chatItems = new Vector();
                    }
                    ChatFrame.this.chatPane.items = t_ChatTab.chatItems;
                    ChatFrame.this.prepareGraphics();
                    ChatFrame.this.chatPane.yOffset = ChatFrame.this.chatPane.getTotalHeight() > ChatFrame.this.chatPane.getHeight() ? ChatFrame.this.chatPane.getTotalHeight() - ChatFrame.this.chatPane.getHeight() : 0;
                    if (!ChatFrame.this.chatPane.items.isEmpty()) {
                        ChatFrame.this.chatPane.setFocused(ChatFrame.this.chatPane.items.size() - 1);
                    }
                    LogUtil.outMessage("Focused index: " + ChatFrame.this.chatPane.getFocused());
                    String resource = null;
                    if (t_ChatTab.resource != null) {
                        resource = t_ChatTab.resource.resource;
                    }
                    t_ChatTab.accountRoot.setUnrMsgs(t_ChatTab.accountRoot.getUnrMsgs() - t_ChatTab.buddyItem.getUnreadCount(resource));
                    MidletMain.mainFrame.updateAccountsStatus();
                    t_ChatTab.buddyItem.setUnreadCount(0, resource);
                    t_ChatTab.buddyItem.updateUiData();
                    t_ChatTab.updateChatCaption();
                    ChatFrame.this.screen.repaint();
                }
                catch (Throwable ex1) {
                    LogUtil.outMessage("chatTabs.tabEvent: " + ex1.getMessage());
                }
            }
        };
        this.chatPane = new Pane(this, true);
        this.chatPane.setTouchOrientation(MidletMain.screen.isPointerEvents);
        this.chatPane.moveStep = Theme.font.getHeight() * 3;
        this.chatPane.actionPerformedEvent = new PaneEvent(){

            public void actionPerformed(PaneObject po) {
                ChatTab chatTab = ChatFrame.this.getSelectedChatTab();
                if (chatTab == null) {
                    return;
                }
                ChatFrame.this.textBox.setTitle(chatTab.title);
                chatTab.accountRoot.sendTypingStatus(chatTab.buddyItem.getUserId(), true);
                Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)ChatFrame.this.textBox);
                ChatFrame.this.textBox.getCaretPosition();
            }
        };
        this.chatTabs.setGObject(this.chatPane);
        this.setGObject(this.chatTabs);
    }

    public void addChatTab(ChatTab chatTab, boolean isSwitchTo) {
        this.chatTabs.addTabItem(chatTab);
        chatTab.buddyItem.updateUiData();
        if (isSwitchTo) {
            this.chatTabs.tabEvent.stateChanged(this.chatTabs.selectedIndex, this.chatTabs.items.size() - 1, this.chatTabs.items.size());
            this.chatTabs.selectedIndex = this.chatTabs.items.size() - 1;
            if (this.chatTabs.totalWidth > MidletMain.screen.getWidth()) {
                this.chatTabs.xOffset = this.chatTabs.totalWidth - MidletMain.screen.getWidth();
            }
        }
        MidletMain.mainFrame.s_nextWindow = this;
    }

    public void removeChatTab(ChatTab chatTab) {
        chatTab.buddyItem.updateUiData();
        this.chatTabs.items.removeElement(chatTab);
    }

    public void removeChatTab(int index) {
        try {
            ChatTab chatTab = (ChatTab)this.chatTabs.items.elementAt(index);
            this.chatTabs.items.removeElementAt(index);
            chatTab.buddyItem.updateUiData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ChatTab getChatTab(AccountRoot accountRoot, String buddyId, String resource, boolean isSwitchTo) {
        for (int c = 0; c < this.chatTabs.items.size(); ++c) {
            ChatTab chatTab = (ChatTab)this.chatTabs.items.elementAt(c);
            if (!chatTab.accountRoot.equals(accountRoot) || !chatTab.buddyItem.getUserId().equals(buddyId) || !(resource != null && (chatTab.resource != null && chatTab.resource.resource.equals(resource) || chatTab.resource == null && resource.equals(""))) && resource != null) continue;
            if (isSwitchTo) {
                this.chatTabs.tabEvent.stateChanged(this.chatTabs.selectedIndex, c, this.chatTabs.items.size());
                this.chatTabs.selectedIndex = c;
                if (this.chatTabs.totalWidth > MidletMain.screen.getWidth()) {
                    if (chatTab.x + chatTab.width > this.chatTabs.xOffset + MidletMain.screen.getWidth()) {
                        this.chatTabs.xOffset = chatTab.x + chatTab.width - MidletMain.screen.getWidth();
                    }
                    if (chatTab.x < this.chatTabs.xOffset) {
                        this.chatTabs.xOffset = chatTab.x;
                    }
                }
            }
            return chatTab;
        }
        return null;
    }

    public boolean addChatItem(ChatTab chatTab, String groupChatNick, String decMsg, byte[] msgCookie, int type, boolean isIncoming) {
        decMsg = StringUtil.replace(decMsg, "[", "\\[");
        decMsg = StringUtil.replace(decMsg, "]", "\\]");
        decMsg = Smiles.replaceSmilesForCodes(decMsg);
        decMsg = StringUtil.replace(decMsg, "\n", "[br/]");
        if (groupChatNick != null && chatTab.accountRoot instanceof XmppAccountRoot) {
            if (decMsg.startsWith("/me")) {
                decMsg = "[c=purple][i]".concat(groupChatNick).concat(decMsg.substring("/me".length(), decMsg.length())).concat("[/i][/c]");
            } else {
                String groupChatRealNick = ((XmppItem)chatTab.buddyItem).groupChatNick;
                if (decMsg.indexOf(groupChatRealNick) != -1) {
                    decMsg = "[c=red][b]".concat(decMsg).concat("[/b][/c]");
                }
            }
        }
        decMsg = "[p]".concat(decMsg).concat("[/p]");
        LogUtil.outMessage("Message: " + decMsg);
        ChatItem chatItem = new ChatItem(this.chatPane, decMsg);
        chatItem.dlvStatus = (byte)(isIncoming ? 3 : 0);
        chatItem.cookie = msgCookie;
        chatItem.itemType = type;
        if (groupChatNick == null) {
            if (chatTab.buddyItem instanceof XmppItem && ((XmppItem)chatTab.buddyItem).isGroupChat && chatTab.resource != null) {
                chatItem.buddyNick = isIncoming ? chatTab.resource.resource : ((XmppItem)chatTab.buddyItem).groupChatNick;
                chatItem.buddyId = isIncoming ? chatTab.resource.resource : ((XmppItem)chatTab.buddyItem).groupChatNick;
            } else {
                chatItem.buddyNick = isIncoming ? chatTab.buddyItem.getUserNick() : chatTab.accountRoot.getUserNick();
                chatItem.buddyId = isIncoming ? chatTab.buddyItem.getUserId() : chatTab.accountRoot.getUserId();
            }
        } else {
            chatItem.buddyNick = groupChatNick;
            chatItem.buddyId = groupChatNick;
        }
        chatItem.itemDateTime = TimeUtil.getTimeString(TimeUtil.getCurrentTimeGMT(), false);
        if (MidletMain.isStoreHistory && !MidletMain.getBoolean(MidletMain.uniquest, chatTab.accountRoot.getAccType() + chatItem.buddyId.hashCode(), "DISABLE_HISTORY")) {
            LogUtil.outMessage("History storing...");
            this.saveToHistory(chatTab.accountRoot.getAccType(), chatTab.buddyItem.getUserId(), chatItem);
        } else {
            LogUtil.outMessage("History storing disabled");
        }
        if (chatTab.chatItems == null) {
            chatTab.chatItems = new Vector();
        }
        chatTab.chatItems.addElement(chatItem);
        MidletMain.chatFrame.prepareGraphics();
        ChatTab tempChatTab = this.getSelectedChatTab();
        LogUtil.outMessage("Focused index: " + this.chatPane.psvLstFocusedIndex);
        LogUtil.outMessage("Items total:   " + this.chatPane.items.size());
        if (tempChatTab != null && tempChatTab.equals(chatTab) && this.chatPane.psvLstFocusedIndex == this.chatPane.items.size() - 2 || this.chatPane.items.size() == 1) {
            this.chatPane.yOffset = this.chatPane.getTotalHeight() > this.chatPane.getHeight() ? this.chatPane.getTotalHeight() - this.chatPane.getHeight() : 0;
            if (!this.chatPane.items.isEmpty()) {
                this.chatPane.setFocused(this.chatPane.items.size() - 1);
            } else {
                chatItem.setFocused(true);
            }
        }
        MidletMain.screen.repaint();
        try {
            if (tempChatTab != null && tempChatTab.equals(chatTab)) {
                return true;
            }
        }
        catch (Throwable ex1) {
            // empty catch block
        }
        return false;
    }

    public void msgAck(AccountRoot accountRoot, String buddyId, String resource, byte[] msgCookie, byte dlvStatus) {
        ChatTab chatTab = this.getChatTab(accountRoot, buddyId, resource);
        if (chatTab != null) {
            for (int i = 0; i < chatTab.chatItems.size(); ++i) {
                if (!ArrayUtil.equals(((ChatItem)chatTab.chatItems.elementAt((int)i)).cookie, msgCookie)) continue;
                ((ChatItem)chatTab.chatItems.elementAt((int)i)).dlvStatus = dlvStatus;
                return;
            }
        }
    }

    public void msgAck(AccountRoot accountRoot, byte[] msgCookie, byte dlvStatus) {
        for (int c = 0; c < this.chatTabs.items.size(); ++c) {
            ChatTab chatTab = (ChatTab)this.chatTabs.items.elementAt(c);
            if (!chatTab.accountRoot.equals(accountRoot)) continue;
            for (int i = 0; i < chatTab.chatItems.size(); ++i) {
                if (!ArrayUtil.equals(((ChatItem)chatTab.chatItems.elementAt((int)i)).cookie, msgCookie)) continue;
                ((ChatItem)chatTab.chatItems.elementAt((int)i)).dlvStatus = dlvStatus;
                return;
            }
        }
    }

    public ChatTab getChatTab(AccountRoot accountRoot, String buddyId, String resource) {
        return this.getChatTab(accountRoot, buddyId, resource, false);
    }

    public ChatTab getChatTab(String buddyId) {
        for (int c = 0; c < this.chatTabs.items.size(); ++c) {
            ChatTab chatTab = (ChatTab)this.chatTabs.items.elementAt(c);
            if (!chatTab.buddyItem.getUserId().equals(buddyId)) continue;
            return chatTab;
        }
        return null;
    }

    public ChatTab getSelectedChatTab() {
        try {
            return (ChatTab)this.chatTabs.items.elementAt(this.chatTabs.selectedIndex);
        }
        catch (Throwable ex1) {
            return null;
        }
    }

    public void updateChatTabBuddyes() {
        block0: for (int c = 0; c < this.chatTabs.items.size(); ++c) {
            boolean nextTab = false;
            ChatTab chatTab = (ChatTab)this.chatTabs.items.elementAt(c);
            Vector buddyItems = chatTab.accountRoot.getBuddyItems();
            for (int i = 0; i < buddyItems.size(); ++i) {
                GroupHeader groupHeader = (GroupHeader)buddyItems.elementAt(i);
                for (int j = 0; j < groupHeader.getChildsCount(); ++j) {
                    if (!((BuddyItem)groupHeader.getChilds().elementAt(j)).getUserId().equals(chatTab.buddyItem.getUserId())) continue;
                    chatTab.buddyItem = (BuddyItem)groupHeader.getChilds().elementAt(j);
                    LogUtil.outMessage(chatTab.buddyItem.getUserNick() + " (" + chatTab.buddyItem.getUserId() + ") updated in chat frame");
                    nextTab = true;
                    break;
                }
                if (nextTab) continue block0;
            }
        }
    }

    private void saveToHistory(String accType, String userId, ChatItem chatItem) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)(accType + userId.hashCode() + ".his"), (boolean)true);
            byte[] data = MidletMain.historyRmsRenderer.getRmsData(chatItem);
            recordStore.addRecord(data, 0, data.length);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            LogUtil.outMessage(this.getClass(), ex);
        }
    }

    public static String getMessageText(ChatItem chatItem) {
        return chatItem.bbResult.originalString;
    }
}

