/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyInfo;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Queue;
import com.tomclaw.mandarin.core.QueueAction;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Button;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PlainContent;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.RichContent;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.util.Hashtable;

public class BuddyInfoFrame
extends Window {
    private Pane pane;
    private int reqSeqNum;
    public BuddyItem buddyItem;
    private AccountRoot accountRoot;
    private String clientBuffer = "";
    private Button updateNickButton;

    public BuddyInfoFrame(AccountRoot accountRoot, BuddyItem buddyItem) {
        super(MidletMain.screen);
        this.accountRoot = accountRoot;
        this.buddyItem = buddyItem;
        this.reqSeqNum = MidletMain.reqSeqNum++;
        this.header = new Header(Localization.getMessage("USER_SUMMARY"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CLOSE")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(BuddyInfoFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem("");
        this.pane = new Pane(null, false);
        if (accountRoot.getStatusIndex() == 0 || buddyItem.isPhone()) {
            this.pane.addItem(new Label(new RichContent("[p][b]" + Localization.getMessage("BUDDY_ID_LABEL") + ": [/b]" + buddyItem.getUserId() + "[/p]")));
            this.pane.addItem(new Label(new RichContent("[p][b]" + Localization.getMessage("NICK_NAME_LABEL") + ": [/b]" + buddyItem.getUserNick() + "[/p]")));
        } else {
            LogUtil.outMessage("Dialog with reqSeqNum = " + this.reqSeqNum);
            String waitText = "WAIT_LABEL";
            accountRoot.requestInfo(buddyItem.getUserId(), this.reqSeqNum);
            Label waitLabel = new Label(Localization.getMessage(waitText));
            this.pane.addItem(waitLabel);
        }
        this.setGObject(this.pane);
    }

    public void updateNickAction(final BuddyInfo buddyInfo) {
        Cookie cookie = this.accountRoot.renameBuddy(buddyInfo.nickName, this.buddyItem, this.buddyItem.getUserPhone());
        LogUtil.outMessage("Request queued, cookie received");
        QueueAction queueAction = new QueueAction(this.accountRoot, this.buddyItem, cookie){

            public void actionPerformed(Hashtable params) {
                LogUtil.outMessage("Action Performed");
                this.buddyItem.setUserNick(buddyInfo.nickName);
                this.buddyItem.updateUiData();
                this.accountRoot.updateOfflineBuddylist();
            }
        };
        LogUtil.outMessage("QueueAction created");
        Queue.pushQueueAction(queueAction);
        LogUtil.outMessage("queueAction: " + queueAction.getCookie().cookieString);
        this.pane.items.removeElement(this.updateNickButton);
        MidletMain.screen.repaint();
    }

    public void placeInfo(final BuddyInfo buddyInfo) {
        this.pane.items.removeAllElements();
        if (buddyInfo.avatar != null) {
            Label avatarLabel = new Label(buddyInfo.nickName);
            ((PlainContent)avatarLabel.getContent()).setBold(true);
            avatarLabel.setHeader(true);
            ((PlainContent)avatarLabel.getContent()).image = buddyInfo.avatar;
            this.pane.addItem(avatarLabel);
        }
        block4: for (int c = 0; c < buddyInfo.getKeyValueSize() + 2; ++c) {
            String labelDescription;
            String labelMessage;
            RichContent content = new RichContent("");
            Label infoLabel = new Label(content);
            switch (c) {
                case 0: {
                    labelMessage = "BUDDY_ID_LABEL";
                    if (this.buddyItem.getUserId().endsWith("@uin.icq")) {
                        labelDescription = this.buddyItem.getUserId().substring(0, this.buddyItem.getUserId().indexOf("@uin.icq"));
                        break;
                    }
                    labelDescription = this.buddyItem.getUserId();
                    break;
                }
                case 1: {
                    labelMessage = "NICK_NAME_LABEL";
                    labelDescription = buddyInfo.nickName;
                    if (buddyInfo.nickName.equals(this.buddyItem.getUserNick())) break;
                    this.updateNickButton = new Button(Localization.getMessage("UPDATE_NICKNAME")){

                        public void actionPerformed() {
                            BuddyInfoFrame.this.updateNickAction(buddyInfo);
                        }
                    };
                    this.updateNickButton.setFocusable(true);
                    this.updateNickButton.setFocused(true);
                    this.pane.addItem(this.updateNickButton);
                    break;
                }
                default: {
                    BuddyInfo.KeyValue keyValue = buddyInfo.getKeyValue(c - 2);
                    labelMessage = keyValue.key;
                    labelDescription = keyValue.value;
                    if (StringUtil.isNullOrEmpty(labelDescription)) continue block4;
                }
            }
            content.setText("[p][b]" + Localization.getMessage(labelMessage) + ": [/b]" + labelDescription + "[/p]");
            this.clientBuffer = this.clientBuffer + infoLabel.getContent().getText() + "\n";
            this.clientBuffer = this.clientBuffer + labelDescription + "\n";
            this.pane.addItem(infoLabel);
        }
        this.soft.rightSoft = new PopupItem(Localization.getMessage("COPY")){

            public void actionPerformed() {
                MidletMain.buffer = BuddyInfoFrame.this.clientBuffer;
            }
        };
        MidletMain.screen.repaint();
        Runtime.getRuntime().gc();
    }
}

