/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.core.Queue;
import com.tomclaw.mandarin.core.QueueAction;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.mmp.MmpAccountRoot;
import com.tomclaw.mandarin.mmp.MmpGroup;
import com.tomclaw.mandarin.mmp.MmpItem;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.tcuilite.RadioGroup;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.util.Hashtable;

public class AddingBuddyFrame
extends Window {
    private static final int TYPE_ICQ = 0;
    private static final int TYPE_MMP = 1;
    private static final int TYPE_PHONE = 2;
    private Field buddyIdField;
    private Field buddyNickField;
    private RadioGroup buddyGroup;

    public AddingBuddyFrame(final AccountRoot accountRoot, final int winType) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("ADD_BUDDY"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(AddingBuddyFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("ADD")){

            public void actionPerformed() {
                if (!StringUtil.isFill(AddingBuddyFrame.this.buddyIdField.getText()) || !StringUtil.isFill(AddingBuddyFrame.this.buddyNickField.getText())) {
                    Handler.showNotify(Localization.getMessage("EMPTY_FIELDS"));
                } else {
                    MmpGroup groupItem = winType == 2 ? ((MmpAccountRoot)accountRoot).phoneGroup : (BuddyGroup)accountRoot.getBuddyItems().elementAt(AddingBuddyFrame.this.buddyGroup.getCombed());
                    BuddyItem buddyItem = accountRoot.getBuddyInstance();
                    buddyItem.setIsPhone(winType == 2);
                    buddyItem.setUserId(AddingBuddyFrame.this.buddyIdField.getText());
                    buddyItem.setUserNick(AddingBuddyFrame.this.buddyNickField.getText());
                    Cookie cookie = accountRoot.addBuddy(buddyItem, groupItem);
                    QueueAction queueAction = new QueueAction(accountRoot, buddyItem, cookie){

                        public void actionPerformed(Hashtable params) {
                            switch (winType) {
                                case 1: 
                                case 2: {
                                    ((MmpItem)this.buddyItem).contactId = (Long)params.get("contactId");
                                }
                            }
                            this.getBuddyGroup().addChild(this.buddyItem);
                            LogUtil.outMessage("Action Performed");
                            this.buddyItem.updateUiData();
                            this.accountRoot.updateOfflineBuddylist();
                        }
                    };
                    queueAction.setBuddyGroup(groupItem);
                    LogUtil.outMessage("QueueAction created");
                    Queue.pushQueueAction(queueAction);
                    MidletMain.screen.setActiveWindow(AddingBuddyFrame.this.s_prevWindow);
                }
            }
        };
        Pane pane = new Pane(null, false);
        String idLabelString = "";
        int constraints = 0;
        switch (winType) {
            case 0: {
                idLabelString = "ENTER_ID_HERE";
                constraints = 2;
                break;
            }
            case 1: {
                idLabelString = "ENTER_MAIL_HERE";
                constraints = 1;
                break;
            }
            case 2: {
                idLabelString = "ENTER_PHONE_HERE";
                constraints = 3;
            }
        }
        Label idLabel = new Label(Localization.getMessage("ADDING_BUDDY"));
        idLabel.setHeader(true);
        pane.addItem(idLabel);
        pane.addItem(new Label(Localization.getMessage(idLabelString)));
        this.buddyIdField = new Field("");
        this.buddyIdField.setFocusable(true);
        this.buddyIdField.setFocused(true);
        this.buddyIdField.constraints = constraints;
        this.buddyIdField.title = Localization.getMessage("BUDDY_ID");
        pane.addItem(this.buddyIdField);
        pane.addItem(new Label(Localization.getMessage("ENTER_NICK_HERE")));
        this.buddyNickField = new Field("");
        this.buddyNickField.setFocusable(true);
        this.buddyNickField.title = Localization.getMessage("BUDDY_NICK");
        pane.addItem(this.buddyNickField);
        if (winType != 2) {
            pane.addItem(new Label(Localization.getMessage("SELECT_GROUP")));
            this.buddyGroup = new RadioGroup();
            if (accountRoot.getBuddyItems().isEmpty()) {
                Handler.showFail(Localization.getMessage("NO_GROUPS"));
            } else {
                for (int c = 0; c < accountRoot.getBuddyItems().size(); ++c) {
                    BuddyGroup groupItem = (BuddyGroup)accountRoot.getBuddyItems().elementAt(c);
                    Radio radio = new Radio(groupItem.getUserId() == null ? "" : groupItem.getUserId(), false);
                    radio.setFocusable(true);
                    pane.addItem(radio);
                    this.buddyGroup.addRadio(radio);
                }
                this.buddyGroup.setCombed(0);
            }
        }
        this.setGObject(pane);
    }
}

