/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Snac {
    public final int family;
    public final int subtype;
    public long requestId;
    public final byte flag1;
    public final byte flag2;
    private final ByteArrayOutputStream byteArray = new ByteArrayOutputStream();

    public Snac(int family, int subtype, int flag1, int flag2) throws IOException {
        this(family, subtype, 0, 0, 0L);
    }

    public Snac(int family, int subtype, int flag1, int flag2, long requestId) throws IOException {
        this.family = family;
        this.subtype = subtype;
        this.flag1 = (byte)(flag1 & 0xFF);
        this.flag2 = (byte)(flag2 & 0xFF);
        this.requestId = requestId;
        this.addWord(family);
        this.addWord(subtype);
        this.addByte(flag1);
        this.addByte(flag2);
        this.addDWord(requestId);
    }

    public Snac() {
        this.family = 0;
        this.subtype = 0;
        this.flag1 = 0;
        this.flag2 = 0;
        this.requestId = 0L;
    }

    public final void addByte(int byt) throws IOException {
        this.byteArray.write((byte)(byt & 0xFF));
    }

    public final void addByteArray(byte[] b) throws IOException {
        if (b.length > 0) {
            this.byteArray.write(b);
        }
    }

    public final void addByteLString(String s) throws IOException {
        byte[] array = StringUtil.stringToByteArray(s, true);
        this.addByte(array.length);
        if (array.length > 0) {
            this.byteArray.write(array);
        }
    }

    public final void addWordLString(String s) throws IOException {
        byte[] array = StringUtil.stringToByteArray(s, true);
        this.addWord(array.length);
        if (array.length > 0) {
            this.byteArray.write(array);
        }
    }

    public final void addDWord(long x) throws IOException {
        this.addWord((int)(x >> 16 & 0xFFFFL));
        this.addWord((int)(x & 0xFFFFL));
    }

    public final void addDWordReversed(long x) throws IOException {
        this.addWordReversed((int)(x & 0xFFFFL));
        this.addWordReversed((int)(x >> 16 & 0xFFFFL));
    }

    public final void addTlv(int type, byte[] value) throws IOException {
        this.addWord(type);
        this.addWord(value.length);
        this.addByteArray(value);
    }

    public final void addWord(int x) throws IOException {
        this.byteArray.write((byte)(x >> 8 & 0xFF));
        this.byteArray.write((byte)(x & 0xFF));
    }

    public final void addWordReversed(int x) throws IOException {
        this.byteArray.write((byte)(x & 0xFF));
        this.byteArray.write((byte)(x >> 8 & 0xFF));
    }

    public void send(OutputStream outputStream, int seq) throws IOException {
        this.byteArray.flush();
        byte[] flapData = this.byteArray.toByteArray();
        this.byteArray.close();
        byte[] flapHeader = Snac.createFlapHeader(2, seq, flapData.length);
        ByteArrayOutputStream bas = new ByteArrayOutputStream(flapData.length + flapHeader.length);
        bas.write(flapHeader);
        bas.write(flapData);
        bas.flush();
        outputStream.write(bas.toByteArray());
        outputStream.flush();
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(System.out, bas.toByteArray(), "<< SNAC (" + HexUtil.toHexString(this.family) + ", " + HexUtil.toHexString(this.subtype) + "): ");
        }
        bas.close();
    }

    public ByteArrayOutputStream getByteArray() {
        return this.byteArray;
    }

    public static byte[] createFlapHeader(int channel, int seqNum, int dataFieldLength) {
        return new byte[]{42, (byte)channel, (byte)(seqNum >> 8 & 0xFF), (byte)(seqNum & 0xFF), (byte)(dataFieldLength >> 8 & 0xFF), (byte)(dataFieldLength & 0xFF)};
    }
}

