/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.RichContent;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.StringUtil;

public class IncomingFileFrame
extends Window {
    private Pane pane;

    public IncomingFileFrame(final IcqAccountRoot icqAccountRoot, final int ch2msgType, final String buddyId, final int[] externalIp, final int dcTcpPort, final boolean isViaRendezvousServer, final long fileLength, final byte[] fileName, final byte[] cookie) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("INC_FILE"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(IncomingFileFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("ACCEPT")){

            public void actionPerformed() {
                new Thread(){

                    public void run() {
                        Handler.performTransferAction(icqAccountRoot, ch2msgType, buddyId, externalIp, dcTcpPort, isViaRendezvousServer, fileLength, fileName, cookie, true);
                    }
                }.start();
                MidletMain.screen.setActiveWindow(IncomingFileFrame.this.s_prevWindow);
            }
        };
        this.pane = new Pane(null, false);
        Label label = new Label(Localization.getMessage("INC_FILE_FROM").concat(" ").concat(buddyId));
        label.setHeader(true);
        this.pane.addItem(label);
        this.addLabels("BUDDYID_LABEL", buddyId);
        this.addLabels("FILENAME_LABEL", StringUtil.byteArrayToString(fileName));
        long humanFileLength = fileLength;
        String fileSizeMetrix = "BYTES";
        if (humanFileLength > 1024L) {
            humanFileLength /= 1024L;
            fileSizeMetrix = "KIB";
        }
        if (humanFileLength > 1024L) {
            humanFileLength /= 1024L;
            fileSizeMetrix = "MIB";
        }
        this.addLabels("FILESIZE_LABEL", String.valueOf(humanFileLength) + " " + Localization.getMessage(fileSizeMetrix));
        this.setGObject(this.pane);
    }

    private void addLabels(String title, String descr) {
        this.pane.addItem(new Label(new RichContent("[p][b]" + Localization.getMessage(title) + ": [/b]" + descr + "[/p]")));
    }
}

