/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.core;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;

public class RmsRenderer {
    public static GroupHeader getRmsGroupHeader(byte[] data, AccountRoot accoutRoot) {
        int offset = DataUtil.get16(data, 0);
        GroupHeader groupHeader = new GroupHeader(StringUtil.byteArrayToString(data, 2, offset, true));
        int childsCount = DataUtil.get16(data, offset += 2);
        offset += 2;
        try {
            for (int c = 0; c < childsCount; ++c) {
                int t_Int = DataUtil.get16(data, offset);
                BuddyItem groupChild = accoutRoot.getBuddyInstance();
                groupChild.setUserId(StringUtil.byteArrayToString(data, offset += 2, t_Int, true));
                offset += t_Int;
                t_Int = DataUtil.get16(data, offset);
                groupChild.setUserNick(StringUtil.byteArrayToString(data, offset += 2, t_Int, true));
                offset += t_Int;
                t_Int = DataUtil.get16(data, offset);
                groupChild.setUserPhone(StringUtil.byteArrayToString(data, offset += 2, t_Int, true));
                groupChild.setBuddyType(DataUtil.get16(data, offset += t_Int));
                groupChild.setIsPhone(DataUtil.get8int(data, offset += 2) == 1);
                ++offset;
                groupChild.updateUiData();
                groupHeader.addChild(groupChild);
            }
        }
        catch (Throwable ex) {
            LogUtil.outMessage("Error while loading RMS list: " + ex.getMessage());
        }
        return groupHeader;
    }

    public static byte[] getRmsData(GroupHeader groupHeader) {
        byte[] titleData = StringUtil.stringToByteArray(groupHeader.title, true);
        byte[] data = new byte[4 + titleData.length];
        DataUtil.put16(data, 0, titleData.length);
        DataUtil.putArray(data, 2, titleData);
        DataUtil.put16(data, 2 + titleData.length, groupHeader.getChildsCount());
        try {
            for (int c = 0; c < groupHeader.getChildsCount(); ++c) {
                BuddyItem groupChild = (BuddyItem)groupHeader.getChilds().elementAt(c);
                titleData = StringUtil.stringToByteArray(groupChild.getUserId(), true);
                byte[] itemData = new byte[9 + titleData.length + StringUtil.stringToByteArray(groupChild.getUserNick(), true).length + StringUtil.stringToByteArray(groupChild.getUserPhone(), true).length];
                DataUtil.put16(itemData, 0, titleData.length);
                DataUtil.putArray(itemData, 2, titleData);
                int offset = 2 + titleData.length;
                titleData = StringUtil.stringToByteArray(groupChild.getUserNick(), true);
                DataUtil.put16(itemData, offset, titleData.length);
                DataUtil.putArray(itemData, offset += 2, titleData);
                offset += titleData.length;
                titleData = StringUtil.stringToByteArray(groupChild.getUserPhone(), true);
                DataUtil.put16(itemData, offset, titleData.length);
                DataUtil.putArray(itemData, offset += 2, titleData);
                DataUtil.put16(itemData, offset += titleData.length, groupChild.getBuddyType());
                DataUtil.put8(itemData, offset += 2, groupChild.isPhone() ? 1 : 0);
                ++offset;
                byte[] t_Byte = new byte[data.length + itemData.length];
                System.arraycopy(data, 0, t_Byte, 0, data.length);
                System.arraycopy(itemData, 0, t_Byte, data.length, itemData.length);
                data = t_Byte;
            }
        }
        catch (Throwable ex1) {
            // empty catch block
        }
        return data;
    }
}

