/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.core;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.GroupChild;
import com.tomclaw.utils.StringUtil;
import java.util.Timer;
import java.util.TimerTask;

public abstract class BuddyItem
extends GroupChild {
    public String userId;
    public String userNick;
    public String userPhone;
    private boolean isPhone;
    public boolean typingStatus;
    public int buddyType;
    private int statusIndex = 0;
    public boolean isAvaitingAuth = false;
    public int unreadCount = 0;
    private Timer typingTimer;
    private TimerTask timerTask;

    public BuddyItem() {
        this("");
    }

    public BuddyItem(String userId) {
        super(userId);
        this.userId = userId;
        this.userNick = userId;
    }

    public void setUserNick(String userNick) {
        this.userNick = userNick;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLeftImages(int[] leftImages) {
        this.imageLeftIndex = leftImages;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public int getUnreadCount(String resource) {
        return this.unreadCount;
    }

    public void setUnreadCount(int unreadCount, String resource) {
        this.unreadCount = unreadCount;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
        if (StringUtil.isNullOrEmpty(this.userId)) {
            this.userId = userPhone;
        }
    }

    public void setTypingStatus(boolean isTyping) {
        this.typingStatus = isTyping;
        if (this.typingTimer != null) {
            this.typingTimer.cancel();
            this.typingTimer = null;
        }
        if (isTyping) {
            this.timerTask = new TimerTask(){

                public void run() {
                    BuddyItem.this.typingStatus = false;
                    BuddyItem.this.updateUiData();
                    MidletMain.screen.repaint();
                    BuddyItem.this.typingTimer = null;
                    BuddyItem.this.timerTask = null;
                }
            };
            this.typingTimer = new Timer();
            this.typingTimer.schedule(this.timerTask, 25000L);
        }
    }

    public void setIsPhone(boolean isPhone) {
        this.isPhone = isPhone;
    }

    public void setBuddyType(int buddyType) {
        this.buddyType = buddyType;
    }

    public String getUserId() {
        return this.userId;
    }

    public int[] getLeftImages() {
        return this.imageLeftIndex;
    }

    public abstract void updateUiData();

    public String getUserPhone() {
        if (this.userPhone == null) {
            return "";
        }
        return this.userPhone;
    }

    public boolean getTypingStatus() {
        return this.typingStatus;
    }

    public String getUserNick() {
        return this.userNick;
    }

    public int getBuddyType() {
        return this.buddyType;
    }

    public boolean isPhone() {
        return this.isPhone;
    }

    public void setStatusIndex(int statusIndex, String resource) {
        this.statusIndex = statusIndex;
    }

    public int getStatusIndex() {
        return this.statusIndex;
    }
}

