/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.core;

import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.ServiceMessages;
import com.tomclaw.mandarin.core.TransactionManager;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.main.TransactionsFrame;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.utils.LogUtil;
import java.util.Vector;

public abstract class AccountRoot {
    public String userId;
    public String userNick;
    public String userPassword;
    public String host = "";
    public String port = "";
    public Vector buddyItems = new Vector();
    public int statusIndex = 0;
    public String statusText = "Mandarin ".concat(MidletMain.version).concat(" [").concat(MidletMain.build.concat("]"));
    public boolean isStatusReadable = true;
    private String buddyListFile = null;
    public boolean isUseSsl = false;
    private TransactionManager transactionManager = null;
    private TransactionsFrame transactionsFrame = null;
    private ServiceMessages serviceMessages = null;
    public boolean isConnecting = false;
    public boolean isShowGroups = true;
    public boolean isShowOffline = false;
    public int yOffset = 0;
    public int selectedColumn = 0;
    public int selectedRow = 0;
    public int unrMsgs = 0;
    public boolean isReset;

    public AccountRoot(String userId) {
        this.userId = userId;
        this.construct();
    }

    public abstract void construct();

    public abstract void connectAction(int var1);

    public AccountRoot init(boolean isStart) {
        this.userNick = MidletMain.getString(MidletMain.accounts, this.userId, "nick");
        this.userPassword = MidletMain.getString(MidletMain.accounts, this.userId, "pass");
        this.host = MidletMain.getString(MidletMain.accounts, this.userId, "host");
        this.port = MidletMain.getString(MidletMain.accounts, this.userId, "port");
        if (isStart) {
            this.loadStatus(this.statusIndex);
            this.isShowGroups = MidletMain.getBoolean(MidletMain.accounts, this.userId, "isShowGroups");
            this.isShowOffline = MidletMain.getBoolean(MidletMain.accounts, this.userId, "isShowOffline");
            LogUtil.outMessage("isShowGroups = " + String.valueOf(this.isShowGroups));
            LogUtil.outMessage("isShowOffline = " + String.valueOf(this.isShowOffline));
            this.buddyListFile = this.getAccType().concat(String.valueOf(this.getUserId().hashCode())).concat(".dat");
            this.loadOfflineBuddyList();
            this.initSpecialData();
        }
        return this;
    }

    public abstract void initSpecialData();

    public int getUnrMsgs() {
        return this.unrMsgs;
    }

    public void setUnrMsgs(int unrMsgs) {
        this.unrMsgs = unrMsgs;
    }

    public int getStatusIndex() {
        return this.statusIndex;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserNick(String userNick) {
        this.userNick = userNick;
    }

    public String getUserNick() {
        return this.userNick;
    }

    public abstract String getAccType();

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean getUseSsl() {
        return this.isUseSsl;
    }

    public void setUseSsl(boolean isUseSsl) {
        this.isUseSsl = isUseSsl;
    }

    public abstract void sendTypingStatus(String var1, boolean var2);

    public Vector getBuddyItems() {
        return this.buddyItems;
    }

    public void setStatusText(String statusText, boolean isStatusReadable) {
        this.statusText = statusText;
        this.isStatusReadable = isStatusReadable;
        this.saveAllSettings();
    }

    public void setBuddyItems(Vector buddyItems) {
        this.buddyItems = buddyItems;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void setSelectedIndex(int selectedColumn, int selectedRow) {
        this.selectedColumn = selectedColumn;
        this.selectedRow = selectedRow;
    }

    public void saveAllSettings() {
        try {
            MidletMain.accounts.addItem(this.userId, "isShowGroups", String.valueOf(this.isShowGroups));
            MidletMain.accounts.addItem(this.userId, "isShowOffline", String.valueOf(this.isShowOffline));
            this.saveSpecialSettings();
        }
        catch (Throwable ex) {
            LogUtil.outMessage("Error while saving settings: " + ex.getMessage());
        }
        MidletMain.saveRmsData(true, false, false);
        LogUtil.outMessage("RMS accounts saving complete");
    }

    public abstract void saveSpecialSettings() throws Throwable;

    public abstract byte[] sendMessage(BuddyItem var1, String var2, String var3);

    public void updateMainFrameBuddyList() {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            for (int i = 0; i < ((GroupHeader)this.buddyItems.elementAt(c)).getChildsCount(); ++i) {
                ((BuddyItem)((GroupHeader)this.buddyItems.elementAt(c)).getChilds().elementAt(i)).updateUiData();
            }
        }
        if (MidletMain.mainFrame.getActiveAccountRoot().equals(this)) {
            MidletMain.mainFrame.buddyList.items = this.buddyItems;
            MidletMain.screen.repaint();
        }
    }

    public ServiceMessages getServiceMessages() {
        if (this.serviceMessages == null) {
            this.serviceMessages = new ServiceMessages();
        }
        return this.serviceMessages;
    }

    public abstract String getStatusImages();

    public void offlineAllBuddyes() {
        for (int i = 0; i < this.buddyItems.size(); ++i) {
            GroupHeader tempGroupItem = (GroupHeader)this.buddyItems.elementAt(i);
            for (int j = 0; j < tempGroupItem.getChildsCount(); ++j) {
                BuddyItem tempIcqItem = (BuddyItem)tempGroupItem.getChilds().elementAt(j);
                tempIcqItem.setStatusIndex(0, null);
            }
        }
    }

    public void offlineAccount() {
        this.statusIndex = 0;
    }

    public abstract void setTreeItems(Vector var1);

    public abstract void setPrivateItems(Vector var1);

    public void updateOfflineBuddylist() {
        MidletMain.updateOfflineBuddylist(this.buddyListFile, this.buddyItems);
    }

    public void updateMainFrameUI() {
        if (MidletMain.mainFrame.getActiveAccountRoot().equals(this)) {
            MidletMain.mainFrame.buddyList.items = this.buddyItems;
            MidletMain.screen.repaint();
        }
    }

    public void loadOfflineBuddyList() {
        MidletMain.loadOfflineBuddyList(this, this.buddyListFile, this.buddyItems);
        this.isReset = true;
    }

    public void loadStatus(int statusIndex) {
        String statusData;
        this.statusText = statusData.substring(0, (statusData = MidletMain.getString(MidletMain.statuses, "PStatus_".concat(this.getAccType().toUpperCase()), String.valueOf(statusIndex))).indexOf("&rdb") == -1 ? statusData.length() : statusData.indexOf("&rdb"));
        this.isStatusReadable = statusData.indexOf("&rdb") == -1 ? false : statusData.substring(statusData.indexOf("&rdb") + 4).equals("true");
        LogUtil.outMessage("loadStatus: " + this.statusText + " [" + this.isStatusReadable + "]");
    }

    public void setShowGroups(boolean isShowGroups) {
        this.isShowGroups = isShowGroups;
    }

    public void setShowOffline(boolean isShowOffline) {
        this.isShowOffline = isShowOffline;
    }

    public boolean getShowGroups() {
        return this.isShowGroups;
    }

    public boolean getShowOffline() {
        return this.isShowOffline;
    }

    public abstract Cookie addGroup(BuddyGroup var1);

    public abstract Cookie addBuddy(BuddyItem var1, BuddyGroup var2);

    public abstract Cookie renameBuddy(String var1, BuddyItem var2, String var3);

    public abstract Cookie renameGroup(String var1, BuddyGroup var2);

    public abstract void requestAuth(String var1, BuddyItem var2);

    public abstract void acceptAuthorization(BuddyItem var1);

    public abstract void requestInfo(String var1, int var2);

    public abstract Cookie removeBuddy(BuddyItem var1);

    public abstract Cookie removeGroup(BuddyGroup var1);

    public abstract BuddyItem getBuddyInstance();

    public abstract BuddyGroup getGroupInstance();

    public TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = new TransactionManager();
        }
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionsFrame getTransactionsFrame() {
        if (this.transactionsFrame == null) {
            this.transactionsFrame = new TransactionsFrame(this);
            this.transactionsFrame.s_prevWindow = MidletMain.mainFrame;
        } else {
            this.transactionsFrame.updateTransactions();
        }
        return this.transactionsFrame;
    }

    public void setTransactionsFrame(TransactionsFrame transactionsFrame) {
        this.transactionsFrame = transactionsFrame;
    }

    public abstract DirectConnection getDirectConnectionInstance();

    public abstract int getNextBuddyId();

    public abstract int getNextGroupId();

    public abstract String getStatusDescr(int var1);
}

