/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.bingear;

import com.tomclaw.bingear.GroupNotFoundException;
import com.tomclaw.bingear.IncorrectValueException;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.StringUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class BinGear {
    public Hashtable hashtable = new Hashtable();

    public void addGroup(String groupName) throws IncorrectValueException {
        if (groupName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        this.hashtable.put(groupName, new Hashtable());
    }

    public void addItem(String groupName, String itemName, String value) throws GroupNotFoundException, IncorrectValueException {
        if (groupName == null || itemName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        try {
            ((Hashtable)this.hashtable.get(groupName)).put(itemName, value);
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
    }

    public Hashtable getGroup(String groupName) throws IncorrectValueException, GroupNotFoundException {
        if (groupName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        try {
            return (Hashtable)this.hashtable.get(groupName);
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
    }

    public String getValue(String groupName, String itemName) throws GroupNotFoundException, IncorrectValueException {
        if (groupName == null || itemName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        try {
            return (String)((Hashtable)this.hashtable.get(groupName)).get(itemName);
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
    }

    public String getValue(String groupName, String itemName, boolean isFullCompare) throws GroupNotFoundException, IncorrectValueException {
        if (groupName == null || itemName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        if (isFullCompare || this.hashtable.containsKey(groupName)) {
            return this.getValue(groupName, itemName);
        }
        try {
            Enumeration groupKeys = this.hashtable.keys();
            while (groupKeys.hasMoreElements()) {
                String tempName = (String)groupKeys.nextElement();
                if (!tempName.startsWith(groupName) && !groupName.startsWith(tempName)) continue;
                return (String)((Hashtable)this.hashtable.get(tempName)).get(itemName);
            }
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
        return null;
    }

    public void renameGroup(String groupOldName, String groupNewName) throws IncorrectValueException, GroupNotFoundException {
        if (groupOldName == null || groupNewName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        try {
            this.hashtable.put(groupNewName, this.hashtable.get(groupOldName));
            this.hashtable.remove(groupOldName);
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupOldName.concat(" is not exist"));
        }
    }

    public String[] listGroups() {
        String[] groups = new String[this.hashtable.size()];
        Enumeration groupKeys = this.hashtable.keys();
        int c = 0;
        while (groupKeys.hasMoreElements()) {
            String groupName;
            groups[c] = groupName = (String)groupKeys.nextElement();
            ++c;
        }
        return groups;
    }

    public String[] listItems(String groupName) throws IncorrectValueException, GroupNotFoundException {
        if (groupName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        try {
            String[] items = new String[((Hashtable)this.hashtable.get(groupName)).size()];
            Enumeration itemKeys = ((Hashtable)this.hashtable.get(groupName)).keys();
            int c = 0;
            while (itemKeys.hasMoreElements()) {
                items[c] = groupName = (String)itemKeys.nextElement();
                ++c;
            }
            return items;
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
    }

    public String[] listItems(String groupName, boolean isFullCompare) throws IncorrectValueException, GroupNotFoundException {
        if (groupName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        if (isFullCompare || this.hashtable.containsKey(groupName)) {
            return this.listItems(groupName);
        }
        try {
            Enumeration groupKeys = this.hashtable.keys();
            while (groupKeys.hasMoreElements()) {
                String tempName = (String)groupKeys.nextElement();
                if (!tempName.startsWith(groupName) && !groupName.startsWith(tempName)) continue;
                String[] items = new String[((Hashtable)this.hashtable.get(tempName)).size()];
                Enumeration itemKeys = ((Hashtable)this.hashtable.get(tempName)).keys();
                int c = 0;
                while (itemKeys.hasMoreElements()) {
                    items[c] = (String)itemKeys.nextElement();
                    ++c;
                }
                return items;
            }
            return null;
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
    }

    public void renameItem(String groupName, String itemOldName, String itemNewName) throws IncorrectValueException, GroupNotFoundException {
        if (groupName == null || itemOldName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        try {
            ((Hashtable)this.hashtable.get(groupName)).put(itemNewName, ((Hashtable)this.hashtable.get(groupName)).get(itemOldName));
            ((Hashtable)this.hashtable.get(groupName)).remove(itemOldName);
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
    }

    public void setValue(String groupName, String itemName, String value) throws GroupNotFoundException, IncorrectValueException {
        if (groupName == null || itemName == null) {
            throw new IncorrectValueException("nulltype is not allowed here as patameter");
        }
        try {
            ((Hashtable)this.hashtable.get(groupName)).put(itemName, value);
        }
        catch (NullPointerException ex1) {
            throw new GroupNotFoundException(groupName.concat(" is not exist"));
        }
    }

    public void removeGroup(String groupName) {
        this.hashtable.remove(groupName);
    }

    public void removeItem(String groupName, String itemName) {
        ((Hashtable)this.hashtable.get(groupName)).remove(itemName);
    }

    public void exportToIni(OutputStream outputStream) throws IOException {
        Enumeration groupKeys = this.hashtable.keys();
        while (groupKeys.hasMoreElements()) {
            String groupName = (String)groupKeys.nextElement();
            outputStream.write(StringUtil.stringToByteArray("[".concat(groupName).concat("]\n"), true));
            Enumeration itemKeys = ((Hashtable)this.hashtable.get(groupName)).keys();
            while (itemKeys.hasMoreElements()) {
                String itemName = (String)itemKeys.nextElement();
                outputStream.write(StringUtil.stringToByteArray(itemName.concat("=").concat((String)((Hashtable)this.hashtable.get(groupName)).get(itemName)).concat("\n"), true));
            }
        }
        outputStream.flush();
    }

    public void saveToDat(DataOutputStream outputStream) throws IOException {
        Enumeration groupKeys = this.hashtable.keys();
        outputStream.writeChar(this.hashtable.size());
        while (groupKeys.hasMoreElements()) {
            String groupName = (String)groupKeys.nextElement();
            outputStream.writeUTF(groupName);
            Enumeration itemKeys = ((Hashtable)this.hashtable.get(groupName)).keys();
            outputStream.writeChar(((Hashtable)this.hashtable.get(groupName)).size());
            while (itemKeys.hasMoreElements()) {
                String itemName = (String)itemKeys.nextElement();
                outputStream.writeUTF(itemName);
                String value = (String)((Hashtable)this.hashtable.get(groupName)).get(itemName);
                outputStream.writeUTF(value);
            }
        }
        outputStream.flush();
    }

    public void readFromDat(DataInputStream inputStream) throws IOException, IncorrectValueException, GroupNotFoundException, EOFException {
        this.hashtable.clear();
        int groupCount = inputStream.readChar();
        for (int c = 0; c < groupCount; ++c) {
            String groupName = inputStream.readUTF();
            this.addGroup(groupName);
            int itemsCount = inputStream.readChar();
            for (int i = 0; i < itemsCount; ++i) {
                String itemName = inputStream.readUTF();
                String value = inputStream.readUTF();
                this.addItem(groupName, itemName, value);
            }
        }
    }

    public void importFromIni(DataInputStream inputStream) throws IOException, IncorrectValueException, GroupNotFoundException, EOFException, Throwable {
        byte ch;
        this.hashtable.clear();
        String prevHeader = null;
        boolean isFirstIndex = true;
        ArrayUtil buffer = new ArrayUtil();
        while (inputStream.available() > 0 && (ch = inputStream.readByte()) != -1) {
            if (ch == 13) continue;
            if (ch == 10) {
                if (buffer.length() <= 1) continue;
                if (buffer.byteString[0] == 91 && buffer.byteString[buffer.length() - 1] == 93) {
                    prevHeader = StringUtil.byteArrayToString(buffer.subarray(1, buffer.length() - 1), true);
                    this.addGroup(prevHeader);
                } else {
                    int equivIndex = isFirstIndex ? buffer.indexOf('=') : buffer.lastIndexOf('=');
                    if (equivIndex > 0) {
                        this.addItem(prevHeader, StringUtil.byteArrayToString(buffer.subarray(0, equivIndex), true), StringUtil.byteArrayToString(buffer.subarray(equivIndex + 1, buffer.length()), true));
                    }
                }
                buffer.clear();
                continue;
            }
            buffer.append(ch);
        }
    }
}

